/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.rotation;

import java.io.IOException;
import java.nio.file.Path;
import java.time.Clock;
import java.util.function.LongSupplier;
import org.neo4j.io.IOUtils;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.impl.transaction.log.files.LogFile;
import org.neo4j.kernel.impl.transaction.log.files.RotatableFile;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogFile;
import org.neo4j.kernel.impl.transaction.log.files.checkpoint.CheckpointLogFile;
import org.neo4j.kernel.impl.transaction.log.rotation.LogRotation;
import org.neo4j.kernel.impl.transaction.log.rotation.monitor.LogRotationMonitor;
import org.neo4j.kernel.impl.transaction.tracing.LogRotateEvent;
import org.neo4j.kernel.impl.transaction.tracing.LogRotateEvents;
import org.neo4j.monitoring.Panic;
import org.neo4j.util.VisibleForTesting;

public class FileLogRotation
implements LogRotation {
    private final Clock clock;
    private final LogRotationMonitor monitor;
    private final Panic databasePanic;
    private final RotatableFile rotatableFile;
    private long lastRotationCompleted;
    private final LongSupplier lastAppendIndexSupplier;
    private final LongSupplier currentFileVersionSupplier;

    public static LogRotation checkpointLogRotation(CheckpointLogFile checkpointLogFile, LogFile logFile, Clock clock, Panic databasePanic, LogRotationMonitor monitor) {
        return new FileLogRotation(checkpointLogFile, clock, databasePanic, monitor, () -> logFile.getLogFileInformation().getLastEntryAppendIndex(), IOUtils.uncheckedLongSupplier(checkpointLogFile::getCurrentDetachedLogVersion));
    }

    public static LogRotation transactionLogRotation(LogFile logFile, Clock clock, Panic databasePanic, LogRotationMonitor monitor) {
        return new FileLogRotation(logFile, clock, databasePanic, monitor, () -> logFile.getLogFileInformation().getLastEntryAppendIndex(), logFile::getCurrentLogVersion);
    }

    private FileLogRotation(RotatableFile rotatableFile, Clock clock, Panic databasePanic, LogRotationMonitor monitor, LongSupplier lastAppendIndexSupplier, LongSupplier currentFileVersionSupplier) {
        this.clock = clock;
        this.monitor = monitor;
        this.databasePanic = databasePanic;
        this.rotatableFile = rotatableFile;
        this.lastAppendIndexSupplier = lastAppendIndexSupplier;
        this.currentFileVersionSupplier = currentFileVersionSupplier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean rotateLogIfNeeded(LogRotateEvents logRotateEvents) throws IOException {
        if (this.rotatableFile.rotationNeeded()) {
            RotatableFile rotatableFile = this.rotatableFile;
            synchronized (rotatableFile) {
                return this.locklessRotateLogIfNeeded(logRotateEvents);
            }
        }
        return false;
    }

    @Override
    public boolean locklessBatchedRotateLogIfNeeded(LogRotateEvents logRotateEvents, long lastAppendIndex, KernelVersion kernelVersion, int checksum) throws IOException {
        if (this.rotatableFile.rotationNeeded()) {
            TransactionLogFile logFile = (TransactionLogFile)this.rotatableFile;
            long version = logFile.getHighestLogVersion();
            this.doRotate(logRotateEvents, lastAppendIndex, () -> version, () -> logFile.rotate(kernelVersion, lastAppendIndex, checksum));
            return true;
        }
        return false;
    }

    @Override
    public boolean locklessRotateLogIfNeeded(LogRotateEvents logRotateEvents) throws IOException {
        if (this.rotatableFile.rotationNeeded()) {
            this.doRotate(logRotateEvents, this.lastAppendIndexSupplier.getAsLong(), this.currentFileVersionSupplier, this.rotatableFile::rotate);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @VisibleForTesting
    public void rotateLogFile(LogRotateEvents logRotateEvents) throws IOException {
        RotatableFile rotatableFile = this.rotatableFile;
        synchronized (rotatableFile) {
            this.doRotate(logRotateEvents, this.lastAppendIndexSupplier.getAsLong(), this.currentFileVersionSupplier, this.rotatableFile::rotate);
        }
    }

    @Override
    public void locklessRotateLogFile(LogRotateEvents logRotateEvents, KernelVersion kernelVersion, long lastAppendIndex, int previousChecksum) throws IOException {
        this.doRotate(logRotateEvents, lastAppendIndex, this.currentFileVersionSupplier, () -> this.rotatableFile.rotate(kernelVersion, lastAppendIndex, previousChecksum));
    }

    @Override
    public long rotationSize() {
        return this.rotatableFile.rotationSize();
    }

    private void doRotate(LogRotateEvents logRotateEvents, long appendIndex, LongSupplier currentFileVersionSupplier, FileRotator fileRotator) throws IOException {
        try (LogRotateEvent rotateEvent = logRotateEvents.beginLogRotate();){
            long currentVersion = currentFileVersionSupplier.getAsLong();
            this.databasePanic.assertNoPanic(IOException.class);
            long startTimeMillis = this.clock.millis();
            this.monitor.startRotation(currentVersion);
            Path newLogFile = fileRotator.rotate();
            long millisSinceLastRotation = this.lastRotationCompleted == 0L ? 0L : startTimeMillis - this.lastRotationCompleted;
            this.lastRotationCompleted = this.clock.millis();
            long rotationElapsedTime = this.lastRotationCompleted - startTimeMillis;
            rotateEvent.rotationCompleted(rotationElapsedTime);
            this.monitor.finishLogRotation(newLogFile, currentVersion, appendIndex, rotationElapsedTime, millisSinceLastRotation);
        }
    }

    @FunctionalInterface
    private static interface FileRotator {
        public Path rotate() throws IOException;
    }
}

