/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.collections.api.block.function.primitive.LongToObjectFunction;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.traversal.Paths;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.values.VirtualValue;
import org.neo4j.values.virtual.VirtualPathValue;

public abstract class BaseCoreAPIPath
implements Path {
    private final VirtualPathValue value;

    protected BaseCoreAPIPath(VirtualPathValue value) {
        this.value = value;
    }

    public VirtualPathValue pathValue() {
        return this.value;
    }

    public String toString() {
        return Paths.defaultPathToStringWithNotInTransactionFallback((Path)this);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof BaseCoreAPIPath) {
            return this.value.equals((VirtualValue)((BaseCoreAPIPath)obj).value);
        }
        if (obj instanceof Path) {
            Path other = (Path)obj;
            if (this.value.nodeIds()[0] != other.startNode().getId()) {
                return false;
            }
            return Iterators.iteratorsEqual(this.relationships().iterator(), other.relationships().iterator());
        }
        return false;
    }

    public Node startNode() {
        return this.mapNode(this.value.nodeIds()[0]);
    }

    public Node endNode() {
        long[] nodeIds = this.value.nodeIds();
        return this.mapNode(nodeIds[nodeIds.length - 1]);
    }

    public Relationship lastRelationship() {
        if (this.value.size() == 0) {
            return null;
        }
        long[] relationshipIds = this.value.relationshipIds();
        return this.mapRelationship(relationshipIds[relationshipIds.length - 1]);
    }

    public Iterable<Relationship> relationships() {
        return BaseCoreAPIPath.asList(this.value.relationshipIds(), this::mapRelationship);
    }

    public Iterable<Relationship> reverseRelationships() {
        return BaseCoreAPIPath.asReverseList(this.value.relationshipIds(), this::mapRelationship);
    }

    public Iterable<Node> nodes() {
        return BaseCoreAPIPath.asList(this.value.nodeIds(), this::mapNode);
    }

    public Iterable<Node> reverseNodes() {
        return BaseCoreAPIPath.asReverseList(this.value.nodeIds(), this::mapNode);
    }

    public int length() {
        return this.value.size();
    }

    public Iterator<Entity> iterator() {
        return new Iterator<Entity>(){
            private final int size;
            private int index;
            private final long[] nodes;
            private final long[] relationships;
            {
                this.size = 2 * BaseCoreAPIPath.this.value.size() + 1;
                this.nodes = BaseCoreAPIPath.this.value.nodeIds();
                this.relationships = BaseCoreAPIPath.this.value.relationshipIds();
            }

            @Override
            public boolean hasNext() {
                return this.index < this.size;
            }

            @Override
            public Entity next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Object entity = (this.index & 1) == 0 ? BaseCoreAPIPath.this.mapNode(this.nodes[this.index >> 1]) : BaseCoreAPIPath.this.mapRelationship(this.relationships[this.index >> 1]);
                ++this.index;
                return entity;
            }
        };
    }

    private static <V> Iterable<V> asList(final long[] values, final LongToObjectFunction<V> mapper) {
        return () -> new Iterator<V>(){
            private int index;

            @Override
            public boolean hasNext() {
                return this.index < values.length;
            }

            @Override
            public V next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return mapper.apply(values[this.index++]);
            }
        };
    }

    private static <V> Iterable<V> asReverseList(final long[] values, final LongToObjectFunction<V> mapper) {
        return () -> new Iterator<V>(){
            private int index;
            {
                this.index = values.length - 1;
            }

            @Override
            public boolean hasNext() {
                return this.index >= 0;
            }

            @Override
            public V next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return mapper.apply(values[this.index--]);
            }
        };
    }

    protected abstract Node mapNode(long var1);

    protected abstract Relationship mapRelationship(long var1);
}

