/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.fabric.executor;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import org.neo4j.bolt.protocol.common.message.AccessMode;
import org.neo4j.cypher.internal.FullyParsedQuery;
import org.neo4j.fabric.eval.UseEvaluation;
import org.neo4j.fabric.executor.ExecutionOptions;
import org.neo4j.fabric.executor.FragmentResult;
import org.neo4j.fabric.executor.Location;
import org.neo4j.fabric.executor.QueryStatementLifecycles;
import org.neo4j.fabric.executor.SingleQueryFragmentExecutor;
import org.neo4j.fabric.planning.FabricPlan;
import org.neo4j.fabric.planning.FabricPlanner;
import org.neo4j.fabric.planning.Fragment;
import org.neo4j.fabric.stream.Prefetcher;
import org.neo4j.fabric.stream.Record;
import org.neo4j.fabric.stream.StatementResult;
import org.neo4j.fabric.stream.summary.MergedQueryStatistics;
import org.neo4j.fabric.transaction.FabricTransaction;
import org.neo4j.fabric.transaction.TransactionMode;
import org.neo4j.graphdb.GqlStatusObject;
import org.neo4j.graphdb.Notification;
import org.neo4j.kernel.impl.query.QueryRoutingMonitor;
import org.neo4j.values.AnyValue;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.MapValueBuilder;
import org.neo4j.values.virtual.VirtualValues;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import scala.jdk.javaapi.CollectionConverters;

class StandardQueryExecutor
extends SingleQueryFragmentExecutor {
    private final Fragment.Exec fragment;

    StandardQueryExecutor(Fragment.Exec fragment, FabricPlanner.PlannerInstance plannerInstance, Executor fabricWorkerExecutor, FabricTransaction.FabricExecutionContext ctx, UseEvaluation.Instance useEvaluator, FabricPlan plan, MapValue queryParams, AccessMode accessMode, Set<Notification> notifications, Set<GqlStatusObject> gqlStatusObjects, QueryStatementLifecycles.StatementLifecycle lifecycle, Prefetcher prefetcher, QueryRoutingMonitor queryRoutingMonitor, MergedQueryStatistics statistics, SingleQueryFragmentExecutor.Tracer tracer, SingleQueryFragmentExecutor.FragmentExecutor fragmentExecutor) {
        super(plannerInstance, fabricWorkerExecutor, ctx, useEvaluator, plan, queryParams, accessMode, notifications, gqlStatusObjects, lifecycle, prefetcher, queryRoutingMonitor, statistics, tracer, fragmentExecutor);
        this.fragment = fragment;
    }

    FragmentResult run(Record argument) {
        SingleQueryFragmentExecutor.PrepareResult prepareResult = this.prepare(this.fragment, argument);
        MapValue parameters = this.addParamsFromRecord(this.queryParams(), prepareResult.argumentValues(), CollectionConverters.asJava(this.fragment.parameters()));
        return this.doExecuteFragment(this.fragment, parameters, prepareResult.graph(), prepareResult.transactionMode(), () -> this.fragmentExecutor().run(this.fragment.input(), argument));
    }

    @Override
    Mono<StatementResult> runRemote(Location.Remote location, ExecutionOptions options, String query, TransactionMode transactionMode, MapValue params) {
        return this.ctx().getRemote().run(location, options, query, transactionMode, params);
    }

    @Override
    StatementResult runLocal(Location.Local location, TransactionMode transactionMode, QueryStatementLifecycles.StatementLifecycle parentLifecycle, FullyParsedQuery query, MapValue params, Flux<Record> input, ExecutionOptions executionOptions, Boolean targetsComposite) {
        return this.ctx().getLocal().run(location, transactionMode, parentLifecycle, query, params, input, executionOptions, targetsComposite);
    }

    private MapValue addParamsFromRecord(MapValue params, Map<String, AnyValue> record, Map<String, String> bindings) {
        int resultSize = params.size() + bindings.size();
        if (resultSize == 0) {
            return VirtualValues.EMPTY_MAP;
        }
        MapValueBuilder builder = new MapValueBuilder(resultSize);
        params.foreach((arg_0, arg_1) -> ((MapValueBuilder)builder).add(arg_0, arg_1));
        bindings.forEach((var, par) -> builder.add(par, this.validateValue((AnyValue)record.get(var))));
        return builder.build();
    }
}

