/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cloud.storage.io;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.concurrent.atomic.AtomicReference;
import org.neo4j.cloud.storage.StorageSystemProvider;
import org.neo4j.io.memory.ByteBuffers;
import org.neo4j.memory.MemoryTracker;

public abstract class WriteableChannel
extends OutputStream
implements WritableByteChannel {
    private final AtomicReference<IOException> ioError = new AtomicReference();
    protected final MemoryTracker memoryTracker;
    protected final ByteBuffer buffer;
    protected long writtenChunks = 0L;
    private boolean closed;

    protected WriteableChannel(int bufferSize, MemoryTracker memoryTracker) {
        this.memoryTracker = memoryTracker;
        this.buffer = ByteBuffers.allocateDirect((int)bufferSize, (ByteOrder)ByteOrder.LITTLE_ENDIAN, (MemoryTracker)memoryTracker);
    }

    protected abstract long internalGetSize();

    protected abstract void completeWriteProcess() throws IOException;

    protected abstract void doBufferWrite(ByteBuffer var1) throws IOException;

    protected abstract void reportChunksWritten(long var1);

    protected abstract boolean hasBeenReplicated();

    public long size() throws IOException {
        this.ensureOpen();
        return this.internalGetSize();
    }

    public long transferFrom(Path path) throws IOException {
        long transferred = 0L;
        int read = 0;
        try (ReadableByteChannel fileChannel = this.toChannel(path);){
            while ((read = fileChannel.read(this.buffer)) >= 0) {
                this.checkBufferIsFull();
                transferred += (long)read;
            }
        }
        return transferred;
    }

    private ReadableByteChannel toChannel(Path path) throws IOException {
        if (path.getFileSystem().provider() instanceof StorageSystemProvider) {
            return Channels.newChannel(Files.newInputStream(path, new OpenOption[0]));
        }
        return FileChannel.open(path, StandardOpenOption.READ);
    }

    @Override
    public void write(int b) throws IOException {
        this.ensureOk();
        this.checkBufferIsFull();
        this.buffer.put((byte)b);
    }

    @Override
    public void write(byte[] bytes, int offset, int length) throws IOException {
        int toWrite;
        this.ensureOk();
        for (int pos = 0; pos < length; pos += toWrite) {
            this.checkBufferIsFull();
            toWrite = Math.min(length - pos, this.buffer.remaining());
            this.buffer.put(bytes, offset + pos, toWrite);
        }
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        this.ensureOk();
        int written = 0;
        while (src.hasRemaining()) {
            this.checkBufferIsFull();
            int toWrite = Math.min(src.remaining(), this.buffer.remaining());
            int thisPos = this.buffer.position();
            int srcPos = src.position();
            this.buffer.put(thisPos, src, srcPos, toWrite).position(thisPos + toWrite);
            written += toWrite;
            src.position(srcPos + toWrite);
        }
        return written;
    }

    @Override
    public boolean isOpen() {
        return !this.closed;
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        try {
            this.completeWriteProcess();
        }
        finally {
            ByteBuffers.releaseBuffer((ByteBuffer)this.buffer, (MemoryTracker)this.memoryTracker);
        }
    }

    protected void ensureOpen() throws IOException {
        if (this.closed) {
            throw new ClosedChannelException();
        }
    }

    protected void ensureOk() throws IOException {
        this.ensureOpen();
        if (this.hasBeenReplicated()) {
            throw new IOException("Cannot write to a channel that has been used in a copyFrom");
        }
        IOException error = this.ioError.get();
        if (error != null) {
            throw error;
        }
    }

    private void checkBufferIsFull() throws IOException {
        if (!this.buffer.hasRemaining()) {
            this.doBufferWrite(this.buffer.flip());
            this.reportChunksWritten(++this.writtenChunks);
            this.buffer.clear();
        }
    }
}

