/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cloud.storage.queues;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import org.neo4j.cloud.storage.StorageUtils;
import org.neo4j.cloud.storage.queues.RequestQueue;
import org.neo4j.function.ThrowingSupplier;
import org.neo4j.util.Preconditions;

public abstract class PullQueue
extends RequestQueue
implements ThrowingSupplier<ByteBuffer, IOException> {
    public static final int QUEUE_SIZE = 4;
    private boolean fillOnNextGet = true;

    protected PullQueue(int queueSize, int chunkSize, long objectSize) {
        super(queueSize, chunkSize, objectSize, 0L);
    }

    public ByteBuffer positionAndGet(long position) throws IOException {
        Preconditions.requireNonNegative((long)position);
        long nextRequestPosition = this.nextRequestPosition();
        if (nextRequestPosition < position) {
            return this.clearAndPosition(position);
        }
        int chunkSize = this.chunkSize();
        long lowestQueueBound = Math.max(0L, nextRequestPosition - (long)this.queueSize() * (long)chunkSize);
        if (position < lowestQueueBound) {
            return this.clearAndPosition(position);
        }
        long offset = position - lowestQueueBound;
        long chunk = offset / (long)chunkSize;
        int chunkOffset = (int)(offset % (long)chunkSize);
        while (chunk-- > 0L) {
            this.poll(false).cancel(true);
        }
        ByteBuffer buffer = this.get();
        return buffer == null ? null : this.signalFilling(buffer.position(chunkOffset));
    }

    public ByteBuffer get() throws IOException {
        if (this.fillOnNextGet) {
            this.fillOnNextGet = false;
            this.fillQueue();
        }
        return this.asByteBuffer(this.poll(true));
    }

    private ByteBuffer clearAndPosition(long position) throws IOException {
        this.clearQueue();
        this.setNextRequestPosition(position);
        if (!this.maybeRequestChunk()) {
            return null;
        }
        return this.signalFilling(this.asByteBuffer(this.poll(false)));
    }

    private ByteBuffer asByteBuffer(CompletableFuture<ByteBuffer> response) throws IOException {
        try {
            return response == null ? null : response.get();
        }
        catch (Exception ex) {
            throw StorageUtils.toIOException(ex, () -> "Unable to get the next chunk of data: " + this);
        }
    }

    private ByteBuffer signalFilling(ByteBuffer data) {
        this.fillOnNextGet = true;
        return data;
    }
}

