/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.cli;

import java.net.URI;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.logging.Handler;
import org.neo4j.shell.ConnectionConfig;
import org.neo4j.shell.cli.AccessMode;
import org.neo4j.shell.cli.CliArgHelper;
import org.neo4j.shell.cli.Encryption;
import org.neo4j.shell.cli.FailBehavior;
import org.neo4j.shell.cli.Format;
import org.neo4j.shell.parameter.ParameterService;
import org.neo4j.shell.terminal.CypherShellTerminal;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class CliArgs {
    static final String DEFAULT_SCHEME = "neo4j";
    static final String DEFAULT_HOST = "localhost";
    static final int DEFAULT_PORT = 7687;
    static final int DEFAULT_NUM_SAMPLE_ROWS = 1000;
    private URI uri;
    private String username = "";
    private Optional<String> impersonatedUser = Optional.empty();
    private String password = "";
    private String databaseName = "";
    private AccessMode accessMode = AccessMode.WRITE;
    private FailBehavior failBehavior = FailBehavior.FAIL_FAST;
    private Format format = Format.AUTO;
    private Optional<String> cypher = Optional.empty();
    private Encryption encryption = Encryption.DEFAULT;
    private boolean nonInteractive;
    private boolean version;
    private boolean driverVersion;
    private int numSampleRows = 1000;
    private boolean wrap = true;
    private String inputFilename;
    private List<ParameterService.RawParameters> parameters;
    private boolean changePassword;
    private CypherShellTerminal.HistoryBehaviour historyBehaviour;
    private Handler logHandler;
    private boolean notificationsEnabled;
    private Duration idleTimeout = CliArgHelper.DEFAULT_IDLE_TIMEOUT;
    private Duration idleTimeoutDelay = CliArgHelper.DEFAULT_IDLE_TIMEOUT_DELAY;

    public void setUsername(String primary, String fallback) {
        this.username = primary == null ? fallback : primary;
    }

    public Optional<String> getImpersonatedUser() {
        return this.impersonatedUser;
    }

    public void setImpersonatedUser(String impersonatedUser) {
        this.impersonatedUser = Optional.ofNullable(impersonatedUser);
    }

    public void setPassword(String primary, String fallback) {
        this.password = primary == null ? fallback : primary;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getDatabase() {
        return this.databaseName;
    }

    public void setDatabase(String databaseName) {
        this.databaseName = databaseName;
    }

    public FailBehavior getFailBehavior() {
        return this.failBehavior;
    }

    void setFailBehavior(FailBehavior failBehavior) {
        this.failBehavior = failBehavior;
    }

    public Optional<String> getCypher() {
        return this.cypher;
    }

    public void setCypher(String cypher) {
        this.cypher = Optional.ofNullable(cypher);
    }

    public Format getFormat() {
        return this.format;
    }

    public void setFormat(Format format) {
        this.format = format;
    }

    public void setParameters(List<ParameterService.RawParameters> parameters) {
        this.parameters = parameters;
    }

    public void setAccessMode(AccessMode accessMode) {
        this.accessMode = accessMode;
    }

    public AccessMode getAccessMode() {
        return this.accessMode;
    }

    public Encryption getEncryption() {
        return this.encryption;
    }

    public void setEncryption(Encryption encryption) {
        this.encryption = encryption;
    }

    public boolean getNonInteractive() {
        return this.nonInteractive;
    }

    public void setNonInteractive(boolean nonInteractive) {
        this.nonInteractive = nonInteractive;
    }

    public String getInputFilename() {
        return this.inputFilename;
    }

    public void setInputFilename(String inputFilename) {
        this.inputFilename = inputFilename;
    }

    public boolean getVersion() {
        return this.version;
    }

    public void setVersion(boolean version) {
        this.version = version;
    }

    public boolean getDriverVersion() {
        return this.driverVersion;
    }

    public void setDriverVersion(boolean version) {
        this.driverVersion = version;
    }

    public boolean isStringShell() {
        return this.cypher.isPresent();
    }

    public boolean getWrap() {
        return this.wrap;
    }

    public void setWrap(boolean wrap) {
        this.wrap = wrap;
    }

    public int getNumSampleRows() {
        return this.numSampleRows;
    }

    public void setNumSampleRows(Integer numSampleRows) {
        if (numSampleRows != null && numSampleRows > 0) {
            this.numSampleRows = numSampleRows;
        }
    }

    public List<ParameterService.RawParameters> getParameters() {
        return this.parameters;
    }

    public void setChangePassword(boolean changePassword) {
        this.changePassword = changePassword;
    }

    public boolean getChangePassword() {
        return this.changePassword;
    }

    public ConnectionConfig connectionConfig() {
        return new ConnectionConfig(this.getUri(), this.getUsername(), this.getPassword(), this.getEncryption(), this.getDatabase(), this.impersonatedUser);
    }

    public CypherShellTerminal.HistoryBehaviour getHistoryBehaviour() {
        return this.historyBehaviour;
    }

    public void setHistoryBehaviour(CypherShellTerminal.HistoryBehaviour historyBehaviour) {
        this.historyBehaviour = historyBehaviour;
    }

    public URI getUri() {
        return this.uri;
    }

    public void setUri(URI uri) {
        this.uri = uri;
    }

    public Optional<Handler> logHandler() {
        return Optional.ofNullable(this.logHandler);
    }

    public void setLogHandler(Handler handler) {
        this.logHandler = handler;
    }

    public boolean getNotificationsEnabled() {
        return this.notificationsEnabled;
    }

    public void setNotificationsEnabled(boolean enabled) {
        this.notificationsEnabled = enabled;
    }

    public void setIdleTimeout(Duration timeout) {
        this.idleTimeout = timeout;
    }

    public Duration getIdleTimeout() {
        return this.idleTimeout;
    }

    public void setIdleTimeoutDelay(Duration delay) {
        this.idleTimeoutDelay = delay;
    }

    public Duration getIdleTimeoutDelay() {
        return this.idleTimeoutDelay;
    }
}

