/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms;

import org.neo4j.dbms.database.DatabaseContextProvider;
import org.neo4j.dbms.database.StandaloneDatabaseContext;
import org.neo4j.graphdb.event.DatabaseEventContext;
import org.neo4j.graphdb.event.DatabaseEventListener;
import org.neo4j.graphdb.event.DatabaseEventListenerAdapter;
import org.neo4j.internal.helpers.Exceptions;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.monitoring.DatabaseEventListeners;
import org.neo4j.kernel.monitoring.ExceptionalDatabaseEvent;

public class CommunityKernelPanicListener
extends DatabaseEventListenerAdapter
implements Lifecycle {
    private final DatabaseEventListeners databaseEventListeners;
    private final DatabaseContextProvider<StandaloneDatabaseContext> databaseContextProvider;

    public CommunityKernelPanicListener(DatabaseEventListeners databaseEventListeners, DatabaseContextProvider<StandaloneDatabaseContext> databaseContextProvider) {
        this.databaseEventListeners = databaseEventListeners;
        this.databaseContextProvider = databaseContextProvider;
    }

    public void databasePanic(DatabaseEventContext eventContext) {
        this.databaseContextProvider.getDatabaseContext(eventContext.getDatabaseName()).ifPresent(context -> context.fail(CommunityKernelPanicListener.getPanicCause(eventContext)));
    }

    private static Throwable getPanicCause(DatabaseEventContext eventContext) {
        ExceptionalDatabaseEvent panic = (ExceptionalDatabaseEvent)eventContext;
        return Exceptions.findCauseOrSuppressed((Throwable)panic.getCause(), throwable -> throwable != null && throwable.getCause() == null).orElse(panic.getCause());
    }

    public void init() {
        this.databaseEventListeners.registerDatabaseEventListener((DatabaseEventListener)this);
    }

    public void start() {
    }

    public void stop() {
    }

    public void shutdown() {
        this.databaseEventListeners.unregisterDatabaseEventListener((DatabaseEventListener)this);
    }
}

