/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.identity;

import java.util.UUID;
import org.neo4j.dbms.identity.AbstractIdentityModule;
import org.neo4j.dbms.identity.ServerId;
import org.neo4j.dbms.identity.ServerIdentityFactory;
import org.neo4j.graphdb.factory.module.GlobalModule;
import org.neo4j.io.state.SimpleStorage;
import org.neo4j.logging.internal.LogService;

public class DefaultIdentityModule
extends AbstractIdentityModule {
    private final ServerId serverId;

    public static ServerIdentityFactory fromGlobalModule() {
        return DefaultIdentityModule::new;
    }

    public DefaultIdentityModule(GlobalModule globalModule) {
        this(globalModule, UUID.randomUUID());
    }

    public DefaultIdentityModule(GlobalModule globalModule, UUID uuid) {
        LogService logService = globalModule.getLogService();
        SimpleStorage<ServerId> storage = DefaultIdentityModule.createServerIdStorage(globalModule.getFileSystem(), globalModule.getNeo4jLayout().serverIdFile());
        this.serverId = DefaultIdentityModule.readOrGenerate(storage, logService.getInternalLog(((Object)((Object)this)).getClass()), ServerId.class, ServerId::new, () -> uuid);
        logService.getUserLog(((Object)((Object)this)).getClass()).info("This instance is %s (%s)", new Object[]{this.serverId, this.serverId.uuid()});
    }

    public ServerId serverId() {
        return this.serverId;
    }
}

