/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.facade;

import java.time.Clock;
import java.util.concurrent.TimeUnit;
import org.neo4j.collection.Dependencies;
import org.neo4j.configuration.Config;
import org.neo4j.dbms.DbmsRuntimeVersionProvider;
import org.neo4j.dbms.database.DatabaseContext;
import org.neo4j.dbms.database.DatabaseContextProvider;
import org.neo4j.dbms.database.DbmsRuntimeSystemGraphComponent;
import org.neo4j.dbms.database.SystemGraphComponent;
import org.neo4j.dbms.database.SystemGraphComponents;
import org.neo4j.dbms.systemgraph.ContextBasedSystemDatabaseProvider;
import org.neo4j.dbms.systemgraph.SystemDatabaseProvider;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.event.DatabaseEventListener;
import org.neo4j.graphdb.facade.GraphDatabaseDependencies;
import org.neo4j.graphdb.factory.module.GlobalModule;
import org.neo4j.graphdb.factory.module.edition.AbstractEditionModule;
import org.neo4j.graphdb.factory.module.edition.migration.MigrationEditionModuleFactory;
import org.neo4j.graphdb.factory.module.edition.migration.SystemDatabaseMigrator;
import org.neo4j.internal.helpers.Exceptions;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.helpers.progress.ProgressListener;
import org.neo4j.kernel.api.security.provider.SecurityProvider;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.impl.factory.DbmsInfo;
import org.neo4j.kernel.impl.storemigration.VisibleMigrationProgressMonitorFactory;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.kernel.internal.event.GlobalTransactionEventListeners;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.logging.InternalLog;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.logging.internal.LogService;
import org.neo4j.logging.internal.SimpleLogService;
import org.neo4j.procedure.impl.GlobalProceduresRegistry;
import org.neo4j.storageengine.migration.MigrationProgressMonitor;

public class SystemDbUpgrader {
    private SystemDbUpgrader() {
    }

    public static void upgrade(MigrationEditionModuleFactory editionFactory, SystemDatabaseMigrator systemDatabaseMigrator, Config config, InternalLogProvider logProvider, final InternalLogProvider systemDbStartupLogProvider, DatabaseEventListener eventListener) throws Exception {
        Transaction tx;
        InternalLog log = logProvider.getLog(SystemDbUpgrader.class);
        MigrationProgressMonitor progressMonitor = VisibleMigrationProgressMonitorFactory.forSystemUpgrade((InternalLog)log);
        progressMonitor.started(3);
        ProgressListener bootstrapProgress = progressMonitor.startSection("Bootstrap");
        GraphDatabaseDependencies graphDatabaseDependencies = GraphDatabaseDependencies.newDependencies().extensions(Iterables.empty()).databaseEventListeners(Iterables.iterable((Object[])new DatabaseEventListener[]{eventListener}));
        GlobalModule globalModule = new GlobalModule(config, DbmsInfo.TOOL, false, graphDatabaseDependencies){

            @Override
            protected LogService createLogService(InternalLogProvider userLogProvider, boolean daemonMode) {
                return new SimpleLogService(systemDbStartupLogProvider);
            }

            @Override
            protected GlobalTransactionEventListeners createGlobalTransactionEventListeners() {
                return GlobalTransactionEventListeners.NULL;
            }
        };
        AbstractEditionModule edition = (AbstractEditionModule)editionFactory.apply(globalModule);
        Dependencies globalDependencies = globalModule.getGlobalDependencies();
        LifeSupport globalLife = globalModule.getGlobalLife();
        globalModule.getGlobalDependencies().satisfyDependency((Object)new GlobalProceduresRegistry());
        SystemGraphComponents.DefaultBuilder systemGraphComponentsBuilder = new SystemGraphComponents.DefaultBuilder();
        DbmsRuntimeSystemGraphComponent dbmsRuntimeSystemGraphComponent = new DbmsRuntimeSystemGraphComponent(globalModule.getGlobalConfig());
        systemGraphComponentsBuilder.register((SystemGraphComponent)dbmsRuntimeSystemGraphComponent);
        edition.registerSystemGraphComponents((SystemGraphComponents.Builder)systemGraphComponentsBuilder, globalModule);
        globalDependencies.satisfyDependency((Object)edition.getSystemGraphComponents());
        DatabaseContextProvider databaseContextProvider = edition.createDatabaseContextProvider(globalModule);
        ContextBasedSystemDatabaseProvider systemDatabaseProvider = new ContextBasedSystemDatabaseProvider(databaseContextProvider);
        edition.bootstrapQueryRouterServices(null);
        edition.registerDatabaseInitializers(globalModule, (SystemDatabaseProvider)systemDatabaseProvider);
        edition.createDefaultDatabaseResolver((SystemDatabaseProvider)systemDatabaseProvider);
        globalDependencies.satisfyDependency((Object)edition.getDefaultDatabaseResolver());
        edition.createSecurityModule(globalModule);
        SecurityProvider securityProvider = edition.getSecurityProvider();
        globalDependencies.satisfyDependencies(new Object[]{securityProvider.authManager()});
        DbmsRuntimeVersionProvider dbmsVersionProvider = edition.createAndRegisterDbmsRuntimeRepository(globalModule, databaseContextProvider, globalDependencies, dbmsRuntimeSystemGraphComponent);
        globalDependencies.satisfyDependency((Object)dbmsVersionProvider);
        globalLife.start();
        DatabaseContext systemContext = (DatabaseContext)databaseContextProvider.getDatabaseContext(NamedDatabaseId.NAMED_SYSTEM_DATABASE_ID).orElseThrow(() -> new IllegalStateException("Could not start System database for upgrade."));
        GraphDatabaseAPI systemDb = systemContext.databaseFacade();
        bootstrapProgress.close();
        ProgressListener indexPopulationProgress = progressMonitor.startSection("Index population");
        try {
            tx = systemDb.beginTx();
            try {
                tx.schema().awaitIndexesOnline(1L, TimeUnit.HOURS);
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (IllegalStateException e) {
            try {
                globalLife.shutdown();
            }
            catch (Exception toSuppress) {
                throw (Exception)Exceptions.chain((Throwable)e, (Throwable)toSuppress);
            }
            throw e;
        }
        indexPopulationProgress.close();
        try {
            tx = systemDb.beginTx();
            try {
                systemDatabaseMigrator.performAdditionalSystemDatabaseMigrationSteps(systemDb, tx, (Clock)globalModule.getGlobalClock(), log);
                tx.commit();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        catch (IllegalStateException e) {
            try {
                globalLife.shutdown();
            }
            catch (Exception toSuppress) {
                throw (Exception)Exceptions.chain((Throwable)e, (Throwable)toSuppress);
            }
            throw e;
        }
        globalLife.shutdown();
        progressMonitor.completed();
    }
}

