/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.factory.module;

import java.time.Clock;
import java.util.function.Function;
import java.util.function.LongFunction;
import java.util.function.Predicate;
import org.neo4j.collection.Dependencies;
import org.neo4j.common.DependencyResolver;
import org.neo4j.configuration.DatabaseConfig;
import org.neo4j.dbms.database.readonly.ReadOnlyDatabases;
import org.neo4j.dbms.identity.ServerIdentity;
import org.neo4j.dbms.systemgraph.TopologyGraphDbmsModel;
import org.neo4j.function.Factory;
import org.neo4j.function.Predicates;
import org.neo4j.graphdb.factory.module.GlobalModule;
import org.neo4j.graphdb.factory.module.id.DatabaseIdContext;
import org.neo4j.internal.id.BufferingIdGeneratorFactory;
import org.neo4j.internal.id.IdController;
import org.neo4j.internal.id.IdGeneratorFactory;
import org.neo4j.io.device.DeviceMapper;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.watcher.DatabaseLayoutWatcher;
import org.neo4j.io.fs.watcher.FileWatchEventListenerFactory;
import org.neo4j.io.fs.watcher.FileWatcher;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.layout.Neo4jLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.kernel.api.SpdKernelTransactionDecorator;
import org.neo4j.kernel.api.procedure.GlobalProcedures;
import org.neo4j.kernel.availability.DatabaseAvailabilityGuard;
import org.neo4j.kernel.database.DatabaseCreationContext;
import org.neo4j.kernel.database.DatabaseStartupController;
import org.neo4j.kernel.database.DatabaseTracers;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.database.StorageEngineFactorySupplier;
import org.neo4j.kernel.extension.ExtensionFactory;
import org.neo4j.kernel.impl.api.CommandCommitListeners;
import org.neo4j.kernel.impl.api.CommitProcessFactory;
import org.neo4j.kernel.impl.api.ExternalIdReuseConditionProvider;
import org.neo4j.kernel.impl.api.LeaseService;
import org.neo4j.kernel.impl.constraints.ConstraintSemantics;
import org.neo4j.kernel.impl.factory.AccessCapabilityFactory;
import org.neo4j.kernel.impl.factory.DbmsInfo;
import org.neo4j.kernel.impl.index.DatabaseIndexStats;
import org.neo4j.kernel.impl.pagecache.IOControllerService;
import org.neo4j.kernel.impl.pagecache.VersionStorageFactory;
import org.neo4j.kernel.impl.query.QueryEngineProvider;
import org.neo4j.kernel.impl.transaction.log.checkpoint.StoreCopyCheckPointMutex;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogFilesHelper;
import org.neo4j.kernel.impl.transaction.stats.DatabaseTransactionStats;
import org.neo4j.kernel.impl.util.collection.CollectionsFactorySupplier;
import org.neo4j.kernel.impl.util.watcher.DefaultFileDeletionListenerFactory;
import org.neo4j.kernel.internal.event.GlobalTransactionEventListeners;
import org.neo4j.kernel.internal.locker.FileLockerService;
import org.neo4j.kernel.monitoring.DatabaseEventListeners;
import org.neo4j.kernel.monitoring.DatabaseHealthEventGenerator;
import org.neo4j.logging.InternalLog;
import org.neo4j.logging.internal.DatabaseLogService;
import org.neo4j.logging.internal.LogService;
import org.neo4j.memory.GlobalMemoryGroupTracker;
import org.neo4j.monitoring.DatabaseHealth;
import org.neo4j.monitoring.HealthEventGenerator;
import org.neo4j.monitoring.Monitors;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.time.SystemNanoClock;
import org.neo4j.token.TokenHolders;

public class ModularDatabaseCreationContext
implements DatabaseCreationContext {
    private final ServerIdentity serverIdentity;
    private final NamedDatabaseId namedDatabaseId;
    private final DatabaseConfig databaseConfig;
    private final QueryEngineProvider queryEngineProvider;
    private final ExternalIdReuseConditionProvider externalIdReuseConditionProvider;
    private final IdGeneratorFactory idGeneratorFactory;
    private final DatabaseLogService databaseLogService;
    private final JobScheduler scheduler;
    private final DependencyResolver globalDependencies;
    private final TokenHolders tokenHolders;
    private final FileSystemAbstraction fs;
    private final DatabaseTransactionStats transactionStats;
    private final DatabaseIndexStats indexStats;
    private final Factory<DatabaseHealth> databaseHealthFactory;
    private final CommitProcessFactory commitProcessFactory;
    private final PageCache pageCache;
    private final ConstraintSemantics constraintSemantics;
    private final Monitors parentMonitors;
    private final DatabaseTracers tracers;
    private final GlobalProcedures globalProcedures;
    private final IOControllerService ioControllerService;
    private final LongFunction<DatabaseAvailabilityGuard> databaseAvailabilityGuardFactory;
    private final SystemNanoClock clock;
    private final StoreCopyCheckPointMutex storeCopyCheckPointMutex;
    private final IdController idController;
    private final DbmsInfo dbmsInfo;
    private final TopologyGraphDbmsModel.HostedOnMode mode;
    private final CursorContextFactory contextFactory;
    private final VersionStorageFactory versionStorageFactory;
    private final DeviceMapper deviceMapper;
    private final CollectionsFactorySupplier collectionsFactorySupplier;
    private final Iterable<ExtensionFactory<?>> extensionFactories;
    private final Function<DatabaseLayout, DatabaseLayoutWatcher> watcherServiceFactory;
    private final DatabaseLayout databaseLayout;
    private final DatabaseEventListeners eventListeners;
    private final GlobalTransactionEventListeners transactionEventListeners;
    private final StorageEngineFactorySupplier storageEngineFactorySupplier;
    private final FileLockerService fileLockerService;
    private final AccessCapabilityFactory accessCapabilityFactory;
    private final LeaseService leaseService;
    private final DatabaseStartupController startupController;
    private final GlobalMemoryGroupTracker transactionsMemoryPool;
    private final GlobalMemoryGroupTracker otherMemoryPool;
    private final ReadOnlyDatabases readOnlyDatabases;
    private final CommandCommitListeners commandCommitListeners;
    private final SpdKernelTransactionDecorator spdKernelTransactionDecorator;

    public ModularDatabaseCreationContext(TopologyGraphDbmsModel.HostedOnMode mode, ServerIdentity serverIdentity, NamedDatabaseId namedDatabaseId, GlobalModule globalModule, Dependencies globalDependencies, CursorContextFactory contextFactory, DeviceMapper deviceMapper, VersionStorageFactory versionStorageFactory, DatabaseConfig databaseConfig, Monitors parentMonitors, LeaseService leaseService, StorageEngineFactorySupplier storageEngineFactorySupplier, ConstraintSemantics constraintSemantics, QueryEngineProvider queryEngineProvider, DatabaseTransactionStats transactionStats, DatabaseIndexStats indexStats, Predicate<String> databaseFileFilter, AccessCapabilityFactory accessCapabilityFactory, ExternalIdReuseConditionProvider externalIdReuseConditionProvider, DatabaseIdContext databaseIdContext, CommitProcessFactory commitProcessFactory, TokenHolders tokenHolders, DatabaseStartupController databaseStartupController, ReadOnlyDatabases readOnlyDatabases, IOControllerService ioControllerService, DatabaseTracers tracers, CommandCommitListeners commandCommitListeners, SpdKernelTransactionDecorator spdKernelTransactionDecorator) {
        this.serverIdentity = serverIdentity;
        this.namedDatabaseId = namedDatabaseId;
        this.databaseConfig = databaseConfig;
        this.contextFactory = contextFactory;
        this.deviceMapper = deviceMapper;
        this.versionStorageFactory = versionStorageFactory;
        this.queryEngineProvider = queryEngineProvider;
        this.externalIdReuseConditionProvider = externalIdReuseConditionProvider;
        this.idGeneratorFactory = databaseIdContext.getIdGeneratorFactory();
        this.idController = databaseIdContext.getIdController();
        this.transactionsMemoryPool = globalModule.getTransactionsMemoryPool();
        this.otherMemoryPool = globalModule.getOtherMemoryPool();
        this.databaseLogService = new DatabaseLogService(namedDatabaseId, globalModule.getLogService());
        this.scheduler = globalModule.getJobScheduler();
        this.globalDependencies = globalDependencies;
        this.tokenHolders = tokenHolders;
        this.transactionEventListeners = globalModule.getTransactionEventListeners();
        this.parentMonitors = parentMonitors;
        this.fs = globalModule.getFileSystem();
        this.transactionStats = transactionStats;
        this.indexStats = indexStats;
        this.eventListeners = globalModule.getDatabaseEventListeners();
        this.databaseHealthFactory = () -> new DatabaseHealth((HealthEventGenerator)new DatabaseHealthEventGenerator(this.eventListeners, namedDatabaseId), this.databaseLogService.getInternalLog(DatabaseHealth.class));
        this.commitProcessFactory = commitProcessFactory;
        this.pageCache = globalModule.getPageCache();
        this.constraintSemantics = constraintSemantics;
        this.tracers = tracers;
        this.globalProcedures = (GlobalProcedures)globalDependencies.resolveDependency(GlobalProcedures.class);
        this.ioControllerService = ioControllerService;
        this.clock = globalModule.getGlobalClock();
        this.storeCopyCheckPointMutex = new StoreCopyCheckPointMutex();
        this.dbmsInfo = globalModule.getDbmsInfo();
        this.mode = mode;
        this.collectionsFactorySupplier = globalModule.getCollectionsFactorySupplier();
        this.extensionFactories = globalModule.getExtensionFactories();
        this.watcherServiceFactory = databaseLayout -> ModularDatabaseCreationContext.createDatabaseFileSystemWatcher(globalModule.getFileWatcher(), databaseLayout, globalModule.getLogService(), databaseFileFilter);
        this.databaseAvailabilityGuardFactory = databaseTimeoutMillis -> this.databaseAvailabilityGuardFactory(namedDatabaseId, globalModule, databaseTimeoutMillis);
        Neo4jLayout neo4jLayout = globalModule.getNeo4jLayout();
        this.storageEngineFactorySupplier = storageEngineFactorySupplier;
        this.databaseLayout = neo4jLayout.databaseLayout(namedDatabaseId.name());
        this.fileLockerService = globalModule.getFileLockerService();
        this.accessCapabilityFactory = accessCapabilityFactory;
        this.leaseService = leaseService;
        this.startupController = databaseStartupController;
        this.readOnlyDatabases = readOnlyDatabases;
        this.commandCommitListeners = commandCommitListeners;
        this.spdKernelTransactionDecorator = spdKernelTransactionDecorator;
    }

    public ServerIdentity getServerIdentity() {
        return this.serverIdentity;
    }

    public NamedDatabaseId getNamedDatabaseId() {
        return this.namedDatabaseId;
    }

    public DatabaseLayout getDatabaseLayout() {
        return this.databaseLayout;
    }

    public DatabaseConfig getDatabaseConfig() {
        return this.databaseConfig;
    }

    public IdGeneratorFactory getIdGeneratorFactory() {
        return this.idGeneratorFactory;
    }

    public DatabaseLogService getDatabaseLogService() {
        return this.databaseLogService;
    }

    public JobScheduler getScheduler() {
        return this.scheduler;
    }

    public DependencyResolver getGlobalDependencies() {
        return this.globalDependencies;
    }

    public TokenHolders getTokenHolders() {
        return this.tokenHolders;
    }

    public GlobalTransactionEventListeners getTransactionEventListeners() {
        return this.transactionEventListeners;
    }

    public FileSystemAbstraction getFs() {
        return this.fs;
    }

    public DatabaseTransactionStats getTransactionStats() {
        return this.transactionStats;
    }

    public DatabaseIndexStats getIndexStats() {
        return this.indexStats;
    }

    public Factory<DatabaseHealth> getDatabaseHealthFactory() {
        return this.databaseHealthFactory;
    }

    public CommitProcessFactory getCommitProcessFactory() {
        return this.commitProcessFactory;
    }

    public PageCache getPageCache() {
        return this.pageCache;
    }

    public ConstraintSemantics getConstraintSemantics() {
        return this.constraintSemantics;
    }

    public Monitors getMonitors() {
        return this.parentMonitors;
    }

    public DatabaseTracers getTracers() {
        return this.tracers;
    }

    public GlobalProcedures getGlobalProcedures() {
        return this.globalProcedures;
    }

    public IOControllerService getIoControllerService() {
        return this.ioControllerService;
    }

    public LongFunction<DatabaseAvailabilityGuard> getDatabaseAvailabilityGuardFactory() {
        return this.databaseAvailabilityGuardFactory;
    }

    public SystemNanoClock getClock() {
        return this.clock;
    }

    public StoreCopyCheckPointMutex getStoreCopyCheckPointMutex() {
        return this.storeCopyCheckPointMutex;
    }

    public IdController getIdController() {
        return this.idController;
    }

    public DbmsInfo getDbmsInfo() {
        return this.dbmsInfo;
    }

    public TopologyGraphDbmsModel.HostedOnMode getMode() {
        return this.mode;
    }

    public CollectionsFactorySupplier getCollectionsFactorySupplier() {
        return this.collectionsFactorySupplier;
    }

    public Iterable<ExtensionFactory<?>> getExtensionFactories() {
        return this.extensionFactories;
    }

    public Function<DatabaseLayout, DatabaseLayoutWatcher> getWatcherServiceFactory() {
        return this.watcherServiceFactory;
    }

    public QueryEngineProvider getEngineProvider() {
        return this.queryEngineProvider;
    }

    public DatabaseEventListeners getDatabaseEventListeners() {
        return this.eventListeners;
    }

    public StorageEngineFactorySupplier getStorageEngineFactorySupplier() {
        return this.storageEngineFactorySupplier;
    }

    public FileLockerService getFileLockerService() {
        return this.fileLockerService;
    }

    public AccessCapabilityFactory getAccessCapabilityFactory() {
        return this.accessCapabilityFactory;
    }

    public LeaseService getLeaseService() {
        return this.leaseService;
    }

    public DatabaseStartupController getStartupController() {
        return this.startupController;
    }

    public GlobalMemoryGroupTracker getTransactionsMemoryPool() {
        return this.transactionsMemoryPool;
    }

    public GlobalMemoryGroupTracker getOtherMemoryPool() {
        return this.otherMemoryPool;
    }

    public ReadOnlyDatabases getDbmsReadOnlyChecker() {
        return this.readOnlyDatabases;
    }

    public CursorContextFactory getContextFactory() {
        return this.contextFactory;
    }

    public VersionStorageFactory getVersionStorageFactory() {
        return this.versionStorageFactory;
    }

    public DeviceMapper getDeviceMapper() {
        return this.deviceMapper;
    }

    public CommandCommitListeners getCommandCommitListeners() {
        return this.commandCommitListeners;
    }

    public SpdKernelTransactionDecorator getSpdKernelTransactionDecorator() {
        return this.spdKernelTransactionDecorator;
    }

    public ExternalIdReuseConditionProvider externalIdReuseConditionProvider() {
        return this.externalIdReuseConditionProvider;
    }

    private DatabaseAvailabilityGuard databaseAvailabilityGuardFactory(NamedDatabaseId namedDatabaseId, GlobalModule globalModule, long databaseTimeoutMillis) {
        InternalLog guardLog = this.databaseLogService.getInternalLog(DatabaseAvailabilityGuard.class);
        return new DatabaseAvailabilityGuard(namedDatabaseId, (Clock)this.clock, guardLog, databaseTimeoutMillis, globalModule.getGlobalAvailabilityGuard());
    }

    private static DatabaseLayoutWatcher createDatabaseFileSystemWatcher(FileWatcher watcher, DatabaseLayout databaseLayout, LogService logging, Predicate<String> fileNameFilter) {
        DefaultFileDeletionListenerFactory listenerFactory = new DefaultFileDeletionListenerFactory(databaseLayout, logging, fileNameFilter);
        return new DatabaseLayoutWatcher(watcher, databaseLayout, (FileWatchEventListenerFactory)listenerFactory);
    }

    public static Predicate<String> defaultFileWatcherFilter() {
        return Predicates.any((Predicate[])new Predicate[]{TransactionLogFilesHelper.DEFAULT_FILENAME_PREDICATE, BufferingIdGeneratorFactory.PAGED_ID_BUFFER_FILE_NAME_FILTER});
    }
}

