/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.factory.module.edition;

import java.util.function.Supplier;
import org.neo4j.bolt.dbapi.BoltGraphDatabaseManagementServiceSPI;
import org.neo4j.bolt.tx.TransactionManager;
import org.neo4j.collection.Dependencies;
import org.neo4j.common.DependencyResolver;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.connectors.ConnectorPortRegister;
import org.neo4j.dbms.DbmsRuntimeVersionProvider;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.dbms.database.DatabaseContext;
import org.neo4j.dbms.database.DatabaseContextProvider;
import org.neo4j.dbms.database.DbmsRuntimeSystemGraphComponent;
import org.neo4j.dbms.database.StandaloneDbmsRuntimeVersionProvider;
import org.neo4j.dbms.database.SystemGraphComponents;
import org.neo4j.dbms.database.TopologyInfoService;
import org.neo4j.dbms.routing.ClientRoutingDomainChecker;
import org.neo4j.dbms.routing.RoutingOption;
import org.neo4j.dbms.routing.RoutingService;
import org.neo4j.dbms.routing.RoutingTableTTLProvider;
import org.neo4j.dbms.routing.ServerSideRoutingTableProvider;
import org.neo4j.dbms.routing.SimpleClientRoutingDomainChecker;
import org.neo4j.dbms.routing.SingleAddressRoutingTableProvider;
import org.neo4j.dbms.systemgraph.SystemDatabaseProvider;
import org.neo4j.exceptions.KernelException;
import org.neo4j.graphdb.event.TransactionEventListener;
import org.neo4j.graphdb.factory.module.GlobalModule;
import org.neo4j.graphdb.factory.module.id.IdContextFactory;
import org.neo4j.graphdb.factory.module.id.IdContextFactoryProvider;
import org.neo4j.internal.collector.DataCollectorProcedures;
import org.neo4j.kernel.api.net.DefaultNetworkConnectionTracker;
import org.neo4j.kernel.api.net.NetworkConnectionTracker;
import org.neo4j.kernel.api.procedure.GlobalProcedures;
import org.neo4j.kernel.api.security.AuthManager;
import org.neo4j.kernel.api.security.provider.SecurityProvider;
import org.neo4j.kernel.database.DatabaseReferenceRepository;
import org.neo4j.kernel.database.DefaultDatabaseResolver;
import org.neo4j.kernel.impl.factory.DbmsInfo;
import org.neo4j.kernel.impl.index.DatabaseIndexStats;
import org.neo4j.kernel.impl.transaction.stats.DatabaseTransactionStats;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.procedure.builtin.BuiltInDbmsProcedures;
import org.neo4j.procedure.builtin.BuiltInProcedures;
import org.neo4j.procedure.builtin.FulltextProcedures;
import org.neo4j.procedure.builtin.TokenProcedures;
import org.neo4j.procedure.builtin.VectorIndexProcedures;
import org.neo4j.procedure.builtin.graphschema.Introspect;
import org.neo4j.procedure.builtin.routing.RoutingProcedureInstaller;
import org.neo4j.procedure.impl.ProcedureConfig;
import org.neo4j.procedure.impl.temporal.TemporalFunction;
import org.neo4j.server.config.AuthConfigProvider;
import org.neo4j.util.FeatureToggles;

public abstract class AbstractEditionModule {
    protected NetworkConnectionTracker connectionTracker;
    protected SecurityProvider securityProvider;
    protected DefaultDatabaseResolver defaultDatabaseResolver;

    public void registerProcedures(GlobalProcedures globalProcedures, ProcedureConfig procedureConfig, GlobalModule globalModule, DatabaseContextProvider<?> databaseContextProvider, RoutingService routingService) throws KernelException {
        globalProcedures.registerProcedure(BuiltInProcedures.class);
        globalProcedures.registerProcedure(TokenProcedures.class);
        globalProcedures.registerProcedure(BuiltInDbmsProcedures.class);
        globalProcedures.registerProcedure(FulltextProcedures.class);
        globalProcedures.registerProcedure(VectorIndexProcedures.class);
        globalProcedures.registerProcedure(DataCollectorProcedures.class);
        if (FeatureToggles.flag(Introspect.class, (String)"enabled", (boolean)false)) {
            globalProcedures.registerProcedure(Introspect.class);
        }
        TemporalFunction.registerTemporalFunctions((GlobalProcedures)globalProcedures, (ProcedureConfig)procedureConfig);
        this.registerEditionSpecificProcedures(globalProcedures, databaseContextProvider);
        RoutingProcedureInstaller.install((GlobalProcedures)globalProcedures, (RoutingService)routingService, (InternalLogProvider)globalModule.getLogService().getInternalLogProvider());
    }

    public ClientRoutingDomainChecker createClientRoutingDomainChecker(GlobalModule globalModule) {
        Config config = globalModule.getGlobalConfig();
        ClientRoutingDomainChecker domainChecker = SimpleClientRoutingDomainChecker.fromConfig((Config)config, (InternalLogProvider)globalModule.getLogService().getInternalLogProvider());
        globalModule.getGlobalDependencies().satisfyDependencies(new Object[]{domainChecker});
        return domainChecker;
    }

    protected void registerEditionSpecificProcedures(GlobalProcedures globalProcedures, DatabaseContextProvider<?> databaseContextProvider) throws KernelException {
    }

    protected abstract AuthConfigProvider createAuthConfigProvider(GlobalModule var1);

    public abstract <DB extends DatabaseContext> DatabaseContextProvider<DB> createDatabaseContextProvider(GlobalModule var1);

    public abstract void registerDatabaseInitializers(GlobalModule var1, SystemDatabaseProvider var2);

    public abstract void registerSystemGraphComponents(SystemGraphComponents.Builder var1, GlobalModule var2);

    public abstract SystemGraphComponents getSystemGraphComponents();

    public abstract void createSecurityModule(GlobalModule var1);

    public abstract DatabaseReferenceRepository getDatabaseReferenceRepo();

    protected static NetworkConnectionTracker createConnectionTracker() {
        return new DefaultNetworkConnectionTracker();
    }

    public DatabaseTransactionStats.Factory getTransactionMonitorFactory() {
        return DatabaseTransactionStats::new;
    }

    public DatabaseIndexStats.Factory getIndexMonitorFactory() {
        return DatabaseIndexStats::new;
    }

    public NetworkConnectionTracker getConnectionTracker() {
        return this.connectionTracker;
    }

    public SecurityProvider getSecurityProvider() {
        return this.securityProvider;
    }

    public void setSecurityProvider(SecurityProvider securityProvider) {
        this.securityProvider = securityProvider;
    }

    public abstract void createDefaultDatabaseResolver(SystemDatabaseProvider var1);

    public DefaultDatabaseResolver getDefaultDatabaseResolver() {
        return this.defaultDatabaseResolver;
    }

    public abstract void bootstrapQueryRouterServices(DatabaseManagementService var1);

    public abstract BoltGraphDatabaseManagementServiceSPI createBoltDatabaseManagementServiceProvider();

    public AuthManager getBoltAuthManager(DependencyResolver dependencyResolver) {
        return (AuthManager)dependencyResolver.resolveDependency(AuthManager.class);
    }

    public AuthManager getBoltInClusterAuthManager() {
        return this.securityProvider.inClusterAuthManager();
    }

    public AuthManager getBoltLoopbackAuthManager() {
        return this.securityProvider.loopbackAuthManager();
    }

    public abstract Lifecycle createWebServer(DatabaseManagementService var1, TransactionManager var2, Dependencies var3, Config var4, InternalLogProvider var5, DbmsInfo var6);

    public DbmsRuntimeVersionProvider createAndRegisterDbmsRuntimeRepository(GlobalModule globalModule, DatabaseContextProvider<?> databaseContextProvider, Dependencies dependencies, DbmsRuntimeSystemGraphComponent dbmsRuntimeSystemGraphComponent) {
        StandaloneDbmsRuntimeVersionProvider dbmsRuntimeRepository = new StandaloneDbmsRuntimeVersionProvider(databaseContextProvider, dbmsRuntimeSystemGraphComponent);
        globalModule.getTransactionEventListeners().registerTransactionEventListener("system", (TransactionEventListener)dbmsRuntimeRepository);
        return dbmsRuntimeRepository;
    }

    protected ServerSideRoutingTableProvider serverSideRoutingTableProvider(GlobalModule globalModule) {
        ConnectorPortRegister portRegister = globalModule.getConnectorPortRegister();
        Config config = globalModule.getGlobalConfig();
        InternalLogProvider logProvider = globalModule.getLogService().getInternalLogProvider();
        RoutingTableTTLProvider ttlProvider = RoutingTableTTLProvider.ttlFromConfig((Config)config);
        return new SingleAddressRoutingTableProvider(portRegister, RoutingOption.ROUTE_WRITE_AND_READ, config, logProvider, ttlProvider);
    }

    public abstract TopologyInfoService createTopologyInfoService(DatabaseContextProvider<?> var1);

    public abstract RoutingService createRoutingService(DatabaseContextProvider<?> var1, ClientRoutingDomainChecker var2);

    public static <T> T tryResolveOrCreate(Class<T> clazz, DependencyResolver dependencies, Supplier<T> newInstanceMethod) {
        return (T)(dependencies.containsDependency(clazz) ? dependencies.resolveDependency(clazz) : newInstanceMethod.get());
    }

    public static IdContextFactory createIdContextFactory(GlobalModule globalModule) {
        return AbstractEditionModule.tryResolveOrCreate(IdContextFactory.class, globalModule.getExternalDependencyResolver(), () -> IdContextFactoryProvider.getInstance().buildIdContextFactory(globalModule));
    }

    public abstract ProcedureConfig getProcedureConfig(Config var1);
}

