/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.factory.module.id;

import java.util.function.Function;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.DatabaseConfig;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.graphdb.factory.module.id.DatabaseIdContext;
import org.neo4j.graphdb.factory.module.id.IdContextFactory;
import org.neo4j.internal.id.AbstractBufferingIdGeneratorFactory;
import org.neo4j.internal.id.BufferedIdController;
import org.neo4j.internal.id.BufferingIdGeneratorFactory;
import org.neo4j.internal.id.IdController;
import org.neo4j.internal.id.IdGeneratorFactory;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.logging.internal.LogService;
import org.neo4j.scheduler.JobScheduler;

public class DefaultIdContextFactory
implements IdContextFactory {
    private final JobScheduler jobScheduler;
    private final IdContextFactory.IdGeneratorFactoryCreator idFactoryProvider;
    private final Function<IdGeneratorFactory, IdGeneratorFactory> factoryWrapper;
    private final LogService logService;

    protected DefaultIdContextFactory(JobScheduler jobScheduler, IdContextFactory.IdGeneratorFactoryCreator idFactoryProvider, Function<IdGeneratorFactory, IdGeneratorFactory> factoryWrapper, LogService logService) {
        this.jobScheduler = jobScheduler;
        this.idFactoryProvider = idFactoryProvider;
        this.factoryWrapper = factoryWrapper;
        this.logService = logService;
    }

    protected AbstractBufferingIdGeneratorFactory wrapWithBufferingFactory(IdGeneratorFactory idGeneratorFactory, DatabaseConfig databaseConfig) {
        return new BufferingIdGeneratorFactory(idGeneratorFactory);
    }

    @Override
    public DatabaseIdContext createIdContext(NamedDatabaseId namedDatabaseId, CursorContextFactory contextFactory, DatabaseConfig databaseConfig, boolean allocationInitiallyEnabled) {
        return this.createBufferingIdContext(this.idFactoryProvider, this.jobScheduler, contextFactory, namedDatabaseId, databaseConfig, allocationInitiallyEnabled);
    }

    private DatabaseIdContext createBufferingIdContext(IdContextFactory.IdGeneratorFactoryCreator idGeneratorFactoryProvider, JobScheduler jobScheduler, CursorContextFactory contextFactory, NamedDatabaseId namedDatabaseId, DatabaseConfig databaseConfig, boolean allocationInitiallyEnabled) {
        IdGeneratorFactory idGeneratorFactory = idGeneratorFactoryProvider.apply(namedDatabaseId, allocationInitiallyEnabled);
        AbstractBufferingIdGeneratorFactory bufferingIdGeneratorFactory = this.wrapWithBufferingFactory(idGeneratorFactory, databaseConfig);
        BufferedIdController bufferingController = DefaultIdContextFactory.createBufferedIdController(bufferingIdGeneratorFactory, jobScheduler, contextFactory, namedDatabaseId.name(), this.logService, databaseConfig);
        return this.createIdContext((IdGeneratorFactory)bufferingIdGeneratorFactory, (IdController)bufferingController);
    }

    private DatabaseIdContext createIdContext(IdGeneratorFactory idGeneratorFactory, IdController idController) {
        return new DatabaseIdContext(this.factoryWrapper.apply(idGeneratorFactory), idController);
    }

    private static BufferedIdController createBufferedIdController(AbstractBufferingIdGeneratorFactory idGeneratorFactory, JobScheduler scheduler, CursorContextFactory contextFactory, String databaseName, LogService logService, DatabaseConfig databaseConfig) {
        return new BufferedIdController(idGeneratorFactory, scheduler, contextFactory, databaseConfig, databaseName, logService);
    }

    protected static boolean isMultiVersion(Config databaseConfig) {
        return "multiversion".equals(databaseConfig.get(GraphDatabaseSettings.db_format));
    }
}

