/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.startup;

import java.io.IOException;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.collections.api.factory.Lists;
import org.neo4j.cli.CommandFailedException;
import org.neo4j.configuration.BootloaderSettings;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.SettingValueParser;
import org.neo4j.configuration.SettingValueParsers;
import org.neo4j.configuration.connectors.HttpConnector;
import org.neo4j.configuration.connectors.HttpsConnector;
import org.neo4j.function.Predicates;
import org.neo4j.graphdb.config.Configuration;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.io.IOUtils;
import org.neo4j.server.startup.BootProcessFailureException;
import org.neo4j.server.startup.BootloaderOsAbstraction;
import org.neo4j.server.startup.EntryPoint;
import org.neo4j.server.startup.Environment;
import org.neo4j.server.startup.ProcessManager;
import org.neo4j.server.startup.validation.ConfigValidationHelper;
import org.neo4j.server.startup.validation.ConfigValidationSummary;
import org.neo4j.time.Stopwatch;
import org.neo4j.util.VisibleForTesting;

public abstract class Bootloader
implements AutoCloseable {
    static final int EXIT_CODE_OK = 0;
    static final int EXIT_CODE_RUNNING = 1;
    static final int EXIT_CODE_NOT_RUNNING = 3;
    static final String ENV_NEO4J_HOME = "NEO4J_HOME";
    static final String ENV_NEO4J_CONF = "NEO4J_CONF";
    static final String ENV_NEO4J_SHUTDOWN_TIMEOUT = "NEO4J_SHUTDOWN_TIMEOUT";
    static final String ENV_HEAP_SIZE = "HEAP_SIZE";
    static final String ENV_JAVA_OPTS = "JAVA_OPTS";
    static final String PROP_JAVA_CP = "java.class.path";
    static final String PROP_VM_NAME = "java.vm.name";
    static final String PROP_BASEDIR = "basedir";
    static final String ARG_EXPAND_COMMANDS = "--expand-commands";
    static final String ARG_CONSOLE_MODE = "--console-mode";
    static final Path DEFAULT_CONFIG_LOCATION = Path.of("conf", new String[0]);
    static final int DEFAULT_NEO4J_SHUTDOWN_TIMEOUT = 120;
    final Class<?> entrypoint;
    final Environment environment;
    final boolean verbose;
    final boolean expandCommands;
    final List<String> additionalArgs;
    private Path home;
    private Path conf;
    private FilteredConfig config;
    private boolean fullConfig;
    private BootloaderOsAbstraction os;
    private ProcessManager processManager;
    private URLClassLoader pluginClassloader;

    protected Bootloader(Class<?> entrypoint, Environment environment, boolean expandCommands, boolean verbose, String ... additionalArgs) {
        this.entrypoint = entrypoint;
        this.environment = environment;
        this.expandCommands = expandCommands;
        this.verbose = verbose;
        this.additionalArgs = Lists.mutable.with((Object[])additionalArgs);
    }

    String getEnv(String key) {
        return this.getEnv(key, "", SettingValueParsers.STRING);
    }

    <T> T getEnv(String key, T defaultValue, SettingValueParser<T> parser) {
        return this.getValue(key, defaultValue, parser, this.environment.envLookup());
    }

    String getProp(String key) {
        return this.getProp(key, "", SettingValueParsers.STRING);
    }

    <T> T getProp(String key, T defaultValue, SettingValueParser<T> parser) {
        return this.getValue(key, defaultValue, parser, this.environment.propLookup());
    }

    private <T> T getValue(String key, T defaultValue, SettingValueParser<T> parser, Function<String, String> lookup) {
        String value = lookup.apply(key);
        try {
            return (T)(StringUtils.isNotEmpty((CharSequence)value) ? parser.parse(value) : defaultValue);
        }
        catch (IllegalArgumentException e) {
            throw new CommandFailedException("Failed to parse value for " + key + ". " + e.getMessage(), (Throwable)e, 1);
        }
    }

    Path home() {
        if (this.home == null) {
            Path defaultHome = this.getProp(PROP_BASEDIR, Path.of("", new String[0]).toAbsolutePath().getParent(), SettingValueParsers.PATH);
            this.home = this.getEnv(ENV_NEO4J_HOME, defaultHome, SettingValueParsers.PATH).toAbsolutePath();
        }
        return this.home;
    }

    public Path confDir() {
        if (this.conf == null) {
            this.conf = this.getEnv(ENV_NEO4J_CONF, this.home().resolve(DEFAULT_CONFIG_LOCATION), SettingValueParsers.PATH);
        }
        return this.conf;
    }

    public Path confFile() {
        return this.confDir().resolve("neo4j.conf");
    }

    public FilteredConfig fullConfig() {
        return this.config(true, false);
    }

    protected void validateConfigVerbose(boolean silentOnSuccess) {
        ConfigValidationHelper helper = new ConfigValidationHelper(this.confFile());
        ConfigValidationSummary summary = helper.validateAll(() -> this.fullConfig().getUnfiltered());
        if (silentOnSuccess) {
            if (summary.result() == ConfigValidationSummary.ValidationResult.ERRORS) {
                summary.print(this.environment.err(), this.verbose);
                summary.printClosingStatement(this.environment.err());
            }
        } else if (summary.result() != ConfigValidationSummary.ValidationResult.OK) {
            summary.print(this.environment.err(), this.verbose);
            summary.printClosingStatement(this.environment.out());
        }
        if (summary.result() == ConfigValidationSummary.ValidationResult.ERRORS) {
            throw new CommandFailedException("Configuration contains errors. This validation can be performed again using 'neo4j-admin server validate-config'.", 1);
        }
    }

    protected void validateConfig() {
        this.config(true, false);
    }

    void rebuildConfig(List<Path> additionalConfigs) {
        this.config = this.buildConfig(true, additionalConfigs, this.confFile(), false);
        this.fullConfig = true;
    }

    public FilteredConfig config() {
        return this.config(false, false);
    }

    private FilteredConfig config(boolean full, boolean allowThrow) {
        if (this.config == null || !this.fullConfig && full) {
            this.config = this.buildConfig(full, List.of(), this.confFile(), allowThrow);
            this.fullConfig = full;
        }
        return this.config;
    }

    private FilteredConfig buildConfig(boolean full, List<Path> additionalConfigs, Path mainConfFile, boolean allowThrow) {
        try {
            Predicate<String> filter = full ? Predicates.alwaysTrue() : Bootloader.settingsUsedByBootloader()::contains;
            Config.Builder builder = this.getConfigBuilder(full).commandExpansion(this.expandCommands).setDefaults(this.overriddenDefaultsValues()).set(GraphDatabaseSettings.neo4j_home, (Object)this.home()).fromFile(mainConfFile, allowThrow, filter);
            Collections.reverse(additionalConfigs);
            additionalConfigs.forEach(additionalConfig -> builder.fromFile(additionalConfig, false, filter));
            return new FilteredConfig(builder.build(), filter);
        }
        catch (RuntimeException e) {
            if (additionalConfigs.isEmpty()) {
                throw new CommandFailedException("Failed to read config " + mainConfFile + ": " + e.getMessage(), (Throwable)e);
            }
            throw new CommandFailedException("Failed to read config: " + e.getMessage(), (Throwable)e);
        }
    }

    private Config.Builder getConfigBuilder(boolean loadPluginsSettings) {
        ClassLoader classloader;
        if (loadPluginsSettings && (classloader = this.getPluginClassLoader()) != null) {
            return Config.newBuilder((ClassLoader)classloader);
        }
        return Config.newBuilder();
    }

    ClassLoader getPluginClassLoader() {
        block10: {
            if (this.pluginClassloader == null) {
                try (Stream<Path> list = Files.list((Path)this.config().get(GraphDatabaseSettings.plugin_dir));){
                    URL[] urls = (URL[])list.filter(path -> path.toString().endsWith(".jar")).map(this::pathToURL).filter(Predicates.notNull()).toArray(URL[]::new);
                    if (urls.length > 0) {
                        this.pluginClassloader = new URLClassLoader(urls, Bootloader.class.getClassLoader());
                    }
                }
                catch (IOException e) {
                    if (!this.verbose) break block10;
                    e.printStackTrace(this.environment.err());
                }
            }
        }
        return this.pluginClassloader;
    }

    private URL pathToURL(Path p) {
        try {
            return p.toUri().toURL();
        }
        catch (MalformedURLException e) {
            if (this.verbose) {
                e.printStackTrace(this.environment.err());
            }
            return null;
        }
    }

    private static Set<String> settingsUsedByBootloader() {
        return Set.of(GraphDatabaseSettings.neo4j_home.name(), GraphDatabaseSettings.logs_directory.name(), GraphDatabaseSettings.plugin_dir.name(), GraphDatabaseSettings.strict_config_validation.name(), GraphDatabaseInternalSettings.config_command_evaluation_timeout.name(), BootloaderSettings.run_directory.name(), BootloaderSettings.additional_jvm.name(), BootloaderSettings.lib_directory.name(), BootloaderSettings.windows_service_name.name(), BootloaderSettings.windows_tools_directory.name(), BootloaderSettings.pid_file.name());
    }

    protected abstract Map<Setting<?>, Object> overriddenDefaultsValues();

    BootloaderOsAbstraction os() {
        if (this.os == null) {
            this.os = BootloaderOsAbstraction.getOsAbstraction(this);
        }
        return this.os;
    }

    ProcessManager processManager() {
        if (this.processManager == null) {
            this.processManager = new ProcessManager(this);
        }
        return this.processManager;
    }

    Runtime.Version version() {
        return this.environment.version();
    }

    private static String pidIfKnown(long pid) {
        return pid != Long.MAX_VALUE ? " (pid:" + pid + ")" : "";
    }

    protected void printDirectories() {
        FilteredConfig config = this.config();
        PrintStream out = this.environment.out();
        out.println("Directories in use:");
        out.println("home:         " + this.home().toAbsolutePath());
        out.println("config:       " + this.confDir().toAbsolutePath());
        out.println("logs:         " + ((Path)config.get(GraphDatabaseSettings.logs_directory)).toAbsolutePath());
        out.println("plugins:      " + ((Path)config.get(GraphDatabaseSettings.plugin_dir)).toAbsolutePath());
        out.println("import:       " + ((Path)config.get(GraphDatabaseSettings.load_csv_file_url_root)).toAbsolutePath());
        out.println("data:         " + ((Path)config.get(GraphDatabaseSettings.data_directory)).toAbsolutePath());
        out.println("certificates: " + this.home().resolve("certificates").toAbsolutePath());
        out.println("licenses:     " + ((Path)config.get(GraphDatabaseSettings.licenses_directory)).toAbsolutePath());
        out.println("run:          " + ((Path)config.get(BootloaderSettings.run_directory)).toAbsolutePath());
    }

    @Override
    public void close() throws IOException {
        IOUtils.closeAll((AutoCloseable[])new URLClassLoader[]{this.pluginClassloader});
    }

    public static class FilteredConfig
    implements Configuration {
        private final Config config;
        private final Predicate<String> filter;

        public FilteredConfig(Config config, Predicate<String> filter) {
            this.config = config;
            this.filter = filter;
        }

        public Object configStringLookup(String name) {
            this.throwIfNotInFilter(name);
            return this.config.configStringLookup(name);
        }

        public Config getUnfiltered() {
            return this.config;
        }

        public <T> T get(Setting<T> setting) {
            this.throwIfNotInFilter(setting.name());
            return (T)this.config.get(setting);
        }

        private void throwIfNotInFilter(String name) {
            if (!this.filter.test(name)) {
                throw new IllegalArgumentException("Not allowed to read this setting " + name + ". It has been filtered out");
            }
        }
    }

    public static class Admin
    extends Bootloader {
        public Admin(Class<?> entrypoint, Environment environment, boolean expandCommands, boolean verbose, String ... additionalArgs) {
            super(entrypoint, environment, expandCommands, verbose, additionalArgs);
        }

        @Override
        protected Map<Setting<?>, Object> overriddenDefaultsValues() {
            return Map.of();
        }

        int admin(List<Path> additionalConfigs) {
            try {
                if (!additionalConfigs.isEmpty()) {
                    this.rebuildConfig(additionalConfigs);
                }
                this.validateConfig();
                this.os().admin();
                return 0;
            }
            catch (BootProcessFailureException e) {
                return e.getExitCode();
            }
        }
    }

    public static class Dbms
    extends Bootloader {
        public Dbms(Environment environment, boolean expandCommands, boolean verbose) {
            this(EntryPoint.serviceloadEntryPoint(), environment, expandCommands, verbose);
        }

        @VisibleForTesting
        Dbms(Class<?> entrypoint, Environment environment, boolean expandCommands, boolean verbose) {
            super(entrypoint, environment, expandCommands, verbose, new String[0]);
            if (expandCommands) {
                this.additionalArgs.add(Bootloader.ARG_EXPAND_COMMANDS);
            }
        }

        @Override
        protected Map<Setting<?>, Object> overriddenDefaultsValues() {
            return GraphDatabaseSettings.SERVER_DEFAULTS;
        }

        void start() {
            long pid;
            BootloaderOsAbstraction os = this.os();
            this.validateConfigVerbose(false);
            Optional<Long> runningProcess = os.getPidIfRunning();
            if (runningProcess.isPresent()) {
                throw new CommandFailedException(String.format("Neo4j is already running%s.", Bootloader.pidIfKnown(runningProcess.get())), 1);
            }
            this.printDirectories();
            this.environment.out().println("Starting Neo4j.");
            try {
                pid = os.start();
            }
            catch (CommandFailedException e) {
                this.environment.err().println(e.getMessage());
                throw new CommandFailedException("Unable to start. See user log for details.", (Throwable)e, e.getExitCode());
            }
            FilteredConfig config = this.config();
            Object serverLocation = (Boolean)config.get(HttpsConnector.enabled) != false ? "It is available at https://" + config.get(HttpsConnector.listen_address) : ((Boolean)config.get(HttpConnector.enabled) != false ? "It is available at http://" + config.get(HttpConnector.listen_address) : "Both http & https are disabled.");
            this.environment.out().printf("Started neo4j%s. %s%n", Bootloader.pidIfKnown(pid), serverLocation);
            this.environment.out().println("There may be a short delay until the server is ready.");
        }

        void console(boolean dryRun) {
            BootloaderOsAbstraction os = this.os();
            this.validateConfigVerbose(dryRun);
            Optional<Long> runningProcess = os.getPidIfRunning();
            this.additionalArgs.add(Bootloader.ARG_CONSOLE_MODE);
            if (dryRun) {
                List<String> args = os.buildStandardStartArguments();
                String cmd = args.stream().map(Dbms::quoteArgument).collect(Collectors.joining(" "));
                this.environment.out().println(cmd);
                if (!runningProcess.isPresent()) {
                    return;
                }
            }
            if (runningProcess.isPresent()) {
                throw new CommandFailedException(String.format("Neo4j is already running%s.", Bootloader.pidIfKnown(runningProcess.get())), 1);
            }
            this.printDirectories();
            this.environment.out().println("Starting Neo4j.");
            os.console();
        }

        void stop(Integer maybeTimeout) {
            BootloaderOsAbstraction os = this.os();
            Optional<Long> runningProcess = os.getPidIfRunning();
            if (runningProcess.isEmpty()) {
                this.environment.out().println("Neo4j is not running.");
                return;
            }
            this.environment.out().print("Stopping Neo4j.");
            int timeout = maybeTimeout != null ? maybeTimeout.intValue() : this.getEnv(Bootloader.ENV_NEO4J_SHUTDOWN_TIMEOUT, 120, SettingValueParsers.INT).intValue();
            Stopwatch stopwatch = Stopwatch.start();
            long pid = runningProcess.get();
            os.stop(pid);
            int printCount = 0;
            do {
                if (!os.isRunning(pid)) {
                    this.environment.out().println(" stopped.");
                    return;
                }
                if (stopwatch.hasTimedOut((long)printCount, TimeUnit.SECONDS)) {
                    ++printCount;
                    this.environment.out().print(".");
                }
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    break;
                }
            } while (!stopwatch.hasTimedOut((long)timeout, TimeUnit.SECONDS));
            this.environment.out().println(" failed to stop.");
            this.environment.out().printf("Neo4j%s took more than %d seconds to stop.%n", Bootloader.pidIfKnown(pid), stopwatch.elapsed(TimeUnit.SECONDS));
            this.environment.out().printf("Please see logs/neo4j.log for details.%n", new Object[0]);
            throw new CommandFailedException("Failed to stop", 1);
        }

        void restart(Integer maybeTimeout) {
            this.stop(maybeTimeout);
            this.start();
        }

        void status() {
            Optional<Long> runningProcess = this.os().getPidIfRunning();
            if (runningProcess.isEmpty()) {
                throw new CommandFailedException("Neo4j is not running.", 3);
            }
            long pid = runningProcess.get();
            this.environment.out().printf("Neo4j is running%s%n", pid != Long.MAX_VALUE ? " at pid " + pid : "");
        }

        void installService() {
            this.validateConfigVerbose(false);
            if (this.os().serviceInstalled()) {
                throw new CommandFailedException("Neo4j service is already installed.", 1);
            }
            this.os().installService();
            this.environment.out().println("Neo4j service installed.");
        }

        void uninstallService() {
            if (!this.os().serviceInstalled()) {
                this.environment.out().println("Neo4j service is not installed");
                return;
            }
            this.os().uninstallService();
            this.environment.out().println("Neo4j service uninstalled.");
        }

        void updateService() {
            this.validateConfigVerbose(false);
            if (!this.os().serviceInstalled()) {
                throw new CommandFailedException("Neo4j service is not installed", 3);
            }
            this.os().updateService();
            this.environment.out().println("Neo4j service updated.");
        }

        private static String quoteArgument(String arg) {
            String singleQuote = "'";
            String doubleQuote = "\"";
            arg = ((String)arg).trim();
            while (((String)arg).length() > 2 && (((String)arg).startsWith("'") && ((String)arg).endsWith("'") || ((String)arg).startsWith("\"") && ((String)arg).endsWith("\""))) {
                arg = ((String)arg).substring(1, ((String)arg).length() - 1);
            }
            if (((String)arg).contains("\"")) {
                if (((String)arg).contains("'")) {
                    throw new CommandFailedException("`" + (String)arg + "` contains both single and double quotes. Can not be correctly quoted for commandline.");
                }
                arg = "'" + (String)arg + "'";
            } else if (((String)arg).contains("'") || ((String)arg).contains(" ")) {
                arg = "\"" + (String)arg + "\"";
            }
            return arg;
        }
    }
}

