/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.startup;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.collections.api.factory.Lists;
import org.eclipse.collections.api.list.MutableList;
import org.neo4j.cli.CommandFailedException;
import org.neo4j.configuration.BootloaderSettings;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.server.startup.BootProcessFailureException;
import org.neo4j.server.startup.Bootloader;
import org.neo4j.server.startup.BootloaderOsAbstraction;
import org.neo4j.server.startup.ExitCodeMessageMapper;
import org.neo4j.server.startup.ProcessManager;
import org.neo4j.server.startup.ProcessStages;
import org.neo4j.time.Stopwatch;
import org.neo4j.util.FeatureToggles;
import org.neo4j.util.Preconditions;
import org.neo4j.util.VisibleForTesting;

class WindowsBootloaderOs
extends BootloaderOsAbstraction {
    private static final boolean ESCAPE_ASTERISKS = FeatureToggles.flag(WindowsBootloaderOs.class, (String)"escapeAsterisks", (boolean)true);
    static final String PRUNSRV_AMD_64_EXE = "prunsrv-amd64.exe";
    static final String PRUNSRV_I_386_EXE = "prunsrv-i386.exe";
    private static final String POWERSHELL_EXE = "powershell.exe";
    private static final int WINDOWS_PATH_MAX_LENGTH = 250;
    private static final ExitCodeMessageMapper SERVICE_COMMANDS_FAILURE = e -> "Unexpected service command failure.";
    private static final ExitCodeMessageMapper POWERSHELL_COMMANDS_FAILURE = e -> "Unexpected powershell command failure.";

    WindowsBootloaderOs(Bootloader ctx) {
        super(ctx);
    }

    @Override
    long start() throws CommandFailedException {
        if (!this.serviceInstalled()) {
            throw new CommandFailedException("Neo4j service is not installed", 3);
        }
        this.issueServiceCommand("ES", new BlockingProcess());
        return Long.MAX_VALUE;
    }

    @Override
    void stop(long pid) throws CommandFailedException {
        if (this.serviceInstalled()) {
            this.issueServiceCommand("SS", ProcessStages.NO_OP);
        }
    }

    @Override
    void installService() throws CommandFailedException {
        this.runServiceCommand("IS");
    }

    @Override
    long console() throws CommandFailedException {
        return this.bootloader.processManager().run(this.buildStandardStartArguments(), new BootloaderOsAbstraction.ConsoleProcess(false));
    }

    @Override
    long admin() throws CommandFailedException {
        if (ESCAPE_ASTERISKS) {
            this.bootloader.additionalArgs.replaceAll(WindowsBootloaderOs::quoteWildcards);
        }
        return super.admin();
    }

    private static String quoteWildcards(String s) {
        if (s.equals("*")) {
            return "\"*\"";
        }
        return s;
    }

    private void runServiceCommand(String baseCommand) {
        MutableList<String> argList = this.baseServiceCommandArgList(baseCommand);
        Path home = this.bootloader.home();
        Path logs = (Path)this.bootloader.config().get(GraphDatabaseSettings.logs_directory);
        Path jvmDll = Path.of(this.getJavaCmd(), new String[0]).getParent().resolve(Path.of("server", "jvm.dll"));
        Preconditions.checkState((boolean)Files.exists(jvmDll, new LinkOption[0]), (String)"Couldn't find the jvm DLL file %s", (Object[])new Object[]{jvmDll});
        List<String> jvmOpts = this.getJvmOpts();
        argList.with((Object)WindowsBootloaderOs.arg("--StartMode", "jvm")).with((Object)WindowsBootloaderOs.arg("--StartMethod", "start")).with((Object)WindowsBootloaderOs.arg("--ServiceUser", "LocalSystem")).with((Object)WindowsBootloaderOs.arg("--StartPath", home.toString())).with((Object)WindowsBootloaderOs.multiArg("--StartParams", "--config-dir=" + this.bootloader.confDir(), "--home-dir=" + home)).with((Object)WindowsBootloaderOs.arg("--StopMode", "jvm")).with((Object)WindowsBootloaderOs.arg("--StopMethod", "stop")).with((Object)WindowsBootloaderOs.arg("--StopPath", home.toString())).with((Object)WindowsBootloaderOs.arg("--Description", "Neo4j Graph Database - " + home)).with((Object)WindowsBootloaderOs.arg("--DisplayName", "Neo4j Graph Database - " + this.serviceName())).with((Object)WindowsBootloaderOs.arg("--Jvm", jvmDll.toString())).with((Object)WindowsBootloaderOs.arg("--LogPath", logs.toString())).with((Object)WindowsBootloaderOs.arg("--StdOutput", logs.resolve("service-out.log").toString())).with((Object)WindowsBootloaderOs.arg("--StdError", logs.resolve("service-error.log").toString())).with((Object)WindowsBootloaderOs.arg("--LogPrefix", "neo4j-service")).with((Object)WindowsBootloaderOs.arg("--Classpath", this.getClassPath())).with((Object)WindowsBootloaderOs.multiArg("--JvmOptions", jvmOpts.toArray(new String[0]))).with((Object)WindowsBootloaderOs.arg("--Startup", "auto")).with((Object)WindowsBootloaderOs.arg("--StopClass", this.bootloader.entrypoint.getName())).with((Object)WindowsBootloaderOs.arg("--StartClass", this.bootloader.entrypoint.getName()));
        for (String additionalArg : this.bootloader.additionalArgs) {
            argList = argList.with((Object)WindowsBootloaderOs.arg("++StartParams", additionalArg));
        }
        argList = this.includeMemoryOption(jvmOpts, argList, "-Xms", "--JvmMs", "Start");
        argList = this.includeMemoryOption(jvmOpts, argList, "-Xmx", "--JvmMx", "Max");
        this.runProcess((List<String>)argList, new ServiceCommandProcess());
    }

    private static String multiArg(String key, String ... values) {
        List<String> argsEscaped = Arrays.stream(values).peek(WindowsBootloaderOs::throwIfContainsSingleQuotes).map(opt -> opt.replace(";", "';'")).map(opt -> opt.replace("#", "'#'")).toList();
        return WindowsBootloaderOs.arg(key, StringUtils.join(argsEscaped, (char)';'));
    }

    private static void throwIfContainsSingleQuotes(String s) {
        if (s.contains("'")) {
            int firstIndex = s.indexOf("'");
            String context = s.substring(Math.max(firstIndex - 25, 0), Math.min(s.length(), firstIndex + 25));
            throw new CommandFailedException(String.format("We are unable to support values that contain single quote marks ('). Single quotes found in value: %s", context));
        }
    }

    private String serviceName() {
        return (String)this.bootloader.config().get(BootloaderSettings.windows_service_name);
    }

    @Override
    void uninstallService() throws CommandFailedException {
        this.issueServiceCommand("DS", new BlockingProcess());
        Stopwatch stopwatch = Stopwatch.start();
        while (this.serviceInstalled() && !stopwatch.hasTimedOut(120L, TimeUnit.SECONDS)) {
            try {
                Thread.sleep(300L);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                break;
            }
        }
    }

    @Override
    void updateService() throws CommandFailedException {
        this.runServiceCommand("US");
    }

    @Override
    Optional<Long> getPidIfRunning() {
        boolean stopped;
        String status = this.getStatus();
        boolean bl = stopped = StringUtils.isEmpty((CharSequence)status) || status.startsWith("Stopped");
        if (stopped) {
            return Optional.empty();
        }
        return Optional.of(Long.MAX_VALUE);
    }

    @Override
    boolean isRunning(long pid) {
        return this.getPidIfRunning().isPresent();
    }

    @Override
    boolean serviceInstalled() {
        return StringUtils.isNotEmpty((CharSequence)this.getStatus());
    }

    private String getStatus() {
        try {
            return Arrays.stream(this.resultFromPowerShellCommand("Get-Service", this.serviceName(), "|", "Format-Table", "-AutoSize")).filter(s -> s.contains(this.serviceName())).findFirst().orElse("");
        }
        catch (BootProcessFailureException e) {
            return "";
        }
    }

    @VisibleForTesting
    String[] getServiceStatusResult() throws BootProcessFailureException {
        String serviceName = this.serviceName();
        return this.resultFromPowerShellCommand("Get-Service", serviceName, "|", "Format-Table", "-AutoSize");
    }

    private String[] resultFromPowerShellCommand(String ... command) {
        ByteArrayOutputStream outBuffer = new ByteArrayOutputStream();
        try (PrintStream out = new PrintStream(outBuffer);){
            this.bootloader.processManager().run(WindowsBootloaderOs.asPowershellScript(List.of(command)), new PowershellWithResult(out));
            String[] stringArray = outBuffer.toString().split(String.format("%n", new Object[0]));
            return stringArray;
        }
    }

    private void issueServiceCommand(String serviceCommand, ProcessStages behaviour) {
        this.runProcess((List<String>)this.baseServiceCommandArgList(serviceCommand), behaviour);
    }

    private void runProcess(List<String> command, ProcessStages behaviour) {
        List<String> entireCommand = WindowsBootloaderOs.asExternalCommand(command);
        long powershellProcessId = this.bootloader.processManager().run(entireCommand, behaviour);
        if (entireCommand.stream().anyMatch(cmd -> cmd.equals(POWERSHELL_EXE)) && command.stream().anyMatch(cmd -> cmd.endsWith(PRUNSRV_I_386_EXE) || cmd.endsWith(PRUNSRV_AMD_64_EXE))) {
            Stopwatch stopwatch = Stopwatch.start();
            do {
                try {
                    this.resultFromPowerShellCommand("Get-Process", "-Id", String.valueOf(powershellProcessId));
                    this.resultFromPowerShellCommand("Get-Process", "prunsrv-amd64.exe,prunsrv-i386.exe,powershell.exe");
                    try {
                        Thread.sleep(100L);
                        continue;
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                    }
                }
                catch (BootProcessFailureException e) {}
                break;
            } while (!stopwatch.hasTimedOut(120L, TimeUnit.SECONDS));
        }
    }

    private MutableList<String> baseServiceCommandArgList(String serviceCommand) {
        return Lists.mutable.with((Object[])new String[]{String.format("& %s", WindowsBootloaderOs.escapeQuote(this.findPrunCommand().toString()))}).with((Object)String.format("//%s//%s", serviceCommand, this.serviceName()));
    }

    private static List<String> asPowershellScript(List<String> command) {
        return WindowsBootloaderOs.asExternalCommand(List.of(String.join((CharSequence)" ", command)));
    }

    private static List<String> asExternalCommand(List<String> command) {
        Stream argsAsOne = command.size() < 2 ? Stream.empty() : Stream.of(command.stream().skip(1L).map(WindowsBootloaderOs::escapeQuote).collect(Collectors.joining(" ")));
        return Stream.concat(Stream.of(POWERSHELL_EXE, "-OutputFormat", "Text", "-ExecutionPolicy", "Bypass", "-Command", command.get(0)), argsAsOne).toList();
    }

    private Path findPrunCommand() {
        boolean is64bit = StringUtils.isNotEmpty((CharSequence)this.bootloader.getEnv("ProgramFiles(x86)"));
        String prunSrvName = is64bit ? PRUNSRV_AMD_64_EXE : PRUNSRV_I_386_EXE;
        Path tools = (Path)this.bootloader.config().get(BootloaderSettings.windows_tools_directory);
        Path path = tools.resolve(prunSrvName);
        Preconditions.checkState((boolean)Files.exists(path, new LinkOption[0]), (String)"Couldn't find prunsrv file for interacting with the windows service subsystem %s", (Object[])new Object[]{path});
        int length = path.toString().length();
        if (length >= 250) {
            this.bootloader.environment.err().printf("WARNING: Path length over %s characters detected. The service may not work correctly because of limitations in the Windows operating system when dealing with long file paths. Path:%s (length:%s)%n", 250, path, length);
        }
        return path;
    }

    private MutableList<String> includeMemoryOption(List<String> jvmOpts, MutableList<String> argList, String option, String serviceOption, String description) {
        String memory = WindowsBootloaderOs.findOptionValue(jvmOpts, option);
        if (memory != null) {
            argList = argList.with((Object)WindowsBootloaderOs.arg(serviceOption, memory));
            this.bootloader.environment.out().println("Use JVM " + description + " Memory of " + memory);
        }
        return argList;
    }

    private static String findOptionValue(List<String> opts, String option) {
        for (String opt : opts) {
            if (!opt.startsWith(option)) continue;
            return opt.substring(option.length());
        }
        return null;
    }

    private static String arg(String key, String value) {
        return value == null ? key : String.format("%s=%s", key, value);
    }

    private static String escapeQuote(String str) {
        return String.format("'%s'", str.replace("'", "''"));
    }

    private static class BlockingProcess
    implements ProcessStages {
        private BlockingProcess() {
        }

        @Override
        public void preStart(ProcessManager processManager, ProcessBuilder processBuilder) {
            processBuilder.redirectOutput(ProcessBuilder.Redirect.DISCARD);
            processBuilder.redirectError(ProcessBuilder.Redirect.DISCARD);
        }

        @Override
        public void postStart(ProcessManager processManager, Process process) throws Exception {
            processManager.waitUntilSuccessful(process, SERVICE_COMMANDS_FAILURE);
        }
    }

    private static class ServiceCommandProcess
    implements ProcessStages {
        private ServiceCommandProcess() {
        }

        @Override
        public void preStart(ProcessManager processManager, ProcessBuilder processBuilder) {
            processBuilder.inheritIO();
        }

        @Override
        public void postStart(ProcessManager processManager, Process process) throws Exception {
            processManager.waitUntilSuccessful(process, SERVICE_COMMANDS_FAILURE);
        }
    }

    private static class PowershellWithResult
    implements ProcessStages {
        private final PrintStream out;

        PowershellWithResult(PrintStream out) {
            this.out = out;
        }

        @Override
        public void preStart(ProcessManager processManager, ProcessBuilder processBuilder) {
            processBuilder.redirectError(ProcessBuilder.Redirect.DISCARD);
        }

        @Override
        public void postStart(ProcessManager processManager, Process process) throws Exception {
            this.out.write(process.getInputStream().readAllBytes());
            processManager.waitUntilSuccessful(process, POWERSHELL_COMMANDS_FAILURE);
        }
    }
}

