/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.startup.validation;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.neo4j.server.startup.validation.ConfigValidationIssue;
import org.neo4j.util.VisibleForTesting;

public class ConfigValidationSummary {
    private ValidationResult result = ValidationResult.OK;
    private final List<Event> events = new ArrayList<Event>();

    public void print(PrintStream out, boolean verbose) {
        for (Event event : this.events) {
            event.print(out, verbose);
            out.println();
        }
    }

    public String message(boolean verbose) {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        this.print(new PrintStream(output), verbose);
        return output.toString();
    }

    public ValidationResult result() {
        return this.result;
    }

    public void add(Event event) {
        this.result = this.result.and(event.result());
        this.events.add(event);
    }

    public void printClosingStatement(PrintStream out) {
        out.println(this.closingStatement());
    }

    public String closingStatement() {
        if (this.result == ValidationResult.ERRORS) {
            return "Configuration file validation failed.";
        }
        if (this.result == ValidationResult.WARNINGS) {
            return "Configuration file validation successful (with warnings).";
        }
        return "Configuration file validation successful.";
    }

    public static enum ValidationResult {
        OK,
        WARNINGS,
        ERRORS;


        @VisibleForTesting
        ValidationResult and(ValidationResult other) {
            return (ValidationResult)((Object)ObjectUtils.max((Comparable[])new ValidationResult[]{this, other}));
        }
    }

    public static interface Event {
        public void print(PrintStream var1, boolean var2);

        public ValidationResult result();

        default public Event treatErrorsAsWarnings() {
            return new NoBigDealEvent(this);
        }
    }

    public static class MessageEvent
    implements Event {
        private final String message;

        public MessageEvent(String message) {
            this.message = message;
        }

        @Override
        public void print(PrintStream out, boolean verbose) {
            out.println(this.message);
        }

        @Override
        public ValidationResult result() {
            return ValidationResult.OK;
        }
    }

    public static class ErrorEvent
    implements Event {
        private final String label;
        private final Exception exception;

        public ErrorEvent(String label, Exception exception) {
            this.label = label;
            this.exception = exception;
        }

        @Override
        public void print(PrintStream out, boolean verbose) {
            out.printf("Error when validating %s: %s%n", this.label, this.exception.getMessage());
            if (verbose) {
                this.exception.printStackTrace(out);
            }
        }

        @Override
        public ValidationResult result() {
            return ValidationResult.ERRORS;
        }
    }

    public static class ResultEvent
    implements Event {
        private final List<ConfigValidationIssue> issues;
        private final String label;
        private ValidationResult result;

        public ResultEvent(String label, List<ConfigValidationIssue> issues) {
            this.label = label;
            this.issues = issues;
            this.result = ValidationResult.OK;
            for (ConfigValidationIssue issue : issues) {
                this.result = this.result.and(issue.isError() ? ValidationResult.ERRORS : ValidationResult.WARNINGS);
            }
        }

        @Override
        public void print(PrintStream out, boolean verbose) {
            out.printf("Validating %s%n", this.label);
            this.printIssueCount(this.issues, out);
            for (ConfigValidationIssue issue : this.issues) {
                this.printIssue(issue, out, verbose);
            }
        }

        private void printIssueCount(List<ConfigValidationIssue> issues, PrintStream out) {
            if (issues.isEmpty()) {
                out.printf("No issues found.%n", new Object[0]);
            } else {
                out.printf("%d issue%s found.%n", issues.size(), issues.size() == 1 ? "" : "s");
            }
        }

        private void printIssue(ConfigValidationIssue issue, PrintStream out, boolean verbose) {
            out.printf("%s%n", issue.getMessage());
            if (verbose) {
                issue.printStackTrace(out);
            }
        }

        @Override
        public ValidationResult result() {
            return this.result;
        }

        @Override
        public ResultEvent treatErrorsAsWarnings() {
            List<ConfigValidationIssue> issues = this.issues.stream().map(ConfigValidationIssue::asWarning).collect(Collectors.toList());
            return new ResultEvent(this.label, issues);
        }
    }

    private record NoBigDealEvent(Event delegate) implements Event
    {
        @Override
        public void print(PrintStream out, boolean verbose) {
            this.delegate.print(out, verbose);
        }

        @Override
        public ValidationResult result() {
            ValidationResult actualResult = this.delegate.result();
            if (actualResult == ValidationResult.ERRORS) {
                return ValidationResult.WARNINGS;
            }
            return actualResult;
        }

        @Override
        public Event treatErrorsAsWarnings() {
            return this;
        }
    }
}

