/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.fsm.state;

import java.util.HashMap;
import java.util.Map;
import org.neo4j.bolt.fsm.state.HandlerRegistry;
import org.neo4j.bolt.fsm.state.MultiTransitionState;
import org.neo4j.bolt.fsm.state.NoopState;
import org.neo4j.bolt.fsm.state.SingleTransitionState;
import org.neo4j.bolt.fsm.state.State;
import org.neo4j.bolt.fsm.state.StateReference;
import org.neo4j.bolt.fsm.state.transition.StateTransition;
import org.neo4j.bolt.protocol.common.message.request.RequestMessage;

final class StateFactoryImpl
implements State.Factory {
    private final StateReference reference;
    private final Map<Class<? extends RequestMessage>, StateTransition<?>> transitions = new HashMap();

    StateFactoryImpl(StateReference reference) {
        this.reference = reference;
    }

    @Override
    public StateReference reference() {
        return this.reference;
    }

    @Override
    public State build() {
        if (this.transitions.isEmpty()) {
            return new NoopState(this.reference);
        }
        if (this.transitions.size() == 1) {
            StateTransition<?> transition = this.transitions.values().iterator().next();
            return new SingleTransitionState(this.reference, transition);
        }
        HandlerRegistry.Factory factory = HandlerRegistry.builder();
        this.transitions.forEach(factory::register);
        return new MultiTransitionState(this.reference, factory.build());
    }

    @Override
    public State.Factory withTransition(StateTransition<?> transition) {
        this.transitions.put(transition.requestType(), transition);
        return this;
    }

    @Override
    public State.Factory withoutTransition(Class<? extends RequestMessage> requestType) {
        this.transitions.remove(requestType);
        return this;
    }
}

