/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.common.fsm.response.metadata;

import java.util.Iterator;
import org.neo4j.bolt.protocol.common.fsm.response.MetadataConsumer;
import org.neo4j.bolt.protocol.common.fsm.response.metadata.DefaultMetadataHandler;
import org.neo4j.graphdb.GqlStatusObject;
import org.neo4j.graphdb.InputPosition;
import org.neo4j.graphdb.Notification;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.ListValueBuilder;
import org.neo4j.values.virtual.MapValueBuilder;
import org.neo4j.values.virtual.VirtualValues;

public abstract class AbstractLegacyMetadataHandler
extends DefaultMetadataHandler {
    @Override
    public void onNotifications(MetadataConsumer handler, Iterable<Notification> notifications, Iterable<GqlStatusObject> statuses) {
        Iterator<Notification> it = notifications.iterator();
        if (!it.hasNext()) {
            return;
        }
        ListValueBuilder children = ListValueBuilder.newListBuilder();
        while (it.hasNext()) {
            Notification notification = it.next();
            InputPosition pos = notification.getPosition();
            boolean includePosition = !pos.equals((Object)InputPosition.empty);
            int size = includePosition ? 5 : 4;
            MapValueBuilder builder = new MapValueBuilder(size);
            builder.add("code", (AnyValue)Values.utf8Value((String)notification.getCode()));
            builder.add("title", (AnyValue)Values.utf8Value((String)notification.getTitle()));
            builder.add("description", (AnyValue)Values.utf8Value((String)notification.getDescription()));
            builder.add("severity", (AnyValue)Values.utf8Value((String)notification.getSeverity().toString()));
            builder.add("category", (AnyValue)Values.stringValue((String)notification.getCategory().toString()));
            if (includePosition) {
                builder.add("position", (AnyValue)VirtualValues.map((String[])new String[]{"offset", "line", "column"}, (AnyValue[])new AnyValue[]{Values.intValue((int)pos.getOffset()), Values.intValue((int)pos.getLine()), Values.intValue((int)pos.getColumn())}));
            }
            children.add((AnyValue)builder.build());
        }
        handler.onMetadata("notifications", (AnyValue)children.build());
    }
}

