/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.common.fsm.response.metadata;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.neo4j.bolt.protocol.common.fsm.response.MetadataConsumer;
import org.neo4j.bolt.protocol.common.fsm.response.metadata.MetadataHandler;
import org.neo4j.graphdb.ExecutionPlanDescription;
import org.neo4j.graphdb.GqlStatusObject;
import org.neo4j.graphdb.Notification;
import org.neo4j.graphdb.QueryExecutionType;
import org.neo4j.graphdb.QueryStatistics;
import org.neo4j.kernel.database.DatabaseReference;
import org.neo4j.kernel.impl.util.ValueUtils;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.BooleanValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.ListValue;
import org.neo4j.values.virtual.ListValueBuilder;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.MapValueBuilder;

public class DefaultMetadataHandler
implements MetadataHandler {
    public static final TextValue READ_ONLY = Values.utf8Value((byte[])new byte[]{114});
    public static final TextValue READ_WRITE = Values.utf8Value((byte[])new byte[]{114, 119});
    public static final TextValue WRITE = Values.utf8Value((byte[])new byte[]{119});
    public static final TextValue SCHEMA_WRITE = Values.utf8Value((byte[])new byte[]{115});
    public static final Map<String, Object> DEFAULT_DIAGNOSTIC_RECORD = Map.of("OPERATION", "", "OPERATION_CODE", "0", "CURRENT_SCHEMA", "/", "_position", Map.of("offset", -1, "line", -1, "column", -1));
    private static final DefaultMetadataHandler INSTANCE = new DefaultMetadataHandler();

    public static DefaultMetadataHandler getInstance() {
        return INSTANCE;
    }

    @Override
    public void onStatementId(MetadataConsumer consumer, long statementId) {
        consumer.onMetadata("qid", (AnyValue)Values.longValue((long)statementId));
    }

    @Override
    public void onTimeSpentPreparingResults(MetadataConsumer handler, long spent) {
        handler.onMetadata("t_first", (AnyValue)Values.longValue((long)spent));
    }

    @Override
    public void onTimeSpentStreaming(MetadataConsumer handler, long spent) {
        handler.onMetadata("t_last", (AnyValue)Values.longValue((long)spent));
    }

    @Override
    public void onFieldNames(MetadataConsumer consumer, List<String> names) {
        ListValue fieldNames = (ListValue)names.stream().map(Values::stringValue).collect(ListValueBuilder.collector());
        consumer.onMetadata("fields", (AnyValue)fieldNames);
    }

    @Override
    public void onExecutionType(MetadataConsumer handler, QueryExecutionType executionType) {
        TextValue code = switch (executionType.queryType()) {
            default -> throw new IncompatibleClassChangeError();
            case QueryExecutionType.QueryType.READ_ONLY -> READ_ONLY;
            case QueryExecutionType.QueryType.READ_WRITE -> READ_WRITE;
            case QueryExecutionType.QueryType.WRITE -> WRITE;
            case QueryExecutionType.QueryType.SCHEMA_WRITE, QueryExecutionType.QueryType.DBMS -> SCHEMA_WRITE;
        };
        handler.onMetadata("type", (AnyValue)code);
    }

    @Override
    public void onDatabase(MetadataConsumer handler, DatabaseReference reference) {
        handler.onMetadata("db", (AnyValue)Values.stringValue((String)reference.alias().name()));
    }

    @Override
    public void onQueryStatistics(MetadataConsumer handler, QueryStatistics statistics) {
        if (!statistics.containsSystemUpdates() && !statistics.containsUpdates()) {
            return;
        }
        MapValueBuilder metadata = new MapValueBuilder();
        this.generateQueryStatistics(metadata, statistics);
        handler.onMetadata("stats", (AnyValue)metadata.build());
    }

    @Override
    public void onExecutionPlan(MetadataConsumer consumer, ExecutionPlanDescription plan) {
        MapValueBuilder metadata = new MapValueBuilder();
        this.generateExecutionPlan(metadata, plan);
        String fieldName = plan.hasProfilerStatistics() ? "profile" : "plan";
        consumer.onMetadata(fieldName, (AnyValue)metadata.build());
    }

    protected void generateExecutionPlan(MapValueBuilder metadata, ExecutionPlanDescription plan) {
        boolean hasProfilerStatistics = plan.hasProfilerStatistics();
        metadata.add("operatorType", (AnyValue)Values.utf8Value((String)plan.getName()));
        metadata.add("args", (AnyValue)ValueUtils.asMapValue((Map)plan.getArguments()));
        metadata.add("identifiers", (AnyValue)ValueUtils.asListValue((Iterable)plan.getIdentifiers()));
        if (!plan.getChildren().isEmpty()) {
            ListValueBuilder children = ListValueBuilder.newListBuilder();
            this.generateExecutionPlanChildren(children, plan);
            metadata.add("children", (AnyValue)children.build());
        }
        if (hasProfilerStatistics) {
            ExecutionPlanDescription.ProfilerStatistics profile = plan.getProfilerStatistics();
            if (profile.hasDbHits()) {
                metadata.add("dbHits", (AnyValue)Values.longValue((long)profile.getDbHits()));
            }
            if (profile.hasPageCacheStats()) {
                metadata.add("pageCacheHits", (AnyValue)Values.longValue((long)profile.getPageCacheHits()));
                metadata.add("pageCacheMisses", (AnyValue)Values.longValue((long)profile.getPageCacheMisses()));
                metadata.add("pageCacheHitRatio", (AnyValue)Values.doubleValue((double)profile.getPageCacheHitRatio()));
            }
            if (profile.hasRows()) {
                metadata.add("rows", (AnyValue)Values.longValue((long)profile.getRows()));
            }
            if (profile.hasTime()) {
                metadata.add("time", (AnyValue)Values.longValue((long)profile.getTime()));
            }
        }
    }

    protected void generateExecutionPlanChildren(ListValueBuilder children, ExecutionPlanDescription plan) {
        for (ExecutionPlanDescription child : plan.getChildren()) {
            MapValueBuilder metadata = new MapValueBuilder();
            this.generateExecutionPlan(metadata, child);
            children.add((AnyValue)metadata.build());
        }
    }

    @Override
    public void onResultsRemaining(MetadataConsumer handler, boolean hasRemaining) {
        if (hasRemaining) {
            handler.onMetadata("has_more", (AnyValue)BooleanValue.TRUE);
        }
    }

    @Override
    public void onRoutingTable(MetadataConsumer consumer, String databaseName, MapValue routingTable) {
        routingTable = this.enrichRoutingTable(databaseName, routingTable);
        consumer.onMetadata("rt", (AnyValue)routingTable);
    }

    protected MapValue enrichRoutingTable(String databaseName, MapValue routingTable) {
        return routingTable.updatedWith("db", (AnyValue)Values.stringValue((String)databaseName));
    }

    @Override
    public void onBookmark(MetadataConsumer handler, String encodedBookmark) {
        handler.onMetadata("bookmark", (AnyValue)Values.utf8Value((String)encodedBookmark));
    }

    @Override
    public void onNotifications(MetadataConsumer handler, Iterable<Notification> notifications, Iterable<GqlStatusObject> statuses) {
        Iterator<GqlStatusObject> it = statuses.iterator();
        if (!it.hasNext()) {
            return;
        }
        ListValueBuilder children = ListValueBuilder.newListBuilder();
        while (it.hasNext()) {
            boolean statusIsNotification;
            GqlStatusObject status = it.next();
            MapValue diagnosticRecord = DefaultMetadataHandler.mapValue(status.diagnosticRecord(), DefaultMetadataHandler::isDefaultDiagnosticRecordEntry);
            int size = 3;
            if (diagnosticRecord.isEmpty()) {
                --size;
            }
            if (statusIsNotification = status instanceof Notification) {
                Notification notification = (Notification)status;
                if (notification.getCode() != null) {
                    ++size;
                }
                if (notification.getTitle() != null) {
                    ++size;
                }
                if (notification.getDescription() != null) {
                    ++size;
                }
            }
            MapValueBuilder builder = new MapValueBuilder(size);
            builder.add("gql_status", (AnyValue)Values.utf8Value((String)status.gqlStatus()));
            builder.add("status_description", (AnyValue)Values.utf8Value((String)status.statusDescription()));
            if (statusIsNotification) {
                Notification notification = (Notification)status;
                if (notification.getCode() != null) {
                    builder.add("neo4j_code", (AnyValue)Values.utf8Value((String)notification.getCode()));
                }
                if (notification.getTitle() != null) {
                    builder.add("title", (AnyValue)Values.utf8Value((String)notification.getTitle()));
                }
                if (notification.getDescription() != null) {
                    builder.add("description", (AnyValue)Values.utf8Value((String)notification.getDescription()));
                }
            }
            if (!diagnosticRecord.isEmpty()) {
                builder.add("diagnostic_record", (AnyValue)diagnosticRecord);
            }
            children.add((AnyValue)builder.build());
        }
        handler.onMetadata("statuses", (AnyValue)children.build());
    }

    private static MapValue mapValue(Map<String, Object> map, Predicate<Map.Entry<String, Object>> skip) {
        MapValueBuilder builder = new MapValueBuilder();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (skip.test(entry)) continue;
            builder.add(entry.getKey(), DefaultMetadataHandler.value(entry.getValue()));
        }
        return builder.build();
    }

    private static ListValue listValue(List<?> list) {
        ListValueBuilder builder = ListValueBuilder.newListBuilder((int)list.size());
        for (Object item : list) {
            builder.add(DefaultMetadataHandler.value(item));
        }
        return builder.build();
    }

    private static AnyValue value(Object value) {
        if (value instanceof Map) {
            return DefaultMetadataHandler.mapValue((Map)value, ignored -> false);
        }
        if (value instanceof List) {
            return DefaultMetadataHandler.listValue((List)value);
        }
        return Values.of((Object)value);
    }

    private static boolean isDefaultDiagnosticRecordEntry(Map.Entry<String, Object> entry) {
        return DEFAULT_DIAGNOSTIC_RECORD.containsKey(entry.getKey()) && DEFAULT_DIAGNOSTIC_RECORD.get(entry.getKey()).equals(entry.getValue());
    }

    protected void generateQueryStatistics(MapValueBuilder metadata, QueryStatistics statistics) {
        if (statistics.containsUpdates()) {
            this.generateUpdateQueryStatistics(metadata, statistics);
        } else if (statistics.containsSystemUpdates()) {
            this.generateSystemQueryStatistics(metadata, statistics);
        }
    }

    protected void generateUpdateQueryStatistics(MapValueBuilder metadata, QueryStatistics statistics) {
        this.addContainsUpdates(metadata);
        DefaultMetadataHandler.addIfNonZero(metadata, "nodes-created", statistics.getNodesCreated());
        DefaultMetadataHandler.addIfNonZero(metadata, "nodes-deleted", statistics.getNodesDeleted());
        DefaultMetadataHandler.addIfNonZero(metadata, "relationships-created", statistics.getRelationshipsCreated());
        DefaultMetadataHandler.addIfNonZero(metadata, "relationships-deleted", statistics.getRelationshipsDeleted());
        DefaultMetadataHandler.addIfNonZero(metadata, "properties-set", statistics.getPropertiesSet());
        DefaultMetadataHandler.addIfNonZero(metadata, "labels-added", statistics.getLabelsAdded());
        DefaultMetadataHandler.addIfNonZero(metadata, "labels-removed", statistics.getLabelsRemoved());
        DefaultMetadataHandler.addIfNonZero(metadata, "indexes-added", statistics.getIndexesAdded());
        DefaultMetadataHandler.addIfNonZero(metadata, "indexes-removed", statistics.getIndexesRemoved());
        DefaultMetadataHandler.addIfNonZero(metadata, "constraints-added", statistics.getConstraintsAdded());
        DefaultMetadataHandler.addIfNonZero(metadata, "constraints-removed", statistics.getConstraintsRemoved());
    }

    protected void addContainsUpdates(MapValueBuilder metadata) {
        metadata.add("contains-updates", (AnyValue)BooleanValue.TRUE);
    }

    protected void generateSystemQueryStatistics(MapValueBuilder metadata, QueryStatistics statistics) {
        this.addContainsSystemUpdates(metadata);
        DefaultMetadataHandler.addIfNonZero(metadata, "system-updates", statistics.getSystemUpdates());
    }

    protected void addContainsSystemUpdates(MapValueBuilder metadata) {
        metadata.add("contains-system-updates", (AnyValue)BooleanValue.TRUE);
    }

    protected static void addIfNonZero(MapValueBuilder builder, String key, int value) {
        if (value != 0) {
            builder.add(key, (AnyValue)Values.longValue((long)value));
        }
    }
}

