/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.io.writer;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.neo4j.bolt.protocol.io.StructType;
import org.neo4j.bolt.protocol.io.pipeline.WriterContext;
import org.neo4j.bolt.protocol.io.writer.StructWriter;
import org.neo4j.bolt.protocol.io.writer.UtcStructWriter;
import org.neo4j.packstream.io.PackstreamBuf;
import org.neo4j.packstream.util.PrimitiveLongIntKeyValueArray;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.TextArray;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.NodeValue;
import org.neo4j.values.virtual.RelationshipValue;

public final class DefaultStructWriter
extends UtcStructWriter
implements StructWriter {
    private static final DefaultStructWriter INSTANCE = new DefaultStructWriter();

    private DefaultStructWriter() {
    }

    public static StructWriter getInstance() {
        return INSTANCE;
    }

    @Override
    public void writePoint(WriterContext ctx, CoordinateReferenceSystem crs, double[] coords) {
        Objects.requireNonNull(crs, ">crs cannot be null");
        switch (coords.length) {
            case 2: {
                this.writePoint2d(ctx, crs, coords[0], coords[1]);
                break;
            }
            case 3: {
                this.writePoint3d(ctx, crs, coords[0], coords[1], coords[2]);
                break;
            }
            default: {
                throw new IllegalArgumentException("Point with 2D or 3D coordinate expected, got crs=" + crs + ", coordinate=" + Arrays.toString(coords));
            }
        }
    }

    private void writePoint2d(WriterContext ctx, CoordinateReferenceSystem crs, double x, double y) {
        Objects.requireNonNull(crs, "crs cannot be null");
        StructType.POINT_2D.writeHeader(ctx);
        ctx.buffer().writeInt(crs.getCode()).writeFloat(x).writeFloat(y);
    }

    private void writePoint3d(WriterContext ctx, CoordinateReferenceSystem crs, double x, double y, double z) {
        Objects.requireNonNull(crs, "crs cannot be null");
        StructType.POINT_3D.writeHeader(ctx);
        ctx.buffer().writeInt(crs.getCode()).writeFloat(x).writeFloat(y).writeFloat(z);
    }

    @Override
    public void writeDuration(WriterContext ctx, long months, long days, long seconds, int nanos) {
        StructType.DURATION.writeHeader(ctx);
        ctx.buffer().writeInt(months).writeInt(days).writeInt(seconds).writeInt(nanos);
    }

    @Override
    public void writeDate(WriterContext ctx, LocalDate localDate) {
        Objects.requireNonNull(localDate, "date cannot be null");
        StructType.DATE.writeHeader(ctx);
        ctx.buffer().writeInt(localDate.toEpochDay());
    }

    @Override
    public void writeLocalTime(WriterContext ctx, LocalTime localTime) {
        Objects.requireNonNull(localTime, "time cannot be null");
        StructType.LOCAL_TIME.writeHeader(ctx);
        ctx.buffer().writeInt(localTime.toNanoOfDay());
    }

    @Override
    public void writeTime(WriterContext ctx, OffsetTime offsetTime) {
        Objects.requireNonNull(offsetTime, "date cannot be null");
        StructType.TIME.writeHeader(ctx);
        ctx.buffer().writeInt(offsetTime.toLocalTime().toNanoOfDay()).writeInt(offsetTime.getOffset().getTotalSeconds());
    }

    @Override
    public void writeLocalDateTime(WriterContext ctx, LocalDateTime localDateTime) {
        Objects.requireNonNull(localDateTime, "dateTime cannot be null");
        StructType.LOCAL_DATE_TIME.writeHeader(ctx);
        ctx.buffer().writeInt(localDateTime.toEpochSecond(ZoneOffset.UTC)).writeInt(localDateTime.getNano());
    }

    @Override
    public void writeDateTime(WriterContext ctx, OffsetDateTime offsetDateTime) {
        StructType.DATE_TIME.writeHeader(ctx);
        ctx.buffer().writeInt(offsetDateTime.toEpochSecond()).writeInt(offsetDateTime.getNano()).writeInt(offsetDateTime.getOffset().getTotalSeconds());
    }

    @Override
    public void writeDateTime(WriterContext ctx, ZonedDateTime zonedDateTime) {
        Objects.requireNonNull(zonedDateTime, "dateTime cannot be null");
        long epochSecond = zonedDateTime.toEpochSecond();
        ZoneId zone = zonedDateTime.getZone();
        if (zone instanceof ZoneOffset) {
            StructType.DATE_TIME.writeHeader(ctx);
            ctx.buffer().writeInt(epochSecond).writeInt(zonedDateTime.getNano()).writeInt(zonedDateTime.getOffset().getTotalSeconds());
            return;
        }
        StructType.DATE_TIME_ZONE_ID.writeHeader(ctx);
        ctx.buffer().writeInt(epochSecond).writeInt(zonedDateTime.getNano()).writeString(zone.getId());
    }

    @Override
    public void writePath(WriterContext ctx, NodeValue[] nodes, RelationshipValue[] relationships) throws RuntimeException {
        StructType.PATH.writeHeader(ctx);
        if (nodes.length == 0) {
            throw new IllegalArgumentException("Illegal node/relationship combination: path contains no nodes");
        }
        if (relationships.length == 0) {
            ctx.buffer().writeListHeader(1);
            ctx.writeValue((AnyValue)nodes[0]);
            ctx.buffer().writeListHeader(0).writeListHeader(0);
            return;
        }
        PrimitiveLongIntKeyValueArray nodeIndices = new PrimitiveLongIntKeyValueArray(nodes.length);
        PrimitiveLongIntKeyValueArray relationshipIndices = new PrimitiveLongIntKeyValueArray(relationships.length);
        ArrayList<NodeValue> reducedNodes = new ArrayList<NodeValue>();
        for (NodeValue node2 : nodes) {
            if (!nodeIndices.putIfAbsent(node2.id(), reducedNodes.size())) continue;
            reducedNodes.add(node2);
        }
        ArrayList<RelationshipValue> reducedRelationships = new ArrayList<RelationshipValue>();
        for (RelationshipValue rel2 : relationships) {
            if (!relationshipIndices.putIfAbsent(rel2.id(), reducedRelationships.size())) continue;
            reducedRelationships.add(rel2);
        }
        ctx.buffer().writeList(reducedNodes, (b, node) -> ctx.writeValue((AnyValue)node));
        ctx.buffer().writeList(reducedRelationships, (b, rel) -> ctx.writeUnboundRelationship(rel.elementId(), rel.id(), rel.type().stringValue(), rel.properties()));
        ctx.buffer().writeListHeader(relationships.length * 2);
        NodeValue currentOrigin = nodes[0];
        for (int i = 0; i < reducedRelationships.size(); ++i) {
            RelationshipValue relationship = (RelationshipValue)reducedRelationships.get(i);
            if (currentOrigin.id() == relationship.startNodeId()) {
                ctx.buffer().writeInt(i + 1);
            } else {
                ctx.buffer().writeInt(-i - 1);
            }
            int targetIndex = nodeIndices.getOrDefault(nodes[i + 1].id(), -1);
            if (targetIndex == -1) {
                throw new IllegalArgumentException("Illegal node/relationship combination: Cannot locate target node for relationship #" + i);
            }
            ctx.buffer().writeInt(targetIndex);
            currentOrigin = (NodeValue)reducedNodes.get(targetIndex);
        }
    }

    @Override
    public void writeNode(WriterContext ctx, String elementId, long nodeId, TextArray labels, MapValue properties, boolean isDeleted) {
        StructType.NODE.writeHeader(ctx);
        List stringLabels = StreamSupport.stream(labels.spliterator(), false).map(label -> ((TextValue)label).stringValue()).collect(Collectors.toList());
        ctx.buffer().writeInt(nodeId).writeList(stringLabels, PackstreamBuf::writeString);
        ctx.writeValue((AnyValue)properties);
        ctx.buffer().writeString(elementId);
    }

    @Override
    public void writeRelationship(WriterContext ctx, String elementId, long relId, String startNodeElementId, long startNodeId, String endNodeElementId, long endNodeId, TextValue type, MapValue properties, boolean isDeleted) {
        StructType.RELATIONSHIP.writeHeader(ctx);
        ctx.buffer().writeInt(relId).writeInt(startNodeId).writeInt(endNodeId).writeString(type.stringValue());
        ctx.writeValue((AnyValue)properties);
        ctx.buffer().writeString(elementId).writeString(startNodeElementId).writeString(endNodeElementId);
    }

    @Override
    public void writeUnboundRelationship(WriterContext ctx, String elementId, long relId, String type, MapValue properties) {
        StructType.UNBOUND_RELATIONSHIP.writeHeader(ctx);
        ctx.buffer().writeInt(relId).writeString(type);
        ctx.writeValue((AnyValue)properties);
        ctx.buffer().writeString(elementId);
    }
}

