/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.exceptions;

import org.neo4j.exceptions.InvalidArgumentException;

public class InvalidCypherOption
extends InvalidArgumentException {
    public InvalidCypherOption(String message) {
        super(message);
    }

    public static InvalidCypherOption invalidCombination(String optionName1, String option1, String optionName2, String option2) {
        return new InvalidCypherOption(String.format("Cannot combine %s '%s' with %s '%s'", optionName1, option1, optionName2, option2));
    }

    public static InvalidCypherOption parallelRuntimeIsDisabled() {
        return new InvalidCypherOption("Parallel runtime has been disabled, please enable it or upgrade to a bigger Aura instance.");
    }

    public static InvalidCypherOption invalidOption(String input, String name, String ... validOptions) {
        return new InvalidCypherOption(String.format("%s is not a valid option for %s. Valid options are: %s", input, name, String.join((CharSequence)", ", validOptions)));
    }

    public static InvalidCypherOption conflictingOptionForName(String name) {
        return new InvalidCypherOption("Can't specify multiple conflicting values for " + name);
    }

    public static InvalidCypherOption unsupportedOptions(String ... keys) {
        return new InvalidCypherOption(String.format("Unsupported options: %s", String.join((CharSequence)", ", keys)));
    }

    public static InvalidCypherOption irEagerAnalyzerUnsupported(String operation) {
        return new InvalidCypherOption(String.format("The Cypher option `eagerAnalyzer=ir` is not supported while %s. Use `eagerAnalyzer=lp` instead.", operation));
    }

    public static InvalidCypherOption sourceGenerationDisabled() {
        return new InvalidCypherOption("In order to use source generation you need to enable `internal.cypher.pipelined.allow_source_generation`");
    }
}

