/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.literal.interpreter;

import java.time.Clock;
import java.time.ZoneId;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ErrorNode;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.neo4j.cypher.internal.parser.AstRuleCtx;
import org.neo4j.cypher.internal.parser.v5.Cypher5Parser;
import org.neo4j.exceptions.SyntaxException;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.DateTimeValue;
import org.neo4j.values.storable.DateValue;
import org.neo4j.values.storable.DurationValue;
import org.neo4j.values.storable.LocalDateTimeValue;
import org.neo4j.values.storable.LocalTimeValue;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.TimeValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.MapValueBuilder;
import org.neo4j.values.virtual.VirtualValues;

class LiteralInterpreterBuilder
implements ParseTreeListener {
    public static final ZoneId DEFAULT_ZONE_ID = ZoneId.systemDefault();
    private static final Object missingAst = new Object();

    LiteralInterpreterBuilder() {
    }

    public void visitTerminal(TerminalNode terminalNode) {
    }

    public void visitErrorNode(ErrorNode errorNode) {
    }

    public void enterEveryRule(ParserRuleContext parserRuleContext) {
    }

    private void exitDefault(AstRuleCtx ctx) {
        ParseTree parseTree;
        if (ctx.getChildCount() == 1 && (parseTree = ctx.getChild(0)) instanceof AstRuleCtx) {
            AstRuleCtx childCtx = (AstRuleCtx)parseTree;
            ctx.ast = childCtx.ast;
        }
    }

    private void throwUnsupportedQuery() {
        throw new UnsupportedOperationException("Query not supported in literal interpreter");
    }

    public void exitEveryRule(ParserRuleContext ctx) {
        if (ctx.exception != null) {
            return;
        }
        ((AstRuleCtx)ctx).ast = missingAst;
        switch (ctx.getRuleIndex()) {
            case 126: {
                this.exitNumberLiteral((Cypher5Parser.NumberLiteralContext)ctx);
                break;
            }
            case 105: {
                this.exitLiteral((Cypher5Parser.LiteralContext)ctx);
                break;
            }
            case 317: {
                this.exitStringLiteral((Cypher5Parser.StringLiteralContext)ctx);
                break;
            }
            case 128: {
                this.exitListLiteral((Cypher5Parser.ListLiteralContext)ctx);
                break;
            }
            case 321: {
                this.exitMap((Cypher5Parser.MapContext)ctx);
                break;
            }
            case 129: {
                this.exitPropertyKeyName((Cypher5Parser.PropertyKeyNameContext)ctx);
                break;
            }
            case 322: {
                this.exitSymbolicNameString((Cypher5Parser.SymbolicNameStringContext)ctx);
                break;
            }
            case 323: {
                this.exitEscapedSymbolicNameString((Cypher5Parser.EscapedSymbolicNameStringContext)ctx);
                break;
            }
            case 324: {
                this.exitUnescapedSymbolicNameString((Cypher5Parser.UnescapedSymbolicNameStringContext)ctx);
                break;
            }
            case 132: {
                this.exitFunctionInvocation((Cypher5Parser.FunctionInvocationContext)ctx);
                break;
            }
            case 133: {
                this.exitFunctionArgument((Cypher5Parser.FunctionArgumentContext)ctx);
                break;
            }
            case 134: {
                this.exitFunctionName((Cypher5Parser.FunctionNameContext)ctx);
                break;
            }
            case 86: {
                this.exitDefault((AstRuleCtx)ctx);
                break;
            }
            case 104: {
                this.exitExpression1((Cypher5Parser.Expression1Context)ctx);
                break;
            }
            case 98: {
                this.exitDefault((AstRuleCtx)ctx);
                break;
            }
            case 97: {
                this.exitDefault((AstRuleCtx)ctx);
                break;
            }
            case 96: {
                this.exitDefault((AstRuleCtx)ctx);
                break;
            }
            case 95: {
                this.exitDefault((AstRuleCtx)ctx);
                break;
            }
            case 94: {
                this.exitDefault((AstRuleCtx)ctx);
                break;
            }
            case 91: {
                this.exitDefault((AstRuleCtx)ctx);
                break;
            }
            case 90: {
                this.exitDefault((AstRuleCtx)ctx);
                break;
            }
            case 89: {
                this.exitDefault((AstRuleCtx)ctx);
                break;
            }
            case 88: {
                this.exitDefault((AstRuleCtx)ctx);
                break;
            }
            case 87: {
                this.exitDefault((AstRuleCtx)ctx);
                break;
            }
            case 135: {
                this.exitNameSpace((Cypher5Parser.NamespaceContext)ctx);
                break;
            }
            case 326: {
                this.exitUnescapedLabelSymbolicNameString((Cypher5Parser.UnescapedLabelSymbolicNameStringContext)ctx);
                break;
            }
            default: {
                this.exitDefault((AstRuleCtx)ctx);
            }
        }
        if (((AstRuleCtx)ctx).ast == missingAst) {
            this.throwUnsupportedQuery();
        }
    }

    private void exitFunctionArgument(Cypher5Parser.FunctionArgumentContext ctx) {
        ParseTree parseTree;
        if (ctx.getChildCount() == 1 && (parseTree = ctx.getChild(0)) instanceof AstRuleCtx) {
            AstRuleCtx childCtx = (AstRuleCtx)parseTree;
            ctx.ast = childCtx.ast;
        }
    }

    private void exitFunctionInvocation(Cypher5Parser.FunctionInvocationContext ctx) {
        ZoneId DEFAULT_ZONE_ID = ZoneId.systemDefault();
        Object object = ctx.functionName().ast;
        if (object instanceof String) {
            String functionName = (String)object;
            List<Object> arguments = ctx.functionArgument().stream().map(AstRuleCtx::ast).collect(Collectors.toList());
            switch (functionName) {
                case "date": {
                    ctx.ast = LiteralInterpreterBuilder.createTemporalValue(arguments, functionName, DateValue::now, DateValue::parse, DateValue::build);
                    break;
                }
                case "datetime": {
                    ctx.ast = LiteralInterpreterBuilder.createTemporalValue(arguments, functionName, DateTimeValue::now, s -> DateTimeValue.parse((CharSequence)s, () -> DEFAULT_ZONE_ID), DateTimeValue::build);
                    break;
                }
                case "time": {
                    ctx.ast = LiteralInterpreterBuilder.createTemporalValue(arguments, functionName, TimeValue::now, s -> TimeValue.parse((CharSequence)s, () -> DEFAULT_ZONE_ID), TimeValue::build);
                    break;
                }
                case "localtime": {
                    ctx.ast = LiteralInterpreterBuilder.createTemporalValue(arguments, functionName, LocalTimeValue::now, LocalTimeValue::parse, LocalTimeValue::build);
                    break;
                }
                case "localdatetime": {
                    ctx.ast = LiteralInterpreterBuilder.createTemporalValue(arguments, functionName, LocalDateTimeValue::now, LocalDateTimeValue::parse, LocalDateTimeValue::build);
                    break;
                }
                case "duration": {
                    ctx.ast = LiteralInterpreterBuilder.createDurationValue(arguments);
                    break;
                }
                case "point": {
                    ctx.ast = LiteralInterpreterBuilder.createPoint(arguments);
                    break;
                }
                default: {
                    this.throwUnsupportedQuery();
                }
            }
        }
    }

    private static <T> T createTemporalValue(List<Object> arguments, String functionName, Function<Clock, T> onEmpty, Function<String, T> onString, BiFunction<MapValue, Supplier<ZoneId>, T> onMap) {
        if (arguments.isEmpty()) {
            return onEmpty.apply(Clock.system(DEFAULT_ZONE_ID));
        }
        if (arguments.size() == 1) {
            Object date = arguments.get(0);
            if (date == null) {
                return null;
            }
            if (date instanceof String) {
                return onString.apply((String)date);
            }
            if (date instanceof Map) {
                MapValue dateMap = LiteralInterpreterBuilder.asMapValue((Map)date);
                return onMap.apply(dateMap, () -> DEFAULT_ZONE_ID);
            }
        }
        throw new IllegalArgumentException("Function `" + functionName + "` did not get expected number of arguments: expected 0 or 1 argument, got " + arguments.size() + " arguments.");
    }

    private static MapValue asMapValue(Map<String, ?> map) {
        int size = map.size();
        if (size == 0) {
            return VirtualValues.EMPTY_MAP;
        }
        MapValueBuilder builder = new MapValueBuilder(size);
        for (Map.Entry<String, ?> entry : map.entrySet()) {
            builder.add(entry.getKey(), (AnyValue)Values.of(entry.getValue()));
        }
        return builder.build();
    }

    private static DurationValue createDurationValue(List<Object> arguments) {
        if (arguments.size() == 1) {
            Object duration = arguments.get(0);
            if (duration instanceof String) {
                return DurationValue.parse((CharSequence)((String)duration));
            }
            if (duration instanceof Map) {
                MapValue dateMap = LiteralInterpreterBuilder.asMapValue((Map)duration);
                return DurationValue.build((MapValue)dateMap);
            }
        }
        throw new IllegalArgumentException("Function `duration` did not get expected number of arguments: expected 1 argument, got " + arguments.size() + " arguments.");
    }

    private static PointValue createPoint(List<Object> arguments) {
        if (arguments.size() == 1) {
            Object point = arguments.get(0);
            if (point == null) {
                return null;
            }
            if (point instanceof Map) {
                Map pointAsMap = (Map)point;
                return PointValue.fromMap((MapValue)LiteralInterpreterBuilder.asMapValue(pointAsMap));
            }
            throw new IllegalArgumentException("Function `point` did not get expected argument. Expected a string or map input but got " + point.getClass().getSimpleName() + ".");
        }
        throw new IllegalArgumentException("Function `point` did not get expected number of arguments: expected 1 argument, got " + arguments.size() + " arguments.");
    }

    private void exitFunctionName(Cypher5Parser.FunctionNameContext ctx) {
        ParseTree parseTree;
        if (ctx.getChildCount() == 2 && (parseTree = ctx.getChild(1)) instanceof AstRuleCtx) {
            AstRuleCtx childCtx = (AstRuleCtx)parseTree;
            ctx.ast = childCtx.ast;
        }
    }

    private void exitExpression1(Cypher5Parser.Expression1Context ctx) {
        if (ctx.literal() != null) {
            ctx.ast = ctx.literal().ast;
        } else if (ctx.listLiteral() != null) {
            ctx.ast = ctx.listLiteral().ast;
        } else if (ctx.functionInvocation() != null) {
            ctx.ast = ctx.functionInvocation().ast;
        }
    }

    private void exitListLiteral(Cypher5Parser.ListLiteralContext ctx) {
        ctx.ast = ctx.expression().stream().map(AstRuleCtx::ast).toList();
    }

    private void exitLiteral(Cypher5Parser.LiteralContext ctx) {
        if (ctx instanceof Cypher5Parser.NummericLiteralContext) {
            Cypher5Parser.NummericLiteralContext nctx = (Cypher5Parser.NummericLiteralContext)ctx;
            ctx.ast = nctx.numberLiteral().ast;
        } else if (ctx instanceof Cypher5Parser.StringsLiteralContext) {
            Cypher5Parser.StringsLiteralContext sctx = (Cypher5Parser.StringsLiteralContext)ctx;
            ctx.ast = sctx.stringLiteral().ast;
        } else if (ctx instanceof Cypher5Parser.OtherLiteralContext) {
            Cypher5Parser.OtherLiteralContext octx = (Cypher5Parser.OtherLiteralContext)ctx;
            ctx.ast = octx.map().ast;
        } else if (ctx instanceof Cypher5Parser.BooleanLiteralContext) {
            Cypher5Parser.BooleanLiteralContext bctx = (Cypher5Parser.BooleanLiteralContext)ctx;
            ctx.ast = bctx.TRUE() != null ? Boolean.TRUE : Boolean.FALSE;
        } else if (ctx instanceof Cypher5Parser.KeywordLiteralContext) {
            Cypher5Parser.KeywordLiteralContext kctx = (Cypher5Parser.KeywordLiteralContext)ctx;
            if (kctx.INF() != null || kctx.INFINITY() != null) {
                ctx.ast = Double.POSITIVE_INFINITY;
            } else if (kctx.NAN() != null) {
                ctx.ast = Double.NaN;
            } else if (kctx.NULL() != null) {
                ctx.ast = null;
            }
        }
    }

    private void exitMap(Cypher5Parser.MapContext ctx) {
        List values = ctx.expression();
        List keys = ctx.propertyKeyName();
        int n = values.size();
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (int i = 0; i < n; ++i) {
            map.put((String)((Cypher5Parser.PropertyKeyNameContext)keys.get(i)).ast(), ((Cypher5Parser.ExpressionContext)values.get((int)i)).ast);
        }
        ctx.ast = map;
    }

    private void exitNumberLiteral(Cypher5Parser.NumberLiteralContext ctx) {
        if (ctx.DECIMAL_DOUBLE() != null) {
            ctx.ast = Double.parseDouble(ctx.getText());
        } else if (ctx.UNSIGNED_DECIMAL_INTEGER() != null) {
            String text = ctx.getText();
            ctx.ast = Long.parseLong(text);
        } else if (ctx.UNSIGNED_OCTAL_INTEGER() != null) {
            String octalString = ctx.getText().replaceFirst("o", "");
            ctx.ast = Long.parseLong(octalString, 8);
        } else if (ctx.UNSIGNED_HEX_INTEGER() != null) {
            String hexString = ctx.getText().replaceFirst("x", "");
            ctx.ast = Long.parseLong(hexString, 16);
        }
    }

    private void exitStringLiteral(Cypher5Parser.StringLiteralContext ctx) {
        ctx.ast = this.cypherStringToString(ctx.getText().substring(1, ctx.getText().length() - 1));
    }

    private void exitPropertyKeyName(Cypher5Parser.PropertyKeyNameContext ctx) {
        ctx.ast = ctx.symbolicNameString().ast;
    }

    private void exitSymbolicNameString(Cypher5Parser.SymbolicNameStringContext ctx) {
        ctx.ast = ctx.escapedSymbolicNameString() != null ? ctx.escapedSymbolicNameString().ast : ctx.unescapedSymbolicNameString().ast;
    }

    private void exitEscapedSymbolicNameString(Cypher5Parser.EscapedSymbolicNameStringContext ctx) {
        ctx.ast = ctx.getText().substring(1, ctx.getText().length() - 1);
    }

    private void exitUnescapedSymbolicNameString(Cypher5Parser.UnescapedSymbolicNameStringContext ctx) {
        ctx.ast = ctx.getText();
    }

    private void exitUnescapedLabelSymbolicNameString(Cypher5Parser.UnescapedLabelSymbolicNameStringContext ctx) {
        ctx.ast = ctx.getText();
    }

    private void exitNameSpace(Cypher5Parser.NamespaceContext ctx) {
        if (ctx.getChildCount() > 0) {
            this.throwUnsupportedQuery();
        }
        ctx.ast = null;
    }

    private String cypherStringToString(String input) {
        int pos = input.indexOf(92);
        if (pos == -1) {
            return input;
        }
        int start = 0;
        int length = input.length();
        CharSequence builder = null;
        while (pos != -1) {
            char replacement;
            if (pos == length - 1) {
                throw new SyntaxException("Failed to parse string literal. The query must contain an even number of non-escaped quotes.");
            }
            switch (input.charAt(pos + 1)) {
                case 't': {
                    char c = '\t';
                    break;
                }
                case 'b': {
                    char c = '\b';
                    break;
                }
                case 'n': {
                    char c = '\n';
                    break;
                }
                case 'r': {
                    char c = '\r';
                    break;
                }
                case 'f': {
                    char c = '\f';
                    break;
                }
                case '\'': {
                    char c = '\'';
                    break;
                }
                case '\"': {
                    char c = '\"';
                    break;
                }
                case '\\': {
                    char c = '\\';
                    break;
                }
                case 'u': {
                    char c = (char)Integer.parseInt(input.substring(pos + 2, pos + 2 + 4), 16);
                    break;
                }
                default: {
                    char c = replacement = '\u0000';
                }
            }
            if (replacement != '\u0000') {
                if (builder == null) {
                    builder = new StringBuilder(input.length());
                }
                ((StringBuilder)builder).append(input, start, pos).append(replacement);
                start = input.charAt(pos + 1) == 'u' ? pos + 6 : pos + 2;
            }
            pos = input.indexOf(92, pos + 2);
        }
        if (builder == null || builder.isEmpty()) {
            return input;
        }
        if (start < input.length()) {
            return ((StringBuilder)builder).append(input, start, input.length()).toString();
        }
        return ((StringBuilder)builder).toString();
    }
}

