/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.memory;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ReadOnlyBufferException;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.arrow.memory.BaseAllocator;
import org.apache.arrow.memory.BoundsChecking;
import org.apache.arrow.memory.BufferManager;
import org.apache.arrow.memory.ReferenceManager;
import org.apache.arrow.memory.util.CommonUtil;
import org.apache.arrow.memory.util.HistoricalLog;
import org.apache.arrow.memory.util.LargeMemoryUtil;
import org.apache.arrow.memory.util.MemoryUtil;
import org.apache.arrow.util.Preconditions;
import org.apache.arrow.util.VisibleForTesting;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ArrowBuf
implements AutoCloseable {
    private static final @UnknownKeyFor @NonNull @Initialized Logger logger = LoggerFactory.getLogger(ArrowBuf.class);
    private static final @UnknownKeyFor @NonNull @Initialized int SHORT_SIZE = 2;
    private static final @UnknownKeyFor @NonNull @Initialized int INT_SIZE = 4;
    private static final @UnknownKeyFor @NonNull @Initialized int FLOAT_SIZE = 4;
    private static final @UnknownKeyFor @NonNull @Initialized int DOUBLE_SIZE = 8;
    private static final @UnknownKeyFor @NonNull @Initialized int LONG_SIZE = 8;
    private static final @UnknownKeyFor @NonNull @Initialized AtomicLong idGenerator = new AtomicLong(0L);
    private static final @UnknownKeyFor @NonNull @Initialized int LOG_BYTES_PER_ROW = 10;
    private final @UnknownKeyFor @NonNull @Initialized long id = idGenerator.incrementAndGet();
    private final @UnknownKeyFor @NonNull @Initialized ReferenceManager referenceManager;
    private final @Nullable @UnknownKeyFor @Initialized BufferManager bufferManager;
    private final @UnknownKeyFor @NonNull @Initialized long addr;
    private @UnknownKeyFor @NonNull @Initialized long readerIndex;
    private @UnknownKeyFor @NonNull @Initialized long writerIndex;
    private final @Nullable @UnknownKeyFor @Initialized HistoricalLog historicalLog = BaseAllocator.DEBUG ? new HistoricalLog(6, "ArrowBuf[%d]", this.id) : null;
    private volatile @UnknownKeyFor @NonNull @Initialized long capacity;

    public ArrowBuf(@UnknownKeyFor @NonNull @Initialized ReferenceManager referenceManager, @Nullable @UnknownKeyFor @Initialized BufferManager bufferManager, @UnknownKeyFor @NonNull @Initialized long capacity, @UnknownKeyFor @NonNull @Initialized long memoryAddress) {
        this.referenceManager = referenceManager;
        this.bufferManager = bufferManager;
        this.addr = memoryAddress;
        this.capacity = capacity;
        this.readerIndex = 0L;
        this.writerIndex = 0L;
        if (this.historicalLog != null) {
            this.historicalLog.recordEvent("create()", new Object[0]);
        }
    }

    public @UnknownKeyFor @NonNull @Initialized int refCnt() {
        return this.referenceManager.getRefCount();
    }

    public void checkBytes(@UnknownKeyFor @NonNull @Initialized long start, @UnknownKeyFor @NonNull @Initialized long end) {
        if (BoundsChecking.BOUNDS_CHECKING_ENABLED) {
            this.checkIndexD(start, end - start);
        }
    }

    private void ensureAccessible() {
        if (this.refCnt() == 0) {
            throw new IllegalStateException("Ref count should be >= 1 for accessing the ArrowBuf");
        }
    }

    public @UnknownKeyFor @NonNull @Initialized ReferenceManager getReferenceManager() {
        return this.referenceManager;
    }

    public @UnknownKeyFor @NonNull @Initialized long capacity() {
        return this.capacity;
    }

    public synchronized @UnknownKeyFor @NonNull @Initialized ArrowBuf capacity(@UnknownKeyFor @NonNull @Initialized long newCapacity) {
        if (newCapacity == this.capacity) {
            return this;
        }
        Preconditions.checkArgument(newCapacity >= 0L);
        if (newCapacity < this.capacity) {
            this.capacity = newCapacity;
            return this;
        }
        throw new UnsupportedOperationException("Buffers don't support resizing that increases the size.");
    }

    public @UnknownKeyFor @NonNull @Initialized ByteOrder order() {
        return ByteOrder.nativeOrder();
    }

    public @UnknownKeyFor @NonNull @Initialized long readableBytes() {
        Preconditions.checkState(this.writerIndex >= this.readerIndex, "Writer index cannot be less than reader index");
        return this.writerIndex - this.readerIndex;
    }

    public @UnknownKeyFor @NonNull @Initialized long writableBytes() {
        return this.capacity() - this.writerIndex;
    }

    public @UnknownKeyFor @NonNull @Initialized ArrowBuf slice() {
        return this.slice(this.readerIndex, this.readableBytes());
    }

    public @UnknownKeyFor @NonNull @Initialized ArrowBuf slice(@UnknownKeyFor @NonNull @Initialized long index, @UnknownKeyFor @NonNull @Initialized long length) {
        Preconditions.checkPositionIndex(index, this.capacity);
        Preconditions.checkPositionIndex(index + length, this.capacity);
        ArrowBuf newBuf = this.referenceManager.deriveBuffer(this, index, length);
        newBuf.writerIndex(length);
        return newBuf;
    }

    public @UnknownKeyFor @NonNull @Initialized ByteBuffer nioBuffer() {
        return this.nioBuffer(this.readerIndex, LargeMemoryUtil.checkedCastToInt(this.readableBytes()));
    }

    public @UnknownKeyFor @NonNull @Initialized ByteBuffer nioBuffer(@UnknownKeyFor @NonNull @Initialized long index, @UnknownKeyFor @NonNull @Initialized int length) {
        this.chk(index, length);
        return this.getDirectBuffer(index, length);
    }

    private @UnknownKeyFor @NonNull @Initialized ByteBuffer getDirectBuffer(@UnknownKeyFor @NonNull @Initialized long index, @UnknownKeyFor @NonNull @Initialized int length) {
        long address = this.addr(index);
        return MemoryUtil.directBuffer(address, length);
    }

    public @UnknownKeyFor @NonNull @Initialized long memoryAddress() {
        return this.addr;
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return String.format("ArrowBuf[%d], address:%d, capacity:%d", this.id, this.memoryAddress(), this.capacity);
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        return System.identityHashCode(this);
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object obj) {
        return this == obj;
    }

    private @UnknownKeyFor @NonNull @Initialized long addr(@UnknownKeyFor @NonNull @Initialized long index) {
        return this.addr + index;
    }

    private void chk(@UnknownKeyFor @NonNull @Initialized long index, @UnknownKeyFor @NonNull @Initialized long length) {
        if (BoundsChecking.BOUNDS_CHECKING_ENABLED) {
            this.checkIndexD(index, length);
        }
    }

    private void checkIndexD(@UnknownKeyFor @NonNull @Initialized long index, @UnknownKeyFor @NonNull @Initialized long fieldLength) {
        this.ensureAccessible();
        Preconditions.checkArgument(fieldLength >= 0L, "expecting non-negative data length");
        if (index < 0L || index > this.capacity() - fieldLength) {
            if (this.historicalLog != null) {
                this.historicalLog.logHistory(logger);
            }
            throw new IndexOutOfBoundsException(String.format("index: %d, length: %d (expected: range(0, %d))", index, fieldLength, this.capacity()));
        }
    }

    public @UnknownKeyFor @NonNull @Initialized long getLong(@UnknownKeyFor @NonNull @Initialized long index) {
        this.chk(index, 8L);
        return MemoryUtil.UNSAFE.getLong(this.addr(index));
    }

    public void setLong(@UnknownKeyFor @NonNull @Initialized long index, @UnknownKeyFor @NonNull @Initialized long value) {
        this.chk(index, 8L);
        MemoryUtil.UNSAFE.putLong(this.addr(index), value);
    }

    public @UnknownKeyFor @NonNull @Initialized float getFloat(@UnknownKeyFor @NonNull @Initialized long index) {
        return Float.intBitsToFloat(this.getInt(index));
    }

    public void setFloat(@UnknownKeyFor @NonNull @Initialized long index, @UnknownKeyFor @NonNull @Initialized float value) {
        this.chk(index, 4L);
        MemoryUtil.UNSAFE.putInt(this.addr(index), Float.floatToRawIntBits(value));
    }

    public @UnknownKeyFor @NonNull @Initialized double getDouble(@UnknownKeyFor @NonNull @Initialized long index) {
        return Double.longBitsToDouble(this.getLong(index));
    }

    public void setDouble(@UnknownKeyFor @NonNull @Initialized long index, @UnknownKeyFor @NonNull @Initialized double value) {
        this.chk(index, 8L);
        MemoryUtil.UNSAFE.putLong(this.addr(index), Double.doubleToRawLongBits(value));
    }

    public @UnknownKeyFor @NonNull @Initialized char getChar(@UnknownKeyFor @NonNull @Initialized long index) {
        return (char)this.getShort(index);
    }

    public void setChar(@UnknownKeyFor @NonNull @Initialized long index, @UnknownKeyFor @NonNull @Initialized int value) {
        this.chk(index, 2L);
        MemoryUtil.UNSAFE.putShort(this.addr(index), (short)value);
    }

    public @UnknownKeyFor @NonNull @Initialized int getInt(@UnknownKeyFor @NonNull @Initialized long index) {
        this.chk(index, 4L);
        return MemoryUtil.UNSAFE.getInt(this.addr(index));
    }

    public void setInt(@UnknownKeyFor @NonNull @Initialized long index, @UnknownKeyFor @NonNull @Initialized int value) {
        this.chk(index, 4L);
        MemoryUtil.UNSAFE.putInt(this.addr(index), value);
    }

    public @UnknownKeyFor @NonNull @Initialized short getShort(@UnknownKeyFor @NonNull @Initialized long index) {
        this.chk(index, 2L);
        return MemoryUtil.UNSAFE.getShort(this.addr(index));
    }

    public void setShort(@UnknownKeyFor @NonNull @Initialized long index, @UnknownKeyFor @NonNull @Initialized int value) {
        this.setShort(index, (short)value);
    }

    public void setShort(@UnknownKeyFor @NonNull @Initialized long index, @UnknownKeyFor @NonNull @Initialized short value) {
        this.chk(index, 2L);
        MemoryUtil.UNSAFE.putShort(this.addr(index), value);
    }

    public void setByte(@UnknownKeyFor @NonNull @Initialized long index, @UnknownKeyFor @NonNull @Initialized int value) {
        this.chk(index, 1L);
        MemoryUtil.UNSAFE.putByte(this.addr(index), (byte)value);
    }

    public void setByte(@UnknownKeyFor @NonNull @Initialized long index, @UnknownKeyFor @NonNull @Initialized byte value) {
        this.chk(index, 1L);
        MemoryUtil.UNSAFE.putByte(this.addr(index), value);
    }

    public @UnknownKeyFor @NonNull @Initialized byte getByte(@UnknownKeyFor @NonNull @Initialized long index) {
        this.chk(index, 1L);
        return MemoryUtil.UNSAFE.getByte(this.addr(index));
    }

    private void ensureWritable(@UnknownKeyFor @NonNull @Initialized int length) {
        if (BoundsChecking.BOUNDS_CHECKING_ENABLED) {
            Preconditions.checkArgument(length >= 0, "expecting non-negative length");
            this.ensureAccessible();
            if ((long)length > this.writableBytes()) {
                throw new IndexOutOfBoundsException(String.format("writerIndex(%d) + length(%d) exceeds capacity(%d)", this.writerIndex, length, this.capacity()));
            }
        }
    }

    private void ensureReadable(@UnknownKeyFor @NonNull @Initialized int length) {
        if (BoundsChecking.BOUNDS_CHECKING_ENABLED) {
            Preconditions.checkArgument(length >= 0, "expecting non-negative length");
            this.ensureAccessible();
            if ((long)length > this.readableBytes()) {
                throw new IndexOutOfBoundsException(String.format("readerIndex(%d) + length(%d) exceeds writerIndex(%d)", this.readerIndex, length, this.writerIndex));
            }
        }
    }

    public @UnknownKeyFor @NonNull @Initialized byte readByte() {
        this.ensureReadable(1);
        byte b = this.getByte(this.readerIndex);
        ++this.readerIndex;
        return b;
    }

    public void readBytes(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] dst) {
        Preconditions.checkArgument(dst != null, "expecting valid dst bytearray");
        this.ensureReadable(dst.length);
        this.getBytes(this.readerIndex, dst, 0, LargeMemoryUtil.checkedCastToInt(dst.length));
    }

    public void writeByte(@UnknownKeyFor @NonNull @Initialized byte value) {
        this.ensureWritable(1);
        MemoryUtil.UNSAFE.putByte(this.addr(this.writerIndex), value);
        ++this.writerIndex;
    }

    public void writeByte(@UnknownKeyFor @NonNull @Initialized int value) {
        this.ensureWritable(1);
        MemoryUtil.UNSAFE.putByte(this.addr(this.writerIndex), (byte)value);
        ++this.writerIndex;
    }

    public void writeBytes(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] src) {
        Preconditions.checkArgument(src != null, "expecting valid src array");
        this.writeBytes(src, 0, src.length);
    }

    public void writeBytes(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] src, @UnknownKeyFor @NonNull @Initialized int srcIndex, @UnknownKeyFor @NonNull @Initialized int length) {
        this.ensureWritable(length);
        this.setBytes(this.writerIndex, src, srcIndex, (long)length);
        this.writerIndex += (long)length;
    }

    public void writeShort(@UnknownKeyFor @NonNull @Initialized int value) {
        this.ensureWritable(2);
        MemoryUtil.UNSAFE.putShort(this.addr(this.writerIndex), (short)value);
        this.writerIndex += 2L;
    }

    public void writeInt(@UnknownKeyFor @NonNull @Initialized int value) {
        this.ensureWritable(4);
        MemoryUtil.UNSAFE.putInt(this.addr(this.writerIndex), value);
        this.writerIndex += 4L;
    }

    public void writeLong(@UnknownKeyFor @NonNull @Initialized long value) {
        this.ensureWritable(8);
        MemoryUtil.UNSAFE.putLong(this.addr(this.writerIndex), value);
        this.writerIndex += 8L;
    }

    public void writeFloat(@UnknownKeyFor @NonNull @Initialized float value) {
        this.ensureWritable(4);
        MemoryUtil.UNSAFE.putInt(this.addr(this.writerIndex), Float.floatToRawIntBits(value));
        this.writerIndex += 4L;
    }

    public void writeDouble(@UnknownKeyFor @NonNull @Initialized double value) {
        this.ensureWritable(8);
        MemoryUtil.UNSAFE.putLong(this.addr(this.writerIndex), Double.doubleToRawLongBits(value));
        this.writerIndex += 8L;
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean isOutOfBounds(@UnknownKeyFor @NonNull @Initialized long index, @UnknownKeyFor @NonNull @Initialized long length, @UnknownKeyFor @NonNull @Initialized long capacity) {
        return (index | length | index + length | capacity - (index + length)) < 0L;
    }

    private void checkIndex(@UnknownKeyFor @NonNull @Initialized long index, @UnknownKeyFor @NonNull @Initialized long fieldLength) {
        if (BoundsChecking.BOUNDS_CHECKING_ENABLED) {
            this.ensureAccessible();
            if (ArrowBuf.isOutOfBounds(index, fieldLength, this.capacity())) {
                throw new IndexOutOfBoundsException(String.format("index: %d, length: %d (expected: range(0, %d))", index, fieldLength, this.capacity()));
            }
        }
    }

    public void getBytes(@UnknownKeyFor @NonNull @Initialized long index, @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] dst) {
        this.getBytes(index, dst, 0, dst.length);
    }

    public void getBytes(@UnknownKeyFor @NonNull @Initialized long index, @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] dst, @UnknownKeyFor @NonNull @Initialized int dstIndex, @UnknownKeyFor @NonNull @Initialized int length) {
        this.checkIndex(index, length);
        Preconditions.checkArgument(dst != null, "expecting a valid dst byte array");
        if (ArrowBuf.isOutOfBounds(dstIndex, length, dst.length)) {
            throw new IndexOutOfBoundsException("Not enough space to copy data into destination" + dstIndex);
        }
        if (length != 0) {
            MemoryUtil.copyMemory(null, this.addr(index), dst, MemoryUtil.BYTE_ARRAY_BASE_OFFSET + (long)dstIndex, length);
        }
    }

    public void setBytes(@UnknownKeyFor @NonNull @Initialized long index, @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] src) {
        this.setBytes(index, src, 0, (long)src.length);
    }

    public void setBytes(@UnknownKeyFor @NonNull @Initialized long index, @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] src, @UnknownKeyFor @NonNull @Initialized int srcIndex, @UnknownKeyFor @NonNull @Initialized long length) {
        this.checkIndex(index, length);
        Preconditions.checkArgument(src != null, "expecting a valid src byte array");
        if (ArrowBuf.isOutOfBounds(srcIndex, length, src.length)) {
            throw new IndexOutOfBoundsException("Not enough space to copy data from byte array" + srcIndex);
        }
        if (length > 0L) {
            MemoryUtil.copyMemory(src, MemoryUtil.BYTE_ARRAY_BASE_OFFSET + (long)srcIndex, null, this.addr(index), length);
        }
    }

    public void getBytes(@UnknownKeyFor @NonNull @Initialized long index, @UnknownKeyFor @NonNull @Initialized ByteBuffer dst) {
        this.checkIndex(index, dst.remaining());
        if (dst.remaining() != 0) {
            long srcAddress = this.addr(index);
            if (dst.isDirect()) {
                if (dst.isReadOnly()) {
                    throw new ReadOnlyBufferException();
                }
                long dstAddress = MemoryUtil.getByteBufferAddress(dst) + (long)dst.position();
                MemoryUtil.copyMemory(null, srcAddress, null, dstAddress, dst.remaining());
                dst.position(dst.position() + dst.remaining());
            } else if (dst.hasArray()) {
                int dstIndex = dst.arrayOffset() + dst.position();
                MemoryUtil.copyMemory(null, srcAddress, dst.array(), MemoryUtil.BYTE_ARRAY_BASE_OFFSET + (long)dstIndex, dst.remaining());
                dst.position(dst.position() + dst.remaining());
            } else {
                throw new UnsupportedOperationException("Copy from this ArrowBuf to ByteBuffer is not supported");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBytes(@UnknownKeyFor @NonNull @Initialized long index, @UnknownKeyFor @NonNull @Initialized ByteBuffer src) {
        this.checkIndex(index, src.remaining());
        int length = src.remaining();
        long dstAddress = this.addr(index);
        if (length != 0) {
            if (src.isDirect()) {
                long srcAddress = MemoryUtil.getByteBufferAddress(src) + (long)src.position();
                MemoryUtil.copyMemory(null, srcAddress, null, dstAddress, length);
                src.position(src.position() + length);
            } else if (src.hasArray()) {
                int srcIndex = src.arrayOffset() + src.position();
                MemoryUtil.copyMemory(src.array(), MemoryUtil.BYTE_ARRAY_BASE_OFFSET + (long)srcIndex, null, dstAddress, length);
                src.position(src.position() + length);
            } else {
                ByteOrder originalByteOrder = src.order();
                src.order(this.order());
                try {
                    while (length - 128 >= 8) {
                        for (int x = 0; x < 16; ++x) {
                            MemoryUtil.UNSAFE.putLong(dstAddress, src.getLong());
                            length -= 8;
                            dstAddress += 8L;
                        }
                    }
                    while (length >= 8) {
                        MemoryUtil.UNSAFE.putLong(dstAddress, src.getLong());
                        length -= 8;
                        dstAddress += 8L;
                    }
                    while (length > 0) {
                        MemoryUtil.UNSAFE.putByte(dstAddress, src.get());
                        --length;
                        ++dstAddress;
                    }
                }
                finally {
                    src.order(originalByteOrder);
                }
            }
        }
    }

    public void setBytes(@UnknownKeyFor @NonNull @Initialized long index, @UnknownKeyFor @NonNull @Initialized ByteBuffer src, @UnknownKeyFor @NonNull @Initialized int srcIndex, @UnknownKeyFor @NonNull @Initialized int length) {
        this.checkIndex(index, length);
        if (src.isDirect()) {
            long srcAddress = MemoryUtil.getByteBufferAddress(src) + (long)srcIndex;
            long dstAddress = this.addr(index);
            MemoryUtil.copyMemory(null, srcAddress, null, dstAddress, length);
        } else if (srcIndex == 0 && src.capacity() == length) {
            this.setBytes(index, src);
        } else {
            ByteBuffer newBuf = src.duplicate();
            newBuf.position(srcIndex);
            newBuf.limit(srcIndex + length);
            this.setBytes(index, newBuf);
        }
    }

    public void getBytes(@UnknownKeyFor @NonNull @Initialized long index, @UnknownKeyFor @NonNull @Initialized ArrowBuf dst, @UnknownKeyFor @NonNull @Initialized long dstIndex, @UnknownKeyFor @NonNull @Initialized int length) {
        this.checkIndex(index, length);
        Preconditions.checkArgument(dst != null, "expecting a valid ArrowBuf");
        if (ArrowBuf.isOutOfBounds(dstIndex, length, dst.capacity())) {
            throw new IndexOutOfBoundsException(String.format("index: %d, length: %d (expected: range(0, %d))", dstIndex, length, dst.capacity()));
        }
        if (length != 0) {
            long srcAddress = this.addr(index);
            long dstAddress = dst.memoryAddress() + dstIndex;
            MemoryUtil.copyMemory(null, srcAddress, null, dstAddress, length);
        }
    }

    public void setBytes(@UnknownKeyFor @NonNull @Initialized long index, @UnknownKeyFor @NonNull @Initialized ArrowBuf src, @UnknownKeyFor @NonNull @Initialized long srcIndex, @UnknownKeyFor @NonNull @Initialized long length) {
        this.checkIndex(index, length);
        Preconditions.checkArgument(src != null, "expecting a valid ArrowBuf");
        if (ArrowBuf.isOutOfBounds(srcIndex, length, src.capacity())) {
            throw new IndexOutOfBoundsException(String.format("index: %d, length: %d (expected: range(0, %d))", index, length, src.capacity()));
        }
        if (length != 0L) {
            long srcAddress = src.memoryAddress() + srcIndex;
            long dstAddress = this.addr(index);
            MemoryUtil.copyMemory(null, srcAddress, null, dstAddress, length);
        }
    }

    public void setBytes(@UnknownKeyFor @NonNull @Initialized long index, @UnknownKeyFor @NonNull @Initialized ArrowBuf src) {
        Preconditions.checkArgument(src != null, "expecting valid ArrowBuf");
        long length = src.readableBytes();
        this.checkIndex(index, length);
        long srcAddress = src.memoryAddress() + src.readerIndex;
        long dstAddress = this.addr(index);
        MemoryUtil.copyMemory(null, srcAddress, null, dstAddress, length);
        src.readerIndex(src.readerIndex + length);
    }

    public @UnknownKeyFor @NonNull @Initialized int setBytes(@UnknownKeyFor @NonNull @Initialized long index, @UnknownKeyFor @NonNull @Initialized InputStream in, @UnknownKeyFor @NonNull @Initialized int length) throws @UnknownKeyFor @NonNull @Initialized IOException {
        byte[] tmp;
        Preconditions.checkArgument(in != null, "expecting valid input stream");
        this.checkIndex(index, length);
        int readBytes = 0;
        if (length > 0 && (readBytes = in.read(tmp = new byte[length])) > 0) {
            MemoryUtil.copyMemory(tmp, MemoryUtil.BYTE_ARRAY_BASE_OFFSET, null, this.addr(index), readBytes);
        }
        return readBytes;
    }

    public void getBytes(@UnknownKeyFor @NonNull @Initialized long index, @UnknownKeyFor @NonNull @Initialized OutputStream out, @UnknownKeyFor @NonNull @Initialized int length) throws @UnknownKeyFor @NonNull @Initialized IOException {
        Preconditions.checkArgument(out != null, "expecting valid output stream");
        this.checkIndex(index, length);
        if (length > 0) {
            byte[] tmp = new byte[length];
            MemoryUtil.copyMemory(null, this.addr(index), tmp, MemoryUtil.BYTE_ARRAY_BASE_OFFSET, length);
            out.write(tmp);
        }
    }

    @Override
    public void close() {
        this.referenceManager.release();
    }

    public @UnknownKeyFor @NonNull @Initialized long getPossibleMemoryConsumed() {
        return this.referenceManager.getSize();
    }

    public @UnknownKeyFor @NonNull @Initialized long getActualMemoryConsumed() {
        return this.referenceManager.getAccountedSize();
    }

    public @UnknownKeyFor @NonNull @Initialized String toHexString(@UnknownKeyFor @NonNull @Initialized long start, @UnknownKeyFor @NonNull @Initialized int length) {
        long roundedStart = start / 10L * 10L;
        StringBuilder sb = new StringBuilder("buffer byte dump\n");
        long index = roundedStart;
        for (long nLogged = 0L; nLogged < (long)length; nLogged += 10L) {
            sb.append(String.format(" [%05d-%05d]", index, index + 10L - 1L));
            for (int i = 0; i < 10; ++i) {
                try {
                    byte b = this.getByte(index++);
                    sb.append(String.format(" 0x%02x", b));
                    continue;
                }
                catch (IndexOutOfBoundsException ioob) {
                    sb.append(" <ioob>");
                }
            }
            sb.append('\n');
        }
        return sb.toString();
    }

    public @UnknownKeyFor @NonNull @Initialized long getId() {
        return this.id;
    }

    @VisibleForTesting
    public void print(@UnknownKeyFor @NonNull @Initialized StringBuilder sb, @UnknownKeyFor @NonNull @Initialized int indent, @UnknownKeyFor @NonNull @Initialized BaseAllocator.Verbosity verbosity) {
        CommonUtil.indent(sb, indent).append(this.toString());
        if (this.historicalLog != null && verbosity.includeHistoricalLog) {
            sb.append("\n");
            this.historicalLog.buildHistory(sb, indent + 1, verbosity.includeStackTraces);
        }
    }

    public void print(@UnknownKeyFor @NonNull @Initialized StringBuilder sb, @UnknownKeyFor @NonNull @Initialized int indent) {
        this.print(sb, indent, BaseAllocator.Verbosity.LOG_WITH_STACKTRACE);
    }

    public @UnknownKeyFor @NonNull @Initialized long readerIndex() {
        return this.readerIndex;
    }

    public @UnknownKeyFor @NonNull @Initialized long writerIndex() {
        return this.writerIndex;
    }

    public @UnknownKeyFor @NonNull @Initialized ArrowBuf readerIndex(@UnknownKeyFor @NonNull @Initialized long readerIndex) {
        this.readerIndex = readerIndex;
        return this;
    }

    public @UnknownKeyFor @NonNull @Initialized ArrowBuf writerIndex(@UnknownKeyFor @NonNull @Initialized long writerIndex) {
        this.writerIndex = writerIndex;
        return this;
    }

    public @UnknownKeyFor @NonNull @Initialized ArrowBuf setZero(@UnknownKeyFor @NonNull @Initialized long index, @UnknownKeyFor @NonNull @Initialized long length) {
        if (length != 0L) {
            this.checkIndex(index, length);
            MemoryUtil.UNSAFE.setMemory(this.addr + index, length, (byte)0);
        }
        return this;
    }

    @Deprecated
    public @UnknownKeyFor @NonNull @Initialized ArrowBuf setOne(@UnknownKeyFor @NonNull @Initialized int index, @UnknownKeyFor @NonNull @Initialized int length) {
        if (length != 0) {
            this.checkIndex(index, length);
            MemoryUtil.UNSAFE.setMemory(this.addr + (long)index, length, (byte)-1);
        }
        return this;
    }

    public @UnknownKeyFor @NonNull @Initialized ArrowBuf setOne(@UnknownKeyFor @NonNull @Initialized long index, @UnknownKeyFor @NonNull @Initialized long length) {
        if (length != 0L) {
            this.checkIndex(index, length);
            MemoryUtil.UNSAFE.setMemory(this.addr + index, length, (byte)-1);
        }
        return this;
    }

    public @UnknownKeyFor @NonNull @Initialized ArrowBuf reallocIfNeeded(@UnknownKeyFor @NonNull @Initialized long size) {
        Preconditions.checkArgument(size >= 0L, "reallocation size must be non-negative");
        if (this.capacity() >= size) {
            return this;
        }
        if (this.bufferManager != null) {
            return this.bufferManager.replace(this, size);
        }
        throw new UnsupportedOperationException("Realloc is only available in the context of operator's UDFs");
    }

    public @UnknownKeyFor @NonNull @Initialized ArrowBuf clear() {
        this.writerIndex = 0L;
        this.readerIndex = 0L;
        return this;
    }
}

