/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.ast.convert.plannerQuery;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.neo4j.cypher.internal.ast.AliasedReturnItem;
import org.neo4j.cypher.internal.ast.AscSortItem;
import org.neo4j.cypher.internal.ast.Clause;
import org.neo4j.cypher.internal.ast.CommandClause;
import org.neo4j.cypher.internal.ast.CreateOrInsert;
import org.neo4j.cypher.internal.ast.Delete;
import org.neo4j.cypher.internal.ast.DescSortItem;
import org.neo4j.cypher.internal.ast.Finish;
import org.neo4j.cypher.internal.ast.Foreach;
import org.neo4j.cypher.internal.ast.ImportingWithSubqueryCall;
import org.neo4j.cypher.internal.ast.InputDataStream;
import org.neo4j.cypher.internal.ast.LoadCSV;
import org.neo4j.cypher.internal.ast.Match;
import org.neo4j.cypher.internal.ast.Merge;
import org.neo4j.cypher.internal.ast.MergeAction;
import org.neo4j.cypher.internal.ast.OnCreate;
import org.neo4j.cypher.internal.ast.OnMatch;
import org.neo4j.cypher.internal.ast.OrderBy;
import org.neo4j.cypher.internal.ast.Query;
import org.neo4j.cypher.internal.ast.Remove;
import org.neo4j.cypher.internal.ast.RemoveDynamicPropertyItem;
import org.neo4j.cypher.internal.ast.RemoveItem;
import org.neo4j.cypher.internal.ast.RemoveLabelItem;
import org.neo4j.cypher.internal.ast.RemovePropertyItem;
import org.neo4j.cypher.internal.ast.Return;
import org.neo4j.cypher.internal.ast.ReturnItem;
import org.neo4j.cypher.internal.ast.ReturnItems;
import org.neo4j.cypher.internal.ast.ScopeClauseSubqueryCall;
import org.neo4j.cypher.internal.ast.SetClause;
import org.neo4j.cypher.internal.ast.SetDynamicPropertyItem;
import org.neo4j.cypher.internal.ast.SetExactPropertiesFromMapItem;
import org.neo4j.cypher.internal.ast.SetIncludingPropertiesFromMapItem;
import org.neo4j.cypher.internal.ast.SetItem;
import org.neo4j.cypher.internal.ast.SetLabelItem;
import org.neo4j.cypher.internal.ast.SetPropertyItem;
import org.neo4j.cypher.internal.ast.SetPropertyItems;
import org.neo4j.cypher.internal.ast.SortItem;
import org.neo4j.cypher.internal.ast.SubqueryCall;
import org.neo4j.cypher.internal.ast.UnresolvedCall;
import org.neo4j.cypher.internal.ast.Unwind;
import org.neo4j.cypher.internal.ast.UseGraph;
import org.neo4j.cypher.internal.ast.Where;
import org.neo4j.cypher.internal.ast.With;
import org.neo4j.cypher.internal.ast.Yield;
import org.neo4j.cypher.internal.ast.semantics.SemanticTable;
import org.neo4j.cypher.internal.compiler.ast.convert.plannerQuery.ClauseConverters;
import org.neo4j.cypher.internal.compiler.ast.convert.plannerQuery.ClauseConverters$;
import org.neo4j.cypher.internal.compiler.ast.convert.plannerQuery.PlannerQueryBuilder;
import org.neo4j.cypher.internal.compiler.ast.convert.plannerQuery.StatementConverters$;
import org.neo4j.cypher.internal.compiler.helpers.AggregationHelper$;
import org.neo4j.cypher.internal.compiler.planner.ProcedureCallProjection;
import org.neo4j.cypher.internal.expressions.ContainerIndex;
import org.neo4j.cypher.internal.expressions.Expression;
import org.neo4j.cypher.internal.expressions.FunctionInvocation;
import org.neo4j.cypher.internal.expressions.HasLabels;
import org.neo4j.cypher.internal.expressions.In;
import org.neo4j.cypher.internal.expressions.IsAggregate$;
import org.neo4j.cypher.internal.expressions.LabelName;
import org.neo4j.cypher.internal.expressions.ListLiteral;
import org.neo4j.cypher.internal.expressions.LogicalProperty;
import org.neo4j.cypher.internal.expressions.LogicalProperty$;
import org.neo4j.cypher.internal.expressions.LogicalVariable;
import org.neo4j.cypher.internal.expressions.MapExpression;
import org.neo4j.cypher.internal.expressions.NodePattern;
import org.neo4j.cypher.internal.expressions.NonPrefixedPatternPart;
import org.neo4j.cypher.internal.expressions.Null;
import org.neo4j.cypher.internal.expressions.PathPatternPart;
import org.neo4j.cypher.internal.expressions.PatternElement;
import org.neo4j.cypher.internal.expressions.PatternElement$;
import org.neo4j.cypher.internal.expressions.PatternPart;
import org.neo4j.cypher.internal.expressions.PatternPartWithSelector;
import org.neo4j.cypher.internal.expressions.Property;
import org.neo4j.cypher.internal.expressions.PropertyKeyName;
import org.neo4j.cypher.internal.expressions.RelTypeName;
import org.neo4j.cypher.internal.expressions.RelationshipChain;
import org.neo4j.cypher.internal.expressions.RelationshipPattern;
import org.neo4j.cypher.internal.expressions.SemanticDirection;
import org.neo4j.cypher.internal.expressions.SimplePattern;
import org.neo4j.cypher.internal.expressions.Variable;
import org.neo4j.cypher.internal.frontend.phases.ResolvedCall;
import org.neo4j.cypher.internal.ir.AggregatingQueryProjection;
import org.neo4j.cypher.internal.ir.AggregatingQueryProjection$;
import org.neo4j.cypher.internal.ir.CSVFormat;
import org.neo4j.cypher.internal.ir.CommandProjection;
import org.neo4j.cypher.internal.ir.CreateNode;
import org.neo4j.cypher.internal.ir.CreatePattern;
import org.neo4j.cypher.internal.ir.CreateRelationship;
import org.neo4j.cypher.internal.ir.DeleteExpression;
import org.neo4j.cypher.internal.ir.DistinctQueryProjection;
import org.neo4j.cypher.internal.ir.DistinctQueryProjection$;
import org.neo4j.cypher.internal.ir.ForeachPattern;
import org.neo4j.cypher.internal.ir.HasHeaders$;
import org.neo4j.cypher.internal.ir.LoadCSVProjection;
import org.neo4j.cypher.internal.ir.MergeNodePattern;
import org.neo4j.cypher.internal.ir.MergeRelationshipPattern;
import org.neo4j.cypher.internal.ir.MutatingPattern;
import org.neo4j.cypher.internal.ir.NoHeaders$;
import org.neo4j.cypher.internal.ir.NodeConnection;
import org.neo4j.cypher.internal.ir.PassthroughAllHorizon;
import org.neo4j.cypher.internal.ir.PathPatterns$;
import org.neo4j.cypher.internal.ir.PatternLength;
import org.neo4j.cypher.internal.ir.PatternRelationship;
import org.neo4j.cypher.internal.ir.PlannerQuery;
import org.neo4j.cypher.internal.ir.QueryGraph;
import org.neo4j.cypher.internal.ir.QueryGraph$;
import org.neo4j.cypher.internal.ir.QueryHorizon;
import org.neo4j.cypher.internal.ir.QueryPagination;
import org.neo4j.cypher.internal.ir.QueryPagination$;
import org.neo4j.cypher.internal.ir.QueryProjection;
import org.neo4j.cypher.internal.ir.QueryProjection$;
import org.neo4j.cypher.internal.ir.RegularQueryProjection;
import org.neo4j.cypher.internal.ir.RegularQueryProjection$;
import org.neo4j.cypher.internal.ir.RegularSinglePlannerQuery;
import org.neo4j.cypher.internal.ir.RegularSinglePlannerQuery$;
import org.neo4j.cypher.internal.ir.RemoveLabelPattern;
import org.neo4j.cypher.internal.ir.Selections;
import org.neo4j.cypher.internal.ir.Selections$;
import org.neo4j.cypher.internal.ir.SetDynamicPropertyPattern;
import org.neo4j.cypher.internal.ir.SetLabelPattern;
import org.neo4j.cypher.internal.ir.SetMutatingPattern;
import org.neo4j.cypher.internal.ir.SetNodePropertiesFromMapPattern;
import org.neo4j.cypher.internal.ir.SetNodePropertiesPattern;
import org.neo4j.cypher.internal.ir.SetNodePropertyPattern;
import org.neo4j.cypher.internal.ir.SetPropertiesFromMapPattern;
import org.neo4j.cypher.internal.ir.SetPropertiesPattern;
import org.neo4j.cypher.internal.ir.SetPropertyPattern;
import org.neo4j.cypher.internal.ir.SetRelationshipPropertiesFromMapPattern;
import org.neo4j.cypher.internal.ir.SetRelationshipPropertiesPattern;
import org.neo4j.cypher.internal.ir.SetRelationshipPropertyPattern;
import org.neo4j.cypher.internal.ir.SimplePatternLength$;
import org.neo4j.cypher.internal.ir.SinglePlannerQuery;
import org.neo4j.cypher.internal.ir.SinglePlannerQuery$;
import org.neo4j.cypher.internal.ir.UnwindProjection;
import org.neo4j.cypher.internal.ir.converters.PatternConverters;
import org.neo4j.cypher.internal.ir.helpers.ExpressionConverters;
import org.neo4j.cypher.internal.ir.helpers.ExpressionConverters$;
import org.neo4j.cypher.internal.ir.ordering.ColumnOrder;
import org.neo4j.cypher.internal.ir.ordering.InterestingOrder;
import org.neo4j.cypher.internal.ir.ordering.InterestingOrderCandidate;
import org.neo4j.cypher.internal.ir.ordering.RequiredOrderCandidate;
import org.neo4j.cypher.internal.label_expressions.LabelExpression;
import org.neo4j.cypher.internal.label_expressions.LabelExpressionLeafName;
import org.neo4j.cypher.internal.util.AnonymousVariableNameGenerator;
import org.neo4j.cypher.internal.util.CancellationChecker;
import org.neo4j.cypher.internal.util.Foldable;
import org.neo4j.cypher.internal.util.symbols.CypherType;
import org.neo4j.exceptions.InternalException;
import org.neo4j.exceptions.SyntaxException;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.IterableFactory;
import scala.collection.IterableFactory$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.collection.immutable.SetOps;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

public final class ClauseConverters$ {
    public static final ClauseConverters$ MODULE$ = new ClauseConverters$();

    public PlannerQueryBuilder addToLogicalPlanInput(PlannerQueryBuilder acc, Clause clause, Option<Clause> nextClause, AnonymousVariableNameGenerator anonymousVariableNameGenerator, CancellationChecker cancellationChecker, QueryProjection.Position position) {
        Clause clause2 = clause;
        if (clause2 instanceof Finish) {
            return acc;
        }
        if (clause2 instanceof Return) {
            Return return_ = (Return)clause2;
            return this.addReturnToLogicalPlanInput(acc, return_, position);
        }
        if (clause2 instanceof Match) {
            Match match = (Match)clause2;
            return this.addMatchToLogicalPlanInput(acc, match, anonymousVariableNameGenerator);
        }
        if (clause2 instanceof With) {
            With with = (With)clause2;
            return this.addWithToLogicalPlanInput(acc, with, nextClause);
        }
        if (clause2 instanceof Unwind) {
            Unwind unwind = (Unwind)clause2;
            return this.addUnwindToLogicalPlanInput(acc, unwind);
        }
        if (clause2 instanceof ResolvedCall) {
            ResolvedCall resolvedCall = (ResolvedCall)clause2;
            return this.addCallToLogicalPlanInput(acc, resolvedCall);
        }
        if (clause2 instanceof CreateOrInsert) {
            CreateOrInsert createOrInsert = (CreateOrInsert)clause2;
            return this.addCreateToLogicalPlanInput(acc, createOrInsert);
        }
        if (clause2 instanceof SetClause) {
            SetClause setClause = (SetClause)clause2;
            return this.addSetClauseToLogicalPlanInput(acc, setClause);
        }
        if (clause2 instanceof Delete) {
            Delete delete = (Delete)clause2;
            return this.addDeleteToLogicalPlanInput(acc, delete);
        }
        if (clause2 instanceof Remove) {
            Remove remove = (Remove)clause2;
            return this.addRemoveToLogicalPlanInput(acc, remove);
        }
        if (clause2 instanceof Merge) {
            Merge merge = (Merge)clause2;
            return this.addMergeToLogicalPlanInput(acc, merge);
        }
        if (clause2 instanceof LoadCSV) {
            LoadCSV loadCSV = (LoadCSV)clause2;
            return this.addLoadCSVToLogicalPlanInput(acc, loadCSV);
        }
        if (clause2 instanceof Foreach) {
            Foreach foreach = (Foreach)clause2;
            return this.addForeachToLogicalPlanInput(acc, foreach, anonymousVariableNameGenerator, cancellationChecker);
        }
        if (clause2 instanceof InputDataStream) {
            InputDataStream inputDataStream = (InputDataStream)clause2;
            return this.addInputDataStreamToLogicalPlanInput(acc, inputDataStream);
        }
        if (clause2 instanceof SubqueryCall) {
            SubqueryCall subqueryCall = (SubqueryCall)clause2;
            return this.addCallSubqueryToLogicalPlanInput(acc, subqueryCall, anonymousVariableNameGenerator, cancellationChecker);
        }
        if (clause2 instanceof CommandClause) {
            CommandClause commandClause = (CommandClause)clause2;
            return this.addCommandClauseToLogicalPlanInput(acc, commandClause);
        }
        if (clause2 instanceof Yield) {
            Yield yield = (Yield)clause2;
            return this.addYieldToLogicalPlanInput(acc, yield);
        }
        if (clause2 instanceof UseGraph) {
            return acc;
        }
        if (clause2 instanceof UnresolvedCall) {
            UnresolvedCall unresolvedCall = (UnresolvedCall)clause2;
            throw new IllegalArgumentException(unresolvedCall + " is not expected here");
        }
        throw new InternalException("Received an AST-clause that has no representation the QG: " + clause2);
    }

    private PlannerQueryBuilder addLoadCSVToLogicalPlanInput(PlannerQueryBuilder acc, LoadCSV clause) {
        return acc.withHorizon((QueryHorizon)new LoadCSVProjection((LogicalVariable)clause.variable(), clause.urlString(), (CSVFormat)(clause.withHeaders() ? HasHeaders$.MODULE$ : NoHeaders$.MODULE$), clause.fieldTerminator())).withTail((SinglePlannerQuery)SinglePlannerQuery$.MODULE$.empty());
    }

    private PlannerQueryBuilder addInputDataStreamToLogicalPlanInput(PlannerQueryBuilder acc, InputDataStream clause) {
        return acc.withQueryInput((Seq<Variable>)clause.variables());
    }

    private Selections asSelections(Option<Where> optWhere) {
        return Selections$.MODULE$.apply((scala.collection.immutable.Set)optWhere.map((Function1 & Serializable)x$1 -> ExpressionConverters.PredicateConverter$.MODULE$.asPredicates$extension(ExpressionConverters$.MODULE$.PredicateConverter(x$1.expression()))).getOrElse((Function0 & Serializable)() -> Predef$.MODULE$.Set().empty()));
    }

    private QueryProjection asQueryProjection(boolean distinct2, Seq<AliasedReturnItem> items, QueryProjection.Position position) {
        Seq seq;
        Seq groupingKeys;
        block7: {
            Tuple2 tuple2;
            block6: {
                tuple2 = items.partition((Function1 & Serializable)item -> BoxesRunTime.boxToBoolean((boolean)IsAggregate$.MODULE$.apply(item.expression())));
                if (tuple2 == null) break block6;
                Seq aggregatingItems = (Seq)tuple2._1();
                groupingKeys = (Seq)tuple2._2();
                if (aggregatingItems == null) break block6;
                seq = aggregatingItems;
                if (groupingKeys != null) break block7;
            }
            throw new MatchError((Object)tuple2);
        }
        Seq seq2 = groupingKeys;
        Tuple2 tuple2 = new Tuple2((Object)seq, (Object)seq2);
        Seq aggregatingItems = (Seq)tuple2._1();
        Seq groupingKeys2 = (Seq)tuple2._2();
        Map projectionMap = ClauseConverters$.turnIntoMap$1(groupingKeys2);
        Map aggregationsMap = ClauseConverters$.turnIntoMap$1(aggregatingItems);
        if (projectionMap.values().exists((Function1 & Serializable)expr -> BoxesRunTime.boxToBoolean((boolean)ClauseConverters$.MODULE$.containsAggregateOutsideOfAggregatingHorizon(expr)))) {
            throw new InternalException("Grouping keys contains aggregation. AST has not been rewritten?");
        }
        if (aggregationsMap.nonEmpty()) {
            Map x$1 = projectionMap;
            Map x$2 = aggregationsMap;
            QueryProjection.Position x$3 = position;
            QueryPagination x$4 = AggregatingQueryProjection$.MODULE$.apply$default$3();
            Selections x$5 = AggregatingQueryProjection$.MODULE$.apply$default$4();
            return new AggregatingQueryProjection(x$1, x$2, x$4, x$5, x$3);
        }
        if (distinct2) {
            Map x$6 = projectionMap;
            QueryProjection.Position x$7 = position;
            QueryPagination x$8 = DistinctQueryProjection$.MODULE$.apply$default$2();
            Selections x$9 = DistinctQueryProjection$.MODULE$.apply$default$3();
            return new DistinctQueryProjection(x$6, x$8, x$9, x$7);
        }
        Map x$10 = projectionMap;
        QueryProjection.Position x$11 = position;
        QueryPagination x$12 = RegularQueryProjection$.MODULE$.apply$default$2();
        Selections x$13 = RegularQueryProjection$.MODULE$.apply$default$3();
        return new RegularQueryProjection(x$10, x$12, x$13, x$11);
    }

    private PlannerQueryBuilder addReturnToLogicalPlanInput(PlannerQueryBuilder acc, Return clause, QueryProjection.Position position) {
        Return return_ = clause;
        if (return_ != null) {
            boolean distinct2 = return_.distinct();
            ReturnItems returnItems = return_.returnItems();
            Option optOrderBy = return_.orderBy();
            Option skip = return_.skip();
            Option limit = return_.limit();
            if (returnItems != null) {
                boolean star = returnItems.includeExisting();
                Seq items = returnItems.items();
                if (!star) {
                    QueryPagination queryPagination = new QueryPagination(QueryPagination$.MODULE$.apply$default$1(), QueryPagination$.MODULE$.apply$default$2()).withSkip(skip).withLimit(limit);
                    QueryProjection projection2 = this.asQueryProjection(distinct2, (Seq<AliasedReturnItem>)items, position).withPagination(queryPagination);
                    InterestingOrder requiredOrder = this.findRequiredOrder((QueryHorizon)projection2, (Option<OrderBy>)optOrderBy);
                    return acc.withHorizon((QueryHorizon)projection2).withInterestingOrder(requiredOrder).withPropagatedTailInterestingOrder();
                }
            }
        }
        throw new InternalException("AST needs to be rewritten before it can be used for planning. Got: " + clause);
    }

    private InterestingOrder findRequiredOrder(QueryHorizon horizon, Option<OrderBy> optOrderBy) {
        Seq interestingOrderCandidates;
        RequiredOrderCandidate requiredOrderCandidate;
        block10: {
            Tuple2 tuple2;
            block9: {
                Seq sortItems = optOrderBy.isDefined() ? ((OrderBy)optOrderBy.get()).sortItems() : (Seq)Seq$.MODULE$.empty();
                QueryHorizon queryHorizon = horizon;
                if (queryHorizon instanceof RegularQueryProjection) {
                    RegularQueryProjection regularQueryProjection = (RegularQueryProjection)queryHorizon;
                    Map projections = regularQueryProjection.projections();
                    RequiredOrderCandidate requiredOrderCandidate2 = this.extractColumnOrderFromOrderBy((Seq<SortItem>)sortItems, (Map<LogicalVariable, Expression>)projections);
                    v0 = new Tuple2((Object)requiredOrderCandidate2, (Object)Seq$.MODULE$.empty());
                } else if (queryHorizon instanceof AggregatingQueryProjection) {
                    AggregatingQueryProjection aggregatingQueryProjection = (AggregatingQueryProjection)queryHorizon;
                    Map groupingExpressions = aggregatingQueryProjection.groupingExpressions();
                    Map aggregationExpressions = aggregatingQueryProjection.aggregationExpressions();
                    RequiredOrderCandidate requiredOrderCandidate3 = this.extractColumnOrderFromOrderBy((Seq<SortItem>)sortItems, (Map<LogicalVariable, Expression>)groupingExpressions);
                    Seq interestingCandidates = (Seq)this.interestingOrderCandidatesForGroupingExpressions((Map<LogicalVariable, Expression>)groupingExpressions).$plus$plus(this.interestingOrderCandidateForAggregations((Map<LogicalVariable, Expression>)groupingExpressions, (Map<LogicalVariable, Expression>)aggregationExpressions));
                    v0 = new Tuple2((Object)requiredOrderCandidate3, (Object)interestingCandidates);
                } else if (queryHorizon instanceof DistinctQueryProjection) {
                    DistinctQueryProjection distinctQueryProjection = (DistinctQueryProjection)queryHorizon;
                    Map groupingExpressions = distinctQueryProjection.groupingExpressions();
                    RequiredOrderCandidate requiredOrderCandidate4 = this.extractColumnOrderFromOrderBy((Seq<SortItem>)sortItems, (Map<LogicalVariable, Expression>)groupingExpressions);
                    Seq<InterestingOrderCandidate> interestingCandidates = this.interestingOrderCandidatesForGroupingExpressions((Map<LogicalVariable, Expression>)groupingExpressions);
                    v0 = new Tuple2((Object)requiredOrderCandidate4, interestingCandidates);
                } else {
                    v0 = tuple2 = new Tuple2((Object)new RequiredOrderCandidate((Seq)Seq$.MODULE$.empty()), (Object)Seq$.MODULE$.empty());
                }
                if (tuple2 == null) break block9;
                requiredOrderCandidate = (RequiredOrderCandidate)tuple2._1();
                interestingOrderCandidates = (Seq)tuple2._2();
                if (interestingOrderCandidates != null) break block10;
            }
            throw new MatchError((Object)tuple2);
        }
        Seq seq = interestingOrderCandidates;
        Tuple2 tuple2 = new Tuple2((Object)requiredOrderCandidate, (Object)seq);
        RequiredOrderCandidate requiredOrderCandidate5 = (RequiredOrderCandidate)tuple2._1();
        Seq interestingOrderCandidates2 = (Seq)tuple2._2();
        return new InterestingOrder(requiredOrderCandidate5, interestingOrderCandidates2);
    }

    private Seq<InterestingOrderCandidate> interestingOrderCandidateForAggregations(Map<LogicalVariable, Expression> groupingExpressions, Map<LogicalVariable, Expression> aggregationExpressions) {
        if (AggregationHelper$.MODULE$.isOnlyMinOrMaxAggregation(groupingExpressions, aggregationExpressions)) {
            Expression value = (Expression)aggregationExpressions.apply(aggregationExpressions.keys().head());
            Seq columns = (Seq)AggregationHelper$.MODULE$.checkMinOrMax(value, (Function1 & Serializable)e -> new .colon.colon((Object)new ColumnOrder.Asc(e, ColumnOrder.Asc$.MODULE$.apply$default$2()), (List)Nil$.MODULE$), (Function1 & Serializable)e -> new .colon.colon((Object)new ColumnOrder.Desc(e, ColumnOrder.Desc$.MODULE$.apply$default$2()), (List)Nil$.MODULE$), Seq$.MODULE$.empty());
            if (columns.nonEmpty()) {
                return new .colon.colon((Object)new InterestingOrderCandidate(columns), (List)Nil$.MODULE$);
            }
            return (Seq)Seq$.MODULE$.empty();
        }
        return ((IterableOnceOps)aggregationExpressions.values().flatMap((Function1 & Serializable)x0$1 -> {
            FunctionInvocation functionInvocation;
            Expression expression = x0$1;
            if (expression instanceof FunctionInvocation && AggregationHelper$.MODULE$.hasInterestingOrder(functionInvocation = (FunctionInvocation)expression)) {
                .colon.colon colon2;
                Expression expression2 = (Expression)functionInvocation.args().apply(0);
                if (expression2 instanceof Property) {
                    Property property = (Property)expression2;
                    colon2 = new .colon.colon((Object)new .colon.colon((Object)new ColumnOrder.Asc((Expression)property, Predef$.MODULE$.Map().empty()), (List)Nil$.MODULE$), (List)new .colon.colon((Object)new .colon.colon((Object)new ColumnOrder.Desc((Expression)property, Predef$.MODULE$.Map().empty()), (List)Nil$.MODULE$), (List)Nil$.MODULE$));
                } else if (expression2 instanceof Variable) {
                    Variable variable = (Variable)expression2;
                    colon2 = new .colon.colon((Object)new .colon.colon((Object)new ColumnOrder.Asc((Expression)variable, Predef$.MODULE$.Map().empty()), (List)Nil$.MODULE$), (List)new .colon.colon((Object)new .colon.colon((Object)new ColumnOrder.Desc((Expression)variable, Predef$.MODULE$.Map().empty()), (List)Nil$.MODULE$), (List)Nil$.MODULE$));
                } else {
                    colon2 = (Seq)Seq$.MODULE$.empty();
                }
                .colon.colon orders = colon2;
                return (Seq)orders.map((Function1 & Serializable)x$4 -> new InterestingOrderCandidate(x$4));
            }
            return (Seq)Seq$.MODULE$.empty();
        })).toSeq();
    }

    private Seq<InterestingOrderCandidate> interestingOrderCandidatesForGroupingExpressions(Map<LogicalVariable, Expression> groupingExpressions) {
        Seq propsAndVars = ((IterableOnceOps)groupingExpressions.values().collect((PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Expression, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof Property) {
                    Property property = (Property)A1;
                    return (B1)property;
                }
                if (A1 instanceof Variable) {
                    Variable variable = (Variable)A1;
                    return (B1)variable;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Expression x1) {
                Expression expression = x1;
                if (expression instanceof Property) {
                    return true;
                }
                return expression instanceof Variable;
            }
        })).toSeq();
        .colon.colon orderings = new .colon.colon((Function1 & Serializable)x$5 -> new ColumnOrder.Asc(x$5, Predef$.MODULE$.Map().empty()), (List)new .colon.colon((Function1 & Serializable)x$6 -> new ColumnOrder.Desc(x$6, Predef$.MODULE$.Map().empty()), (List)Nil$.MODULE$));
        return (Seq)propsAndVars.flatMap(arg_0 -> ClauseConverters$.$anonfun$interestingOrderCandidatesForGroupingExpressions$3((Seq)orderings, arg_0));
    }

    private RequiredOrderCandidate extractColumnOrderFromOrderBy(Seq<SortItem> sortItems, Map<LogicalVariable, Expression> projections) {
        Seq columns = (Seq)sortItems.map((Function1 & Serializable)x0$1 -> {
            Expression v;
            Expression v2;
            boolean bl = false;
            AscSortItem ascSortItem = null;
            boolean bl2 = false;
            DescSortItem descSortItem = null;
            SortItem sortItem = x0$1;
            if (sortItem instanceof AscSortItem) {
                Property property;
                Expression v3;
                bl = true;
                ascSortItem = (AscSortItem)sortItem;
                Expression e = ascSortItem.expression();
                if (e instanceof Property && (v3 = (property = (Property)e).map()) instanceof LogicalVariable) {
                    LogicalVariable logicalVariable = (LogicalVariable)v3;
                    Option option = projections.get((Object)logicalVariable);
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        Expression expression = (Expression)some.value();
                        return new ColumnOrder.Asc((Expression)property, (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)logicalVariable), (Object)expression)})));
                    }
                    if (None$.MODULE$.equals(option)) {
                        return new ColumnOrder.Asc((Expression)property, ColumnOrder.Asc$.MODULE$.apply$default$2());
                    }
                    throw new MatchError((Object)option);
                }
            }
            if (sortItem instanceof DescSortItem) {
                Property property;
                Expression v4;
                bl2 = true;
                descSortItem = (DescSortItem)sortItem;
                Expression e = descSortItem.expression();
                if (e instanceof Property && (v4 = (property = (Property)e).map()) instanceof LogicalVariable) {
                    LogicalVariable logicalVariable = (LogicalVariable)v4;
                    Option option = projections.get((Object)logicalVariable);
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        Expression expression = (Expression)some.value();
                        return new ColumnOrder.Desc((Expression)property, (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)logicalVariable), (Object)expression)})));
                    }
                    if (None$.MODULE$.equals(option)) {
                        return new ColumnOrder.Desc((Expression)property, ColumnOrder.Desc$.MODULE$.apply$default$2());
                    }
                    throw new MatchError((Object)option);
                }
            }
            if (bl && (v2 = ascSortItem.expression()) instanceof LogicalVariable) {
                LogicalVariable logicalVariable = (LogicalVariable)v2;
                Option option = projections.get((Object)logicalVariable);
                if (option instanceof Some) {
                    Some some = (Some)option;
                    Expression expression = (Expression)some.value();
                    return new ColumnOrder.Asc((Expression)logicalVariable, (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)logicalVariable), (Object)expression)})));
                }
                if (None$.MODULE$.equals(option)) {
                    return new ColumnOrder.Asc((Expression)logicalVariable, ColumnOrder.Asc$.MODULE$.apply$default$2());
                }
                throw new MatchError((Object)option);
            }
            if (bl2 && (v = descSortItem.expression()) instanceof LogicalVariable) {
                LogicalVariable logicalVariable = (LogicalVariable)v;
                Option option = projections.get((Object)logicalVariable);
                if (option instanceof Some) {
                    Some some = (Some)option;
                    Expression expression = (Expression)some.value();
                    return new ColumnOrder.Desc((Expression)logicalVariable, (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)logicalVariable), (Object)expression)})));
                }
                if (None$.MODULE$.equals(option)) {
                    return new ColumnOrder.Desc((Expression)logicalVariable, ColumnOrder.Desc$.MODULE$.apply$default$2());
                }
                throw new MatchError((Object)option);
            }
            if (bl) {
                Expression expression = ascSortItem.expression();
                scala.collection.immutable.Set deps = expression.dependencies();
                Map orderProjections = (Map)projections.filter((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)deps.contains(p._1())));
                return new ColumnOrder.Asc(expression, orderProjections);
            }
            if (bl2) {
                Expression expression = descSortItem.expression();
                scala.collection.immutable.Set deps = expression.dependencies();
                Map orderProjections = (Map)projections.filter((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)deps.contains(p._1())));
                return new ColumnOrder.Desc(expression, orderProjections);
            }
            throw new MatchError((Object)sortItem);
        });
        return new RequiredOrderCandidate(columns);
    }

    private PlannerQueryBuilder addSetClauseToLogicalPlanInput(PlannerQueryBuilder acc, SetClause clause) {
        return (PlannerQueryBuilder)clause.items().foldLeft((Object)acc, (Function2 & Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                PlannerQueryBuilder builder = (PlannerQueryBuilder)tuple2._1();
                SetItem item = (SetItem)tuple2._2();
                return builder.amendQueryGraph((Function1<QueryGraph, QueryGraph>)(Function1 & Serializable)x$7 -> x$7.addMutatingPatterns((MutatingPattern)MODULE$.org$neo4j$cypher$internal$compiler$ast$convert$plannerQuery$ClauseConverters$$toSetPattern(acc.semanticTable(), item)));
            }
            throw new MatchError((Object)tuple2);
        });
    }

    private PlannerQueryBuilder addCreateToLogicalPlanInput(PlannerQueryBuilder builder, CreateOrInsert clause) {
        ArrayBuffer commands = new ArrayBuffer();
        Set seenPatternNodes = (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        seenPatternNodes.$plus$plus$eq(builder.lastQGNodesAndArguments());
        clause.pattern().patternParts().foreach((Function1 & Serializable)x0$1 -> {
            ClauseConverters$.$anonfun$addCreateToLogicalPlanInput$1(commands, seenPatternNodes, clause, x0$1);
            return BoxedUnit.UNIT;
        });
        return builder.amendQueryGraph((Function1<QueryGraph, QueryGraph>)(Function1 & Serializable)x$8 -> x$8.addMutatingPatterns((MutatingPattern)new CreatePattern(commands.toSeq())));
    }

    private scala.collection.immutable.Set<LabelName> getLabelNameSet(Option<LabelExpression> labelExpression) {
        LabelExpression l;
        LabelExpression w;
        LabelExpression d;
        LabelExpression c;
        LabelExpression n;
        LabelExpression labelExpression2;
        LabelExpression labelExpression3;
        boolean bl = false;
        Some some = null;
        Option<LabelExpression> option = labelExpression;
        if (None$.MODULE$.equals(option)) {
            return Predef$.MODULE$.Set().empty();
        }
        if (option instanceof Some) {
            LabelExpression.Leaf leaf;
            LabelExpressionLeafName labelName;
            bl = true;
            some = (Some)option;
            LabelExpression labelExpression4 = (LabelExpression)some.value();
            if (labelExpression4 instanceof LabelExpression.Leaf && (labelName = (leaf = (LabelExpression.Leaf)labelExpression4).name()) instanceof LabelName) {
                LabelName labelName2 = (LabelName)labelName;
                return (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LabelName[]{labelName2}));
            }
        }
        if (bl && (labelExpression3 = (LabelExpression)some.value()) instanceof LabelExpression.ColonConjunction) {
            LabelExpression.ColonConjunction colonConjunction = (LabelExpression.ColonConjunction)labelExpression3;
            LabelExpression lhs = colonConjunction.lhs();
            LabelExpression rhs = colonConjunction.rhs();
            return (scala.collection.immutable.Set)this.getLabelNameSet((Option<LabelExpression>)new Some((Object)lhs)).$plus$plus(this.getLabelNameSet((Option<LabelExpression>)new Some((Object)rhs)));
        }
        if (bl && (labelExpression2 = (LabelExpression)some.value()) instanceof LabelExpression.Conjunctions) {
            LabelExpression.Conjunctions conjunctions = (LabelExpression.Conjunctions)labelExpression2;
            Seq children = conjunctions.children();
            return ((IterableOnceOps)children.flatMap((Function1 & Serializable)child -> MODULE$.getLabelNameSet((Option<LabelExpression>)new Some(child)))).toSet();
        }
        if (bl && (n = (LabelExpression)some.value()) instanceof LabelExpression.Negation) {
            LabelExpression.Negation negation = (LabelExpression.Negation)n;
            throw ClauseConverters$.fail$1((LabelExpression)negation);
        }
        if (bl && (c = (LabelExpression)some.value()) instanceof LabelExpression.ColonDisjunction) {
            LabelExpression.ColonDisjunction colonDisjunction = (LabelExpression.ColonDisjunction)c;
            throw ClauseConverters$.fail$1((LabelExpression)colonDisjunction);
        }
        if (bl && (d = (LabelExpression)some.value()) instanceof LabelExpression.Disjunctions) {
            LabelExpression.Disjunctions disjunctions = (LabelExpression.Disjunctions)d;
            throw ClauseConverters$.fail$1((LabelExpression)disjunctions);
        }
        if (bl && (w = (LabelExpression)some.value()) instanceof LabelExpression.Wildcard) {
            LabelExpression.Wildcard wildcard = (LabelExpression.Wildcard)w;
            throw ClauseConverters$.fail$1((LabelExpression)wildcard);
        }
        if (bl && (l = (LabelExpression)some.value()) instanceof LabelExpression.Leaf) {
            LabelExpression.Leaf leaf = (LabelExpression.Leaf)l;
            throw ClauseConverters$.fail$1((LabelExpression)leaf);
        }
        throw new MatchError(option);
    }

    private ClauseConverters.CreateNodeCommand createNodeCommand(NodePattern pattern) {
        NodePattern nodePattern = pattern;
        if (nodePattern != null) {
            Option option = nodePattern.variable();
            Option labelExpression = nodePattern.labelExpression();
            Option props = nodePattern.properties();
            Option option2 = nodePattern.predicate();
            if (option instanceof Some) {
                Some some = (Some)option;
                LogicalVariable variable = (LogicalVariable)some.value();
                if (None$.MODULE$.equals(option2)) {
                    return new ClauseConverters.CreateNodeCommand(new CreateNode(variable, this.getLabelNameSet((Option<LabelExpression>)labelExpression), props), variable);
                }
            }
        }
        throw new InternalException("All nodes must be named at this instance");
    }

    private Seq<ClauseConverters.CreateEntityCommand> allCreatePatternsInOrderAndDeduped(RelationshipChain chain) {
        return (Seq)this.allCreatePatternsInOrderAndDeduped((PatternElement)chain, (Vector<ClauseConverters.CreateEntityCommand>)package$.MODULE$.Vector().empty(), (scala.collection.immutable.Set<LogicalVariable>)Predef$.MODULE$.Set().empty())._1();
    }

    private Tuple3<Vector<ClauseConverters.CreateEntityCommand>, scala.collection.immutable.Set<LogicalVariable>, LogicalVariable> allCreatePatternsInOrderAndDeduped(PatternElement element, Vector<ClauseConverters.CreateEntityCommand> acc, scala.collection.immutable.Set<LogicalVariable> seenNodes) {
        NodePattern nodePattern;
        Option option;
        PatternElement patternElement = element;
        if (patternElement instanceof NodePattern && (option = (nodePattern = (NodePattern)patternElement).variable()) instanceof Some) {
            Some some = (Some)option;
            LogicalVariable node = (LogicalVariable)some.value();
            return new Tuple3((Object)this.addNode$1(nodePattern, seenNodes, acc), (Object)seenNodes.$plus((Object)node), (Object)node);
        }
        if (patternElement instanceof RelationshipChain) {
            RelationshipChain relationshipChain = (RelationshipChain)patternElement;
            SimplePattern left = relationshipChain.element();
            RelationshipPattern relationshipPattern = relationshipChain.relationship();
            NodePattern rightNode = relationshipChain.rightNode();
            if (relationshipPattern != null) {
                Option option2 = relationshipPattern.variable();
                Option option3 = relationshipPattern.labelExpression();
                Option properties = relationshipPattern.properties();
                SemanticDirection direction = relationshipPattern.direction();
                if (option2 instanceof Some) {
                    LabelExpression.Leaf leaf;
                    LabelExpressionLeafName relType;
                    Some some;
                    LabelExpression labelExpression;
                    Some some2 = (Some)option2;
                    LogicalVariable relVar = (LogicalVariable)some2.value();
                    if (option3 instanceof Some && (labelExpression = (LabelExpression)(some = (Some)option3).value()) instanceof LabelExpression.Leaf && (relType = (leaf = (LabelExpression.Leaf)labelExpression).name()) instanceof RelTypeName) {
                        Option option4;
                        RelTypeName relTypeName = (RelTypeName)relType;
                        if (rightNode != null && (option4 = rightNode.variable()) instanceof Some) {
                            Some some3 = (Some)option4;
                            LogicalVariable rightVar = (LogicalVariable)some3.value();
                            Tuple3<Vector<ClauseConverters.CreateEntityCommand>, scala.collection.immutable.Set<LogicalVariable>, LogicalVariable> tuple3 = this.allCreatePatternsInOrderAndDeduped((PatternElement)left, acc, seenNodes);
                            if (tuple3 == null) {
                                throw new MatchError(tuple3);
                            }
                            Vector addLeft = (Vector)tuple3._1();
                            scala.collection.immutable.Set seenLeft = (scala.collection.immutable.Set)tuple3._2();
                            LogicalVariable leftNode = (LogicalVariable)tuple3._3();
                            Tuple3 tuple32 = new Tuple3((Object)addLeft, (Object)seenLeft, (Object)leftNode);
                            Vector addLeft2 = (Vector)tuple32._1();
                            scala.collection.immutable.Set seenLeft2 = (scala.collection.immutable.Set)tuple32._2();
                            LogicalVariable leftNode2 = (LogicalVariable)tuple32._3();
                            Tuple3<Vector<ClauseConverters.CreateEntityCommand>, scala.collection.immutable.Set<LogicalVariable>, LogicalVariable> tuple33 = this.allCreatePatternsInOrderAndDeduped((PatternElement)rightNode, (Vector<ClauseConverters.CreateEntityCommand>)addLeft2, (scala.collection.immutable.Set<LogicalVariable>)seenLeft2);
                            if (tuple33 == null) {
                                throw new MatchError(tuple33);
                            }
                            Vector addRight = (Vector)tuple33._1();
                            scala.collection.immutable.Set seenRight = (scala.collection.immutable.Set)tuple33._2();
                            Tuple2 tuple2 = new Tuple2((Object)addRight, (Object)seenRight);
                            Vector addRight2 = (Vector)tuple2._1();
                            scala.collection.immutable.Set seenRight2 = (scala.collection.immutable.Set)tuple2._2();
                            ClauseConverters.CreateRelCommand newR = new ClauseConverters.CreateRelCommand(new CreateRelationship(relVar, leftNode2, relTypeName, rightVar, direction, properties), relVar);
                            return new Tuple3(addRight2.$colon$plus((Object)newR), (Object)seenRight2, (Object)rightVar);
                        }
                    }
                }
            }
        }
        throw new IllegalArgumentException("The pattern element must be a NodePattern or a RelationshipChain. Got: " + patternElement);
    }

    private PlannerQueryBuilder addDeleteToLogicalPlanInput(PlannerQueryBuilder acc, Delete clause) {
        return acc.amendQueryGraph((Function1<QueryGraph, QueryGraph>)(Function1 & Serializable)x$11 -> x$11.addMutatingPatterns((Seq)clause.expressions().map((Function1 & Serializable)x$12 -> new DeleteExpression(x$12, clause.forced()))));
    }

    private Seq<AliasedReturnItem> asReturnItems(QueryGraph current, ReturnItems returnItems) {
        ReturnItems returnItems2 = returnItems;
        if (returnItems2 != null) {
            boolean star = returnItems2.includeExisting();
            Seq items = returnItems2.items();
            if (star) {
                return (Seq)QueryProjection$.MODULE$.forVariables(current.allCoveredIds()).$plus$plus((IterableOnce)items);
            }
        }
        if (returnItems2 != null) {
            Seq items = returnItems2.items();
            return items;
        }
        return (Seq)Seq$.MODULE$.empty();
    }

    private PlannerQueryBuilder addMatchToLogicalPlanInput(PlannerQueryBuilder acc, Match clause, AnonymousVariableNameGenerator anonymousVariableNameGenerator) {
        PatternConverters converter = new PatternConverters(anonymousVariableNameGenerator);
        List pathPatterns = converter.convertPattern(clause.pattern());
        PlannerQueryBuilder accWithMaybeHorizon = ClauseConverters$.hasPatternOverlapOnInteriorVars$1(acc, clause) || ClauseConverters$.isPotentiallyUnsolvable$1(pathPatterns, acc) ? acc.withHorizon((QueryHorizon)new PassthroughAllHorizon()).withTail((SinglePlannerQuery)new RegularSinglePlannerQuery(QueryGraph$.MODULE$.apply(QueryGraph$.MODULE$.apply$default$1(), QueryGraph$.MODULE$.apply$default$2(), QueryGraph$.MODULE$.apply$default$3(), QueryGraph$.MODULE$.apply$default$4(), QueryGraph$.MODULE$.apply$default$5(), QueryGraph$.MODULE$.apply$default$6(), QueryGraph$.MODULE$.apply$default$7(), QueryGraph$.MODULE$.apply$default$8(), QueryGraph$.MODULE$.apply$default$9(), QueryGraph$.MODULE$.apply$default$10()), RegularSinglePlannerQuery$.MODULE$.apply$default$2(), RegularSinglePlannerQuery$.MODULE$.apply$default$3(), RegularSinglePlannerQuery$.MODULE$.apply$default$4(), RegularSinglePlannerQuery$.MODULE$.apply$default$5())) : acc;
        Selections selections = this.asSelections((Option<Where>)clause.where());
        if (clause.optional()) {
            return accWithMaybeHorizon.amendQueryGraph((Function1<QueryGraph, QueryGraph>)(Function1 & Serializable)qg -> {
                Selections x$1 = selections;
                scala.collection.immutable.Set x$2 = clause.hints().toSet();
                scala.collection.immutable.Set x$3 = QueryGraph$.MODULE$.apply$default$1();
                scala.collection.immutable.Set x$4 = QueryGraph$.MODULE$.apply$default$2();
                scala.collection.immutable.Set x$5 = QueryGraph$.MODULE$.apply$default$3();
                scala.collection.immutable.Set x$6 = QueryGraph$.MODULE$.apply$default$4();
                IndexedSeq x$7 = QueryGraph$.MODULE$.apply$default$6();
                scala.collection.immutable.Set x$8 = QueryGraph$.MODULE$.apply$default$8();
                IndexedSeq x$9 = QueryGraph$.MODULE$.apply$default$9();
                scala.collection.immutable.Set x$10 = QueryGraph$.MODULE$.apply$default$10();
                return qg.addOptionalMatch(QueryGraph$.MODULE$.apply(x$3, x$4, x$5, x$6, x$1, x$7, x$2, x$8, x$9, x$10).addPathPatterns(pathPatterns));
            });
        }
        return accWithMaybeHorizon.amendQueryGraph((Function1<QueryGraph, QueryGraph>)(Function1 & Serializable)qg -> qg.addSelections(selections).addHints((IterableOnce)clause.hints()).addPathPatterns(pathPatterns));
    }

    private PlannerQueryBuilder addCallSubqueryToLogicalPlanInput(PlannerQueryBuilder acc, SubqueryCall clause, AnonymousVariableNameGenerator anonymousVariableNameGenerator, CancellationChecker cancellationChecker) {
        PlannerQuery plannerQuery;
        Query subquery = clause.innerQuery();
        SubqueryCall subqueryCall = clause;
        if (subqueryCall instanceof ScopeClauseSubqueryCall) {
            ScopeClauseSubqueryCall scopeClauseSubqueryCall = (ScopeClauseSubqueryCall)subqueryCall;
            Query x$1 = subquery;
            SemanticTable x$2 = acc.semanticTable();
            AnonymousVariableNameGenerator x$3 = anonymousVariableNameGenerator;
            CancellationChecker x$4 = cancellationChecker;
            QueryProjection.Position$.Intermediate$ x$5 = QueryProjection.Position$.Intermediate$.MODULE$;
            scala.collection.immutable.Set x$6 = scopeClauseSubqueryCall.importedVariables().toSet();
            plannerQuery = StatementConverters$.MODULE$.convertToNestedPlannerQuery(x$1, x$2, x$3, x$4, (scala.collection.immutable.Set<LogicalVariable>)x$6, (QueryProjection.Position)x$5);
        } else if (subqueryCall instanceof ImportingWithSubqueryCall) {
            Query x$7 = subquery;
            SemanticTable x$8 = acc.semanticTable();
            AnonymousVariableNameGenerator x$9 = anonymousVariableNameGenerator;
            CancellationChecker x$10 = cancellationChecker;
            QueryProjection.Position$.Intermediate$ x$11 = QueryProjection.Position$.Intermediate$.MODULE$;
            scala.collection.immutable.Set<LogicalVariable> x$12 = StatementConverters$.MODULE$.convertToNestedPlannerQuery$default$5();
            plannerQuery = StatementConverters$.MODULE$.convertToNestedPlannerQuery(x$7, x$8, x$9, x$10, x$12, (QueryProjection.Position)x$11);
        } else {
            throw new MatchError((Object)subqueryCall);
        }
        PlannerQuery callSubquery = plannerQuery;
        return acc.withCallSubquery(callSubquery, clause.isCorrelated(), subquery.isReturning(), (Option<SubqueryCall.InTransactionsParameters>)clause.inTransactionsParameters());
    }

    private PlannerQueryBuilder addCommandClauseToLogicalPlanInput(PlannerQueryBuilder acc, CommandClause clause) {
        return acc.withHorizon((QueryHorizon)new CommandProjection(clause)).withTail((SinglePlannerQuery)SinglePlannerQuery$.MODULE$.empty());
    }

    private PlannerQueryBuilder addYieldToLogicalPlanInput(PlannerQueryBuilder builder, Yield yield) {
        Selections selections = this.asSelections((Option<Where>)yield.where());
        Seq<AliasedReturnItem> returnItems = this.asReturnItems(builder.currentQueryGraph(), yield.returnItems());
        QueryPagination queryPagination = new QueryPagination(QueryPagination$.MODULE$.apply$default$1(), QueryPagination$.MODULE$.apply$default$2()).withLimit(yield.limit()).withSkip(yield.skip());
        QueryProjection queryProjection = this.asQueryProjection(false, returnItems, (QueryProjection.Position)QueryProjection.Position$.Intermediate$.MODULE$).withPagination(queryPagination).withSelection(selections);
        InterestingOrder requiredOrder = this.findRequiredOrder((QueryHorizon)queryProjection, (Option<OrderBy>)yield.orderBy());
        return builder.withHorizon((QueryHorizon)queryProjection).withInterestingOrder(requiredOrder).withTail((SinglePlannerQuery)new RegularSinglePlannerQuery(QueryGraph$.MODULE$.apply(QueryGraph$.MODULE$.apply$default$1(), QueryGraph$.MODULE$.apply$default$2(), QueryGraph$.MODULE$.apply$default$3(), QueryGraph$.MODULE$.apply$default$4(), QueryGraph$.MODULE$.apply$default$5(), QueryGraph$.MODULE$.apply$default$6(), QueryGraph$.MODULE$.apply$default$7(), QueryGraph$.MODULE$.apply$default$8(), QueryGraph$.MODULE$.apply$default$9(), QueryGraph$.MODULE$.apply$default$10()), RegularSinglePlannerQuery$.MODULE$.apply$default$2(), RegularSinglePlannerQuery$.MODULE$.apply$default$3(), RegularSinglePlannerQuery$.MODULE$.apply$default$4(), RegularSinglePlannerQuery$.MODULE$.apply$default$5()));
    }

    private Map<PropertyKeyName, Expression> toPropertyMap(Option<Expression> expr) {
        Some some;
        Expression expression;
        Option<Expression> option = expr;
        if (None$.MODULE$.equals(option)) {
            return Predef$.MODULE$.Map().empty();
        }
        if (option instanceof Some && (expression = (Expression)(some = (Some)option).value()) instanceof MapExpression) {
            MapExpression mapExpression = (MapExpression)expression;
            Seq items = mapExpression.items();
            return items.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        }
        throw new InternalException("Expected MapExpression, got " + option);
    }

    private Seq<Expression> toPropertySelection(LogicalVariable identifier, Map<PropertyKeyName, Expression> map2) {
        return ((IterableOnceOps)map2.map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                PropertyKeyName k = (PropertyKeyName)tuple2._1();
                Expression e = (Expression)tuple2._2();
                return new In((Expression)new Property((Expression)identifier, k, k.position()), (Expression)new ListLiteral((Seq)new .colon.colon((Object)e, (List)Nil$.MODULE$), e.position()), identifier.position());
            }
            throw new MatchError((Object)tuple2);
        })).toIndexedSeq();
    }

    public SetMutatingPattern org$neo4j$cypher$internal$compiler$ast$convert$plannerQuery$ClauseConverters$$toSetPattern(SemanticTable semanticTable, SetItem setItem) {
        boolean bl = false;
        SetPropertyItem setPropertyItem = null;
        boolean bl2 = false;
        SetPropertyItems setPropertyItems = null;
        boolean bl3 = false;
        SetExactPropertiesFromMapItem setExactPropertiesFromMapItem = null;
        boolean bl4 = false;
        SetIncludingPropertiesFromMapItem setIncludingPropertiesFromMapItem = null;
        SetItem setItem2 = setItem;
        if (setItem2 instanceof SetLabelItem) {
            SetLabelItem setLabelItem = (SetLabelItem)setItem2;
            Variable id = setLabelItem.variable();
            Seq labels = setLabelItem.labels();
            Seq dynamicLabels = setLabelItem.dynamicLabels();
            return new SetLabelPattern((LogicalVariable)id, labels, dynamicLabels);
        }
        if (setItem2 instanceof SetPropertyItem) {
            Some some;
            bl = true;
            setPropertyItem = (SetPropertyItem)setItem2;
            LogicalProperty logicalProperty = setPropertyItem.property();
            Expression expr = setPropertyItem.expression();
            if (logicalProperty != null && !(some = LogicalProperty$.MODULE$.unapply(logicalProperty)).isEmpty()) {
                Variable variable;
                Expression node = (Expression)((Tuple2)some.get())._1();
                PropertyKeyName propertyKey = (PropertyKeyName)((Tuple2)some.get())._2();
                if (node instanceof Variable && semanticTable.typeFor((Expression)(variable = (Variable)node)).is((CypherType)org.neo4j.cypher.internal.util.symbols.package$.MODULE$.CTNode())) {
                    return new SetNodePropertyPattern((LogicalVariable)variable, propertyKey, expr);
                }
            }
        }
        if (setItem2 instanceof SetPropertyItems) {
            Variable variable;
            bl2 = true;
            setPropertyItems = (SetPropertyItems)setItem2;
            Expression node = setPropertyItems.map();
            Seq items = setPropertyItems.items();
            if (node instanceof Variable && semanticTable.typeFor((Expression)(variable = (Variable)node)).is((CypherType)org.neo4j.cypher.internal.util.symbols.package$.MODULE$.CTNode())) {
                return new SetNodePropertiesPattern((LogicalVariable)variable, items);
            }
        }
        if (bl) {
            Some some;
            LogicalProperty logicalProperty = setPropertyItem.property();
            Expression expr = setPropertyItem.expression();
            if (logicalProperty != null && !(some = LogicalProperty$.MODULE$.unapply(logicalProperty)).isEmpty()) {
                Variable variable;
                Expression rel = (Expression)((Tuple2)some.get())._1();
                PropertyKeyName propertyKey = (PropertyKeyName)((Tuple2)some.get())._2();
                if (rel instanceof Variable && semanticTable.typeFor((Expression)(variable = (Variable)rel)).is((CypherType)org.neo4j.cypher.internal.util.symbols.package$.MODULE$.CTRelationship())) {
                    return new SetRelationshipPropertyPattern((LogicalVariable)variable, propertyKey, expr);
                }
            }
        }
        if (bl2) {
            Variable variable;
            Expression rel = setPropertyItems.map();
            Seq items = setPropertyItems.items();
            if (rel instanceof Variable && semanticTable.typeFor((Expression)(variable = (Variable)rel)).is((CypherType)org.neo4j.cypher.internal.util.symbols.package$.MODULE$.CTRelationship())) {
                return new SetRelationshipPropertiesPattern((LogicalVariable)variable, items);
            }
        }
        if (bl) {
            Some some;
            LogicalProperty logicalProperty = setPropertyItem.property();
            Expression expr = setPropertyItem.expression();
            if (logicalProperty != null && !(some = LogicalProperty$.MODULE$.unapply(logicalProperty)).isEmpty()) {
                Expression entityExpr = (Expression)((Tuple2)some.get())._1();
                PropertyKeyName propertyKey = (PropertyKeyName)((Tuple2)some.get())._2();
                return new SetPropertyPattern(entityExpr, propertyKey, expr);
            }
        }
        if (bl2) {
            Expression entityExpr = setPropertyItems.map();
            Seq items = setPropertyItems.items();
            return new SetPropertiesPattern(entityExpr, items);
        }
        if (setItem2 instanceof SetExactPropertiesFromMapItem) {
            bl3 = true;
            setExactPropertiesFromMapItem = (SetExactPropertiesFromMapItem)setItem2;
            Variable node = setExactPropertiesFromMapItem.variable();
            Expression expression = setExactPropertiesFromMapItem.expression();
            if (semanticTable.typeFor((Expression)node).is((CypherType)org.neo4j.cypher.internal.util.symbols.package$.MODULE$.CTNode())) {
                return new SetNodePropertiesFromMapPattern((LogicalVariable)node, expression, true);
            }
        }
        if (bl3) {
            Variable rel = setExactPropertiesFromMapItem.variable();
            Expression expression = setExactPropertiesFromMapItem.expression();
            if (semanticTable.typeFor((Expression)rel).is((CypherType)org.neo4j.cypher.internal.util.symbols.package$.MODULE$.CTRelationship())) {
                return new SetRelationshipPropertiesFromMapPattern((LogicalVariable)rel, expression, true);
            }
        }
        if (bl3) {
            Variable vr = setExactPropertiesFromMapItem.variable();
            Expression expression = setExactPropertiesFromMapItem.expression();
            return new SetPropertiesFromMapPattern((Expression)vr, expression, true);
        }
        if (setItem2 instanceof SetIncludingPropertiesFromMapItem) {
            bl4 = true;
            setIncludingPropertiesFromMapItem = (SetIncludingPropertiesFromMapItem)setItem2;
            Variable node = setIncludingPropertiesFromMapItem.variable();
            Expression expression = setIncludingPropertiesFromMapItem.expression();
            if (semanticTable.typeFor((Expression)node).is((CypherType)org.neo4j.cypher.internal.util.symbols.package$.MODULE$.CTNode())) {
                return new SetNodePropertiesFromMapPattern((LogicalVariable)node, expression, false);
            }
        }
        if (bl4) {
            Variable rel = setIncludingPropertiesFromMapItem.variable();
            Expression expression = setIncludingPropertiesFromMapItem.expression();
            if (semanticTable.typeFor((Expression)rel).is((CypherType)org.neo4j.cypher.internal.util.symbols.package$.MODULE$.CTRelationship())) {
                return new SetRelationshipPropertiesFromMapPattern((LogicalVariable)rel, expression, false);
            }
        }
        if (bl4) {
            Variable vr = setIncludingPropertiesFromMapItem.variable();
            Expression expression = setIncludingPropertiesFromMapItem.expression();
            return new SetPropertiesFromMapPattern((Expression)vr, expression, false);
        }
        if (setItem2 instanceof SetDynamicPropertyItem) {
            SetDynamicPropertyItem setDynamicPropertyItem = (SetDynamicPropertyItem)setItem2;
            ContainerIndex containerIndex = setDynamicPropertyItem.dynamicPropertyLookup();
            Expression expression = setDynamicPropertyItem.expression();
            if (containerIndex != null) {
                Expression expr = containerIndex.expr();
                Expression idx = containerIndex.idx();
                return new SetDynamicPropertyPattern(expr, idx, expression);
            }
        }
        throw new MatchError((Object)setItem2);
    }

    private PlannerQueryBuilder addMergeToLogicalPlanInput(PlannerQueryBuilder builder, Merge clause) {
        PatternElement pattern;
        Seq onCreate = (Seq)((IterableOps)clause.actions().collect((PartialFunction)new Serializable(builder){
            private static final long serialVersionUID = 0L;
            private final PlannerQueryBuilder builder$1;

            public final <A1 extends MergeAction, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof OnCreate) {
                    OnCreate onCreate = (OnCreate)A1;
                    SetClause setClause = onCreate.action();
                    return (B1)setClause.items().map((Function1 & Serializable)setItem -> ClauseConverters$.MODULE$.org$neo4j$cypher$internal$compiler$ast$convert$plannerQuery$ClauseConverters$$toSetPattern($this.builder$1.semanticTable(), (SetItem)setItem));
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(MergeAction x1) {
                MergeAction mergeAction = x1;
                return mergeAction instanceof OnCreate;
            }
            {
                this.builder$1 = builder$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(org.neo4j.cypher.internal.compiler.ast.convert.plannerQuery.ClauseConverters$$anonfun$3 org.neo4j.cypher.internal.ast.SetItem )}, serializedLambda);
            }
        })).flatten(Predef$.MODULE$.$conforms());
        Seq onMatch = (Seq)((IterableOps)clause.actions().collect((PartialFunction)new Serializable(builder){
            private static final long serialVersionUID = 0L;
            private final PlannerQueryBuilder builder$1;

            public final <A1 extends MergeAction, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                A1 A1 = x2;
                if (A1 instanceof OnMatch) {
                    OnMatch onMatch = (OnMatch)A1;
                    SetClause setClause = onMatch.action();
                    return (B1)setClause.items().map((Function1 & Serializable)setItem -> ClauseConverters$.MODULE$.org$neo4j$cypher$internal$compiler$ast$convert$plannerQuery$ClauseConverters$$toSetPattern($this.builder$1.semanticTable(), (SetItem)setItem));
                }
                return (B1)function1.apply(x2);
            }

            public final boolean isDefinedAt(MergeAction x2) {
                MergeAction mergeAction = x2;
                return mergeAction instanceof OnMatch;
            }
            {
                this.builder$1 = builder$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$2(org.neo4j.cypher.internal.compiler.ast.convert.plannerQuery.ClauseConverters$$anonfun$4 org.neo4j.cypher.internal.ast.SetItem )}, serializedLambda);
            }
        })).flatten(Predef$.MODULE$.$conforms());
        boolean bl = false;
        PathPatternPart pathPatternPart = null;
        NonPrefixedPatternPart nonPrefixedPatternPart = clause.pattern();
        if (nonPrefixedPatternPart instanceof PathPatternPart) {
            bl = true;
            pathPatternPart = (PathPatternPart)nonPrefixedPatternPart;
            PatternElement patternElement = pathPatternPart.element();
            if (patternElement instanceof NodePattern) {
                NodePattern nodePattern = (NodePattern)patternElement;
                Option option = nodePattern.variable();
                Option labelExpression = nodePattern.labelExpression();
                Option props = nodePattern.properties();
                if (option instanceof Some) {
                    Some some = (Some)option;
                    LogicalVariable id = (LogicalVariable)some.value();
                    scala.collection.immutable.Set<LabelName> labels = this.getLabelNameSet((Option<LabelExpression>)labelExpression);
                    scala.collection.immutable.Set labelPredicates = (scala.collection.immutable.Set)labels.map((Function1 & Serializable)l -> new HasLabels((Expression)id, (Seq)new .colon.colon(l, (List)Nil$.MODULE$), id.position()));
                    Seq<Expression> propertyPredicates = this.toPropertySelection(id, this.toPropertyMap((Option<Expression>)props));
                    CreateNode createNodePattern = new CreateNode(id, labels, props);
                    Selections selections = this.asSelections((Option<Where>)clause.where()).$plus$plus(Selections$.MODULE$.from((Iterable)labelPredicates.$plus$plus(propertyPredicates)));
                    scala.collection.immutable.Set dependencies = (scala.collection.immutable.Set)((SetOps)selections.variableDependencies().$plus$plus((IterableOnce)createNodePattern.dependencies()).$plus$plus((IterableOnce)onCreate.flatMap((Function1 & Serializable)x$14 -> x$14.dependencies())).$plus$plus((IterableOnce)onMatch.flatMap((Function1 & Serializable)x$15 -> x$15.dependencies()))).$minus((Object)id);
                    scala.collection.immutable.Set arguments = (scala.collection.immutable.Set)builder.currentlyAvailableVariables().intersect((scala.collection.Set)dependencies);
                    scala.collection.immutable.Set x$1 = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LogicalVariable[]{id}));
                    Selections x$2 = selections;
                    scala.collection.immutable.Set x$3 = arguments;
                    scala.collection.immutable.Set x$4 = QueryGraph$.MODULE$.apply$default$1();
                    scala.collection.immutable.Set x$5 = QueryGraph$.MODULE$.apply$default$2();
                    IndexedSeq x$6 = QueryGraph$.MODULE$.apply$default$6();
                    scala.collection.immutable.Set x$7 = QueryGraph$.MODULE$.apply$default$7();
                    scala.collection.immutable.Set x$8 = QueryGraph$.MODULE$.apply$default$8();
                    IndexedSeq x$9 = QueryGraph$.MODULE$.apply$default$9();
                    scala.collection.immutable.Set x$10 = QueryGraph$.MODULE$.apply$default$10();
                    QueryGraph matchGraph = QueryGraph$.MODULE$.apply(x$4, x$5, x$1, x$3, x$2, x$6, x$7, x$8, x$9, x$10);
                    MergeNodePattern mergePattern = new MergeNodePattern(createNodePattern, matchGraph, onCreate, onMatch);
                    QueryGraph queryGraph = QueryGraph$.MODULE$.empty().withArgumentIds(arguments).addMutatingPatterns((MutatingPattern)mergePattern);
                    return builder.withHorizon((QueryHorizon)new PassthroughAllHorizon()).withTail((SinglePlannerQuery)new RegularSinglePlannerQuery(queryGraph, RegularSinglePlannerQuery$.MODULE$.apply$default$2(), RegularSinglePlannerQuery$.MODULE$.apply$default$3(), RegularSinglePlannerQuery$.MODULE$.apply$default$4(), RegularSinglePlannerQuery$.MODULE$.apply$default$5())).withHorizon((QueryHorizon)new PassthroughAllHorizon()).withTail((SinglePlannerQuery)new RegularSinglePlannerQuery(RegularSinglePlannerQuery$.MODULE$.apply$default$1(), RegularSinglePlannerQuery$.MODULE$.apply$default$2(), RegularSinglePlannerQuery$.MODULE$.apply$default$3(), RegularSinglePlannerQuery$.MODULE$.apply$default$4(), RegularSinglePlannerQuery$.MODULE$.apply$default$5()));
                }
            }
        }
        if (bl && (pattern = pathPatternPart.element()) instanceof RelationshipChain) {
            RelationshipChain relationshipChain = (RelationshipChain)pattern;
            Tuple2 tuple2 = (Tuple2)this.allCreatePatternsInOrderAndDeduped(relationshipChain).foldRight((Object)new Tuple2((Object)Seq$.MODULE$.empty(), (Object)Seq$.MODULE$.empty()), (Function2 & Serializable)(x0$1, x1$1) -> {
                Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
                if (tuple2 != null) {
                    ClauseConverters.CreateEntityCommand e = (ClauseConverters.CreateEntityCommand)tuple2._1();
                    Tuple2 tuple22 = (Tuple2)tuple2._2();
                    if (tuple22 != null) {
                        Seq ns = (Seq)tuple22._1();
                        Seq rs = (Seq)tuple22._2();
                        ClauseConverters.CreateEntityCommand createEntityCommand = e;
                        if (createEntityCommand instanceof ClauseConverters.CreateNodeCommand) {
                            ClauseConverters.CreateNodeCommand createNodeCommand;
                            ClauseConverters.CreateNodeCommand createNodeCommand2 = createNodeCommand = (ClauseConverters.CreateNodeCommand)createEntityCommand;
                            return new Tuple2(ns.$plus$colon((Object)createNodeCommand2), (Object)rs);
                        }
                        if (createEntityCommand instanceof ClauseConverters.CreateRelCommand) {
                            ClauseConverters.CreateRelCommand createRelCommand;
                            ClauseConverters.CreateRelCommand createRelCommand2 = createRelCommand = (ClauseConverters.CreateRelCommand)createEntityCommand;
                            return new Tuple2((Object)ns, rs.$plus$colon((Object)createRelCommand2));
                        }
                        throw new MatchError((Object)createEntityCommand);
                    }
                }
                throw new MatchError((Object)tuple2);
            });
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Seq nodes = (Seq)tuple2._1();
            Seq rels = (Seq)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)nodes, (Object)rels);
            Seq nodes2 = (Seq)tuple22._1();
            Seq rels2 = (Seq)tuple22._2();
            scala.collection.immutable.Set<LogicalVariable> seenPatternNodesAndArguments = builder.lastQGNodesAndArguments();
            Tuple2 tuple23 = nodes2.partition((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)ClauseConverters$.$anonfun$addMergeToLogicalPlanInput$5(seenPatternNodesAndArguments, x0$2)));
            if (tuple23 == null) {
                throw new MatchError((Object)tuple23);
            }
            Seq nodesCreatedBefore = (Seq)tuple23._1();
            Seq nodesToCreate = (Seq)tuple23._2();
            Tuple2 tuple24 = new Tuple2((Object)nodesCreatedBefore, (Object)nodesToCreate);
            Seq nodesCreatedBefore2 = (Seq)tuple24._1();
            Seq nodesToCreate2 = (Seq)tuple24._2();
            nodesCreatedBefore2.collectFirst((PartialFunction)new Serializable(){
                private static final long serialVersionUID = 0L;

                public final <A1 extends ClauseConverters.CreateNodeCommand, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                    CreateNode c;
                    A1 A1 = x3;
                    if (A1 != null && ((c = A1.create()).labels().nonEmpty() || c.properties().nonEmpty())) {
                        throw new SyntaxException("Can't create node `" + c.variable().name() + "` with labels or properties here. The variable is already declared in this context");
                    }
                    return (B1)function1.apply(x3);
                }

                public final boolean isDefinedAt(ClauseConverters.CreateNodeCommand x3) {
                    CreateNode c;
                    ClauseConverters.CreateNodeCommand createNodeCommand = x3;
                    return createNodeCommand != null && ((c = createNodeCommand.create()).labels().nonEmpty() || c.properties().nonEmpty());
                }
            });
            Seq hasLabels = (Seq)nodes2.flatMap((Function1 & Serializable)x0$3 -> {
                ClauseConverters.CreateNodeCommand createNodeCommand = x0$3;
                if (createNodeCommand != null) {
                    CreateNode n = createNodeCommand.create();
                    LogicalVariable v = createNodeCommand.variable();
                    return (scala.collection.immutable.Set)n.labels().map((Function1 & Serializable)l -> new HasLabels((Expression)v, (Seq)new .colon.colon(l, (List)Nil$.MODULE$), v.position()));
                }
                throw new MatchError((Object)createNodeCommand);
            });
            Seq hasProps = (Seq)((IterableOps)nodes2.flatMap((Function1 & Serializable)x0$4 -> {
                ClauseConverters.CreateNodeCommand createNodeCommand = x0$4;
                if (createNodeCommand != null) {
                    CreateNode n = createNodeCommand.create();
                    LogicalVariable v = createNodeCommand.variable();
                    return MODULE$.toPropertySelection(v, MODULE$.toPropertyMap((Option<Expression>)n.properties()));
                }
                throw new MatchError((Object)createNodeCommand);
            })).$plus$plus((IterableOnce)rels2.flatMap((Function1 & Serializable)x0$5 -> {
                ClauseConverters.CreateRelCommand createRelCommand = x0$5;
                if (createRelCommand != null) {
                    CreateRelationship r = createRelCommand.create();
                    LogicalVariable v = createRelCommand.variable();
                    return MODULE$.toPropertySelection(v, MODULE$.toPropertyMap((Option<Expression>)r.properties()));
                }
                throw new MatchError((Object)createRelCommand);
            }));
            Selections selections = this.asSelections((Option<Where>)clause.where()).$plus$plus(Selections$.MODULE$.from((Iterable)hasLabels.$plus$plus((IterableOnce)hasProps)));
            scala.collection.immutable.Set dependencies = (scala.collection.immutable.Set)((SetOps)selections.variableDependencies().$plus$plus((IterableOnce)nodesCreatedBefore2.map((Function1 & Serializable)x$18 -> x$18.create().variable())).$plus$plus((IterableOnce)((IterableOps)nodesToCreate2.map((Function1 & Serializable)x$19 -> x$19.create())).flatMap((Function1 & Serializable)x$20 -> x$20.dependencies())).$plus$plus((IterableOnce)((IterableOps)rels2.map((Function1 & Serializable)x$21 -> x$21.create())).flatMap((Function1 & Serializable)x$22 -> x$22.dependencies())).$plus$plus((IterableOnce)onCreate.flatMap((Function1 & Serializable)x$23 -> x$23.dependencies())).$plus$plus((IterableOnce)onMatch.flatMap((Function1 & Serializable)x$24 -> x$24.dependencies()))).$minus$minus((IterableOnce)nodesToCreate2.map((Function1 & Serializable)x$25 -> x$25.create().variable())).$minus$minus((IterableOnce)rels2.map((Function1 & Serializable)x$26 -> x$26.create().variable()));
            scala.collection.immutable.Set arguments = (scala.collection.immutable.Set)builder.currentlyAvailableVariables().intersect((scala.collection.Set)dependencies);
            scala.collection.immutable.Set x$11 = ((IterableOnceOps)nodes2.map((Function1 & Serializable)x$27 -> x$27.create().variable())).toSet();
            scala.collection.immutable.Set x$12 = ((IterableOnceOps)rels2.map((Function1 & Serializable)x0$6 -> {
                ClauseConverters.CreateRelCommand createRelCommand = x0$6;
                if (createRelCommand != null) {
                    CreateRelationship r = createRelCommand.create();
                    return new PatternRelationship(r.variable(), new Tuple2((Object)r.leftNode(), (Object)r.rightNode()), r.direction(), (Seq)new .colon.colon((Object)r.relType(), (List)Nil$.MODULE$), (PatternLength)SimplePatternLength$.MODULE$);
                }
                throw new MatchError((Object)createRelCommand);
            })).toSet();
            Selections x$13 = selections;
            scala.collection.immutable.Set x$142 = arguments;
            scala.collection.immutable.Set x$152 = QueryGraph$.MODULE$.apply$default$2();
            IndexedSeq x$16 = QueryGraph$.MODULE$.apply$default$6();
            scala.collection.immutable.Set x$17 = QueryGraph$.MODULE$.apply$default$7();
            scala.collection.immutable.Set x$182 = QueryGraph$.MODULE$.apply$default$8();
            IndexedSeq x$192 = QueryGraph$.MODULE$.apply$default$9();
            scala.collection.immutable.Set x$202 = QueryGraph$.MODULE$.apply$default$10();
            QueryGraph matchGraph = QueryGraph$.MODULE$.apply(x$12, x$152, x$11, x$142, x$13, x$16, x$17, x$182, x$192, x$202);
            QueryGraph queryGraph = QueryGraph$.MODULE$.empty().withArgumentIds(arguments).addMutatingPatterns((MutatingPattern)new MergeRelationshipPattern((Seq)nodesToCreate2.map((Function1 & Serializable)x$28 -> x$28.create()), (Seq)rels2.map((Function1 & Serializable)x$29 -> x$29.create()), matchGraph, onCreate, onMatch));
            return builder.withHorizon((QueryHorizon)new PassthroughAllHorizon()).withTail((SinglePlannerQuery)new RegularSinglePlannerQuery(queryGraph, RegularSinglePlannerQuery$.MODULE$.apply$default$2(), RegularSinglePlannerQuery$.MODULE$.apply$default$3(), RegularSinglePlannerQuery$.MODULE$.apply$default$4(), RegularSinglePlannerQuery$.MODULE$.apply$default$5())).withHorizon((QueryHorizon)new PassthroughAllHorizon()).withTail((SinglePlannerQuery)new RegularSinglePlannerQuery(RegularSinglePlannerQuery$.MODULE$.apply$default$1(), RegularSinglePlannerQuery$.MODULE$.apply$default$2(), RegularSinglePlannerQuery$.MODULE$.apply$default$3(), RegularSinglePlannerQuery$.MODULE$.apply$default$4(), RegularSinglePlannerQuery$.MODULE$.apply$default$5()));
        }
        throw new InternalException("Received an AST-clause that has no representation the QG: " + nonPrefixedPatternPart);
    }

    private PlannerQueryBuilder addWithToLogicalPlanInput(PlannerQueryBuilder builder, With clause, Option<Clause> nextClause) {
        With with = clause;
        if (with != null) {
            boolean bl = with.distinct();
            ReturnItems ri = with.returnItems();
            Option option = with.orderBy();
            Option option2 = with.skip();
            Option option3 = with.limit();
            Option where = with.where();
            if (!bl && None$.MODULE$.equals(option) && None$.MODULE$.equals(option2) && None$.MODULE$.equals(option3) && ClauseConverters$.optionalMatchesOK$1(where, builder, nextClause) && ClauseConverters$.noUpdates$1(builder) && ClauseConverters$.returnItemsOK$1(ri) && ClauseConverters$.noShortestPaths$1(builder)) {
                Selections selections = this.asSelections((Option<Where>)where);
                return builder.amendQueryGraph((Function1<QueryGraph, QueryGraph>)(Function1 & Serializable)x$30 -> x$30.addSelections(selections));
            }
        }
        if (with != null) {
            boolean distinct2 = with.distinct();
            ReturnItems projection2 = with.returnItems();
            Option orderBy = with.orderBy();
            Option skip = with.skip();
            Option limit = with.limit();
            Option where = with.where();
            Selections selections = this.asSelections((Option<Where>)where);
            Seq<AliasedReturnItem> returnItems = this.asReturnItems(builder.currentQueryGraph(), projection2);
            QueryPagination queryPagination = new QueryPagination(QueryPagination$.MODULE$.apply$default$1(), QueryPagination$.MODULE$.apply$default$2()).withLimit(limit).withSkip(skip);
            QueryProjection queryProjection = this.asQueryProjection(distinct2, returnItems, (QueryProjection.Position)QueryProjection.Position$.Intermediate$.MODULE$).withPagination(queryPagination).withSelection(selections);
            InterestingOrder requiredOrder = this.findRequiredOrder((QueryHorizon)queryProjection, (Option<OrderBy>)orderBy);
            return builder.withHorizon((QueryHorizon)queryProjection).withInterestingOrder(requiredOrder).withPropagatedTailInterestingOrder().withTail((SinglePlannerQuery)new RegularSinglePlannerQuery(QueryGraph$.MODULE$.apply(QueryGraph$.MODULE$.apply$default$1(), QueryGraph$.MODULE$.apply$default$2(), QueryGraph$.MODULE$.apply$default$3(), QueryGraph$.MODULE$.apply$default$4(), QueryGraph$.MODULE$.apply$default$5(), QueryGraph$.MODULE$.apply$default$6(), QueryGraph$.MODULE$.apply$default$7(), QueryGraph$.MODULE$.apply$default$8(), QueryGraph$.MODULE$.apply$default$9(), QueryGraph$.MODULE$.apply$default$10()), RegularSinglePlannerQuery$.MODULE$.apply$default$2(), RegularSinglePlannerQuery$.MODULE$.apply$default$3(), RegularSinglePlannerQuery$.MODULE$.apply$default$4(), RegularSinglePlannerQuery$.MODULE$.apply$default$5()));
        }
        throw new InternalException("AST needs to be rewritten before it can be used for planning. Got: " + clause);
    }

    private PlannerQueryBuilder addUnwindToLogicalPlanInput(PlannerQueryBuilder builder, Unwind clause) {
        return builder.withHorizon((QueryHorizon)new UnwindProjection((LogicalVariable)clause.variable(), clause.expression())).withTail((SinglePlannerQuery)SinglePlannerQuery$.MODULE$.empty());
    }

    private PlannerQueryBuilder addCallToLogicalPlanInput(PlannerQueryBuilder builder, ResolvedCall call) {
        return builder.withHorizon((QueryHorizon)new ProcedureCallProjection(call)).withTail((SinglePlannerQuery)SinglePlannerQuery$.MODULE$.empty());
    }

    private PlannerQueryBuilder addForeachToLogicalPlanInput(PlannerQueryBuilder builder, Foreach clause, AnonymousVariableNameGenerator anonymousVariableNameGenerator, CancellationChecker cancellationChecker) {
        scala.collection.immutable.Set<LogicalVariable> availableBeforeForeach = builder.currentlyAvailableVariables();
        scala.collection.immutable.Set availableToInnerClauses = (scala.collection.immutable.Set)availableBeforeForeach.$plus((Object)clause.variable());
        PlannerQueryBuilder innerBuilder = StatementConverters$.MODULE$.addClausesToPlannerQueryBuilder((Seq<Clause>)clause.updates(), new PlannerQueryBuilder((SinglePlannerQuery)SinglePlannerQuery$.MODULE$.empty(), builder.semanticTable()).amendQueryGraph((Function1<QueryGraph, QueryGraph>)(Function1 & Serializable)x$31 -> x$31.withArgumentIds(availableToInnerClauses)).withHorizon((QueryHorizon)new PassthroughAllHorizon()), anonymousVariableNameGenerator, cancellationChecker, (QueryProjection.Position)QueryProjection.Position$.Intermediate$.MODULE$);
        scala.collection.immutable.Set dependencies = (scala.collection.immutable.Set)((IterableOnceOps)innerBuilder.q().allPlannerQueries().view().flatMap((Function1 & Serializable)x$32 -> (IndexedSeq)x$32.queryGraph().mutatingPatterns().flatMap((Function1 & Serializable)x$33 -> x$33.dependencies()))).to(IterableFactory$.MODULE$.toFactory((IterableFactory)Predef$.MODULE$.Set()));
        scala.collection.immutable.Set arguments = (scala.collection.immutable.Set)availableToInnerClauses.intersect((scala.collection.Set)dependencies);
        PlannerQueryBuilder innerBuilderWithFixedArguments = innerBuilder.withInitialArguments((scala.collection.immutable.Set<LogicalVariable>)arguments);
        SinglePlannerQuery innerPlannerQuery = innerBuilderWithFixedArguments.build();
        ForeachPattern foreachPattern = new ForeachPattern((LogicalVariable)clause.variable(), clause.expression(), innerPlannerQuery);
        scala.collection.immutable.Set<LogicalVariable> x$1 = availableBeforeForeach;
        IndexedSeq x$2 = (IndexedSeq)package$.MODULE$.IndexedSeq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ForeachPattern[]{foreachPattern}));
        scala.collection.immutable.Set x$3 = QueryGraph$.MODULE$.apply$default$1();
        scala.collection.immutable.Set x$4 = QueryGraph$.MODULE$.apply$default$2();
        scala.collection.immutable.Set x$5 = QueryGraph$.MODULE$.apply$default$3();
        Selections x$6 = QueryGraph$.MODULE$.apply$default$5();
        IndexedSeq x$7 = QueryGraph$.MODULE$.apply$default$6();
        scala.collection.immutable.Set x$8 = QueryGraph$.MODULE$.apply$default$7();
        scala.collection.immutable.Set x$9 = QueryGraph$.MODULE$.apply$default$8();
        scala.collection.immutable.Set x$10 = QueryGraph$.MODULE$.apply$default$10();
        QueryGraph foreachGraph = QueryGraph$.MODULE$.apply(x$3, x$4, x$5, x$1, x$6, x$7, x$8, x$9, x$2, x$10);
        return builder.withHorizon((QueryHorizon)new PassthroughAllHorizon()).withTail((SinglePlannerQuery)new RegularSinglePlannerQuery(foreachGraph, RegularSinglePlannerQuery$.MODULE$.apply$default$2(), RegularSinglePlannerQuery$.MODULE$.apply$default$3(), RegularSinglePlannerQuery$.MODULE$.apply$default$4(), RegularSinglePlannerQuery$.MODULE$.apply$default$5())).withHorizon((QueryHorizon)new PassthroughAllHorizon()).withTail((SinglePlannerQuery)new RegularSinglePlannerQuery(RegularSinglePlannerQuery$.MODULE$.apply$default$1(), RegularSinglePlannerQuery$.MODULE$.apply$default$2(), RegularSinglePlannerQuery$.MODULE$.apply$default$3(), RegularSinglePlannerQuery$.MODULE$.apply$default$4(), RegularSinglePlannerQuery$.MODULE$.apply$default$5()));
    }

    private PlannerQueryBuilder addRemoveToLogicalPlanInput(PlannerQueryBuilder acc, Remove clause) {
        return (PlannerQueryBuilder)clause.items().foldLeft((Object)acc, (Function2 & Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                PlannerQueryBuilder builder = (PlannerQueryBuilder)tuple2._1();
                RemoveItem removeItem = (RemoveItem)tuple2._2();
                if (removeItem instanceof RemoveLabelItem) {
                    RemoveLabelItem removeLabelItem = (RemoveLabelItem)removeItem;
                    LogicalVariable variable = removeLabelItem.variable();
                    Seq labelNames = removeLabelItem.labels();
                    Seq dynamicLabels = removeLabelItem.dynamicLabels();
                    return builder.amendQueryGraph((Function1<QueryGraph, QueryGraph>)(Function1 & Serializable)x$34 -> x$34.addMutatingPatterns((MutatingPattern)new RemoveLabelPattern(variable, labelNames, dynamicLabels)));
                }
            }
            if (tuple2 != null) {
                RemovePropertyItem removePropertyItem;
                LogicalProperty logicalProperty;
                PlannerQueryBuilder builder = (PlannerQueryBuilder)tuple2._1();
                RemoveItem removeItem = (RemoveItem)tuple2._2();
                if (removeItem instanceof RemovePropertyItem && (logicalProperty = (removePropertyItem = (RemovePropertyItem)removeItem).property()) instanceof Property) {
                    Property property = (Property)logicalProperty;
                    Expression variable = property.map();
                    PropertyKeyName propertyKey = property.propertyKey();
                    if (variable instanceof Variable) {
                        Variable variable2 = (Variable)variable;
                        if (acc.semanticTable().typeFor((Expression)variable2).is((CypherType)org.neo4j.cypher.internal.util.symbols.package$.MODULE$.CTNode())) {
                            return builder.amendQueryGraph((Function1<QueryGraph, QueryGraph>)(Function1 & Serializable)x$35 -> x$35.addMutatingPatterns((MutatingPattern)new SetNodePropertyPattern((LogicalVariable)variable2, propertyKey, (Expression)new Null(propertyKey.position()))));
                        }
                    }
                }
            }
            if (tuple2 != null) {
                RemovePropertyItem removePropertyItem;
                LogicalProperty logicalProperty;
                PlannerQueryBuilder builder = (PlannerQueryBuilder)tuple2._1();
                RemoveItem removeItem = (RemoveItem)tuple2._2();
                if (removeItem instanceof RemovePropertyItem && (logicalProperty = (removePropertyItem = (RemovePropertyItem)removeItem).property()) instanceof Property) {
                    Property property = (Property)logicalProperty;
                    Expression variable = property.map();
                    PropertyKeyName propertyKey = property.propertyKey();
                    if (variable instanceof Variable) {
                        Variable variable3 = (Variable)variable;
                        if (acc.semanticTable().typeFor((Expression)variable3).is((CypherType)org.neo4j.cypher.internal.util.symbols.package$.MODULE$.CTRelationship())) {
                            return builder.amendQueryGraph((Function1<QueryGraph, QueryGraph>)(Function1 & Serializable)x$36 -> x$36.addMutatingPatterns((MutatingPattern)new SetRelationshipPropertyPattern((LogicalVariable)variable3, propertyKey, (Expression)new Null(propertyKey.position()))));
                        }
                    }
                }
            }
            if (tuple2 != null) {
                RemovePropertyItem removePropertyItem;
                LogicalProperty logicalProperty;
                PlannerQueryBuilder builder = (PlannerQueryBuilder)tuple2._1();
                RemoveItem removeItem = (RemoveItem)tuple2._2();
                if (removeItem instanceof RemovePropertyItem && (logicalProperty = (removePropertyItem = (RemovePropertyItem)removeItem).property()) instanceof Property) {
                    Property property = (Property)logicalProperty;
                    Expression variable = property.map();
                    PropertyKeyName propertyKey = property.propertyKey();
                    return builder.amendQueryGraph((Function1<QueryGraph, QueryGraph>)(Function1 & Serializable)x$37 -> x$37.addMutatingPatterns((MutatingPattern)new SetPropertyPattern(variable, propertyKey, (Expression)new Null(propertyKey.position()))));
                }
            }
            if (tuple2 != null) {
                RemoveDynamicPropertyItem removeDynamicPropertyItem;
                ContainerIndex containerIndex;
                PlannerQueryBuilder builder = (PlannerQueryBuilder)tuple2._1();
                RemoveItem removeItem = (RemoveItem)tuple2._2();
                if (removeItem instanceof RemoveDynamicPropertyItem && (containerIndex = (removeDynamicPropertyItem = (RemoveDynamicPropertyItem)removeItem).dynamicPropertyLookup()) != null) {
                    Expression entity = containerIndex.expr();
                    Expression prop = containerIndex.idx();
                    return builder.amendQueryGraph((Function1<QueryGraph, QueryGraph>)(Function1 & Serializable)x$38 -> x$38.addMutatingPatterns((MutatingPattern)new SetDynamicPropertyPattern(entity, prop, (Expression)new Null(prop.position()))));
                }
            }
            if (tuple2 != null) {
                RemoveItem other = (RemoveItem)tuple2._2();
                throw new InternalException("REMOVE " + other + " not supported in cost planner yet");
            }
            throw new MatchError((Object)tuple2);
        });
    }

    private boolean containsAggregateOutsideOfAggregatingHorizon(Expression expr) {
        return BoxesRunTime.unboxToBoolean((Object)expr.folder().treeFold((Object)BoxesRunTime.boxToBoolean((boolean)false), (PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Option option;
                A1 A1 = x1;
                if (A1 instanceof AggregatingQueryProjection) {
                    return (B1)(Function1 & Serializable)x$39 -> anonfun.containsAggregateOutsideOfAggregatingHorizon.1.$anonfun$applyOrElse$3(BoxesRunTime.unboxToBoolean((Object)x$39));
                }
                if (A1 != null && !(option = IsAggregate$.MODULE$.unapply(A1)).isEmpty()) {
                    return (B1)(Function1 & Serializable)x$40 -> anonfun.containsAggregateOutsideOfAggregatingHorizon.1.$anonfun$applyOrElse$4(BoxesRunTime.unboxToBoolean((Object)x$40));
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Object x1) {
                Option option;
                Object object = x1;
                if (object instanceof AggregatingQueryProjection) {
                    return true;
                }
                return object != null && !(option = IsAggregate$.MODULE$.unapply(object)).isEmpty();
            }

            public static final /* synthetic */ Foldable.SkipChildren $anonfun$applyOrElse$3(boolean x$39) {
                return new Foldable.SkipChildren((Object)BoxesRunTime.boxToBoolean((boolean)false));
            }

            public static final /* synthetic */ Foldable.SkipChildren $anonfun$applyOrElse$4(boolean x$40) {
                return new Foldable.SkipChildren((Object)BoxesRunTime.boxToBoolean((boolean)true));
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$3$adapted(java.lang.Object ), $anonfun$applyOrElse$4$adapted(java.lang.Object )}, serializedLambda);
            }
        }));
    }

    private static final Map turnIntoMap$1(Seq x) {
        return ((IterableOnceOps)x.map((Function1 & Serializable)e -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)e.variable()), (Object)e.expression()))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public static final /* synthetic */ Seq $anonfun$interestingOrderCandidatesForGroupingExpressions$3(Seq orderings$1, Expression prop) {
        return (Seq)orderings$1.map((Function1 & Serializable)indexOrder -> new InterestingOrderCandidate((Seq)new .colon.colon((Object)((Product)indexOrder.apply((Object)prop)), (List)Nil$.MODULE$)));
    }

    public static final /* synthetic */ void $anonfun$addCreateToLogicalPlanInput$1(ArrayBuffer commands$1, Set seenPatternNodes$1, CreateOrInsert clause$1, NonPrefixedPatternPart x0$1) {
        PatternElement pattern;
        boolean bl = false;
        PathPatternPart pathPatternPart = null;
        NonPrefixedPatternPart nonPrefixedPatternPart = x0$1;
        if (nonPrefixedPatternPart instanceof PathPatternPart) {
            bl = true;
            pathPatternPart = (PathPatternPart)nonPrefixedPatternPart;
            PatternElement patternElement = pathPatternPart.element();
            if (patternElement instanceof NodePattern) {
                NodePattern nodePattern = (NodePattern)patternElement;
                Option option = nodePattern.variable();
                Option labelExpression = nodePattern.labelExpression();
                Option props = nodePattern.properties();
                Option option2 = nodePattern.predicate();
                if (option instanceof Some) {
                    Some some = (Some)option;
                    LogicalVariable id = (LogicalVariable)some.value();
                    if (None$.MODULE$.equals(option2)) {
                        scala.collection.immutable.Set<LabelName> labels = MODULE$.getLabelNameSet((Option<LabelExpression>)labelExpression);
                        commands$1.$plus$eq((Object)new CreateNode(id, labels, props));
                        seenPatternNodes$1.$plus$eq((Object)id);
                        return;
                    }
                }
            }
        }
        if (bl && (pattern = pathPatternPart.element()) instanceof RelationshipChain) {
            RelationshipChain relationshipChain = (RelationshipChain)pattern;
            MODULE$.allCreatePatternsInOrderAndDeduped(relationshipChain).foreach((Function1 & Serializable)x0$2 -> {
                ClauseConverters.CreateEntityCommand createEntityCommand = x0$2;
                if (createEntityCommand instanceof ClauseConverters.CreateNodeCommand) {
                    ClauseConverters.CreateNodeCommand createNodeCommand = (ClauseConverters.CreateNodeCommand)createEntityCommand;
                    CreateNode create = createNodeCommand.create();
                    if (seenPatternNodes$1.add((Object)create.variable())) {
                        return commands$1.$plus$eq((Object)create);
                    }
                    if (create.labels().nonEmpty() || create.properties().nonEmpty()) {
                        throw new SyntaxException("Can't create node `" + create.variable().name() + "` with labels or properties here. The variable is already declared in this context");
                    }
                    return BoxedUnit.UNIT;
                }
                if (createEntityCommand instanceof ClauseConverters.CreateRelCommand) {
                    ClauseConverters.CreateRelCommand createRelCommand = (ClauseConverters.CreateRelCommand)createEntityCommand;
                    CreateRelationship create = createRelCommand.create();
                    return commands$1.$plus$eq((Object)create);
                }
                throw new MatchError((Object)createEntityCommand);
            });
            return;
        }
        throw new InternalException("Received an AST-clause that has no representation the QG: " + clause$1);
    }

    private static final Nothing$ fail$1(LabelExpression le) {
        throw new IllegalStateException("This label expression is not allowed here: " + le + ". This is a bug and should have been caught by Semantic Analysis.");
    }

    private final Vector addNode$1(NodePattern node, scala.collection.immutable.Set seenNodes$1, Vector acc$2) {
        if (seenNodes$1.contains(node.variable().get())) {
            if (node.labelExpression().nonEmpty() || node.properties().nonEmpty()) {
                throw new SyntaxException("Can't create node `" + ((LogicalVariable)node.variable().get()).name() + "` with labels or properties here. The variable is already declared in this context");
            }
            return acc$2;
        }
        return (Vector)acc$2.$colon$plus((Object)this.createNodeCommand(node));
    }

    private static final boolean hasPatternOverlapOnInteriorVars$1(PlannerQueryBuilder acc$3, Match clause$3) {
        scala.collection.immutable.Set previousStrictInteriorVars = (scala.collection.immutable.Set)acc$3.currentQueryGraph().selectivePathPatterns().flatMap((Function1 & Serializable)spp -> (scala.collection.immutable.Set)spp.coveredIds().$minus$minus((IterableOnce)spp.boundaryNodesSet()));
        scala.collection.immutable.Set currentPatternVars = ((IterableOnceOps)clause$3.pattern().patternParts().flatMap((Function1 & Serializable)x$13 -> x$13.allVariables())).toSet();
        boolean hasReferenceFromThisPatternToInterior = previousStrictInteriorVars.intersect((scala.collection.Set)currentPatternVars).nonEmpty();
        scala.collection.immutable.Set previousPatternVars = acc$3.currentQueryGraph().coveredIdsForPatterns();
        scala.collection.immutable.Set currentStrictInteriorVarsAndDependencies = ((IterableOnceOps)((IterableOps)clause$3.pattern().patternParts().view().collect((PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends PatternPartWithSelector, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 != null && A1.selector() instanceof PatternPart.SelectiveSelector) {
                    return (B1)A1.allVariables().$minus$minus((IterableOnce)PatternElement$.MODULE$.boundaryNodes(A1.element())).$plus$plus((IterableOnce)A1.dependencies());
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(PatternPartWithSelector x1) {
                PatternPartWithSelector patternPartWithSelector = x1;
                return patternPartWithSelector != null && patternPartWithSelector.selector() instanceof PatternPart.SelectiveSelector;
            }
        })).flatten(Predef$.MODULE$.$conforms())).toSet();
        boolean hasInteriorOrDependencyReferringToPreviouslyBoundVar = previousPatternVars.intersect((scala.collection.Set)currentStrictInteriorVarsAndDependencies).nonEmpty();
        return hasReferenceFromThisPatternToInterior || hasInteriorOrDependencyReferringToPreviouslyBoundVar;
    }

    public static final /* synthetic */ boolean $anonfun$addMatchToLogicalPlanInput$3(scala.collection.immutable.Set connections) {
        scala.collection.immutable.Set overlappingNodes = (scala.collection.immutable.Set)((NodeConnection)connections.head()).nodes().intersect((scala.collection.Set)((NodeConnection)connections.last()).nodes());
        scala.collection.immutable.Set overlappingRelationships = (scala.collection.immutable.Set)((NodeConnection)connections.head()).relationships().intersect((scala.collection.Set)((NodeConnection)connections.last()).relationships());
        return overlappingNodes.isEmpty() && overlappingRelationships.nonEmpty();
    }

    private static final boolean isPotentiallyUnsolvable$1(List pathPatterns$1, PlannerQueryBuilder acc$3) {
        scala.collection.immutable.Set allNodeConnections = (scala.collection.immutable.Set)PathPatterns$.MODULE$.allNodeConnections$extension(pathPatterns$1).$plus$plus((IterableOnce)acc$3.currentQueryGraph().nodeConnections());
        Iterator allNodeConnectionsOverlappingOnlyOnRelationship = allNodeConnections.subsets(2).filter((Function1 & Serializable)connections -> BoxesRunTime.boxToBoolean((boolean)ClauseConverters$.$anonfun$addMatchToLogicalPlanInput$3(connections))).flatten(Predef$.MODULE$.$conforms());
        return allNodeConnections.size() >= 4 && allNodeConnectionsOverlappingOnlyOnRelationship.size() >= 2;
    }

    public static final /* synthetic */ boolean $anonfun$addMergeToLogicalPlanInput$5(scala.collection.immutable.Set seenPatternNodesAndArguments$1, ClauseConverters.CreateNodeCommand x0$2) {
        ClauseConverters.CreateNodeCommand createNodeCommand = x0$2;
        if (createNodeCommand != null) {
            CreateNode c = createNodeCommand.create();
            return seenPatternNodesAndArguments$1.apply((Object)c.variable());
        }
        throw new MatchError((Object)createNodeCommand);
    }

    private static final boolean optionalMatchesOK$1(Option where, PlannerQueryBuilder builder$2, Option nextClause$1) {
        Match match;
        Some some;
        Clause m;
        Option option;
        return !builder$2.currentQueryGraph().hasOptionalPatterns() || where.isEmpty() && (option = nextClause$1) instanceof Some && (m = (Clause)(some = (Some)option).value()) instanceof Match && (match = (Match)m).optional();
    }

    private static final boolean noUpdates$1(PlannerQueryBuilder builder$2) {
        return !builder$2.currentQueryGraph().containsUpdates() && builder$2.readOnly();
    }

    private static final boolean noShortestPaths$1(PlannerQueryBuilder builder$2) {
        return builder$2.currentQueryGraph().shortestRelationshipPatterns().isEmpty();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$addWithToLogicalPlanInput$1(ReturnItem x0$1) {
        ReturnItem returnItem = x0$1;
        if (!(returnItem instanceof AliasedReturnItem)) throw new InternalException("This should have been rewritten to an AliasedReturnItem.");
        AliasedReturnItem aliasedReturnItem = (AliasedReturnItem)returnItem;
        if (MODULE$.containsAggregateOutsideOfAggregatingHorizon(aliasedReturnItem.expression())) return false;
        Expression expression = aliasedReturnItem.expression();
        LogicalVariable logicalVariable = aliasedReturnItem.variable();
        if (expression != null) {
            if (!expression.equals(logicalVariable)) return false;
            return true;
        }
        if (logicalVariable == null) return true;
        return false;
    }

    private static final boolean returnItemsOK$1(ReturnItems ri) {
        return ri.items().forall((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ClauseConverters$.$anonfun$addWithToLogicalPlanInput$1(x0$1)));
    }

    private ClauseConverters$() {
    }
}

