/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.hashing;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.nio.ByteOrder;

public final class WyHash {
    private static final VarHandle LE_INTEGER = MethodHandles.byteArrayViewVarHandle(int[].class, ByteOrder.LITTLE_ENDIAN).withInvokeExactBehavior();
    private static final VarHandle LE_LONG = MethodHandles.byteArrayViewVarHandle(long[].class, ByteOrder.LITTLE_ENDIAN).withInvokeExactBehavior();
    private static final long WYP_0 = -6884282663029611473L;
    private static final long WYP_1 = -1800455987208640293L;
    private static final long WYP_2 = -8161530843051276573L;
    private static final long WYP_3 = 6384245875588680899L;
    private static final long WYP_4 = 2129725606500045391L;

    private WyHash() {
    }

    public static long hashLong(long input) {
        long hi = input & 0xFFFFFFFFL;
        long lo = input >>> 32 & 0xFFFFFFFFL;
        return WyHash.wymum(WyHash.wymum(hi ^ 0xA0761D6478BD642FL, lo ^ 0xE7037ED1A0B428DBL), 2129725606500045383L);
    }

    public static long hashInt(int input) {
        long longInput = (long)input & 0xFFFFFFFFL;
        return WyHash.wymum(WyHash.wymum(longInput ^ 0xA0761D6478BD642FL, longInput ^ 0xE7037ED1A0B428DBL), 2129725606500045387L);
    }

    public static long hashShort(short input) {
        long hi = (long)(input >>> 8) & 0xFFL;
        long wyr3 = hi | hi << 8 | ((long)input & 0xFFL) << 16;
        return WyHash.wymum(WyHash.wymum(wyr3 ^ 0xA0761D6478BD642FL, -1800455987208640293L), 2129725606500045389L);
    }

    public static long hashChar(char input) {
        return WyHash.hashShort((short)input);
    }

    public static long hashByte(byte input) {
        long hi = (long)input & 0xFFL;
        long wyr3 = hi | hi << 8 | hi << 16;
        return WyHash.wymum(WyHash.wymum(wyr3 ^ 0xA0761D6478BD642FL, -1800455987208640293L), 2129725606500045390L);
    }

    public static long hash(byte[] input, int off, int len) {
        return WyHash.wyHash64(input, off, len);
    }

    private static long unsignedLongMulXorFold(long lhs, long rhs) {
        long upper = Math.multiplyHigh(lhs, rhs) + (lhs >> 63 & rhs) + (rhs >> 63 & lhs);
        long lower = lhs * rhs;
        return lower ^ upper;
    }

    private static long wymum(long lhs, long rhs) {
        return WyHash.unsignedLongMulXorFold(lhs, rhs);
    }

    private static long wyr3(byte[] in, int index, int k) {
        return (long)in[index] << 16 | (long)in[index + (k >>> 1)] << 8 | (long)in[index + k - 1];
    }

    private static long u64Rorate32(byte[] in, int index) {
        return WyHash.u32(in, index) << 32 | WyHash.u32(in, index + 4);
    }

    private static long u32(byte[] input, int offset) {
        return (long)LE_INTEGER.get(input, offset) & 0xFFFFFFFFL;
    }

    private static long i64(byte[] input, int offset) {
        return LE_LONG.get(input, offset);
    }

    static long wyHash64(byte[] input, int off, int length) {
        if (length <= 0) {
            return 0L;
        }
        if (length < 4) {
            return WyHash.wymum(WyHash.wymum(WyHash.wyr3(input, off, length) ^ 0xA0761D6478BD642FL, -1800455987208640293L), (long)length ^ 0x1D8E4E27C47D124FL);
        }
        if (length <= 8) {
            return WyHash.wymum(WyHash.wymum(WyHash.u32(input, off) ^ 0xA0761D6478BD642FL, WyHash.u32(input, off + length - 4) ^ 0xE7037ED1A0B428DBL), (long)length ^ 0x1D8E4E27C47D124FL);
        }
        if (length <= 16) {
            return WyHash.wymum(WyHash.wymum(WyHash.u64Rorate32(input, off) ^ 0xA0761D6478BD642FL, WyHash.u64Rorate32(input, off + length - 8) ^ 0xE7037ED1A0B428DBL), (long)length ^ 0x1D8E4E27C47D124FL);
        }
        if (length <= 24) {
            return WyHash.wymum(WyHash.wymum(WyHash.u64Rorate32(input, off) ^ 0xA0761D6478BD642FL, WyHash.u64Rorate32(input, off + 8) ^ 0xE7037ED1A0B428DBL) ^ WyHash.wymum(WyHash.u64Rorate32(input, off + length - 8) ^ 0x8EBC6AF09C88C6E3L, 6384245875588680899L), (long)length ^ 0x1D8E4E27C47D124FL);
        }
        if (length <= 32) {
            return WyHash.wymum(WyHash.wymum(WyHash.u64Rorate32(input, off) ^ 0xA0761D6478BD642FL, WyHash.u64Rorate32(input, off + 8) ^ 0xE7037ED1A0B428DBL) ^ WyHash.wymum(WyHash.u64Rorate32(input, off + 16) ^ 0x8EBC6AF09C88C6E3L, WyHash.u64Rorate32(input, off + length - 8) ^ 0x589965CC75374CC3L), (long)length ^ 0x1D8E4E27C47D124FL);
        }
        long seed = 0L;
        long see1 = 0L;
        int i = length;
        int p = off;
        while (i > 256) {
            seed = WyHash.wymum(WyHash.i64(input, p) ^ seed ^ 0xA0761D6478BD642FL, WyHash.i64(input, p + 8) ^ seed ^ 0xE7037ED1A0B428DBL) ^ WyHash.wymum(WyHash.i64(input, p + 16) ^ seed ^ 0x8EBC6AF09C88C6E3L, WyHash.i64(input, p + 24) ^ seed ^ 0x589965CC75374CC3L);
            see1 = WyHash.wymum(WyHash.i64(input, p + 32) ^ see1 ^ 0xE7037ED1A0B428DBL, WyHash.i64(input, p + 40) ^ see1 ^ 0x8EBC6AF09C88C6E3L) ^ WyHash.wymum(WyHash.i64(input, p + 48) ^ see1 ^ 0x589965CC75374CC3L, WyHash.i64(input, p + 56) ^ see1 ^ 0xA0761D6478BD642FL);
            seed = WyHash.wymum(WyHash.i64(input, p + 64) ^ seed ^ 0xA0761D6478BD642FL, WyHash.i64(input, p + 72) ^ seed ^ 0xE7037ED1A0B428DBL) ^ WyHash.wymum(WyHash.i64(input, p + 80) ^ seed ^ 0x8EBC6AF09C88C6E3L, WyHash.i64(input, p + 88) ^ seed ^ 0x589965CC75374CC3L);
            see1 = WyHash.wymum(WyHash.i64(input, p + 96) ^ see1 ^ 0xE7037ED1A0B428DBL, WyHash.i64(input, p + 104) ^ see1 ^ 0x8EBC6AF09C88C6E3L) ^ WyHash.wymum(WyHash.i64(input, p + 112) ^ see1 ^ 0x589965CC75374CC3L, WyHash.i64(input, p + 120) ^ see1 ^ 0xA0761D6478BD642FL);
            seed = WyHash.wymum(WyHash.i64(input, p + 128) ^ seed ^ 0xA0761D6478BD642FL, WyHash.i64(input, p + 136) ^ seed ^ 0xE7037ED1A0B428DBL) ^ WyHash.wymum(WyHash.i64(input, p + 144) ^ seed ^ 0x8EBC6AF09C88C6E3L, WyHash.i64(input, p + 152) ^ seed ^ 0x589965CC75374CC3L);
            see1 = WyHash.wymum(WyHash.i64(input, p + 160) ^ see1 ^ 0xE7037ED1A0B428DBL, WyHash.i64(input, p + 168) ^ see1 ^ 0x8EBC6AF09C88C6E3L) ^ WyHash.wymum(WyHash.i64(input, p + 176) ^ see1 ^ 0x589965CC75374CC3L, WyHash.i64(input, p + 184) ^ see1 ^ 0xA0761D6478BD642FL);
            seed = WyHash.wymum(WyHash.i64(input, p + 192) ^ seed ^ 0xA0761D6478BD642FL, WyHash.i64(input, p + 200) ^ seed ^ 0xE7037ED1A0B428DBL) ^ WyHash.wymum(WyHash.i64(input, p + 208) ^ seed ^ 0x8EBC6AF09C88C6E3L, WyHash.i64(input, p + 216) ^ seed ^ 0x589965CC75374CC3L);
            see1 = WyHash.wymum(WyHash.i64(input, p + 224) ^ see1 ^ 0xE7037ED1A0B428DBL, WyHash.i64(input, p + 232) ^ see1 ^ 0x8EBC6AF09C88C6E3L) ^ WyHash.wymum(WyHash.i64(input, p + 240) ^ see1 ^ 0x589965CC75374CC3L, WyHash.i64(input, p + 248) ^ see1 ^ 0xA0761D6478BD642FL);
            i -= 256;
            p += 256;
        }
        while (i > 32) {
            seed = WyHash.wymum(WyHash.i64(input, p) ^ seed ^ 0xA0761D6478BD642FL, WyHash.i64(input, p + 8) ^ seed ^ 0xE7037ED1A0B428DBL);
            see1 = WyHash.wymum(WyHash.i64(input, p + 16) ^ see1 ^ 0x8EBC6AF09C88C6E3L, WyHash.i64(input, p + 24) ^ see1 ^ 0x589965CC75374CC3L);
            i -= 32;
            p += 32;
        }
        if (i < 4) {
            seed = WyHash.wymum(WyHash.wyr3(input, p, i) ^ seed ^ 0xA0761D6478BD642FL, seed ^ 0xE7037ED1A0B428DBL);
        } else if (i <= 8) {
            seed = WyHash.wymum(WyHash.u32(input, p) ^ seed ^ 0xA0761D6478BD642FL, WyHash.u32(input, p + i - 4) ^ seed ^ 0xE7037ED1A0B428DBL);
        } else if (i <= 16) {
            seed = WyHash.wymum(WyHash.u64Rorate32(input, p) ^ seed ^ 0xA0761D6478BD642FL, WyHash.u64Rorate32(input, p + i - 8) ^ seed ^ 0xE7037ED1A0B428DBL);
        } else if (i <= 24) {
            seed = WyHash.wymum(WyHash.u64Rorate32(input, p) ^ seed ^ 0xA0761D6478BD642FL, WyHash.u64Rorate32(input, p + 8) ^ seed ^ 0xE7037ED1A0B428DBL);
            see1 = WyHash.wymum(WyHash.u64Rorate32(input, p + i - 8) ^ see1 ^ 0x8EBC6AF09C88C6E3L, see1 ^ 0x589965CC75374CC3L);
        } else {
            seed = WyHash.wymum(WyHash.u64Rorate32(input, p) ^ seed ^ 0xA0761D6478BD642FL, WyHash.u64Rorate32(input, p + 8) ^ seed ^ 0xE7037ED1A0B428DBL);
            see1 = WyHash.wymum(WyHash.u64Rorate32(input, p + 16) ^ see1 ^ 0x8EBC6AF09C88C6E3L, WyHash.u64Rorate32(input, p + i - 8) ^ see1 ^ 0x589965CC75374CC3L);
        }
        return WyHash.wymum(seed ^ see1, (long)length ^ 0x1D8E4E27C47D124FL);
    }
}

