/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.helpers.traversal;

import java.util.Iterator;
import java.util.function.LongPredicate;
import java.util.function.Predicate;
import org.neo4j.graphdb.Direction;
import org.neo4j.internal.kernel.api.KernelReadTracer;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.RelationshipTraversalCursor;
import org.neo4j.internal.kernel.api.helpers.traversal.BiDirectionalBFSImpl;
import org.neo4j.internal.kernel.api.helpers.traversal.State;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.values.virtual.PathReference;

public class BiDirectionalBFS
implements AutoCloseable {
    private final BiDirectionalBFSImpl<?> inner;

    private BiDirectionalBFS(BiDirectionalBFSImpl<?> inner) {
        this.inner = inner;
    }

    public static BiDirectionalBFS newEmptyBiDirectionalBFS(long sourceNodeId, long targetNodeId, int[] types, Direction direction, int maxDepth, boolean stopAsapAtIntersect, Read read, NodeCursor nodeCursor, RelationshipTraversalCursor relCursor, MemoryTracker memoryTracker, LongPredicate nodeFilter, Predicate<RelationshipTraversalCursor> relFilter, boolean needOnlyOnePath, boolean allowZeroLength) {
        BiDirectionalBFSImpl bfs = needOnlyOnePath ? new BiDirectionalBFSImpl.SinglePathBiDirectionalBFS(sourceNodeId, targetNodeId, types, direction, maxDepth, read, nodeCursor, relCursor, memoryTracker, nodeFilter, relFilter, allowZeroLength) : (stopAsapAtIntersect ? new BiDirectionalBFSImpl.LazyMultiPathBiDirectionalBFS(sourceNodeId, targetNodeId, types, direction, maxDepth, read, nodeCursor, relCursor, memoryTracker, nodeFilter, relFilter, allowZeroLength) : new BiDirectionalBFSImpl.EagerMultiPathBiDirectionalBFS(sourceNodeId, targetNodeId, types, direction, maxDepth, read, nodeCursor, relCursor, memoryTracker, nodeFilter, relFilter, allowZeroLength));
        bfs.algorithmState = State.CAN_SEARCH_FOR_INTERSECTION;
        return new BiDirectionalBFS(bfs);
    }

    public static BiDirectionalBFS newEmptyBiDirectionalBFS(int[] types, Direction direction, int maxDepth, boolean stopAsapAtIntersect, Read read, NodeCursor nodeCursor, RelationshipTraversalCursor relCursor, MemoryTracker memoryTracker, boolean needOnlyOnePath, boolean allowZeroLength) {
        BiDirectionalBFSImpl bfs = needOnlyOnePath ? new BiDirectionalBFSImpl.SinglePathBiDirectionalBFS(-1L, -1L, types, direction, maxDepth, read, nodeCursor, relCursor, memoryTracker, null, null, allowZeroLength) : (stopAsapAtIntersect ? new BiDirectionalBFSImpl.LazyMultiPathBiDirectionalBFS(-1L, -1L, types, direction, maxDepth, read, nodeCursor, relCursor, memoryTracker, null, null, allowZeroLength) : new BiDirectionalBFSImpl.EagerMultiPathBiDirectionalBFS(-1L, -1L, types, direction, maxDepth, read, nodeCursor, relCursor, memoryTracker, null, null, allowZeroLength));
        bfs.algorithmState = State.NOT_INITIALIZED_WITH_NODES;
        return new BiDirectionalBFS(bfs);
    }

    public static BiDirectionalBFS newEmptyBiDirectionalBFS(int[] types, Direction direction, int maxDepth, boolean stopAsapAtIntersect, Read read, MemoryTracker memoryTracker, boolean needOnlyOnePath, boolean allowZeroLength) {
        BiDirectionalBFSImpl bfs = needOnlyOnePath ? new BiDirectionalBFSImpl.SinglePathBiDirectionalBFS(-1L, -1L, types, direction, maxDepth, read, null, null, memoryTracker, null, null, allowZeroLength) : (stopAsapAtIntersect ? new BiDirectionalBFSImpl.LazyMultiPathBiDirectionalBFS(-1L, -1L, types, direction, maxDepth, read, null, null, memoryTracker, null, null, allowZeroLength) : new BiDirectionalBFSImpl.EagerMultiPathBiDirectionalBFS(-1L, -1L, types, direction, maxDepth, read, null, null, memoryTracker, null, null, allowZeroLength));
        bfs.algorithmState = State.NOT_INITIALIZED_WITH_NODES;
        return new BiDirectionalBFS(bfs);
    }

    public void resetForNewRow(long sourceNodeId, long targetNodeId, LongPredicate nodeFilter, Predicate<RelationshipTraversalCursor> relFilter) {
        this.inner.resetForNewRow(sourceNodeId, targetNodeId, nodeFilter, relFilter);
    }

    public void resetForNewRow(long sourceNodeId, long targetNodeId, NodeCursor nodeCursor, RelationshipTraversalCursor relCursor, LongPredicate nodeFilter, Predicate<RelationshipTraversalCursor> relFilter) {
        this.inner.resetForNewRow(sourceNodeId, targetNodeId, nodeCursor, relCursor, nodeFilter, relFilter);
    }

    public Iterator<PathReference> shortestPathIterator() {
        return this.inner.shortestPathIterator();
    }

    @Override
    public void close() {
        this.inner.close();
    }

    public void setTracer(KernelReadTracer tracer) {
        this.inner.setTracer(tracer);
    }
}

