/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.helpers.traversal.ppbfs;

import java.util.BitSet;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.neo4j.memory.HeapEstimator;

public class Lengths
extends BitSet {
    private static final int FACTOR = Type.values().length;
    public static final int NONE = -1;
    public static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(Lengths.class) + HeapEstimator.sizeOfLongArray((int)1);

    public boolean get(int index, Type type) {
        return this.get(index * FACTOR + type.offset);
    }

    public void set(int index, Type type) {
        this.set(index * FACTOR + type.offset);
    }

    public void clear(int index, Type type) {
        this.clear(index * FACTOR + type.offset);
    }

    public int max(Type type) {
        return this.stream(type).max().orElse(-1);
    }

    public int next(int start, Type type) {
        int i = this.nextSetBit(start * FACTOR + type.offset);
        while (i != -1) {
            if (i % FACTOR == type.offset) {
                return i / FACTOR;
            }
            i = this.nextSetBit(i + 1);
        }
        return -1;
    }

    public int min(Type type) {
        return this.next(0, type);
    }

    public boolean isEmpty(Type type) {
        if (this.isEmpty()) {
            return true;
        }
        return this.min(type) == -1;
    }

    private IntStream stream(Type type) {
        return this.stream().filter(i -> i % FACTOR == type.offset).map(i -> i / FACTOR);
    }

    public String renderSourceLengths() {
        return this.stream(Type.Source).mapToObj(i -> i + (this.get(i, Type.ConfirmedSource) ? "\u2713" : "?")).collect(Collectors.joining(",", "{", "}"));
    }

    public static enum Type {
        Source(0),
        ConfirmedSource(1);

        private final int offset;

        private Type(int offset) {
            this.offset = offset;
        }
    }
}

