/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.impl.StandardExpander;
import org.neo4j.graphdb.traversal.BranchState;
import org.neo4j.internal.helpers.collection.NestingResourceIterator;
import org.neo4j.internal.helpers.collection.ResourceClosingIterator;

public final class OrderedByTypeExpander
extends StandardExpander.RegularExpander {
    private final Collection<DirectedRelationshipType> orderedTypes;

    public OrderedByTypeExpander() {
        this(Collections.emptyList());
    }

    private OrderedByTypeExpander(Collection<DirectedRelationshipType> orderedTypes) {
        super(Collections.emptyMap());
        this.orderedTypes = orderedTypes;
    }

    @Override
    public StandardExpander add(RelationshipType type, Direction direction) {
        ArrayList<DirectedRelationshipType> newTypes = new ArrayList<DirectedRelationshipType>(this.orderedTypes);
        newTypes.add(new DirectedRelationshipType(type, direction));
        return new OrderedByTypeExpander(newTypes);
    }

    @Override
    public StandardExpander remove(RelationshipType type) {
        ArrayList<DirectedRelationshipType> newTypes = new ArrayList<DirectedRelationshipType>();
        for (DirectedRelationshipType directedType : this.orderedTypes) {
            if (type.name().equals(directedType.type.name())) continue;
            newTypes.add(directedType);
        }
        return new OrderedByTypeExpander(newTypes);
    }

    @Override
    void buildString(StringBuilder result) {
        result.append(this.orderedTypes);
    }

    @Override
    public StandardExpander reverse() {
        ArrayList<DirectedRelationshipType> newTypes = new ArrayList<DirectedRelationshipType>(this.orderedTypes.size());
        for (DirectedRelationshipType directedType : this.orderedTypes) {
            newTypes.add(directedType.reverse());
        }
        return new OrderedByTypeExpander(newTypes);
    }

    @Override
    StandardExpander.RegularExpander createNew(Map<Direction, RelationshipType[]> newTypes) {
        throw new UnsupportedOperationException();
    }

    @Override
    ResourceIterator<Relationship> doExpand(Path path, BranchState state) {
        final Node node = path.endNode();
        return new NestingResourceIterator<Relationship, DirectedRelationshipType>(this.orderedTypes.iterator()){

            protected ResourceIterator<Relationship> createNestedIterator(DirectedRelationshipType directedType) {
                RelationshipType type = directedType.type();
                Direction dir = directedType.direction();
                ResourceIterable<Relationship> relationships = dir == Direction.BOTH ? node.getRelationships(type) : node.getRelationships(dir, type);
                return ResourceClosingIterator.fromResourceIterable(relationships);
            }
        };
    }

    private record DirectedRelationshipType(RelationshipType type, Direction direction) {
        DirectedRelationshipType reverse() {
            return new DirectedRelationshipType(this.type, this.direction.reverse());
        }
    }
}

