/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.connectors.kafka.sink;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.kafka.connect.sink.ErrantRecordReporter;
import org.apache.kafka.connect.sink.SinkRecord;
import org.apache.kafka.connect.sink.SinkTask;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neo4j.connectors.kafka.configuration.helpers.VersionUtil;
import org.neo4j.connectors.kafka.sink.ChangeQuery;
import org.neo4j.connectors.kafka.sink.SinkConfiguration;
import org.neo4j.connectors.kafka.sink.SinkMessage;
import org.neo4j.connectors.kafka.sink.SinkStrategyHandler;
import org.neo4j.driver.Bookmark;
import org.neo4j.driver.Driver;
import org.neo4j.driver.Session;
import org.neo4j.driver.Transaction;
import org.neo4j.driver.TransactionWork;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u000b\u001a\u00020\bH\u0016J\u001e\u0010\f\u001a\u00020\r2\u0014\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007H\u0016J\b\u0010\u000f\u001a\u00020\rH\u0016J\u0018\u0010\u0010\u001a\u00020\r2\u000e\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u0012H\u0016J\u001e\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/neo4j/connectors/kafka/sink/Neo4jSinkTask;", "Lorg/apache/kafka/connect/sink/SinkTask;", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "settings", "", "", "config", "Lorg/neo4j/connectors/kafka/sink/SinkConfiguration;", "version", "start", "", "props", "stop", "put", "records", "", "Lorg/apache/kafka/connect/sink/SinkRecord;", "processMessages", "handler", "Lorg/neo4j/connectors/kafka/sink/SinkStrategyHandler;", "messages", "", "Lorg/neo4j/connectors/kafka/sink/SinkMessage;", "sink"})
@SourceDebugExtension(value={"SMAP\nNeo4jSinkTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Neo4jSinkTask.kt\norg/neo4j/connectors/kafka/sink/Neo4jSinkTask\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,85:1\n1563#2:86\n1634#2,3:87\n1491#2:90\n1516#2,3:91\n1519#2,3:101\n1252#2,4:106\n1869#2:112\n1374#2:113\n1460#2,5:114\n1870#2:119\n1869#2,2:120\n1869#2,2:122\n1869#2,2:124\n382#3,7:94\n478#3:104\n424#3:105\n216#4,2:110\n*S KotlinDebug\n*F\n+ 1 Neo4jSinkTask.kt\norg/neo4j/connectors/kafka/sink/Neo4jSinkTask\n*L\n46#1:86\n46#1:87,3\n47#1:90\n47#1:91,3\n47#1:101,3\n48#1:106,4\n57#1:112\n65#1:113\n65#1:114,5\n57#1:119\n71#1:120,2\n73#1:122,2\n60#1:124,2\n47#1:94,7\n48#1:104\n48#1:105\n49#1:110,2\n*E\n"})
public final class Neo4jSinkTask
extends SinkTask {
    @NotNull
    private final Logger log;
    private Map<String, String> settings;
    private SinkConfiguration config;

    public Neo4jSinkTask() {
        Logger logger = LoggerFactory.getLogger(Neo4jSinkTask.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.log = logger;
    }

    @NotNull
    public String version() {
        return VersionUtil.INSTANCE.version(Neo4jSinkTask.class);
    }

    public void start(@Nullable Map<String, String> props) {
        this.log.info("starting");
        Map<String, String> map = props;
        Intrinsics.checkNotNull(map);
        this.settings = map;
        Map<String, String> map2 = this.settings;
        if (map2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
            map2 = null;
        }
        this.config = new SinkConfiguration(map2);
    }

    public void stop() {
        SinkConfiguration sinkConfiguration = this.config;
        if (sinkConfiguration == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"config");
            sinkConfiguration = null;
        }
        sinkConfiguration.close();
    }

    /*
     * WARNING - void declaration
     */
    public void put(@Nullable Collection<? extends SinkRecord> records) {
        if (records != null) {
            void $this$forEach$iv;
            void $this$associateByTo$iv$iv$iv;
            void $this$mapKeysTo$iv$iv;
            Map $this$mapKeys$iv;
            Object value$iv$iv$iv;
            Object key$iv$iv$iv;
            Object element$iv$iv2;
            void $this$groupByTo$iv$iv;
            Object object;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = records;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                SinkRecord sinkRecord = (SinkRecord)item$iv$iv;
                object = destination$iv$iv;
                boolean bl = false;
                object.add(new SinkMessage((SinkRecord)it));
            }
            Iterable $this$groupBy$iv = (List)destination$iv$iv;
            boolean $i$f$groupBy22 = false;
            destination$iv$iv = $this$groupBy$iv;
            Map destination$iv$iv2 = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv2 : $this$groupByTo$iv$iv) {
                Object object2;
                void $this$getOrPut$iv$iv$iv;
                SinkMessage it = (SinkMessage)element$iv$iv2;
                boolean bl = false;
                String key$iv$iv = it.getTopic();
                Map map = destination$iv$iv2;
                key$iv$iv$iv = key$iv$iv;
                boolean $i$f$getOrPut = false;
                value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl2 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv, answer$iv$iv$iv);
                    object2 = answer$iv$iv$iv;
                } else {
                    object2 = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object2;
                list$iv$iv.add(element$iv$iv2);
            }
            Map $i$f$groupBy22 = destination$iv$iv2;
            boolean $i$f$mapKeys = false;
            destination$iv$iv2 = $this$mapKeys$iv;
            Map destination$iv$iv3 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
            boolean $i$f$mapKeysTo = false;
            element$iv$iv2 = $this$mapKeysTo$iv$iv.entrySet();
            Map destination$iv$iv$iv = destination$iv$iv3;
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void it$iv$iv;
                void it;
                key$iv$iv$iv = (Map.Entry)element$iv$iv$iv;
                object = destination$iv$iv$iv;
                boolean bl = false;
                SinkConfiguration sinkConfiguration = this.config;
                if (sinkConfiguration == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"config");
                    sinkConfiguration = null;
                }
                value$iv$iv$iv = (Map.Entry)element$iv$iv$iv;
                SinkStrategyHandler sinkStrategyHandler = (SinkStrategyHandler)MapsKt.getValue(sinkConfiguration.getTopicHandlers(), it.getKey());
                Object object3 = object;
                boolean bl3 = false;
                Object v = it$iv$iv.getValue();
                object3.put(sinkStrategyHandler, v);
            }
            $this$mapKeys$iv = destination$iv$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv;
                Map.Entry entry = element$iv = iterator.next();
                boolean bl = false;
                SinkStrategyHandler handler = (SinkStrategyHandler)entry.getKey();
                List messages = (List)entry.getValue();
                this.processMessages(handler, messages);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void processMessages(SinkStrategyHandler handler, List<SinkMessage> messages) {
        Set handled = new LinkedHashSet();
        try {
            Iterable<Iterable<ChangeQuery>> txGroups;
            Iterable<Iterable<ChangeQuery>> $this$forEach$iv = txGroups = handler.handle((Iterable<SinkMessage>)messages);
            boolean $i$f$forEach = false;
            Iterator<Iterable<ChangeQuery>> iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                void $this$flatMapTo$iv$iv;
                void $this$flatMap$iv;
                Session session;
                Iterable<ChangeQuery> element$iv;
                Iterable<ChangeQuery> group = element$iv = iterator.next();
                boolean bl = false;
                SinkConfiguration sinkConfiguration = this.config;
                if (sinkConfiguration == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"config");
                    sinkConfiguration = null;
                }
                Driver driver = sinkConfiguration.getDriver();
                SinkConfiguration sinkConfiguration2 = this.config;
                if (sinkConfiguration2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"config");
                    sinkConfiguration2 = null;
                }
                Object object = (AutoCloseable)driver.session(sinkConfiguration2.sessionConfig(new Bookmark[0]));
                Throwable throwable = null;
                try {
                    session = (Session)object;
                    boolean bl2 = false;
                    TransactionWork transactionWork = arg_0 -> Neo4jSinkTask.processMessages$lambda$0$0$0(group, arg_0);
                    SinkConfiguration sinkConfiguration3 = this.config;
                    if (sinkConfiguration3 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"config");
                        sinkConfiguration3 = null;
                    }
                    session.writeTransaction(transactionWork, sinkConfiguration3.txConfig());
                    session = Unit.INSTANCE;
                }
                catch (Throwable bl2) {
                    throwable = bl2;
                    throw bl2;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)object, (Throwable)throwable);
                }
                object = group;
                Set set = handled;
                boolean $i$f$flatMap = false;
                session = $this$flatMap$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$flatMapTo = false;
                for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                    ChangeQuery it = (ChangeQuery)element$iv$iv;
                    boolean bl3 = false;
                    Iterable<SinkMessage> list$iv$iv = it.getMessages();
                    CollectionsKt.addAll((Collection)destination$iv$iv, list$iv$iv);
                }
                set.addAll((List)destination$iv$iv);
            }
        }
        catch (Throwable e) {
            List unhandled = CollectionsKt.minus((Iterable)messages, (Iterable)handled);
            if (unhandled.size() > 1) {
                Iterable $this$forEach$iv = unhandled;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    SinkMessage m = (SinkMessage)element$iv;
                    boolean bl = false;
                    this.processMessages(handler, CollectionsKt.listOf((Object)m));
                }
            } else {
                Iterable $this$forEach$iv = unhandled;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    SinkMessage m = (SinkMessage)element$iv;
                    boolean bl = false;
                    ErrantRecordReporter reporter = this.context.errantRecordReporter();
                    if (reporter != null) {
                        Void cfr_ignored_0 = (Void)reporter.report(m.getRecord(), e).get();
                        continue;
                    }
                    throw e;
                }
            }
        }
    }

    private static final Unit processMessages$lambda$0$0$0(Iterable $group, Transaction tx) {
        Iterable $this$forEach$iv = $group;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ChangeQuery it = (ChangeQuery)element$iv;
            boolean bl = false;
            tx.run(it.getQuery()).consume();
        }
        return Unit.INSTANCE;
    }
}

