/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.connectors.kafka.sink.converters;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.errors.DataException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\b\u0006\b&\u0018\u0000 E*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001EB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\r\u0010\u0005\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010\u0006J)\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00018\u00002\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u000bH$\u00a2\u0006\u0002\u0010\rJ)\u0010\u000e\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00018\u00002\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u000fH$\u00a2\u0006\u0002\u0010\u0010J'\u0010\u0011\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00018\u00002\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0012H$\u00a2\u0006\u0002\u0010\u0013J'\u0010\u0014\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00018\u00002\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0015H$\u00a2\u0006\u0002\u0010\u0016J'\u0010\u0017\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00018\u00002\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0015H$\u00a2\u0006\u0002\u0010\u0016J'\u0010\u0018\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00018\u00002\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0015H$\u00a2\u0006\u0002\u0010\u0016J'\u0010\u0019\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00018\u00002\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u001aH$\u00a2\u0006\u0002\u0010\u001bJ'\u0010\u001c\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00018\u00002\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u001dH$\u00a2\u0006\u0002\u0010\u001eJ)\u0010\u001f\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00018\u00002\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010 H$\u00a2\u0006\u0002\u0010!J'\u0010\"\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00018\u00002\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020#H$\u00a2\u0006\u0002\u0010$J)\u0010%\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00018\u00002\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010&H$\u00a2\u0006\u0002\u0010'J'\u0010(\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00018\u00002\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020)H$\u00a2\u0006\u0002\u0010*J'\u0010+\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00018\u00002\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020,H$\u00a2\u0006\u0002\u0010-J'\u0010.\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00018\u00002\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020/H$\u00a2\u0006\u0002\u00100J;\u00101\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00018\u00002\u0006\u0010\n\u001a\u00020\u000b2\b\u00102\u001a\u0004\u0018\u0001032\u0010\u00104\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0018\u000105H$\u00a2\u0006\u0002\u00106JC\u00107\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00018\u00002\u0006\u0010\n\u001a\u00020\u000b2\b\u00102\u001a\u0004\u0018\u0001032\u0018\u00108\u001a\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0018\u000109H$\u00a2\u0006\u0002\u0010:J\u001f\u0010;\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00018\u00002\u0006\u0010\n\u001a\u00020\u000bH$\u00a2\u0006\u0002\u0010<J\u0013\u0010=\u001a\u00028\u00002\u0006\u0010\f\u001a\u00020\u0002\u00a2\u0006\u0002\u0010>J#\u0010?\u001a\u00020\b2\u0006\u0010\t\u001a\u00028\u00002\u000e\u0010\f\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030@\u00a2\u0006\u0002\u0010AJ\u001b\u0010B\u001a\u00020\b2\u0006\u0010\t\u001a\u00028\u00002\u0006\u0010C\u001a\u00020/\u00a2\u0006\u0002\u0010D\u00a8\u0006F"}, d2={"Lorg/neo4j/connectors/kafka/sink/converters/ValueConverter;", "T", "", "<init>", "()V", "newValue", "()Ljava/lang/Object;", "setStringField", "", "result", "fieldName", "", "value", "(Ljava/lang/Object;Ljava/lang/String;Ljava/lang/String;)V", "setFloat32Field", "", "(Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Float;)V", "setFloat64Field", "", "(Ljava/lang/Object;Ljava/lang/String;D)V", "setTimestampField", "Ljava/util/Date;", "(Ljava/lang/Object;Ljava/lang/String;Ljava/util/Date;)V", "setDateField", "setTimeField", "setInt8Field", "", "(Ljava/lang/Object;Ljava/lang/String;B)V", "setInt16Field", "", "(Ljava/lang/Object;Ljava/lang/String;S)V", "setInt32Field", "", "(Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Integer;)V", "setInt64Field", "", "(Ljava/lang/Object;Ljava/lang/String;J)V", "setBytesField", "", "(Ljava/lang/Object;Ljava/lang/String;[B)V", "setDecimalField", "Ljava/math/BigDecimal;", "(Ljava/lang/Object;Ljava/lang/String;Ljava/math/BigDecimal;)V", "setBooleanField", "", "(Ljava/lang/Object;Ljava/lang/String;Z)V", "setStructField", "Lorg/apache/kafka/connect/data/Struct;", "(Ljava/lang/Object;Ljava/lang/String;Lorg/apache/kafka/connect/data/Struct;)V", "setArray", "schema", "Lorg/apache/kafka/connect/data/Schema;", "array", "", "(Ljava/lang/Object;Ljava/lang/String;Lorg/apache/kafka/connect/data/Schema;Ljava/util/List;)V", "setMap", "map", "", "(Ljava/lang/Object;Ljava/lang/String;Lorg/apache/kafka/connect/data/Schema;Ljava/util/Map;)V", "setNullField", "(Ljava/lang/Object;Ljava/lang/String;)V", "convert", "(Ljava/lang/Object;)Ljava/lang/Object;", "convertMap", "", "(Ljava/lang/Object;Ljava/util/Map;)V", "convertStruct", "struct", "(Ljava/lang/Object;Lorg/apache/kafka/connect/data/Struct;)V", "Companion", "sink"})
public abstract class ValueConverter<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final Logger log = LoggerFactory.getLogger(ValueConverter.class);

    protected abstract T newValue();

    protected abstract void setStringField(@Nullable T var1, @NotNull String var2, @Nullable String var3);

    protected abstract void setFloat32Field(@Nullable T var1, @NotNull String var2, @Nullable Float var3);

    protected abstract void setFloat64Field(@Nullable T var1, @NotNull String var2, double var3);

    protected abstract void setTimestampField(@Nullable T var1, @NotNull String var2, @NotNull Date var3);

    protected abstract void setDateField(@Nullable T var1, @NotNull String var2, @NotNull Date var3);

    protected abstract void setTimeField(@Nullable T var1, @NotNull String var2, @NotNull Date var3);

    protected abstract void setInt8Field(@Nullable T var1, @NotNull String var2, byte var3);

    protected abstract void setInt16Field(@Nullable T var1, @NotNull String var2, short var3);

    protected abstract void setInt32Field(@Nullable T var1, @NotNull String var2, @Nullable Integer var3);

    protected abstract void setInt64Field(@Nullable T var1, @NotNull String var2, long var3);

    protected abstract void setBytesField(@Nullable T var1, @NotNull String var2, @Nullable byte[] var3);

    protected abstract void setDecimalField(@Nullable T var1, @NotNull String var2, @NotNull BigDecimal var3);

    protected abstract void setBooleanField(@Nullable T var1, @NotNull String var2, boolean var3);

    protected abstract void setStructField(@Nullable T var1, @NotNull String var2, @NotNull Struct var3);

    protected abstract void setArray(@Nullable T var1, @NotNull String var2, @Nullable Schema var3, @Nullable List<Object> var4);

    protected abstract void setMap(@Nullable T var1, @NotNull String var2, @Nullable Schema var3, @Nullable Map<Object, Object> var4);

    protected abstract void setNullField(@Nullable T var1, @NotNull String var2);

    public final T convert(@NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        T result = this.newValue();
        Object object = value;
        if (object instanceof Struct) {
            this.convertStruct(result, (Struct)value);
        } else if (object instanceof Map) {
            this.convertMap(result, (Map)value);
        } else {
            String string = "Only Schema (%s) or Schema less (%s) are supported. %s is not a supported type.";
            Object[] objectArray = new Object[]{Struct.class.getName(), Map.class.getName(), value.getClass().getName()};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            throw new DataException(string2);
        }
        return result;
    }

    public final void convertMap(T result, @NotNull Map<?, ?> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        for (Object key : value.keySet()) {
            Intrinsics.checkNotNull(key, (String)"null cannot be cast to non-null type kotlin.String");
            String fieldName = (String)key;
            Object fieldValue = value.get(key);
            try {
                if (fieldValue == null) {
                    log.trace("convertMap() - Setting '{}' to null.", (Object)fieldName);
                    this.setNullField(result, fieldName);
                    continue;
                }
                if (fieldValue instanceof String) {
                    log.trace("convertMap() - Processing '{}' as string.", (Object)fieldName);
                    this.setStringField(result, fieldName, (String)fieldValue);
                    continue;
                }
                if (fieldValue instanceof Byte) {
                    log.trace("convertMap() - Processing '{}' as int8.", (Object)fieldName);
                    this.setInt8Field(result, fieldName, ((Number)fieldValue).byteValue());
                    continue;
                }
                if (fieldValue instanceof Short) {
                    log.trace("convertMap() - Processing '{}' as int16.", (Object)fieldName);
                    this.setInt16Field(result, fieldName, ((Number)fieldValue).shortValue());
                    continue;
                }
                if (fieldValue instanceof Integer) {
                    log.trace("convertMap() - Processing '{}' as int32.", (Object)fieldName);
                    this.setInt32Field(result, fieldName, (Integer)fieldValue);
                    continue;
                }
                if (fieldValue instanceof Long) {
                    log.trace("convertMap() - Processing '{}' as long.", (Object)fieldName);
                    this.setInt64Field(result, fieldName, ((Number)fieldValue).longValue());
                    continue;
                }
                if (fieldValue instanceof BigInteger) {
                    log.trace("convertMap() - Processing '{}' as long.", (Object)fieldName);
                    this.setInt64Field(result, fieldName, ((BigInteger)fieldValue).longValue());
                    continue;
                }
                if (fieldValue instanceof Double) {
                    log.trace("convertMap() - Processing '{}' as float64.", (Object)fieldName);
                    this.setFloat64Field(result, fieldName, ((Number)fieldValue).doubleValue());
                    continue;
                }
                if (fieldValue instanceof Float) {
                    log.trace("convertMap() - Processing '{}' as float32.", (Object)fieldName);
                    this.setFloat32Field(result, fieldName, (Float)fieldValue);
                    continue;
                }
                if (fieldValue instanceof BigDecimal) {
                    log.trace("convertMap() - Processing '{}' as decimal.", (Object)fieldName);
                    this.setDecimalField(result, fieldName, (BigDecimal)fieldValue);
                    continue;
                }
                if (fieldValue instanceof Boolean) {
                    log.trace("convertMap() - Processing '{}' as boolean.", (Object)fieldName);
                    this.setBooleanField(result, fieldName, (Boolean)fieldValue);
                    continue;
                }
                if (fieldValue instanceof Date) {
                    log.trace("convertMap() - Processing '{}' as timestamp.", (Object)fieldName);
                    this.setTimestampField(result, fieldName, (Date)fieldValue);
                    continue;
                }
                if (fieldValue instanceof byte[]) {
                    log.trace("convertMap() - Processing '{}' as bytes.", (Object)fieldName);
                    this.setBytesField(result, fieldName, (byte[])fieldValue);
                    continue;
                }
                if (fieldValue instanceof List) {
                    log.trace("convertMap() - Processing '{}' as array.", (Object)fieldName);
                    this.setArray(result, fieldName, null, TypeIntrinsics.asMutableList(fieldValue));
                    continue;
                }
                if (fieldValue instanceof Map) {
                    log.trace("convertMap() - Processing '{}' as map.", (Object)fieldName);
                    this.setMap(result, fieldName, null, TypeIntrinsics.asMutableMap(fieldValue));
                    continue;
                }
                String string = "%s is not a supported data type.";
                Object[] objectArray = new Object[]{fieldValue.getClass().getName()};
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                throw new DataException(string2);
            }
            catch (Exception ex) {
                String string = "Exception thrown while processing field '%s'";
                Object[] objectArray = new Object[]{fieldName};
                String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
                throw new DataException(string3, (Throwable)ex);
            }
        }
    }

    public final void convertStruct(T result, @NotNull Struct struct) {
        Intrinsics.checkNotNullParameter((Object)struct, (String)"struct");
        Schema schema = struct.schema();
        block16: for (Field field : schema.fields()) {
            String fieldName = field.name();
            log.trace("convertStruct() - Processing '{}'", (Object)field.name());
            Object fieldValue = struct.get(field);
            try {
                if (fieldValue == null) {
                    log.trace("convertStruct() - Setting '{}' to null.", (Object)fieldName);
                    Intrinsics.checkNotNull((Object)fieldName);
                    this.setNullField(result, fieldName);
                    continue;
                }
                log.trace("convertStruct() - Field '{}'.field().schema().type() = '{}'", (Object)fieldName, (Object)field.schema().type());
                Schema.Type type = field.schema().type();
                switch (type == null ? -1 : WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                    case 1: {
                        log.trace("convertStruct() - Processing '{}' as string.", (Object)fieldName);
                        Intrinsics.checkNotNull((Object)fieldName);
                        this.setStringField(result, fieldName, (String)fieldValue);
                        continue block16;
                    }
                    case 2: {
                        log.trace("convertStruct() - Processing '{}' as int8.", (Object)fieldName);
                        Intrinsics.checkNotNull((Object)fieldName);
                        this.setInt8Field(result, fieldName, (Byte)fieldValue);
                        continue block16;
                    }
                    case 3: {
                        log.trace("convertStruct() - Processing '{}' as int16.", (Object)fieldName);
                        Intrinsics.checkNotNull((Object)fieldName);
                        this.setInt16Field(result, fieldName, (Short)fieldValue);
                        continue block16;
                    }
                    case 4: {
                        if (Intrinsics.areEqual((Object)"org.apache.kafka.connect.data.Date", (Object)field.schema().name())) {
                            log.trace("convertStruct() - Processing '{}' as date.", (Object)fieldName);
                            Intrinsics.checkNotNull((Object)fieldName);
                            this.setDateField(result, fieldName, (Date)fieldValue);
                            continue block16;
                        }
                        if (Intrinsics.areEqual((Object)"org.apache.kafka.connect.data.Time", (Object)field.schema().name())) {
                            log.trace("convertStruct() - Processing '{}' as time.", (Object)fieldName);
                            Intrinsics.checkNotNull((Object)fieldName);
                            this.setTimeField(result, fieldName, (Date)fieldValue);
                            continue block16;
                        }
                        int int32Value = (Integer)fieldValue;
                        log.trace("convertStruct() - Processing '{}' as int32.", (Object)fieldName);
                        Intrinsics.checkNotNull((Object)fieldName);
                        this.setInt32Field(result, fieldName, int32Value);
                        continue block16;
                    }
                    case 5: {
                        if (Intrinsics.areEqual((Object)"org.apache.kafka.connect.data.Timestamp", (Object)field.schema().name())) {
                            log.trace("convertStruct() - Processing '{}' as timestamp.", (Object)fieldName);
                            Intrinsics.checkNotNull((Object)fieldName);
                            this.setTimestampField(result, fieldName, (Date)fieldValue);
                            continue block16;
                        }
                        long int64Value = (Long)fieldValue;
                        log.trace("convertStruct() - Processing '{}' as int64.", (Object)fieldName);
                        Intrinsics.checkNotNull((Object)fieldName);
                        this.setInt64Field(result, fieldName, int64Value);
                        continue block16;
                    }
                    case 6: {
                        if (Intrinsics.areEqual((Object)"org.apache.kafka.connect.data.Decimal", (Object)field.schema().name())) {
                            log.trace("convertStruct() - Processing '{}' as decimal.", (Object)fieldName);
                            Intrinsics.checkNotNull((Object)fieldName);
                            this.setDecimalField(result, fieldName, (BigDecimal)fieldValue);
                            continue block16;
                        }
                        byte[] bytes = (byte[])fieldValue;
                        log.trace("convertStruct() - Processing '{}' as bytes.", (Object)fieldName);
                        Intrinsics.checkNotNull((Object)fieldName);
                        this.setBytesField(result, fieldName, bytes);
                        continue block16;
                    }
                    case 7: {
                        log.trace("convertStruct() - Processing '{}' as float32.", (Object)fieldName);
                        Intrinsics.checkNotNull((Object)fieldName);
                        this.setFloat32Field(result, fieldName, (Float)fieldValue);
                        continue block16;
                    }
                    case 8: {
                        log.trace("convertStruct() - Processing '{}' as float64.", (Object)fieldName);
                        Intrinsics.checkNotNull((Object)fieldName);
                        this.setFloat64Field(result, fieldName, (Double)fieldValue);
                        continue block16;
                    }
                    case 9: {
                        log.trace("convertStruct() - Processing '{}' as boolean.", (Object)fieldName);
                        Intrinsics.checkNotNull((Object)fieldName);
                        this.setBooleanField(result, fieldName, (Boolean)fieldValue);
                        continue block16;
                    }
                    case 10: {
                        log.trace("convertStruct() - Processing '{}' as struct.", (Object)fieldName);
                        Intrinsics.checkNotNull((Object)fieldName);
                        this.setStructField(result, fieldName, (Struct)fieldValue);
                        continue block16;
                    }
                    case 11: {
                        log.trace("convertStruct() - Processing '{}' as array.", (Object)fieldName);
                        Intrinsics.checkNotNull((Object)fieldName);
                        this.setArray(result, fieldName, schema, TypeIntrinsics.asMutableList((Object)fieldValue));
                        continue block16;
                    }
                    case 12: {
                        log.trace("convertStruct() - Processing '{}' as map.", (Object)fieldName);
                        Intrinsics.checkNotNull((Object)fieldName);
                        this.setMap(result, fieldName, schema, TypeIntrinsics.asMutableMap((Object)fieldValue));
                        continue block16;
                    }
                }
                throw new DataException("Unsupported schema.type(): " + schema.type());
            }
            catch (Exception ex) {
                String string = "Exception thrown while processing field '%s'";
                Object[] objectArray = new Object[]{fieldName};
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                throw new DataException(string2, (Throwable)ex);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/neo4j/connectors/kafka/sink/converters/ValueConverter$Companion;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "sink"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Schema.Type.values().length];
            try {
                nArray[Schema.Type.STRING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Schema.Type.INT8.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Schema.Type.INT16.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Schema.Type.INT32.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Schema.Type.INT64.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Schema.Type.BYTES.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Schema.Type.FLOAT32.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Schema.Type.FLOAT64.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Schema.Type.BOOLEAN.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Schema.Type.STRUCT.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Schema.Type.ARRAY.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Schema.Type.MAP.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

