/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.connectors.kafka.sink.strategy;

import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.apache.kafka.connect.data.Struct;
import org.jetbrains.annotations.NotNull;
import org.neo4j.cdc.client.model.ChangeEvent;
import org.neo4j.connectors.kafka.data.ChangeEventExtensionsKt;
import org.neo4j.connectors.kafka.data.StreamsTransactionEventExtensions;
import org.neo4j.connectors.kafka.events.StreamsTransactionEvent;
import org.neo4j.connectors.kafka.sink.SinkMessage;
import org.neo4j.connectors.kafka.sink.strategy.legacy.ConnectExtensionFunctionsKt;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0002H\u0000\u001a\u0010\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0002H\u0000\u001a\u0010\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0002H\u0000\u00a8\u0006\u0006"}, d2={"toChangeEvent", "Lorg/neo4j/cdc/client/model/ChangeEvent;", "Lorg/neo4j/connectors/kafka/sink/SinkMessage;", "parseCdcChangeEvent", "message", "parseStreamsChangeEvent", "sink"})
public final class CdcHandlerKt {
    @NotNull
    public static final ChangeEvent toChangeEvent(@NotNull SinkMessage $this$toChangeEvent) {
        Intrinsics.checkNotNullParameter((Object)$this$toChangeEvent, (String)"<this>");
        return $this$toChangeEvent.isCdcMessage() ? CdcHandlerKt.parseCdcChangeEvent($this$toChangeEvent) : CdcHandlerKt.parseStreamsChangeEvent($this$toChangeEvent);
    }

    @NotNull
    public static final ChangeEvent parseCdcChangeEvent(@NotNull SinkMessage message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Class<?> value = message.getValue();
        if (!(value instanceof Struct)) {
            Class<?> clazz = value;
            throw new IllegalArgumentException("unexpected message value type " + (clazz != null && (clazz = clazz.getClass()) != null ? clazz.getName() : null) + " in " + message);
        }
        return ChangeEventExtensionsKt.toChangeEvent((Struct)((Struct)value));
    }

    @NotNull
    public static final ChangeEvent parseStreamsChangeEvent(@NotNull SinkMessage message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        StreamsTransactionEvent streamsTransactionEvent = ConnectExtensionFunctionsKt.toStreamsTransactionEvent(ConnectExtensionFunctionsKt.toStreamsSinkEntity(message.getRecord()), (Function1<? super StreamsTransactionEvent, Boolean>)((Function1)CdcHandlerKt::parseStreamsChangeEvent$lambda$0));
        if (streamsTransactionEvent == null) {
            throw new IllegalArgumentException("unsupported change event message in " + message);
        }
        StreamsTransactionEvent event = streamsTransactionEvent;
        return StreamsTransactionEventExtensions.INSTANCE.toChangeEvent(event);
    }

    private static final boolean parseStreamsChangeEvent$lambda$0(StreamsTransactionEvent streamsTransactionEvent) {
        Intrinsics.checkNotNullParameter((Object)streamsTransactionEvent, (String)"<unused var>");
        return true;
    }
}

