/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.connectors.kafka.sink.strategy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neo4j.connectors.kafka.data.ConstraintData;
import org.neo4j.connectors.kafka.sink.ChangeQuery;
import org.neo4j.connectors.kafka.sink.SinkMessage;
import org.neo4j.connectors.kafka.sink.SinkStrategy;
import org.neo4j.connectors.kafka.sink.strategy.PatternHandler;
import org.neo4j.connectors.kafka.sink.strategy.pattern.NodePattern;
import org.neo4j.connectors.kafka.sink.strategy.pattern.Pattern;
import org.neo4j.connectors.kafka.sink.strategy.pattern.PatternConstraintValidator;
import org.neo4j.connectors.kafka.sink.strategy.pattern.PropertyMapping;
import org.neo4j.cypherdsl.core.AliasedExpression;
import org.neo4j.cypherdsl.core.Cypher;
import org.neo4j.cypherdsl.core.ExposesSubqueryCall;
import org.neo4j.cypherdsl.core.Expression;
import org.neo4j.cypherdsl.core.IdentifiableElement;
import org.neo4j.cypherdsl.core.Literal;
import org.neo4j.cypherdsl.core.Named;
import org.neo4j.cypherdsl.core.Node;
import org.neo4j.cypherdsl.core.PatternElement;
import org.neo4j.cypherdsl.core.Property;
import org.neo4j.cypherdsl.core.ResultStatement;
import org.neo4j.cypherdsl.core.Statement;
import org.neo4j.cypherdsl.core.StatementBuilder;
import org.neo4j.cypherdsl.core.SymbolicName;
import org.neo4j.cypherdsl.core.renderer.Renderer;
import org.neo4j.driver.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u00013BW\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\u0004\u0012\b\b\u0002\u0010\r\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0010\u0010\u0011BY\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\u0004\u0012\b\b\u0002\u0010\r\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0010\u0010\u0012J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\"\u0010\u001b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001d0\u001c0\u001c2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001cH\u0016J\u0016\u0010 \u001a\u00020!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#H\u0016J!\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00040#2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#H\u0000\u00a2\u0006\u0002\b&J\b\u0010'\u001a\u00020\u0004H\u0002J+\u0010(\u001a\u00070)\u00a2\u0006\u0002\b*2\u0006\u0010+\u001a\u00020,2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00040.2\u0006\u0010/\u001a\u000200H\u0002J+\u00101\u001a\u00070)\u00a2\u0006\u0002\b*2\u0006\u0010+\u001a\u00020,2\f\u00102\u001a\b\u0012\u0004\u0012\u00020\u00040.2\u0006\u0010/\u001a\u000200H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0014\u00a8\u00064"}, d2={"Lorg/neo4j/connectors/kafka/sink/strategy/NodePatternHandler;", "Lorg/neo4j/connectors/kafka/sink/strategy/PatternHandler;", "Lorg/neo4j/connectors/kafka/sink/strategy/pattern/NodePattern;", "topic", "", "pattern", "mergeProperties", "", "renderer", "Lorg/neo4j/cypherdsl/core/renderer/Renderer;", "batchSize", "", "bindTimestampAs", "bindHeaderAs", "bindKeyAs", "bindValueAs", "<init>", "(Ljava/lang/String;Lorg/neo4j/connectors/kafka/sink/strategy/pattern/NodePattern;ZLorg/neo4j/cypherdsl/core/renderer/Renderer;ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "(Ljava/lang/String;Ljava/lang/String;ZLorg/neo4j/cypherdsl/core/renderer/Renderer;ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getTopic", "()Ljava/lang/String;", "logger", "Lorg/slf4j/Logger;", "query", "getQuery$sink", "strategy", "Lorg/neo4j/connectors/kafka/sink/SinkStrategy;", "handle", "", "Lorg/neo4j/connectors/kafka/sink/ChangeQuery;", "messages", "Lorg/neo4j/connectors/kafka/sink/SinkMessage;", "validate", "", "constraints", "", "Lorg/neo4j/connectors/kafka/data/ConstraintData;", "checkConstraints", "checkConstraints$sink", "buildStatement", "buildDeleteStatement", "Lorg/neo4j/cypherdsl/core/ResultStatement;", "Lorg/jetbrains/annotations/NotNull;", "event", "Lorg/neo4j/cypherdsl/core/SymbolicName;", "deleteOperation", "Lorg/neo4j/cypherdsl/core/Literal;", "node", "Lorg/neo4j/cypherdsl/core/Node;", "buildCreateStatement", "createOperation", "MessageToEventList", "sink"})
@SourceDebugExtension(value={"SMAP\nNodePatternHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NodePatternHandler.kt\norg/neo4j/connectors/kafka/sink/strategy/NodePatternHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,214:1\n1869#2,2:215\n1193#2,2:217\n1267#2,4:219\n1563#2:223\n1634#2,3:224\n1563#2:227\n1634#2,3:228\n*S KotlinDebug\n*F\n+ 1 NodePatternHandler.kt\norg/neo4j/connectors/kafka/sink/strategy/NodePatternHandler\n*L\n138#1:215,2\n155#1:217,2\n155#1:219,4\n127#1:223\n127#1:224,3\n128#1:227\n128#1:228,3\n*E\n"})
public final class NodePatternHandler
extends PatternHandler<NodePattern> {
    @NotNull
    private final String topic;
    private final boolean mergeProperties;
    @NotNull
    private final Renderer renderer;
    private final int batchSize;
    @NotNull
    private final Logger logger;
    @NotNull
    private final String query;

    public NodePatternHandler(@NotNull String topic, @NotNull NodePattern pattern, boolean mergeProperties, @NotNull Renderer renderer, int batchSize, @NotNull String bindTimestampAs, @NotNull String bindHeaderAs, @NotNull String bindKeyAs, @NotNull String bindValueAs) {
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        Intrinsics.checkNotNullParameter((Object)renderer, (String)"renderer");
        Intrinsics.checkNotNullParameter((Object)bindTimestampAs, (String)"bindTimestampAs");
        Intrinsics.checkNotNullParameter((Object)bindHeaderAs, (String)"bindHeaderAs");
        Intrinsics.checkNotNullParameter((Object)bindKeyAs, (String)"bindKeyAs");
        Intrinsics.checkNotNullParameter((Object)bindValueAs, (String)"bindValueAs");
        super((Pattern)pattern, bindTimestampAs, bindHeaderAs, bindKeyAs, bindValueAs);
        this.topic = topic;
        this.mergeProperties = mergeProperties;
        this.renderer = renderer;
        this.batchSize = batchSize;
        Logger logger = LoggerFactory.getLogger(this.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.logger = logger;
        this.query = this.buildStatement();
        this.logger.debug("using Cypher query '{}' for topic '{}'", (Object)this.query, (Object)this.topic);
    }

    public /* synthetic */ NodePatternHandler(String string, NodePattern nodePattern, boolean bl, Renderer renderer, int n, String string2, String string3, String string4, String string5, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 0x20) != 0) {
            string2 = "__timestamp";
        }
        if ((n2 & 0x40) != 0) {
            string3 = "__header";
        }
        if ((n2 & 0x80) != 0) {
            string4 = "__key";
        }
        if ((n2 & 0x100) != 0) {
            string5 = "__value";
        }
        this(string, nodePattern, bl, renderer, n, string2, string3, string4, string5);
    }

    @NotNull
    public final String getTopic() {
        return this.topic;
    }

    @NotNull
    public final String getQuery$sink() {
        return this.query;
    }

    public NodePatternHandler(@NotNull String topic, @NotNull String pattern, boolean mergeProperties, @NotNull Renderer renderer, int batchSize, @NotNull String bindTimestampAs, @NotNull String bindHeaderAs, @NotNull String bindKeyAs, @NotNull String bindValueAs) {
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        Intrinsics.checkNotNullParameter((Object)renderer, (String)"renderer");
        Intrinsics.checkNotNullParameter((Object)bindTimestampAs, (String)"bindTimestampAs");
        Intrinsics.checkNotNullParameter((Object)bindHeaderAs, (String)"bindHeaderAs");
        Intrinsics.checkNotNullParameter((Object)bindKeyAs, (String)"bindKeyAs");
        Intrinsics.checkNotNullParameter((Object)bindValueAs, (String)"bindValueAs");
        Pattern parsed = Pattern.Companion.parse(pattern);
        if (!(parsed instanceof NodePattern)) {
            throw new IllegalArgumentException("Invalid pattern provided for NodePatternHandler: " + parsed.getClass().getName());
        }
        this(topic, (NodePattern)parsed, mergeProperties, renderer, batchSize, bindTimestampAs, bindHeaderAs, bindKeyAs, bindValueAs);
    }

    public /* synthetic */ NodePatternHandler(String string, String string2, boolean bl, Renderer renderer, int n, String string3, String string4, String string5, String string6, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 0x20) != 0) {
            string3 = "__timestamp";
        }
        if ((n2 & 0x40) != 0) {
            string4 = "__header";
        }
        if ((n2 & 0x80) != 0) {
            string5 = "__key";
        }
        if ((n2 & 0x100) != 0) {
            string6 = "__value";
        }
        this(string, string2, bl, renderer, n, string3, string4, string5, string6);
    }

    @Override
    @NotNull
    public SinkStrategy strategy() {
        return SinkStrategy.NODE_PATTERN;
    }

    @Override
    @NotNull
    public Iterable<Iterable<ChangeQuery>> handle(@NotNull Iterable<SinkMessage> messages) {
        Intrinsics.checkNotNullParameter(messages, (String)"messages");
        return SequencesKt.toList((Sequence)SequencesKt.onEach((Sequence)SequencesKt.map((Sequence)SequencesKt.chunked((Sequence)SequencesKt.map((Sequence)SequencesKt.onEach((Sequence)CollectionsKt.asSequence(messages), arg_0 -> NodePatternHandler.handle$lambda$0(this, arg_0)), arg_0 -> NodePatternHandler.handle$lambda$1(this, arg_0)), (int)this.batchSize), arg_0 -> NodePatternHandler.handle$lambda$2(this, arg_0)), arg_0 -> NodePatternHandler.handle$lambda$3(this, arg_0)));
    }

    @Override
    public void validate(@NotNull List<ConstraintData> constraints) {
        Intrinsics.checkNotNullParameter(constraints, (String)"constraints");
        List<String> warningMessages = this.checkConstraints$sink(constraints);
        Iterable $this$forEach$iv = warningMessages;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            this.logger.warn(it);
        }
    }

    @NotNull
    public final List<String> checkConstraints$sink(@NotNull List<ConstraintData> constraints) {
        Intrinsics.checkNotNullParameter(constraints, (String)"constraints");
        String string = PatternConstraintValidator.INSTANCE.checkNodeWarning(constraints, (NodePattern)this.getPattern(), ((NodePattern)this.getPattern()).getText());
        if (string == null) {
            return CollectionsKt.emptyList();
        }
        String nodeWarning = string;
        return CollectionsKt.listOf((Object)nodeWarning);
    }

    /*
     * WARNING - void declaration
     */
    private final String buildStatement() {
        void $this$associateTo$iv$iv;
        void $this$associate$iv;
        Literal literal = Cypher.literalOf((Object)"C");
        Intrinsics.checkNotNullExpressionValue((Object)literal, (String)"literalOf(...)");
        Literal createOperation = literal;
        Literal literal2 = Cypher.literalOf((Object)"D");
        Intrinsics.checkNotNullExpressionValue((Object)literal2, (String)"literalOf(...)");
        Literal deleteOperation = literal2;
        Expression[] expressionArray = (Expression[])((NodePattern)this.getPattern()).getKeyProperties();
        Node node = Cypher.node((String)((String)CollectionsKt.first((Iterable)((NodePattern)this.getPattern()).getLabels())), (List)CollectionsKt.drop((Iterable)((NodePattern)this.getPattern()).getLabels(), (int)1));
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        void var7_8 = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            PropertyMapping it = (PropertyMapping)element$iv$iv;
            boolean bl = false;
            String[] stringArray = new String[]{"keys"};
            Property property = PatternHandler.Companion.getNAME_EVENT$sink().property(stringArray);
            stringArray = new String[]{it.getTo()};
            Pair pair = TuplesKt.to((Object)it.getTo(), (Object)property.property(stringArray));
            map.put(pair.getFirst(), pair.getSecond());
        }
        Node node2 = ((Node)node.withProperties(destination$iv$iv)).named("n");
        Intrinsics.checkNotNullExpressionValue((Object)node2, (String)"named(...)");
        Node node3 = node2;
        expressionArray = new Expression[]{PatternHandler.Companion.getNAME_CREATED$sink(), PatternHandler.Companion.getNAME_DELETED$sink()};
        Statement statement = Cypher.call((Statement)((Statement)this.buildCreateStatement(PatternHandler.Companion.getNAME_EVENT$sink(), (Literal<String>)createOperation, node3))).call((Statement)this.buildDeleteStatement(PatternHandler.Companion.getNAME_EVENT$sink(), (Literal<String>)deleteOperation, node3)).returning(expressionArray).build();
        expressionArray = new IdentifiableElement[]{PatternHandler.Companion.getNAME_EVENT$sink()};
        ExposesSubqueryCall.BuildableSubquery buildableSubquery = Cypher.unwind((Expression)((Expression)Cypher.parameter((String)"events"))).as(PatternHandler.Companion.getNAME_EVENT$sink()).call(statement, (IdentifiableElement[])expressionArray);
        expressionArray = new Expression[2];
        Object[] objectArray = new Object[]{PatternHandler.Companion.getNAME_CREATED$sink()};
        expressionArray[0] = Cypher.raw((String)"sum($E)", (Object[])objectArray).as(PatternHandler.Companion.getNAME_CREATED$sink());
        objectArray = new Object[]{PatternHandler.Companion.getNAME_DELETED$sink()};
        expressionArray[1] = Cypher.raw((String)"sum($E)", (Object[])objectArray).as(PatternHandler.Companion.getNAME_DELETED$sink());
        String string = this.renderer.render(buildableSubquery.returning(expressionArray).build());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"render(...)");
        return string;
    }

    private final ResultStatement buildDeleteStatement(SymbolicName event, Literal<String> deleteOperation, Node node) {
        SymbolicName[] symbolicNameArray = new SymbolicName[]{event};
        StatementBuilder.OrderableOngoingReadingAndWithWithoutWhere orderableOngoingReadingAndWithWithoutWhere = Cypher.with((SymbolicName[])symbolicNameArray);
        symbolicNameArray = new SymbolicName[]{event};
        StatementBuilder.OrderableOngoingReadingAndWithWithWhere orderableOngoingReadingAndWithWithWhere = orderableOngoingReadingAndWithWithoutWhere.with(symbolicNameArray).where(Cypher.valueAt((Expression)((Expression)event), (Integer)0).eq((Expression)deleteOperation));
        symbolicNameArray = new AliasedExpression[]{Cypher.valueAt((Expression)((Expression)event), (Integer)1).as(event)};
        StatementBuilder.OrderableOngoingReadingAndWithWithoutWhere orderableOngoingReadingAndWithWithoutWhere2 = orderableOngoingReadingAndWithWithWhere.with((AliasedExpression[])symbolicNameArray);
        symbolicNameArray = new PatternElement[]{node};
        StatementBuilder.OngoingReadingWithoutWhere ongoingReadingWithoutWhere = orderableOngoingReadingAndWithWithoutWhere2.match((PatternElement[])symbolicNameArray);
        symbolicNameArray = new Named[]{node};
        StatementBuilder.OngoingUpdate ongoingUpdate = ongoingReadingWithoutWhere.detachDelete((Named[])symbolicNameArray);
        symbolicNameArray = new Expression[1];
        Object[] objectArray = new Object[]{node.getRequiredSymbolicName()};
        symbolicNameArray[0] = Cypher.raw((String)"count($E)", (Object[])objectArray).as(PatternHandler.Companion.getNAME_DELETED$sink());
        Statement statement = ongoingUpdate.returning((Expression[])symbolicNameArray).build();
        Intrinsics.checkNotNullExpressionValue((Object)statement, (String)"build(...)");
        return (ResultStatement)statement;
    }

    private final ResultStatement buildCreateStatement(SymbolicName event, Literal<String> createOperation, Node node) {
        StatementBuilder.BuildableMatchAndUpdate buildableMatchAndUpdate;
        SymbolicName[] symbolicNameArray = new SymbolicName[]{event};
        StatementBuilder.OrderableOngoingReadingAndWithWithoutWhere orderableOngoingReadingAndWithWithoutWhere = Cypher.with((SymbolicName[])symbolicNameArray);
        symbolicNameArray = new SymbolicName[]{event};
        StatementBuilder.OrderableOngoingReadingAndWithWithWhere orderableOngoingReadingAndWithWithWhere = orderableOngoingReadingAndWithWithoutWhere.with(symbolicNameArray).where(Cypher.valueAt((Expression)((Expression)event), (Integer)0).eq((Expression)createOperation));
        symbolicNameArray = new AliasedExpression[]{Cypher.valueAt((Expression)((Expression)event), (Integer)1).as(event)};
        StatementBuilder.OrderableOngoingReadingAndWithWithoutWhere orderableOngoingReadingAndWithWithoutWhere2 = orderableOngoingReadingAndWithWithWhere.with((AliasedExpression[])symbolicNameArray);
        symbolicNameArray = new PatternElement[]{node};
        StatementBuilder.OngoingMerge it = orderableOngoingReadingAndWithWithoutWhere2.merge((PatternElement[])symbolicNameArray);
        boolean bl = false;
        if (this.mergeProperties) {
            String[] stringArray = new String[]{"properties"};
            buildableMatchAndUpdate = it.mutate(node.asExpression(), (Expression)Cypher.property((Expression)((Expression)PatternHandler.Companion.getNAME_EVENT$sink()), (String[])stringArray));
        } else {
            Object[] objectArray = new Expression[2];
            objectArray[0] = node.asExpression();
            String[] stringArray = new String[]{"properties"};
            objectArray[1] = Cypher.property((Expression)((Expression)PatternHandler.Companion.getNAME_EVENT$sink()), (String[])stringArray);
            StatementBuilder.BuildableMatchAndUpdate buildableMatchAndUpdate2 = it.set(objectArray);
            objectArray = new String[]{"keys"};
            buildableMatchAndUpdate = buildableMatchAndUpdate2.mutate(node.asExpression(), (Expression)Cypher.property((Expression)((Expression)PatternHandler.Companion.getNAME_EVENT$sink()), (String[])objectArray));
        }
        symbolicNameArray = new Expression[1];
        Object[] objectArray = new Object[]{node.getRequiredSymbolicName()};
        symbolicNameArray[0] = Cypher.raw((String)"count($E)", (Object[])objectArray).as(PatternHandler.Companion.getNAME_CREATED$sink());
        Statement statement = buildableMatchAndUpdate.returning((Expression[])symbolicNameArray).build();
        Intrinsics.checkNotNullExpressionValue((Object)statement, (String)"build(...)");
        return (ResultStatement)statement;
    }

    private static final Unit handle$lambda$0(NodePatternHandler this$0, SinkMessage it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.logger.trace("received message: '{}'", (Object)it);
        return Unit.INSTANCE;
    }

    private static final MessageToEventList handle$lambda$1(NodePatternHandler this$0, SinkMessage it) {
        List list;
        Object[] objectArray;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        boolean isTombstoneMessage = it.getValue() == null;
        Map<String, Object> flattened = this$0.flattenMessage(it);
        Set used = new LinkedHashSet();
        String[] stringArray = new String[]{this$0.getBindValueAs(), this$0.getBindKeyAs()};
        Map<String, Object> keys = this$0.extractKeys((Pattern)this$0.getPattern(), (Map<String, ? extends Object>)flattened, isTombstoneMessage, used, stringArray);
        if (isTombstoneMessage) {
            objectArray = new Object[]{"D", MapsKt.mapOf((Pair)TuplesKt.to((Object)"keys", keys))};
            list = CollectionsKt.listOf((Object[])objectArray);
        } else {
            objectArray = new Object[2];
            objectArray[0] = "C";
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"keys", keys), TuplesKt.to((Object)"properties", this$0.computeProperties((Pattern)this$0.getPattern(), (Map<String, ? extends Object>)flattened, used))};
            objectArray[1] = MapsKt.mapOf((Pair[])pairArray);
            list = CollectionsKt.listOf((Object[])objectArray);
        }
        List mapped = list;
        this$0.logger.trace("message '{}' mapped to: '{}'", (Object)it, (Object)mapped);
        return new MessageToEventList(it, mapped);
    }

    private static final List handle$lambda$2(NodePatternHandler this$0, List it) {
        Collection<List<Object>> collection;
        MessageToEventList data;
        Iterable iterable;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Iterable iterable2 = it;
        Integer n = null;
        Long l = null;
        boolean $i$f$map = false;
        void var4_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            MessageToEventList messageToEventList = (MessageToEventList)item$iv$iv;
            iterable = destination$iv$iv;
            boolean bl = false;
            iterable.add(data.getMessage());
        }
        iterable = (List)destination$iv$iv;
        $this$map$iv = it;
        String string = "events";
        String string2 = this$0.query;
        iterable = iterable;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            data = (MessageToEventList)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(data.getEventList());
        }
        collection = (List)destination$iv$iv;
        Map map = MapsKt.mapOf((Pair)TuplesKt.to((Object)string, (Object)collection));
        String string3 = string2;
        Query query = new Query(string3, map);
        Iterable iterable3 = iterable;
        Integer n2 = n;
        Long l2 = l;
        return CollectionsKt.listOf((Object)new ChangeQuery(l2, n2, iterable3, query));
    }

    private static final Unit handle$lambda$3(NodePatternHandler this$0, List it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.logger.trace("mapped messages: '{}'", (Object)it);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005H\u00c6\u0003J#\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lorg/neo4j/connectors/kafka/sink/strategy/NodePatternHandler$MessageToEventList;", "", "message", "Lorg/neo4j/connectors/kafka/sink/SinkMessage;", "eventList", "", "<init>", "(Lorg/neo4j/connectors/kafka/sink/SinkMessage;Ljava/util/List;)V", "getMessage", "()Lorg/neo4j/connectors/kafka/sink/SinkMessage;", "getEventList", "()Ljava/util/List;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "sink"})
    public static final class MessageToEventList {
        @NotNull
        private final SinkMessage message;
        @NotNull
        private final List<Object> eventList;

        public MessageToEventList(@NotNull SinkMessage message, @NotNull List<? extends Object> eventList) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            Intrinsics.checkNotNullParameter(eventList, (String)"eventList");
            this.message = message;
            this.eventList = eventList;
        }

        @NotNull
        public final SinkMessage getMessage() {
            return this.message;
        }

        @NotNull
        public final List<Object> getEventList() {
            return this.eventList;
        }

        @NotNull
        public final SinkMessage component1() {
            return this.message;
        }

        @NotNull
        public final List<Object> component2() {
            return this.eventList;
        }

        @NotNull
        public final MessageToEventList copy(@NotNull SinkMessage message, @NotNull List<? extends Object> eventList) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            Intrinsics.checkNotNullParameter(eventList, (String)"eventList");
            return new MessageToEventList(message, eventList);
        }

        public static /* synthetic */ MessageToEventList copy$default(MessageToEventList messageToEventList, SinkMessage sinkMessage, List list, int n, Object object) {
            if ((n & 1) != 0) {
                sinkMessage = messageToEventList.message;
            }
            if ((n & 2) != 0) {
                list = messageToEventList.eventList;
            }
            return messageToEventList.copy(sinkMessage, list);
        }

        @NotNull
        public String toString() {
            return "MessageToEventList(message=" + this.message + ", eventList=" + this.eventList + ")";
        }

        public int hashCode() {
            int result = this.message.hashCode();
            result = result * 31 + ((Object)this.eventList).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MessageToEventList)) {
                return false;
            }
            MessageToEventList messageToEventList = (MessageToEventList)other;
            if (!Intrinsics.areEqual((Object)this.message, (Object)messageToEventList.message)) {
                return false;
            }
            return Intrinsics.areEqual(this.eventList, messageToEventList.eventList);
        }
    }
}

