/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.connectors.kafka.sink.strategy.cud;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neo4j.connectors.kafka.exceptions.InvalidDataException;
import org.neo4j.connectors.kafka.sink.strategy.cud.HelpersKt;
import org.neo4j.connectors.kafka.sink.strategy.cud.NodeReference;
import org.neo4j.connectors.kafka.sink.strategy.cud.Operation;
import org.neo4j.connectors.kafka.utils.MapUtils;
import org.neo4j.cypherdsl.core.Cypher;
import org.neo4j.cypherdsl.core.Expression;
import org.neo4j.cypherdsl.core.Named;
import org.neo4j.cypherdsl.core.Node;
import org.neo4j.cypherdsl.core.Parameter;
import org.neo4j.cypherdsl.core.PatternElement;
import org.neo4j.cypherdsl.core.Relationship;
import org.neo4j.cypherdsl.core.StatementBuilder;
import org.neo4j.cypherdsl.core.renderer.Renderer;
import org.neo4j.driver.Query;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \"2\u00020\u0001:\u0001\"B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0014\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\t0\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0005H\u00c6\u0003J\u0017\u0010\u001a\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\t0\bH\u00c6\u0003J?\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\u0016\b\u0002\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\t0\bH\u00c6\u0001J\u0013\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\tH\u00d6\u0003J\t\u0010\u001f\u001a\u00020 H\u00d6\u0001J\t\u0010!\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u001f\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006#"}, d2={"Lorg/neo4j/connectors/kafka/sink/strategy/cud/CreateRelationship;", "Lorg/neo4j/connectors/kafka/sink/strategy/cud/Operation;", "type", "", "start", "Lorg/neo4j/connectors/kafka/sink/strategy/cud/NodeReference;", "end", "properties", "", "", "<init>", "(Ljava/lang/String;Lorg/neo4j/connectors/kafka/sink/strategy/cud/NodeReference;Lorg/neo4j/connectors/kafka/sink/strategy/cud/NodeReference;Ljava/util/Map;)V", "getType", "()Ljava/lang/String;", "getStart", "()Lorg/neo4j/connectors/kafka/sink/strategy/cud/NodeReference;", "getEnd", "getProperties", "()Ljava/util/Map;", "toQuery", "Lorg/neo4j/driver/Query;", "renderer", "Lorg/neo4j/cypherdsl/core/renderer/Renderer;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "sink"})
public final class CreateRelationship
implements Operation {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String type;
    @NotNull
    private final NodeReference start;
    @NotNull
    private final NodeReference end;
    @NotNull
    private final Map<String, Object> properties;

    public CreateRelationship(@NotNull String type, @NotNull NodeReference start, @NotNull NodeReference end, @NotNull Map<String, ? extends Object> properties) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter((Object)end, (String)"end");
        Intrinsics.checkNotNullParameter(properties, (String)"properties");
        this.type = type;
        this.start = start;
        this.end = end;
        this.properties = properties;
    }

    @NotNull
    public final String getType() {
        return this.type;
    }

    @NotNull
    public final NodeReference getStart() {
        return this.start;
    }

    @NotNull
    public final NodeReference getEnd() {
        return this.end;
    }

    @NotNull
    public final Map<String, Object> getProperties() {
        return this.properties;
    }

    @Override
    @NotNull
    public Query toQuery(@NotNull Renderer renderer) {
        Intrinsics.checkNotNullParameter((Object)renderer, (String)"renderer");
        if (((CharSequence)this.type).length() == 0) {
            throw new InvalidDataException("'rel_type' must be specified.");
        }
        if (this.start.getIds().isEmpty() || this.end.getIds().isEmpty()) {
            throw new InvalidDataException("'from' and 'to' must contain at least one ID property.");
        }
        Parameter parameter = Cypher.parameter((String)"start");
        Intrinsics.checkNotNullExpressionValue((Object)parameter, (String)"parameter(...)");
        Parameter startParam = parameter;
        Parameter parameter2 = Cypher.parameter((String)"end");
        Intrinsics.checkNotNullExpressionValue((Object)parameter2, (String)"parameter(...)");
        Parameter endParam = parameter2;
        Parameter parameter3 = Cypher.parameter((String)"properties");
        Intrinsics.checkNotNullExpressionValue((Object)parameter3, (String)"parameter(...)");
        Parameter propertiesParam = parameter3;
        Triple<Node, Node, StatementBuilder.OrderableOngoingReadingAndWithWithoutWhere> triple = HelpersKt.lookupNodes(this.start, this.end, (Expression)startParam, (Expression)endParam);
        Node startNode = (Node)triple.component1();
        Node endNode = (Node)triple.component2();
        StatementBuilder.OrderableOngoingReadingAndWithWithoutWhere lookup = (StatementBuilder.OrderableOngoingReadingAndWithWithoutWhere)triple.component3();
        String[] stringArray = new String[]{this.type};
        Relationship relationship = ((Relationship)startNode.relationshipTo(endNode, stringArray)).named("r");
        Intrinsics.checkNotNullExpressionValue((Object)relationship, (String)"named(...)");
        Relationship relationship2 = relationship;
        stringArray = new PatternElement[]{relationship2};
        String stmt = renderer.render(lookup.create((PatternElement[])stringArray).set((Named)relationship2, (Expression)propertiesParam).build());
        stringArray = new Pair[]{TuplesKt.to((Object)"start", (Object)MapsKt.mapOf((Pair)TuplesKt.to((Object)"keys", this.start.getIds()))), TuplesKt.to((Object)"end", (Object)MapsKt.mapOf((Pair)TuplesKt.to((Object)"keys", this.end.getIds()))), TuplesKt.to((Object)"properties", this.properties)};
        return new Query(stmt, MapsKt.mapOf((Pair[])stringArray));
    }

    @NotNull
    public final String component1() {
        return this.type;
    }

    @NotNull
    public final NodeReference component2() {
        return this.start;
    }

    @NotNull
    public final NodeReference component3() {
        return this.end;
    }

    @NotNull
    public final Map<String, Object> component4() {
        return this.properties;
    }

    @NotNull
    public final CreateRelationship copy(@NotNull String type, @NotNull NodeReference start, @NotNull NodeReference end, @NotNull Map<String, ? extends Object> properties) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter((Object)end, (String)"end");
        Intrinsics.checkNotNullParameter(properties, (String)"properties");
        return new CreateRelationship(type, start, end, properties);
    }

    public static /* synthetic */ CreateRelationship copy$default(CreateRelationship createRelationship, String string, NodeReference nodeReference, NodeReference nodeReference2, Map map, int n, Object object) {
        if ((n & 1) != 0) {
            string = createRelationship.type;
        }
        if ((n & 2) != 0) {
            nodeReference = createRelationship.start;
        }
        if ((n & 4) != 0) {
            nodeReference2 = createRelationship.end;
        }
        if ((n & 8) != 0) {
            map = createRelationship.properties;
        }
        return createRelationship.copy(string, nodeReference, nodeReference2, map);
    }

    @NotNull
    public String toString() {
        return "CreateRelationship(type=" + this.type + ", start=" + this.start + ", end=" + this.end + ", properties=" + this.properties + ")";
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = result * 31 + this.start.hashCode();
        result = result * 31 + this.end.hashCode();
        result = result * 31 + ((Object)this.properties).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CreateRelationship)) {
            return false;
        }
        CreateRelationship createRelationship = (CreateRelationship)other;
        if (!Intrinsics.areEqual((Object)this.type, (Object)createRelationship.type)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.start, (Object)createRelationship.start)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.end, (Object)createRelationship.end)) {
            return false;
        }
        return Intrinsics.areEqual(this.properties, createRelationship.properties);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u00020\u00052\u0014\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0007\u00a8\u0006\t"}, d2={"Lorg/neo4j/connectors/kafka/sink/strategy/cud/CreateRelationship$Companion;", "", "<init>", "()V", "from", "Lorg/neo4j/connectors/kafka/sink/strategy/cud/CreateRelationship;", "values", "", "", "sink"})
    @SourceDebugExtension(value={"SMAP\nCreateRelationship.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CreateRelationship.kt\norg/neo4j/connectors/kafka/sink/strategy/cud/CreateRelationship$Companion\n+ 2 MapUtils.kt\norg/neo4j/connectors/kafka/utils/MapUtils\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,81:1\n65#2,7:82\n41#2,5:89\n46#2,12:97\n59#2,2:110\n41#2,5:112\n46#2,12:120\n59#2,2:133\n41#2,5:135\n46#2,12:143\n59#2,2:156\n126#3:94\n153#3,2:95\n155#3:109\n126#3:117\n153#3,2:118\n155#3:132\n126#3:140\n153#3,2:141\n155#3:155\n*S KotlinDebug\n*F\n+ 1 CreateRelationship.kt\norg/neo4j/connectors/kafka/sink/strategy/cud/CreateRelationship$Companion\n*L\n65#1:82,7\n68#1:89,5\n68#1:97,12\n68#1:110,2\n72#1:112,5\n72#1:120,12\n72#1:133,2\n75#1:135,5\n75#1:143,12\n75#1:156,2\n68#1:94\n68#1:95,2\n68#1:109\n72#1:117\n72#1:118,2\n72#1:132\n75#1:140\n75#1:141,2\n75#1:155\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CreateRelationship from(@NotNull Map<String, ? extends Object> values) {
            Map map;
            Map map2;
            Map map3;
            Map.Entry it$iv;
            boolean bl;
            Collection collection;
            Map.Entry item$iv$iv$iv;
            Iterator iterator;
            Map $this$mapTo$iv$iv$iv;
            boolean $i$f$mapTo;
            Collection destination$iv$iv$iv;
            Map $this$map$iv$iv;
            boolean $i$f$map;
            Object object;
            Map<String, ? extends Object> $this$getMap$iv;
            Object value$iv;
            String string;
            Map<String, ? extends Object> $this$getTyped$iv;
            Intrinsics.checkNotNullParameter(values, (String)"values");
            MapUtils mapUtils = MapUtils.INSTANCE;
            Map<String, ? extends Object> map4 = values;
            String key$iv = "rel_type";
            boolean $i$f$getTyped = false;
            Object v = $this$getTyped$iv.get(key$iv);
            if (v == null) {
                string = null;
            } else {
                value$iv = v;
                if (Reflection.getOrCreateKotlinClass(String.class).isInstance(value$iv)) {
                    Object v2 = value$iv;
                    if (v2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                    }
                    string = (String)v2;
                } else {
                    throw new InvalidDataException("Map element '" + key$iv + "' is not an instance of " + Reflection.getOrCreateKotlinClass(String.class).getSimpleName());
                }
            }
            if (string == null) {
                throw new InvalidDataException("No rel_type found");
            }
            MapUtils this_$iv = MapUtils.INSTANCE;
            $this$getTyped$iv = values;
            key$iv = "from";
            Object object2 = NodeReference.Companion;
            String string2 = string;
            boolean $i$f$getMap = false;
            value$iv = $this$getMap$iv.get(key$iv);
            if (value$iv == null) {
                object = null;
            } else if (value$iv instanceof Map) {
                Map map5 = (Map)value$iv;
                $i$f$map = false;
                void var9_11 = $this$map$iv$iv;
                destination$iv$iv$iv = new ArrayList($this$map$iv$iv.size());
                $i$f$mapTo = false;
                iterator = $this$mapTo$iv$iv$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = item$iv$iv$iv = iterator.next();
                    collection = destination$iv$iv$iv;
                    bl = false;
                    if (!Reflection.getOrCreateKotlinClass(String.class).isInstance(it$iv.getKey())) {
                        throw new InvalidDataException("Keys of '" + key$iv + "' is not an instance of " + Reflection.getOrCreateKotlinClass(String.class).getSimpleName());
                    }
                    if (!Reflection.getOrCreateKotlinClass(Object.class).isInstance(it$iv.getValue())) {
                        throw new InvalidDataException("Values of '" + key$iv + "' is not an instance of " + Reflection.getOrCreateKotlinClass(Object.class).getSimpleName());
                    }
                    Object k = it$iv.getKey();
                    if (k == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                    }
                    collection.add(TuplesKt.to((Object)((String)k), it$iv.getValue()));
                }
                object = MapsKt.toMap((Iterable)((List)destination$iv$iv$iv));
            } else {
                throw new InvalidDataException("Map element '" + key$iv + "' is not an instance of Map");
            }
            Object object3 = object;
            NodeReference.Companion companion = object3;
            if (companion == null) {
                throw new InvalidDataException("No from found");
            }
            this_$iv = MapUtils.INSTANCE;
            $this$getMap$iv = values;
            key$iv = "to";
            object3 = NodeReference.Companion;
            object2 = ((NodeReference.Companion)object2).from((Map<String, ? extends Object>)((Object)companion));
            $i$f$getMap = false;
            value$iv = $this$getMap$iv.get(key$iv);
            if (value$iv == null) {
                map3 = null;
            } else if (value$iv instanceof Map) {
                $this$map$iv$iv = (Map)value$iv;
                $i$f$map = false;
                $this$mapTo$iv$iv$iv = $this$map$iv$iv;
                destination$iv$iv$iv = new ArrayList($this$map$iv$iv.size());
                $i$f$mapTo = false;
                iterator = $this$mapTo$iv$iv$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    it$iv = item$iv$iv$iv = iterator.next();
                    collection = destination$iv$iv$iv;
                    bl = false;
                    if (!Reflection.getOrCreateKotlinClass(String.class).isInstance(it$iv.getKey())) {
                        throw new InvalidDataException("Keys of '" + key$iv + "' is not an instance of " + Reflection.getOrCreateKotlinClass(String.class).getSimpleName());
                    }
                    if (!Reflection.getOrCreateKotlinClass(Object.class).isInstance(it$iv.getValue())) {
                        throw new InvalidDataException("Values of '" + key$iv + "' is not an instance of " + Reflection.getOrCreateKotlinClass(Object.class).getSimpleName());
                    }
                    Object k = it$iv.getKey();
                    if (k == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                    }
                    collection.add(TuplesKt.to((Object)((String)k), it$iv.getValue()));
                }
                map3 = MapsKt.toMap((Iterable)((List)destination$iv$iv$iv));
            } else {
                throw new InvalidDataException("Map element '" + key$iv + "' is not an instance of Map");
            }
            Map map6 = map2 = map3;
            if (map6 == null) {
                throw new InvalidDataException("No to found");
            }
            this_$iv = MapUtils.INSTANCE;
            $this$getMap$iv = values;
            key$iv = "properties";
            object3 = ((NodeReference.Companion)object3).from(map6);
            $i$f$getMap = false;
            value$iv = $this$getMap$iv.get(key$iv);
            if (value$iv == null) {
                map = null;
            } else if (value$iv instanceof Map) {
                $this$map$iv$iv = (Map)value$iv;
                $i$f$map = false;
                $this$mapTo$iv$iv$iv = $this$map$iv$iv;
                destination$iv$iv$iv = new ArrayList($this$map$iv$iv.size());
                $i$f$mapTo = false;
                iterator = $this$mapTo$iv$iv$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    it$iv = item$iv$iv$iv = iterator.next();
                    collection = destination$iv$iv$iv;
                    bl = false;
                    if (!Reflection.getOrCreateKotlinClass(String.class).isInstance(it$iv.getKey())) {
                        throw new InvalidDataException("Keys of '" + key$iv + "' is not an instance of " + Reflection.getOrCreateKotlinClass(String.class).getSimpleName());
                    }
                    if (!Reflection.getOrCreateKotlinClass(Object.class).isInstance(it$iv.getValue())) {
                        throw new InvalidDataException("Values of '" + key$iv + "' is not an instance of " + Reflection.getOrCreateKotlinClass(Object.class).getSimpleName());
                    }
                    Object k = it$iv.getKey();
                    if (k == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                    }
                    collection.add(TuplesKt.to((Object)((String)k), it$iv.getValue()));
                }
                map = MapsKt.toMap((Iterable)((List)destination$iv$iv$iv));
            } else {
                throw new InvalidDataException("Map element '" + key$iv + "' is not an instance of Map");
            }
            Map map7 = map2 = map;
            if (map7 == null) {
                throw new InvalidDataException("No properties found");
            }
            Map map8 = map7;
            Object object4 = object3;
            Object object5 = object2;
            String string3 = string2;
            return new CreateRelationship(string3, (NodeReference)object5, (NodeReference)object4, map8);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

