/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.connectors.kafka.sink.strategy.cud;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neo4j.connectors.kafka.exceptions.InvalidDataException;
import org.neo4j.connectors.kafka.sink.strategy.cud.HelpersKt;
import org.neo4j.connectors.kafka.sink.strategy.cud.Operation;
import org.neo4j.connectors.kafka.utils.MapUtils;
import org.neo4j.cypherdsl.core.Cypher;
import org.neo4j.cypherdsl.core.ExposesWhere;
import org.neo4j.cypherdsl.core.Expression;
import org.neo4j.cypherdsl.core.Named;
import org.neo4j.cypherdsl.core.Node;
import org.neo4j.cypherdsl.core.Parameter;
import org.neo4j.cypherdsl.core.PatternElement;
import org.neo4j.cypherdsl.core.StatementBuilder;
import org.neo4j.cypherdsl.core.renderer.Renderer;
import org.neo4j.driver.Query;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB5\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0014\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u000f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0017\u0010\u0017\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\tH\u00c6\u0003J;\u0010\u0019\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0016\b\u0002\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u00062\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\t2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0007H\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u0004H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001f\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006 "}, d2={"Lorg/neo4j/connectors/kafka/sink/strategy/cud/DeleteNode;", "Lorg/neo4j/connectors/kafka/sink/strategy/cud/Operation;", "labels", "", "", "ids", "", "", "detach", "", "<init>", "(Ljava/util/Set;Ljava/util/Map;Z)V", "getLabels", "()Ljava/util/Set;", "getIds", "()Ljava/util/Map;", "getDetach", "()Z", "toQuery", "Lorg/neo4j/driver/Query;", "renderer", "Lorg/neo4j/cypherdsl/core/renderer/Renderer;", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "Companion", "sink"})
public final class DeleteNode
implements Operation {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Set<String> labels;
    @NotNull
    private final Map<String, Object> ids;
    private final boolean detach;

    public DeleteNode(@NotNull Set<String> labels, @NotNull Map<String, ? extends Object> ids, boolean detach) {
        Intrinsics.checkNotNullParameter(labels, (String)"labels");
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        this.labels = labels;
        this.ids = ids;
        this.detach = detach;
    }

    public /* synthetic */ DeleteNode(Set set, Map map, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = false;
        }
        this(set, map, bl);
    }

    @NotNull
    public final Set<String> getLabels() {
        return this.labels;
    }

    @NotNull
    public final Map<String, Object> getIds() {
        return this.ids;
    }

    public final boolean getDetach() {
        return this.detach;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Query toQuery(@NotNull Renderer renderer) {
        StatementBuilder.OngoingUpdate ongoingUpdate;
        void it;
        Intrinsics.checkNotNullParameter((Object)renderer, (String)"renderer");
        if (this.ids.isEmpty()) {
            throw new InvalidDataException("Node must contain at least one ID property.");
        }
        Parameter parameter = Cypher.parameter((String)"keys");
        Intrinsics.checkNotNullExpressionValue((Object)parameter, (String)"parameter(...)");
        Parameter keysParam = parameter;
        Node node = HelpersKt.buildNode(this.labels, this.ids, (Expression)keysParam).named("n");
        Intrinsics.checkNotNullExpressionValue((Object)node, (String)"named(...)");
        Node node2 = node;
        PatternElement[] patternElementArray = new PatternElement[]{node2};
        StatementBuilder.OngoingReadingWithoutWhere ongoingReadingWithoutWhere = (StatementBuilder.OngoingReadingWithoutWhere)HelpersKt.applyFilter((ExposesWhere)Cypher.match((PatternElement[])patternElementArray), node2, this.ids, (Expression)keysParam);
        Renderer renderer2 = renderer;
        boolean bl = false;
        if (this.detach) {
            Named[] namedArray = new Named[]{node2};
            ongoingUpdate = it.detachDelete(namedArray);
        } else {
            Named[] namedArray = new Named[]{node2};
            ongoingUpdate = it.delete(namedArray);
        }
        String stmt = renderer2.render(ongoingUpdate.build());
        return new Query(stmt, MapsKt.mapOf((Pair)TuplesKt.to((Object)"keys", this.ids)));
    }

    @NotNull
    public final Set<String> component1() {
        return this.labels;
    }

    @NotNull
    public final Map<String, Object> component2() {
        return this.ids;
    }

    public final boolean component3() {
        return this.detach;
    }

    @NotNull
    public final DeleteNode copy(@NotNull Set<String> labels, @NotNull Map<String, ? extends Object> ids, boolean detach) {
        Intrinsics.checkNotNullParameter(labels, (String)"labels");
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        return new DeleteNode(labels, ids, detach);
    }

    public static /* synthetic */ DeleteNode copy$default(DeleteNode deleteNode, Set set, Map map, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            set = deleteNode.labels;
        }
        if ((n & 2) != 0) {
            map = deleteNode.ids;
        }
        if ((n & 4) != 0) {
            bl = deleteNode.detach;
        }
        return deleteNode.copy(set, map, bl);
    }

    @NotNull
    public String toString() {
        return "DeleteNode(labels=" + this.labels + ", ids=" + this.ids + ", detach=" + this.detach + ")";
    }

    public int hashCode() {
        int result = ((Object)this.labels).hashCode();
        result = result * 31 + ((Object)this.ids).hashCode();
        result = result * 31 + Boolean.hashCode(this.detach);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DeleteNode)) {
            return false;
        }
        DeleteNode deleteNode = (DeleteNode)other;
        if (!Intrinsics.areEqual(this.labels, deleteNode.labels)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.ids, deleteNode.ids)) {
            return false;
        }
        return this.detach == deleteNode.detach;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u00020\u00052\u0014\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0007\u00a8\u0006\t"}, d2={"Lorg/neo4j/connectors/kafka/sink/strategy/cud/DeleteNode$Companion;", "", "<init>", "()V", "from", "Lorg/neo4j/connectors/kafka/sink/strategy/cud/DeleteNode;", "values", "", "", "sink"})
    @SourceDebugExtension(value={"SMAP\nDeleteNode.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeleteNode.kt\norg/neo4j/connectors/kafka/sink/strategy/cud/DeleteNode$Companion\n+ 2 MapUtils.kt\norg/neo4j/connectors/kafka/utils/MapUtils\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,66:1\n24#2,4:67\n28#2,7:74\n36#2:82\n41#2,5:83\n46#2,12:91\n59#2,2:104\n65#2,7:106\n1563#3:71\n1634#3,2:72\n1636#3:81\n126#4:88\n153#4,2:89\n155#4:103\n*S KotlinDebug\n*F\n+ 1 DeleteNode.kt\norg/neo4j/connectors/kafka/sink/strategy/cud/DeleteNode$Companion\n*L\n59#1:67,4\n59#1:74,7\n59#1:82\n60#1:83,5\n60#1:91,12\n60#1:104,2\n61#1:106,7\n59#1:71\n59#1:72,2\n59#1:81\n60#1:88\n60#1:89,2\n60#1:103\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final DeleteNode from(@NotNull Map<String, ? extends Object> values) {
            Boolean bl;
            void $this$getTyped$iv;
            Map map;
            Map<String, ? extends Object> $this$getMap$iv;
            Object it$iv;
            Collection collection;
            Object item$iv$iv$iv;
            Iterator<Object> iterator;
            Object $this$mapTo$iv$iv$iv;
            boolean $i$f$mapTo;
            Collection destination$iv$iv$iv;
            boolean $i$f$map;
            Object $this$map$iv$iv;
            Iterable iterable;
            Map<String, ? extends Object> $this$getIterable$iv;
            Intrinsics.checkNotNullParameter(values, (String)"values");
            MapUtils mapUtils = MapUtils.INSTANCE;
            Map<String, ? extends Object> map2 = values;
            String key$iv = "labels";
            boolean $i$f$getIterable = false;
            Object value$iv = $this$getIterable$iv.get(key$iv);
            if (value$iv == null) {
                iterable = null;
            } else if (value$iv instanceof Iterable) {
                $this$map$iv$iv = (Iterable)value$iv;
                $i$f$map = false;
                Iterable iterable2 = $this$map$iv$iv;
                destination$iv$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv$iv, (int)10));
                $i$f$mapTo = false;
                iterator = $this$mapTo$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    void v1;
                    item$iv$iv$iv = iterator.next();
                    Object t = item$iv$iv$iv;
                    collection = destination$iv$iv$iv;
                    boolean bl2 = false;
                    if (Reflection.getOrCreateKotlinClass(String.class).isInstance(it$iv)) {
                        v1 = it$iv;
                        if (v1 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                        }
                    } else {
                        throw new InvalidDataException("Elements of '" + key$iv + "' is not an instance of " + Reflection.getOrCreateKotlinClass(String.class).getSimpleName());
                    }
                    collection.add((String)v1);
                }
                iterable = (List)destination$iv$iv$iv;
            } else {
                throw new InvalidDataException("Map element '" + key$iv + "' is not an instance of Iterable");
            }
            Set set = iterable;
            if (iterable == null || (set = CollectionsKt.toSet(set)) == null) {
                set = SetsKt.emptySet();
            }
            MapUtils this_$iv = MapUtils.INSTANCE;
            $this$getIterable$iv = values;
            key$iv = "ids";
            Set set2 = set;
            boolean $i$f$getMap = false;
            value$iv = $this$getMap$iv.get(key$iv);
            if (value$iv == null) {
                map = null;
            } else if (value$iv instanceof Map) {
                $this$map$iv$iv = (Map)value$iv;
                $i$f$map = false;
                $this$mapTo$iv$iv$iv = $this$map$iv$iv;
                destination$iv$iv$iv = new ArrayList($this$map$iv$iv.size());
                $i$f$mapTo = false;
                iterator = $this$mapTo$iv$iv$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    it$iv = item$iv$iv$iv = (Map.Entry)iterator.next();
                    collection = destination$iv$iv$iv;
                    boolean bl3 = false;
                    if (!Reflection.getOrCreateKotlinClass(String.class).isInstance(it$iv.getKey())) {
                        throw new InvalidDataException("Keys of '" + key$iv + "' is not an instance of " + Reflection.getOrCreateKotlinClass(String.class).getSimpleName());
                    }
                    if (!Reflection.getOrCreateKotlinClass(Object.class).isInstance(it$iv.getValue())) {
                        throw new InvalidDataException("Values of '" + key$iv + "' is not an instance of " + Reflection.getOrCreateKotlinClass(Object.class).getSimpleName());
                    }
                    Object k = it$iv.getKey();
                    if (k == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                    }
                    collection.add(TuplesKt.to((Object)((String)k), it$iv.getValue()));
                }
                map = MapsKt.toMap((Iterable)((List)destination$iv$iv$iv));
            } else {
                throw new InvalidDataException("Map element '" + key$iv + "' is not an instance of Map");
            }
            if (map == null) {
                throw new InvalidDataException("No IDS found");
            }
            this_$iv = MapUtils.INSTANCE;
            $this$getMap$iv = values;
            key$iv = "detach";
            boolean $i$f$getTyped = false;
            Object v = $this$getTyped$iv.get(key$iv);
            if (v == null) {
                bl = null;
            } else {
                value$iv = v;
                if (Reflection.getOrCreateKotlinClass(Boolean.class).isInstance(value$iv)) {
                    Object v2 = value$iv;
                    if (v2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Boolean");
                    }
                    bl = (Boolean)v2;
                } else {
                    throw new InvalidDataException("Map element '" + key$iv + "' is not an instance of " + Reflection.getOrCreateKotlinClass(Boolean.class).getSimpleName());
                }
            }
            boolean bl4 = bl != null ? bl : false;
            Map map3 = map;
            Set set3 = set2;
            return new DeleteNode(set3, map3, bl4);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

