/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.connectors.kafka.sink.strategy.pattern;

import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neo4j.connectors.kafka.sink.strategy.pattern.NodePattern;
import org.neo4j.connectors.kafka.sink.strategy.pattern.Pattern;
import org.neo4j.connectors.kafka.sink.strategy.pattern.PatternKt;
import org.neo4j.connectors.kafka.sink.strategy.pattern.PropertyMapping;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u001b\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001BQ\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\n\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\t\u0010\u001d\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0005H\u00c6\u0003J\t\u0010 \u001a\u00020\bH\u00c6\u0003J\u000f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u00c6\u0003J\u000f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u00c6\u0003J\u000f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00030\nH\u00c6\u0003Ja\u0010$\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\b2\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u000e\b\u0002\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u000e\b\u0002\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\nH\u00c6\u0001J\u0013\u0010%\u001a\u00020\b2\b\u0010&\u001a\u0004\u0018\u00010'H\u00d6\u0003J\t\u0010(\u001a\u00020)H\u00d6\u0001J\t\u0010*\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0018R\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0018R\u0014\u0010\u001b\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0011\u00a8\u0006+"}, d2={"Lorg/neo4j/connectors/kafka/sink/strategy/pattern/RelationshipPattern;", "Lorg/neo4j/connectors/kafka/sink/strategy/pattern/Pattern;", "type", "", "start", "Lorg/neo4j/connectors/kafka/sink/strategy/pattern/NodePattern;", "end", "includeAllValueProperties", "", "keyProperties", "", "Lorg/neo4j/connectors/kafka/sink/strategy/pattern/PropertyMapping;", "includeProperties", "excludeProperties", "<init>", "(Ljava/lang/String;Lorg/neo4j/connectors/kafka/sink/strategy/pattern/NodePattern;Lorg/neo4j/connectors/kafka/sink/strategy/pattern/NodePattern;ZLjava/util/Set;Ljava/util/Set;Ljava/util/Set;)V", "getType", "()Ljava/lang/String;", "getStart", "()Lorg/neo4j/connectors/kafka/sink/strategy/pattern/NodePattern;", "getEnd", "getIncludeAllValueProperties", "()Z", "getKeyProperties", "()Ljava/util/Set;", "getIncludeProperties", "getExcludeProperties", "text", "getText", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "equals", "other", "", "hashCode", "", "toString", "sink"})
public final class RelationshipPattern
implements Pattern {
    @NotNull
    private final String type;
    @NotNull
    private final NodePattern start;
    @NotNull
    private final NodePattern end;
    private final boolean includeAllValueProperties;
    @NotNull
    private final Set<PropertyMapping> keyProperties;
    @NotNull
    private final Set<PropertyMapping> includeProperties;
    @NotNull
    private final Set<String> excludeProperties;

    public RelationshipPattern(@NotNull String type, @NotNull NodePattern start, @NotNull NodePattern end, boolean includeAllValueProperties, @NotNull Set<PropertyMapping> keyProperties, @NotNull Set<PropertyMapping> includeProperties, @NotNull Set<String> excludeProperties) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter((Object)end, (String)"end");
        Intrinsics.checkNotNullParameter(keyProperties, (String)"keyProperties");
        Intrinsics.checkNotNullParameter(includeProperties, (String)"includeProperties");
        Intrinsics.checkNotNullParameter(excludeProperties, (String)"excludeProperties");
        this.type = type;
        this.start = start;
        this.end = end;
        this.includeAllValueProperties = includeAllValueProperties;
        this.keyProperties = keyProperties;
        this.includeProperties = includeProperties;
        this.excludeProperties = excludeProperties;
    }

    @NotNull
    public final String getType() {
        return this.type;
    }

    @NotNull
    public final NodePattern getStart() {
        return this.start;
    }

    @NotNull
    public final NodePattern getEnd() {
        return this.end;
    }

    @Override
    public boolean getIncludeAllValueProperties() {
        return this.includeAllValueProperties;
    }

    @Override
    @NotNull
    public Set<PropertyMapping> getKeyProperties() {
        return this.keyProperties;
    }

    @Override
    @NotNull
    public Set<PropertyMapping> getIncludeProperties() {
        return this.includeProperties;
    }

    @Override
    @NotNull
    public Set<String> getExcludeProperties() {
        return this.excludeProperties;
    }

    @Override
    @NotNull
    public String getText() {
        String string = this.start.getText() + "-" + ("[:" + PatternKt.trySanitize(this.type) + " " + PatternKt.propertiesAsText(this) + "]") + "->" + this.end.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public final String component1() {
        return this.type;
    }

    @NotNull
    public final NodePattern component2() {
        return this.start;
    }

    @NotNull
    public final NodePattern component3() {
        return this.end;
    }

    public final boolean component4() {
        return this.includeAllValueProperties;
    }

    @NotNull
    public final Set<PropertyMapping> component5() {
        return this.keyProperties;
    }

    @NotNull
    public final Set<PropertyMapping> component6() {
        return this.includeProperties;
    }

    @NotNull
    public final Set<String> component7() {
        return this.excludeProperties;
    }

    @NotNull
    public final RelationshipPattern copy(@NotNull String type, @NotNull NodePattern start, @NotNull NodePattern end, boolean includeAllValueProperties, @NotNull Set<PropertyMapping> keyProperties, @NotNull Set<PropertyMapping> includeProperties, @NotNull Set<String> excludeProperties) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter((Object)end, (String)"end");
        Intrinsics.checkNotNullParameter(keyProperties, (String)"keyProperties");
        Intrinsics.checkNotNullParameter(includeProperties, (String)"includeProperties");
        Intrinsics.checkNotNullParameter(excludeProperties, (String)"excludeProperties");
        return new RelationshipPattern(type, start, end, includeAllValueProperties, keyProperties, includeProperties, excludeProperties);
    }

    public static /* synthetic */ RelationshipPattern copy$default(RelationshipPattern relationshipPattern, String string, NodePattern nodePattern, NodePattern nodePattern2, boolean bl, Set set, Set set2, Set set3, int n, Object object) {
        if ((n & 1) != 0) {
            string = relationshipPattern.type;
        }
        if ((n & 2) != 0) {
            nodePattern = relationshipPattern.start;
        }
        if ((n & 4) != 0) {
            nodePattern2 = relationshipPattern.end;
        }
        if ((n & 8) != 0) {
            bl = relationshipPattern.includeAllValueProperties;
        }
        if ((n & 0x10) != 0) {
            set = relationshipPattern.keyProperties;
        }
        if ((n & 0x20) != 0) {
            set2 = relationshipPattern.includeProperties;
        }
        if ((n & 0x40) != 0) {
            set3 = relationshipPattern.excludeProperties;
        }
        return relationshipPattern.copy(string, nodePattern, nodePattern2, bl, set, set2, set3);
    }

    @NotNull
    public String toString() {
        return "RelationshipPattern(type=" + this.type + ", start=" + this.start + ", end=" + this.end + ", includeAllValueProperties=" + this.includeAllValueProperties + ", keyProperties=" + this.keyProperties + ", includeProperties=" + this.includeProperties + ", excludeProperties=" + this.excludeProperties + ")";
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = result * 31 + this.start.hashCode();
        result = result * 31 + this.end.hashCode();
        result = result * 31 + Boolean.hashCode(this.includeAllValueProperties);
        result = result * 31 + ((Object)this.keyProperties).hashCode();
        result = result * 31 + ((Object)this.includeProperties).hashCode();
        result = result * 31 + ((Object)this.excludeProperties).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RelationshipPattern)) {
            return false;
        }
        RelationshipPattern relationshipPattern = (RelationshipPattern)other;
        if (!Intrinsics.areEqual((Object)this.type, (Object)relationshipPattern.type)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.start, (Object)relationshipPattern.start)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.end, (Object)relationshipPattern.end)) {
            return false;
        }
        if (this.includeAllValueProperties != relationshipPattern.includeAllValueProperties) {
            return false;
        }
        if (!Intrinsics.areEqual(this.keyProperties, relationshipPattern.keyProperties)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.includeProperties, relationshipPattern.includeProperties)) {
            return false;
        }
        return Intrinsics.areEqual(this.excludeProperties, relationshipPattern.excludeProperties);
    }
}

