/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cdc.client;

import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.neo4j.cdc.client.model.ChangeEvent;
import org.neo4j.cdc.client.model.ChangeIdentifier;
import org.neo4j.cdc.client.model.Event;
import org.neo4j.cdc.client.model.Metadata;

public final class ResultMapper {
    private static final String ID_FIELD = "id";
    private static final String TX_ID_FIELD = "txId";
    private static final String SEQ_FIELD = "seq";
    private static final String METADATA_FIELD = "metadata";
    private static final String EVENT_FIELD = "event";

    private ResultMapper() {
    }

    public static ChangeIdentifier parseChangeIdentifier(Map<String, Object> message) {
        return new ChangeIdentifier((String)message.get(ID_FIELD));
    }

    public static ChangeEvent parseChangeEvent(Map<String, Object> message) {
        ChangeIdentifier changeIdentifier = new ChangeIdentifier(MapUtils.getString(message, (Object)ID_FIELD));
        Long txId = MapUtils.getLong(message, (Object)TX_ID_FIELD);
        int seq = MapUtils.getIntValue(message, (Object)SEQ_FIELD);
        Metadata metadata = Metadata.fromMap(MapUtils.getMap(message, (Object)METADATA_FIELD));
        Event event = Event.create(MapUtils.getMap(message, (Object)EVENT_FIELD));
        return new ChangeEvent(changeIdentifier, txId, seq, metadata, event);
    }
}

