/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cdc.client.model;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections4.MapUtils;
import org.neo4j.cdc.client.model.EntityEvent;
import org.neo4j.cdc.client.model.EntityOperation;
import org.neo4j.cdc.client.model.EventType;
import org.neo4j.cdc.client.model.ModelUtils;
import org.neo4j.cdc.client.model.NodeState;

public class NodeEvent
extends EntityEvent<NodeState> {
    private final Map<String, List<Map<String, Object>>> keys;
    private final List<String> labels;

    public NodeEvent(String elementId, EntityOperation operation, List<String> labels, Map<String, List<Map<String, Object>>> keys, NodeState before, NodeState after) {
        super(elementId, EventType.NODE, operation, before, after);
        this.keys = keys;
        this.labels = labels;
    }

    public List<String> getLabels() {
        return this.labels;
    }

    public Map<String, List<Map<String, Object>>> getKeys() {
        return this.keys;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NodeEvent nodeEvent = (NodeEvent)o;
        if (!Objects.equals(this.keys, nodeEvent.keys)) {
            return false;
        }
        return Objects.equals(this.labels, nodeEvent.labels);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.keys != null ? this.keys.hashCode() : 0);
        result = 31 * result + (this.labels != null ? this.labels.hashCode() : 0);
        return result;
    }

    public String toString() {
        return String.format("NodeEvent{elementId=%s, labels=%s, keys=%s, operation=%s, before=%s, after=%s}", new Object[]{this.getElementId(), this.labels, this.keys, this.getOperation(), this.getBefore(), this.getAfter()});
    }

    public static NodeEvent fromMap(Map<?, ?> map) {
        Map<String, Object> cypherMap = ModelUtils.checkedMap(Objects.requireNonNull(map), String.class, Object.class);
        String elementId = MapUtils.getString(cypherMap, (Object)"elementId");
        EntityOperation operation = EntityOperation.fromShorthand(MapUtils.getString(cypherMap, (Object)"operation"));
        List<String> labels = ModelUtils.getList(cypherMap, "labels", String.class);
        Map<String, List<Map<String, Object>>> keys = ModelUtils.getNodesKeys(cypherMap);
        Map<String, Object> state = ModelUtils.checkedMap(Objects.requireNonNull(MapUtils.getMap(cypherMap, (Object)"state")), String.class, Object.class);
        NodeState before = NodeState.fromMap(MapUtils.getMap(state, (Object)"before"));
        NodeState after = NodeState.fromMap(MapUtils.getMap(state, (Object)"after"));
        return new NodeEvent(elementId, operation, labels, keys, before, after);
    }
}

