/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cdc.client.selector;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class RelationshipNodeSelector {
    @NotNull
    private final Set<String> labels;
    @NotNull
    private final Map<String, Object> key;

    private RelationshipNodeSelector(@NotNull Set<String> labels, @NotNull Map<String, Object> key) {
        this.labels = Objects.requireNonNull(labels);
        this.key = Objects.requireNonNull(key);
    }

    @NotNull
    public Set<String> getLabels() {
        return this.labels;
    }

    @NotNull
    public Map<String, Object> getKey() {
        return this.key;
    }

    public Map<String, Object> asMap() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (!this.labels.isEmpty()) {
            result.put("labels", this.labels);
        }
        if (!this.key.isEmpty()) {
            result.put("key", this.key);
        }
        return result;
    }

    public boolean isEmpty() {
        return this.labels.isEmpty() && this.key.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RelationshipNodeSelector that = (RelationshipNodeSelector)o;
        if (!this.labels.equals(that.labels)) {
            return false;
        }
        return this.key.equals(that.key);
    }

    public int hashCode() {
        int result = this.labels.hashCode();
        result = 31 * result + this.key.hashCode();
        return result;
    }

    public static RelationshipNodeSelectorBuilder builder() {
        return new RelationshipNodeSelectorBuilder();
    }

    public static class RelationshipNodeSelectorBuilder {
        private Set<String> labels;
        private Map<String, Object> key;

        private RelationshipNodeSelectorBuilder() {
        }

        public RelationshipNodeSelectorBuilder withLabels(Set<String> labels) {
            this.labels = labels;
            return this;
        }

        public RelationshipNodeSelectorBuilder withKey(Map<String, Object> key) {
            this.key = key;
            return this;
        }

        public RelationshipNodeSelector build() {
            return new RelationshipNodeSelector(Objects.requireNonNullElseGet(this.labels, Collections::emptySet), Objects.requireNonNullElseGet(this.key, Collections::emptyMap));
        }
    }
}

