/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cdc.client.selector;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neo4j.cdc.client.model.ChangeEvent;
import org.neo4j.cdc.client.model.EntityOperation;
import org.neo4j.cdc.client.model.RelationshipEvent;
import org.neo4j.cdc.client.selector.EntitySelector;
import org.neo4j.cdc.client.selector.RelationshipNodeSelector;

public class RelationshipSelector
extends EntitySelector {
    @Nullable
    private final String type;
    @NotNull
    private final RelationshipNodeSelector start;
    @NotNull
    private final RelationshipNodeSelector end;
    @NotNull
    private final Map<String, Object> key;

    private RelationshipSelector(@Nullable EntityOperation change, @NotNull Set<String> changesTo, @Nullable String type, @NotNull RelationshipNodeSelector start, @NotNull RelationshipNodeSelector end, @NotNull Map<String, Object> key, @Nullable String executingUser, @Nullable String authenticatedUser, @NotNull Map<String, Object> txMetadata, @NotNull Set<String> includeProperties, @NotNull Set<String> excludeProperties) {
        super(change, changesTo, executingUser, authenticatedUser, txMetadata, includeProperties, excludeProperties);
        this.type = type;
        this.start = Objects.requireNonNull(start);
        this.end = Objects.requireNonNull(end);
        this.key = Objects.requireNonNull(key);
    }

    @Nullable
    public String getType() {
        return this.type;
    }

    @NotNull
    public RelationshipNodeSelector getStart() {
        return this.start;
    }

    @NotNull
    public RelationshipNodeSelector getEnd() {
        return this.end;
    }

    @NotNull
    public Map<String, Object> getKey() {
        return this.key;
    }

    @Override
    public boolean matches(ChangeEvent e) {
        RelationshipEvent relationshipEvent;
        block12: {
            block11: {
                block10: {
                    block9: {
                        if (!(e.getEvent() instanceof RelationshipEvent)) {
                            return false;
                        }
                        if (!super.matches(e)) {
                            return false;
                        }
                        relationshipEvent = (RelationshipEvent)e.getEvent();
                        if (this.type != null && !relationshipEvent.getType().equals(this.type)) {
                            return false;
                        }
                        if (this.start.getLabels().stream().anyMatch(l -> !relationshipEvent.getStart().getLabels().contains(l))) break block9;
                        if (this.start.getKey().isEmpty()) break block10;
                        if (!relationshipEvent.getStart().getKeys().values().stream().flatMap(Collection::stream).noneMatch(this.start.getKey()::equals)) break block10;
                    }
                    return false;
                }
                if (this.end.getLabels().stream().anyMatch(l -> !relationshipEvent.getEnd().getLabels().contains(l))) break block11;
                if (this.end.getKey().isEmpty()) break block12;
                if (!relationshipEvent.getEnd().getKeys().values().stream().flatMap(Collection::stream).noneMatch(this.end.getKey()::equals)) break block12;
            }
            return false;
        }
        return this.key.isEmpty() || relationshipEvent.getKeys().contains(this.key);
    }

    @Override
    public Map<String, Object> asMap() {
        HashMap<String, Object> result = new HashMap<String, Object>(super.asMap());
        result.put("select", "r");
        if (this.type != null) {
            result.put("type", this.type);
        }
        if (!this.start.isEmpty()) {
            result.put("start", this.start.asMap());
        }
        if (!this.end.isEmpty()) {
            result.put("end", this.end.asMap());
        }
        if (!this.key.isEmpty()) {
            result.put("key", this.key);
        }
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RelationshipSelector that = (RelationshipSelector)o;
        if (!Objects.equals(this.type, that.type)) {
            return false;
        }
        if (!this.start.equals(that.start)) {
            return false;
        }
        if (!this.end.equals(that.end)) {
            return false;
        }
        return this.key.equals(that.key);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + this.start.hashCode();
        result = 31 * result + this.end.hashCode();
        result = 31 * result + this.key.hashCode();
        return result;
    }

    public static RelationshipSelectorBuilder builder() {
        return new RelationshipSelectorBuilder();
    }

    public static class RelationshipSelectorBuilder
    extends EntitySelector.Builder<RelationshipSelectorBuilder, RelationshipSelector> {
        private String type;
        private RelationshipNodeSelector start;
        private RelationshipNodeSelector end;
        private Map<String, Object> key;

        private RelationshipSelectorBuilder() {
        }

        public RelationshipSelectorBuilder withType(String type) {
            this.type = type;
            return this;
        }

        public RelationshipSelectorBuilder withStart(RelationshipNodeSelector start) {
            this.start = start;
            return this;
        }

        public RelationshipSelectorBuilder withEnd(RelationshipNodeSelector end) {
            this.end = end;
            return this;
        }

        public RelationshipSelectorBuilder withKey(Map<String, Object> key) {
            this.key = key;
            return this;
        }

        @Override
        public RelationshipSelector build() {
            return new RelationshipSelector(this.operation, Objects.requireNonNullElseGet(this.changesTo, Collections::emptySet), this.type, Objects.requireNonNullElseGet(this.start, () -> RelationshipNodeSelector.builder().build()), Objects.requireNonNullElseGet(this.end, () -> RelationshipNodeSelector.builder().build()), Objects.requireNonNullElseGet(this.key, Collections::emptyMap), this.executingUser, this.authenticatedUser, Objects.requireNonNullElseGet(this.txMetadata, Collections::emptyMap), Objects.requireNonNullElseGet(this.includeProperties, Collections::emptySet), Objects.requireNonNullElseGet(this.excludeProperties, Collections::emptySet));
        }
    }
}

