/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.connectors.kafka.source;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.TimeSource;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.reactive.ReactiveFlowKt;
import org.apache.kafka.connect.data.SchemaAndValue;
import org.apache.kafka.connect.source.SourceRecord;
import org.apache.kafka.connect.source.SourceTask;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neo4j.cdc.client.CDCClient;
import org.neo4j.cdc.client.CDCService;
import org.neo4j.cdc.client.SessionConfigSupplier;
import org.neo4j.cdc.client.TransactionConfigSupplier;
import org.neo4j.cdc.client.model.ChangeEvent;
import org.neo4j.cdc.client.model.ChangeIdentifier;
import org.neo4j.cdc.client.selector.Selector;
import org.neo4j.connectors.kafka.configuration.helpers.VersionUtil;
import org.neo4j.connectors.kafka.data.ChangeEventConverter;
import org.neo4j.connectors.kafka.data.Headers;
import org.neo4j.connectors.kafka.data.ValueConverter;
import org.neo4j.connectors.kafka.source.Neo4jCdcKeyStrategy;
import org.neo4j.connectors.kafka.source.Neo4jCdcValueStrategy;
import org.neo4j.connectors.kafka.source.SourceConfiguration;
import org.neo4j.connectors.kafka.source.StartFrom;
import org.neo4j.driver.Driver;
import org.neo4j.driver.SessionConfig;
import org.neo4j.driver.TransactionConfig;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0017\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\u0018J\b\u0010\u0019\u001a\u00020\bH\u0016J\u001e\u0010\u001a\u001a\u00020\u001b2\u0014\u0010\u001c\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007H\u0016J\b\u0010\u001d\u001a\u00020\u001bH\u0016J\u000e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001fH\u0016J\u0016\u0010!\u001a\b\u0012\u0004\u0012\u00020 0\"2\u0006\u0010#\u001a\u00020$H\u0002J\u0018\u0010%\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\u0012X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/neo4j/connectors/kafka/source/Neo4jCdcTask;", "Lorg/apache/kafka/connect/source/SourceTask;", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "settings", "", "", "config", "Lorg/neo4j/connectors/kafka/source/SourceConfiguration;", "sessionConfig", "Lorg/neo4j/driver/SessionConfig;", "transactionConfig", "Lorg/neo4j/driver/TransactionConfig;", "cdc", "Lorg/neo4j/cdc/client/CDCService;", "offset", "Ljava/util/concurrent/atomic/AtomicReference;", "converter", "Lorg/neo4j/connectors/kafka/data/ValueConverter;", "changeEventConverter", "Lorg/neo4j/connectors/kafka/data/ChangeEventConverter;", "latestOffset", "latestOffset$source", "version", "start", "", "props", "stop", "poll", "", "Lorg/apache/kafka/connect/source/SourceRecord;", "build", "Lkotlinx/coroutines/flow/Flow;", "changeEvent", "Lorg/neo4j/cdc/client/model/ChangeEvent;", "resumeFrom", "source"})
@SourceDebugExtension(value={"SMAP\nNeo4jCdcTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Neo4jCdcTask.kt\norg/neo4j/connectors/kafka/source/Neo4jCdcTask\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,193:1\n37#2,2:194\n216#3:196\n217#3:201\n1563#4:197\n1634#4,3:198\n*S KotlinDebug\n*F\n+ 1 Neo4jCdcTask.kt\norg/neo4j/connectors/kafka/source/Neo4jCdcTask\n*L\n80#1:194,2\n136#1:196\n136#1:201\n139#1:197\n139#1:198,3\n*E\n"})
public final class Neo4jCdcTask
extends SourceTask {
    @NotNull
    private final Logger log;
    private Map<String, String> settings;
    private SourceConfiguration config;
    private SessionConfig sessionConfig;
    private TransactionConfig transactionConfig;
    private CDCService cdc;
    private AtomicReference<String> offset;
    private ValueConverter converter;
    private ChangeEventConverter changeEventConverter;

    public Neo4jCdcTask() {
        Logger logger = LoggerFactory.getLogger(Neo4jCdcTask.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.log = logger;
    }

    @NotNull
    public final String latestOffset$source() {
        AtomicReference<String> atomicReference = this.offset;
        if (atomicReference == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"offset");
            atomicReference = null;
        }
        String string = atomicReference.get();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"get(...)");
        return string;
    }

    @NotNull
    public String version() {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        Intrinsics.checkNotNull(clazz, (String)"null cannot be cast to non-null type java.lang.Class<*>");
        return VersionUtil.INSTANCE.version(clazz);
    }

    public void start(@Nullable Map<String, String> props) {
        AtomicReference<String> atomicReference;
        CDCService cDCService;
        this.log.info("starting");
        Map<String, String> map2 = props;
        Intrinsics.checkNotNull(map2);
        this.settings = map2;
        Map<String, String> map3 = this.settings;
        if (map3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
            map3 = null;
        }
        this.config = new SourceConfiguration(map3);
        SessionConfig.Builder configBuilder = SessionConfig.builder();
        SourceConfiguration sourceConfiguration = this.config;
        if (sourceConfiguration == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"config");
            sourceConfiguration = null;
        }
        if (!StringsKt.isBlank((CharSequence)sourceConfiguration.getDatabase())) {
            SourceConfiguration sourceConfiguration2 = this.config;
            if (sourceConfiguration2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"config");
                sourceConfiguration2 = null;
            }
            configBuilder.withDatabase(sourceConfiguration2.getDatabase());
        }
        SessionConfig sessionConfig = configBuilder.build();
        Intrinsics.checkNotNullExpressionValue((Object)sessionConfig, (String)"build(...)");
        this.sessionConfig = sessionConfig;
        SourceConfiguration sourceConfiguration3 = this.config;
        if (sourceConfiguration3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"config");
            sourceConfiguration3 = null;
        }
        this.transactionConfig = sourceConfiguration3.txConfig();
        SourceConfiguration sourceConfiguration4 = this.config;
        if (sourceConfiguration4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"config");
            sourceConfiguration4 = null;
        }
        Driver driver = sourceConfiguration4.getDriver();
        SessionConfigSupplier sessionConfigSupplier = () -> Neo4jCdcTask.start$lambda$0(this);
        TransactionConfigSupplier transactionConfigSupplier = () -> Neo4jCdcTask.start$lambda$1(this);
        SourceConfiguration sourceConfiguration5 = this.config;
        if (sourceConfiguration5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"config");
            sourceConfiguration5 = null;
        }
        long l = sourceConfiguration5.getCdcPollingInterval-UwyO8pc();
        int n = Duration.getNanosecondsComponent-impl((long)l);
        long l2 = Duration.getInWholeSeconds-impl((long)l);
        java.time.Duration duration = java.time.Duration.ofSeconds(l2, n);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"toComponents-impl(...)");
        SourceConfiguration sourceConfiguration6 = this.config;
        if (sourceConfiguration6 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"config");
            sourceConfiguration6 = null;
        }
        Collection $this$toTypedArray$iv = sourceConfiguration6.getCdcSelectors();
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Selector[] selectorArray = thisCollection$iv.toArray(new Selector[0]);
        this.cdc = (CDCService)new CDCClient(driver, sessionConfigSupplier, transactionConfigSupplier, duration, Arrays.copyOf(selectorArray, selectorArray.length));
        this.log.debug("constructed cdc client");
        SourceConfiguration sourceConfiguration7 = this.config;
        if (sourceConfiguration7 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"config");
            sourceConfiguration7 = null;
        }
        if ((cDCService = this.cdc) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cdc");
            cDCService = null;
        }
        if ((atomicReference = (this.offset = new AtomicReference<String>(this.resumeFrom(sourceConfiguration7, cDCService)))) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"offset");
            atomicReference = null;
        }
        this.log.info("resuming from offset: " + atomicReference.get());
        SourceConfiguration sourceConfiguration8 = this.config;
        if (sourceConfiguration8 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"config");
            sourceConfiguration8 = null;
        }
        this.changeEventConverter = new ChangeEventConverter(sourceConfiguration8.getPayloadMode());
    }

    public void stop() {
        this.log.info("stopping");
        SourceConfiguration sourceConfiguration = this.config;
        if (sourceConfiguration == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"config");
            sourceConfiguration = null;
        }
        sourceConfiguration.close();
    }

    @NotNull
    public List<SourceRecord> poll() {
        AtomicReference<String> atomicReference = this.offset;
        if (atomicReference == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"offset");
            atomicReference = null;
        }
        this.log.info("polling from offset: " + atomicReference.get());
        List list = new ArrayList();
        BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, (List<SourceRecord>)list, null){
            Object L$0;
            Object L$1;
            long J$0;
            long J$1;
            int label;
            final /* synthetic */ Neo4jCdcTask this$0;
            final /* synthetic */ List<SourceRecord> $list;
            {
                this.this$0 = $receiver;
                this.$list = $list;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var8_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        timeSource = TimeSource.Monotonic.INSTANCE;
                        start = timeSource.markNow-z9LOYto();
                        v0 = Neo4jCdcTask.access$getConfig$p(this.this$0);
                        if (v0 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"config");
                            v0 = null;
                        }
                        limit = TimeSource.Monotonic.ValueTimeMark.plus-LRDsOJo((long)start, (long)v0.getCdcPollingDuration-UwyO8pc());
lbl12:
                        // 3 sources

                        while (TimeSource.Monotonic.ValueTimeMark.hasNotPassedNow-impl((long)limit)) {
                            v1 = Neo4jCdcTask.access$getCdc$p(this.this$0);
                            if (v1 == null) {
                                Intrinsics.throwUninitializedPropertyAccessException((String)"cdc");
                                v1 = null;
                            }
                            v2 = v1.current();
                            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"current(...)");
                            this.L$0 = SpillingKt.nullOutSpilledVariable((Object)timeSource);
                            this.L$1 = null;
                            this.J$0 = start;
                            this.J$1 = limit;
                            this.label = 1;
                            v3 = FlowKt.first((Flow)ReactiveFlowKt.asFlow((Publisher)((Publisher)v2)), (Continuation)((Continuation)this));
                            if (v3 == var8_2) {
                                return var8_2;
                            }
                            ** GOTO lbl35
                        }
                        break;
                    }
                    case 1: {
                        limit = this.J$1;
                        start = this.J$0;
                        timeSource = (TimeSource.Monotonic)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v3 = $result;
lbl35:
                        // 2 sources

                        lastKnownCurrent = (ChangeIdentifier)v3;
                        v4 = Neo4jCdcTask.access$getCdc$p(this.this$0);
                        if (v4 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"cdc");
                            v4 = null;
                        }
                        if ((v5 = Neo4jCdcTask.access$getOffset$p(this.this$0)) == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"offset");
                            v5 = null;
                        }
                        v6 = v4.query(new ChangeIdentifier((String)v5.get()));
                        v7 = Neo4jCdcTask.access$getConfig$p(this.this$0);
                        if (v7 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"config");
                            v7 = null;
                        }
                        v8 = v6.take((long)v7.getBatchSize(), true);
                        Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"take(...)");
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)timeSource);
                        this.L$1 = lastKnownCurrent;
                        this.J$0 = start;
                        this.J$1 = limit;
                        this.label = 2;
                        v9 = FlowKt.toList((Flow)FlowKt.flatMapConcat((Flow)ReactiveFlowKt.asFlow((Publisher)((Publisher)v8)), (Function2)((Function2)new Function2<ChangeEvent, Continuation<? super Flow<? extends SourceRecord>>, Object>(this.this$0, null){
                            int label;
                            /* synthetic */ Object L$0;
                            final /* synthetic */ Neo4jCdcTask this$0;
                            {
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             */
                            public final Object invokeSuspend(Object $result) {
                                ChangeEvent changeEvent = (ChangeEvent)this.L$0;
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        void it;
                                        ResultKt.throwOnFailure((Object)$result);
                                        Intrinsics.checkNotNull((Object)it);
                                        return Neo4jCdcTask.access$build(this.this$0, (ChangeEvent)it);
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                var3_3.L$0 = value;
                                return (Continuation)var3_3;
                            }

                            public final Object invoke(ChangeEvent p1, Continuation<? super Flow<? extends SourceRecord>> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        })), this.$list, (Continuation)((Continuation)this));
                        if (v9 == var8_2) {
                            return var8_2;
                        }
                        ** GOTO lbl66
                    }
                    case 2: {
                        limit = this.J$1;
                        start = this.J$0;
                        lastKnownCurrent = (ChangeIdentifier)this.L$1;
                        timeSource = (TimeSource.Monotonic)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v9 = $result;
lbl66:
                        // 2 sources

                        if (((Collection)this.$list).isEmpty() == false) break;
                        v10 = Neo4jCdcTask.access$getOffset$p(this.this$0);
                        if (v10 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"offset");
                            v10 = null;
                        }
                        v10.set(lastKnownCurrent.getId());
                        v11 = Neo4jCdcTask.access$getConfig$p(this.this$0);
                        if (v11 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"config");
                            v11 = null;
                        }
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)timeSource);
                        this.L$1 = SpillingKt.nullOutSpilledVariable((Object)lastKnownCurrent);
                        this.J$0 = start;
                        this.J$1 = limit;
                        this.label = 3;
                        v12 = DelayKt.delay-VtjQ1oo((long)v11.getCdcPollingInterval-UwyO8pc(), (Continuation)((Continuation)this));
                        if (v12 != var8_2) ** GOTO lbl12
                        return var8_2;
                    }
                    case 3: {
                        limit = this.J$1;
                        start = this.J$0;
                        lastKnownCurrent = (ChangeIdentifier)this.L$1;
                        timeSource = (TimeSource.Monotonic)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v12 = $result;
                        ** GOTO lbl12
                    }
                }
                if (((Collection)this.$list).isEmpty() == false) {
                    v13 = Neo4jCdcTask.access$getOffset$p(this.this$0);
                    if (v13 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"offset");
                        v13 = null;
                    }
                    v14 = ((SourceRecord)CollectionsKt.last(this.$list)).sourceOffset().get("value");
                    Intrinsics.checkNotNull(v14, (String)"null cannot be cast to non-null type kotlin.String");
                    v13.set((String)v14);
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
        this.log.info("poll resulted in {} messages", (Object)list.size());
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private final Flow<SourceRecord> build(ChangeEvent changeEvent) {
        List result = new ArrayList();
        SourceConfiguration sourceConfiguration = this.config;
        if (sourceConfiguration == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"config");
            sourceConfiguration = null;
        }
        Map<Selector, List<String>> $this$forEach$iv = sourceConfiguration.getCdcSelectorsToTopics();
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<Selector, List<String>>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Map.Entry<Selector, List<String>> element$iv;
            Map.Entry<Selector, List<String>> it = element$iv = iterator.next();
            boolean bl = false;
            if (!it.getKey().matches(changeEvent)) continue;
            Iterable iterable = it.getValue();
            List list = result;
            boolean $i$f$map = false;
            void var12_12 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void topic;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                ChangeEvent transformed = it.getKey().applyProperties(changeEvent);
                ChangeEventConverter changeEventConverter = this.changeEventConverter;
                if (changeEventConverter == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"changeEventConverter");
                    changeEventConverter = null;
                }
                Intrinsics.checkNotNull((Object)transformed);
                SchemaAndValue transformedValue = changeEventConverter.toConnectValue(transformed);
                SourceConfiguration sourceConfiguration2 = this.config;
                if (sourceConfiguration2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"config");
                    sourceConfiguration2 = null;
                }
                Neo4jCdcKeyStrategy keyStrategy = sourceConfiguration2.getCdcTopicsToKeyStrategy().getOrDefault(topic, Neo4jCdcKeyStrategy.WHOLE_VALUE);
                SourceConfiguration sourceConfiguration3 = this.config;
                if (sourceConfiguration3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"config");
                    sourceConfiguration3 = null;
                }
                Neo4jCdcValueStrategy valueStrategy = sourceConfiguration3.getCdcTopicsToValueStrategy().getOrDefault(topic, Neo4jCdcValueStrategy.CHANGE_EVENT);
                SourceConfiguration sourceConfiguration4 = this.config;
                if (sourceConfiguration4 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"config");
                    sourceConfiguration4 = null;
                }
                collection.add(new SourceRecord(sourceConfiguration4.getPartition(), MapsKt.mapOf((Pair)TuplesKt.to((Object)"value", (Object)changeEvent.getId().getId())), (String)topic, null, keyStrategy.schema(transformedValue), keyStrategy.value(transformedValue), valueStrategy.schema(transformedValue), valueStrategy.value(transformedValue), Long.valueOf(changeEvent.getMetadata().getTxCommitTime().toInstant().toEpochMilli()), (Iterable)Headers.INSTANCE.from(changeEvent)));
            }
            list.addAll((List)destination$iv$iv);
        }
        return FlowKt.asFlow((Iterable)result);
    }

    private final String resumeFrom(SourceConfiguration config, CDCService cdc) {
        String string;
        Map offset;
        Map map2 = this.context.offsetStorageReader().offset(config.getPartition());
        if (map2 == null) {
            map2 = offset = MapsKt.emptyMap();
        }
        if (!config.getIgnoreStoredOffset() && offset.get("value") instanceof String) {
            this.log.debug("previously stored offset is {}", offset.get("value"));
            Object v = offset.get("value");
            Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type kotlin.String");
            return (String)v;
        }
        switch (WhenMappings.$EnumSwitchMapping$0[config.getStartFrom().ordinal()]) {
            case 1: {
                ChangeIdentifier changeIdentifier = (ChangeIdentifier)cdc.earliest().block();
                String string2 = changeIdentifier != null ? changeIdentifier.getId() : null;
                string = string2;
                Intrinsics.checkNotNull((Object)string2);
                break;
            }
            case 2: {
                ChangeIdentifier changeIdentifier = (ChangeIdentifier)cdc.current().block();
                String string3 = changeIdentifier != null ? changeIdentifier.getId() : null;
                string = string3;
                Intrinsics.checkNotNull((Object)string3);
                break;
            }
            case 3: {
                string = config.getStartFromCustom();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        String value = string;
        Object[] objectArray = new Object[]{"neo4j.start-from", config.getStartFrom(), "neo4j.ignore-stored-offset", config.getIgnoreStoredOffset(), value};
        this.log.debug("{} is set as {} ({} = {}), offset to resume from is {}", objectArray);
        return value;
    }

    private static final SessionConfig start$lambda$0(Neo4jCdcTask this$0) {
        SessionConfig sessionConfig = this$0.sessionConfig;
        if (sessionConfig == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"sessionConfig");
            sessionConfig = null;
        }
        return sessionConfig;
    }

    private static final TransactionConfig start$lambda$1(Neo4jCdcTask this$0) {
        TransactionConfig transactionConfig = this$0.transactionConfig;
        if (transactionConfig == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"transactionConfig");
            transactionConfig = null;
        }
        return transactionConfig;
    }

    public static final /* synthetic */ SourceConfiguration access$getConfig$p(Neo4jCdcTask $this) {
        return $this.config;
    }

    public static final /* synthetic */ CDCService access$getCdc$p(Neo4jCdcTask $this) {
        return $this.cdc;
    }

    public static final /* synthetic */ AtomicReference access$getOffset$p(Neo4jCdcTask $this) {
        return $this.offset;
    }

    public static final /* synthetic */ Flow access$build(Neo4jCdcTask $this, ChangeEvent changeEvent) {
        return $this.build(changeEvent);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[StartFrom.values().length];
            try {
                nArray[StartFrom.EARLIEST.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StartFrom.NOW.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StartFrom.USER_PROVIDED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

