/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.connectors.kafka.data;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.apache.kafka.connect.data.Date;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.data.Timestamp;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neo4j.connectors.kafka.data.DynamicTypes;
import org.neo4j.connectors.kafka.data.PropertyType;
import org.neo4j.connectors.kafka.data.SimpleTypes;
import org.neo4j.connectors.kafka.data.TypesCommonsKt;
import org.neo4j.driver.Values;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u000b\u001a\u0004\u0018\u00010\u00012\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u00012\b\b\u0002\u0010\u000f\u001a\u00020\u0010J.\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00122\u0006\u0010\u000e\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J(\u0010\u0013\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00142\u0006\u0010\u000e\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\"\u0010\u0015\u001a\u0004\u0018\u00010\u00012\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0016\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0001H\u0002J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u000e\u001a\u00020\u0001H\u0002J\u0010\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0001H\u0002J\u0010\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0001H\u0002J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u000e\u001a\u00020\u0001H\u0002J\u001a\u0010\u001d\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u000e\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\rH\u0002J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u000e\u001a\u00020\u0001H\u0002J\u0012\u0010 \u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u000e\u001a\u00020\u0001H\u0002J\u0012\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010\u000e\u001a\u00020\u0001H\u0002J\u001a\u0010#\u001a\u0004\u0018\u00010\"2\u0006\u0010\u000e\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\rH\u0002J\u0013\u0010$\u001a\u00020\u0010*\u0004\u0018\u00010\u0001H\u0000\u00a2\u0006\u0002\b%R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/neo4j/connectors/kafka/data/DynamicTypes;", "", "<init>", "()V", "MILLIS_PER_DAY", "", "PROTOBUF_DECIMAL_TYPE", "", "PROTOBUF_DATE_TYPE", "PROTOBUF_TIME_TYPE", "PROTOBUF_TIMESTAMP_TYPE", "fromConnectValue", "schema", "Lorg/apache/kafka/connect/data/Schema;", "value", "skipNullValuesInMaps", "", "fromMap", "", "fromArray", "", "fromStruct", "fromString", "fromBytes", "", "fromProtobufDecimal", "fromConnectDecimal", "fromProtobufTimestamp", "Ljava/time/LocalDateTime;", "fromConnectTimestamp", "fromProtobufTime", "Ljava/time/LocalTime;", "fromConnectTime", "fromProtobufDate", "Ljava/time/LocalDate;", "fromConnectDate", "notNullOrEmpty", "notNullOrEmpty$common", "common"})
@SourceDebugExtension(value={"SMAP\nDynamicTypes.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DynamicTypes.kt\norg/neo4j/connectors/kafka/data/DynamicTypes\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,361:1\n1740#2,3:362\n1252#2,4:367\n1056#2:371\n1563#2:372\n1634#2,3:373\n1761#2,3:376\n1761#2,3:381\n478#3:365\n424#3:366\n12970#4,2:379\n*S KotlinDebug\n*F\n+ 1 DynamicTypes.kt\norg/neo4j/connectors/kafka/data/DynamicTypes\n*L\n185#1:362,3\n188#1:367,4\n190#1:371\n191#1:372\n191#1:373,3\n355#1:376,3\n357#1:381,3\n188#1:365\n188#1:366\n356#1:379,2\n*E\n"})
public final class DynamicTypes {
    @NotNull
    public static final DynamicTypes INSTANCE = new DynamicTypes();
    public static final int MILLIS_PER_DAY = 86400000;
    @NotNull
    private static final String PROTOBUF_DECIMAL_TYPE = "confluent.type.Decimal";
    @NotNull
    private static final String PROTOBUF_DATE_TYPE = "google.type.Date";
    @NotNull
    private static final String PROTOBUF_TIME_TYPE = "google.type.TimeOfDay";
    @NotNull
    private static final String PROTOBUF_TIMESTAMP_TYPE = "google.protobuf.Timestamp";

    private DynamicTypes() {
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    public final Object fromConnectValue(@NotNull Schema schema, @Nullable Object value, boolean skipNullValuesInMaps) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        if (value == null) {
            return null;
        }
        String string2 = schema.name();
        if (string2 != null) {
            int n = -1;
            switch (string2.hashCode()) {
                case 397507184: {
                    if (!string2.equals("org.apache.kafka.connect.data.Date")) break;
                    n = 1;
                    break;
                }
                case 2117612025: {
                    if (!string2.equals(PROTOBUF_TIME_TYPE)) break;
                    n = 2;
                    break;
                }
                case 1010727247: {
                    if (!string2.equals("org.apache.kafka.connect.data.Decimal")) break;
                    n = 3;
                    break;
                }
                case 1293788200: {
                    if (!string2.equals(PROTOBUF_TIMESTAMP_TYPE)) break;
                    n = 4;
                    break;
                }
                case 397991311: {
                    if (!string2.equals("org.apache.kafka.connect.data.Time")) break;
                    n = 5;
                    break;
                }
                case 886551117: {
                    if (!string2.equals(PROTOBUF_DECIMAL_TYPE)) break;
                    n = 6;
                    break;
                }
                case -1673494387: {
                    if (!string2.equals(PROTOBUF_DATE_TYPE)) break;
                    n = 7;
                    break;
                }
                case 349767572: {
                    if (!string2.equals("org.apache.kafka.connect.data.Timestamp")) break;
                    n = 8;
                    break;
                }
            }
            switch (n) {
                case 1: {
                    object = this.fromConnectDate(value, schema);
                    return object;
                }
                case 7: {
                    object = this.fromProtobufDate(value);
                    return object;
                }
                case 5: {
                    object = this.fromConnectTime(value);
                    return object;
                }
                case 2: {
                    object = this.fromProtobufTime(value);
                    return object;
                }
                case 8: {
                    object = this.fromConnectTimestamp(value, schema);
                    return object;
                }
                case 4: {
                    object = this.fromProtobufTimestamp(value);
                    return object;
                }
                case 3: {
                    object = this.fromConnectDecimal(value);
                    return object;
                }
                case 6: {
                    object = this.fromProtobufDecimal(value);
                    return object;
                }
            }
        }
        Schema.Type type = schema.type();
        switch (type == null ? -1 : WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: {
                object = (Boolean)value;
                return object;
            }
            case 2: {
                object = (Byte)value;
                return object;
            }
            case 3: {
                object = (Short)value;
                return object;
            }
            case 4: {
                object = (Integer)value;
                return object;
            }
            case 5: {
                object = (Long)value;
                return object;
            }
            case 6: {
                object = (Float)value;
                return object;
            }
            case 7: {
                object = (Double)value;
                return object;
            }
            case 8: {
                object = this.fromBytes(value);
                return object;
            }
            case 9: {
                object = this.fromString(schema, value);
                return object;
            }
            case 10: {
                object = this.fromStruct(schema, value, skipNullValuesInMaps);
                return object;
            }
            case 11: {
                object = this.fromArray(value, schema, skipNullValuesInMaps);
                return object;
            }
            case 12: {
                object = this.fromMap(value, schema, skipNullValuesInMaps);
                return object;
            }
        }
        throw new IllegalArgumentException("unsupported schema (" + schema + ") and value type (" + value.getClass().getName() + ")");
    }

    public static /* synthetic */ Object fromConnectValue$default(DynamicTypes dynamicTypes, Schema schema, Object object, boolean bl, int n, Object object2) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return dynamicTypes.fromConnectValue(schema, object, bl);
    }

    private final Map<String, Object> fromMap(Object value, Schema schema, boolean skipNullValuesInMaps) {
        Map result = new LinkedHashMap();
        Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.collections.Map<*, *>");
        Map map = (Map)value;
        for (Map.Entry entry : map.entrySet()) {
            if (!(entry.getKey() instanceof String)) {
                Object object = entry.getKey();
                throw new IllegalArgumentException("invalid key type (" + (object != null && (object = object.getClass()) != null ? ((Class)object).getName() : null) + " in map value");
            }
            Map map2 = result;
            Object k = entry.getKey();
            Intrinsics.checkNotNull(k, (String)"null cannot be cast to non-null type kotlin.String");
            String string2 = (String)k;
            Schema schema2 = schema.valueSchema();
            Intrinsics.checkNotNullExpressionValue((Object)schema2, (String)"valueSchema(...)");
            Object object = this.fromConnectValue(schema2, entry.getValue(), skipNullValuesInMaps);
            map2.put(string2, object);
        }
        return result;
    }

    private final List<Object> fromArray(Object value, Schema schema, boolean skipNullValuesInMaps) {
        List result = new ArrayList();
        if (value.getClass().isArray()) {
            int n = Array.getLength(value);
            for (int i = 0; i < n; ++i) {
                Schema schema2 = schema.valueSchema();
                Intrinsics.checkNotNullExpressionValue((Object)schema2, (String)"valueSchema(...)");
                result.add(this.fromConnectValue(schema2, Array.get(value, i), skipNullValuesInMaps));
            }
        } else if (value instanceof Iterable) {
            for (Object element : (Iterable)value) {
                Schema schema3 = schema.valueSchema();
                Intrinsics.checkNotNullExpressionValue((Object)schema3, (String)"valueSchema(...)");
                result.add(this.fromConnectValue(schema3, element, skipNullValuesInMaps));
            }
        } else {
            throw new IllegalArgumentException("unsupported array type " + value.getClass().getName());
        }
        return CollectionsKt.toList((Iterable)result);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final Object fromStruct(Schema schema, Object value, boolean skipNullValuesInMaps) {
        block18: {
            block16: {
                block21: {
                    block20: {
                        block19: {
                            block17: {
                                if (!TypesCommonsKt.matches(PropertyType.INSTANCE.getSchema(), schema)) break block17;
                                v0 = PropertyType.INSTANCE.fromConnectValue((Struct)value);
                                break block18;
                            }
                            if (!SimpleTypes.POINT.matches(schema)) break block19;
                            var4_4 = (Struct)value;
                            if (var4_4 == null) ** GOTO lbl-1000
                            it = var4_4;
                            $i$a$-let-DynamicTypes$fromStruct$1 = false;
                            dimension = it.getInt8("dimension");
                            if (dimension == 2) {
                                v1 = it.getInt32("srid");
                                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getInt32(...)");
                                v2 = ((Number)v1).intValue();
                                v3 = it.getFloat64("x");
                                Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"getFloat64(...)");
                                v4 = ((Number)v3).doubleValue();
                                v5 = it.getFloat64("y");
                                Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"getFloat64(...)");
                                v6 = Values.point((int)v2, (double)v4, (double)((Number)v5).doubleValue());
                            } else if (dimension == 3) {
                                v7 = it.getInt32("srid");
                                Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"getInt32(...)");
                                v8 = ((Number)v7).intValue();
                                v9 = it.getFloat64("x");
                                Intrinsics.checkNotNullExpressionValue((Object)v9, (String)"getFloat64(...)");
                                v10 = ((Number)v9).doubleValue();
                                v11 = it.getFloat64("y");
                                Intrinsics.checkNotNullExpressionValue((Object)v11, (String)"getFloat64(...)");
                                v12 = ((Number)v11).doubleValue();
                                v13 = it.getFloat64("z");
                                Intrinsics.checkNotNullExpressionValue((Object)v13, (String)"getFloat64(...)");
                                v6 = Values.point((int)v8, (double)v10, (double)v12, (double)((Number)v13).doubleValue());
                            } else {
                                throw new IllegalArgumentException("unsupported dimension value " + dimension);
                            }
                            var5_16 = v6;
                            if (var5_16 != null) {
                                v0 = var5_16.asPoint();
                            } else lbl-1000:
                            // 2 sources

                            {
                                v0 = null;
                            }
                            break block18;
                        }
                        if (!SimpleTypes.DURATION.matches(schema)) break block20;
                        var4_5 = (Struct)value;
                        if (var4_5 == null) ** GOTO lbl-1000
                        it = var4_5;
                        $i$a$-let-DynamicTypes$fromStruct$2 = false;
                        v14 = it.getInt64("months");
                        Intrinsics.checkNotNullExpressionValue((Object)v14, (String)"getInt64(...)");
                        v15 = ((Number)v14).longValue();
                        v16 = it.getInt64("days");
                        Intrinsics.checkNotNullExpressionValue((Object)v16, (String)"getInt64(...)");
                        v17 = ((Number)v16).longValue();
                        v18 = it.getInt64("seconds");
                        Intrinsics.checkNotNullExpressionValue((Object)v18, (String)"getInt64(...)");
                        v19 = ((Number)v18).longValue();
                        v20 = it.getInt32("nanoseconds");
                        Intrinsics.checkNotNullExpressionValue((Object)v20, (String)"getInt32(...)");
                        var5_17 = Values.isoDuration((long)v15, (long)v17, (long)v19, (int)((Number)v20).intValue());
                        if (var5_17 != null) {
                            v0 = var5_17.asIsoDuration();
                        } else lbl-1000:
                        // 2 sources

                        {
                            v0 = null;
                        }
                        break block18;
                    }
                    result = new LinkedHashMap<K, V>();
                    Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type org.apache.kafka.connect.data.Struct");
                    struct = (Struct)value;
                    for (Field field : schema.fields()) {
                        v21 = field.schema();
                        Intrinsics.checkNotNullExpressionValue((Object)v21, (String)"schema(...)");
                        fieldValue = this.fromConnectValue(v21, struct.get(field), skipNullValuesInMaps);
                        if (fieldValue == null && skipNullValuesInMaps) continue;
                        result.put(field.name(), fieldValue);
                    }
                    if (!(result.isEmpty() == false)) ** GOTO lbl-1000
                    $this$all$iv = result.keySet();
                    $i$f$all = false;
                    if (!($this$all$iv instanceof Collection) || !((Collection)$this$all$iv).isEmpty()) break block21;
                    v22 = true;
                    break block16;
                }
                fieldValue = $this$all$iv.iterator();
                while (fieldValue.hasNext()) {
                    element$iv = fieldValue.next();
                    it = (String)element$iv;
                    $i$a$-all-DynamicTypes$fromStruct$3 = false;
                    if (!StringsKt.startsWith$default((String)it, (String)"e", (boolean)false, (int)2, null)) ** GOTO lbl-1000
                    v23 = it.substring(1);
                    Intrinsics.checkNotNullExpressionValue((Object)v23, (String)"substring(...)");
                    if (StringsKt.toIntOrNull((String)v23) != null) {
                        v24 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v24 = false;
                    }
                    if (v24) continue;
                    v22 = false;
                    break block16;
                }
                v22 = true;
            }
            if (v22) {
                $this$all$iv = result;
                $i$f$mapKeys = false;
                fieldValue = $this$mapKeys$iv;
                destination$iv$iv = new LinkedHashMap<K, V>(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
                $i$f$mapKeysTo = false;
                $i$a$-all-DynamicTypes$fromStruct$3 = $this$mapKeysTo$iv$iv.entrySet();
                destination$iv$iv$iv = destination$iv$iv;
                $i$f$associateByTo = false;
                for (T element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                    var16_30 /* !! */  = (Map.Entry)element$iv$iv$iv;
                    var22_36 = destination$iv$iv$iv;
                    $i$a$-mapKeys-DynamicTypes$fromStruct$4 = false;
                    v25 = ((String)it.getKey()).substring(1);
                    Intrinsics.checkNotNullExpressionValue((Object)v25, (String)"substring(...)");
                    var18_32 = (Map.Entry)element$iv$iv$iv;
                    var19_33 = Integer.parseInt(v25);
                    var20_34 = var22_36;
                    $i$a$-associateByTo-MapsKt__MapsKt$mapKeysTo$1$iv$iv = false;
                    var16_30 /* !! */  = it$iv$iv.getValue();
                    var20_34.put(var19_33, var16_30 /* !! */ );
                }
                $this$mapKeys$iv = destination$iv$iv$iv.entrySet();
                $i$f$sortedBy = false;
                $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        Map.Entry it = (Map.Entry)a;
                        boolean bl = false;
                        Comparable comparable = (Integer)it.getKey();
                        it = (Map.Entry)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Integer)it.getKey()));
                    }
                });
                $i$f$map = false;
                $this$mapKeysTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    $i$f$associateByTo = (Map.Entry)item$iv$iv;
                    var22_36 = destination$iv$iv;
                    $i$a$-map-DynamicTypes$fromStruct$6 = false;
                    var22_36.add(it.getValue());
                }
                v0 = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
            } else lbl-1000:
            // 2 sources

            {
                v0 = result;
            }
        }
        return v0;
    }

    private final Object fromString(Schema schema, Object value) {
        Object object;
        LocalDate parsedValue2;
        Object object2;
        String it;
        if (SimpleTypes.LOCALDATE.matches(schema)) {
            String string2 = (String)value;
            if (string2 != null) {
                it = string2;
                boolean bl = false;
                object2 = DateTimeFormatter.ISO_DATE.parse((CharSequence)it, DynamicTypes::fromString$lambda$0$0);
            } else {
                object2 = null;
            }
        } else if (SimpleTypes.LOCALTIME.matches(schema)) {
            String string3 = (String)value;
            if (string3 != null) {
                it = string3;
                boolean bl = false;
                object2 = DateTimeFormatter.ISO_TIME.parse((CharSequence)it, DynamicTypes::fromString$lambda$1$0);
            } else {
                object2 = null;
            }
        } else if (SimpleTypes.LOCALDATETIME.matches(schema)) {
            String string4 = (String)value;
            if (string4 != null) {
                it = string4;
                boolean bl = false;
                object2 = DateTimeFormatter.ISO_DATE_TIME.parse((CharSequence)it, DynamicTypes::fromString$lambda$2$0);
            } else {
                object2 = null;
            }
        } else if (SimpleTypes.ZONEDDATETIME.matches(schema)) {
            String string5 = (String)value;
            if (string5 != null) {
                it = string5;
                boolean bl = false;
                object2 = DateTimeFormatter.ISO_DATE_TIME.parse((CharSequence)it, fromString.parsedValue.4.1.INSTANCE);
            } else {
                object2 = null;
            }
        } else if (SimpleTypes.OFFSETTIME.matches(schema)) {
            String string6 = (String)value;
            if (string6 != null) {
                it = string6;
                boolean bl = false;
                object2 = DateTimeFormatter.ISO_TIME.parse((CharSequence)it, DynamicTypes::fromString$lambda$4$0);
            } else {
                object2 = null;
            }
        } else {
            object2 = value;
        }
        LocalDate localDate = parsedValue2 = object2;
        if (localDate instanceof String) {
            object = parsedValue2;
        } else if (localDate instanceof Character) {
            object = String.valueOf(((Character)((Object)parsedValue2)).charValue());
        } else if (localDate instanceof char[]) {
            object = StringsKt.concatToString((char[])((char[])parsedValue2));
        } else if (localDate instanceof CharSequence) {
            object = ((Object)parsedValue2).toString();
        } else if (localDate instanceof LocalDate) {
            object = parsedValue2;
        } else if (localDate instanceof LocalTime) {
            object = parsedValue2;
        } else if (localDate instanceof LocalDateTime) {
            object = parsedValue2;
        } else if (localDate instanceof OffsetDateTime) {
            object = parsedValue2;
        } else if (localDate instanceof ZonedDateTime) {
            object = parsedValue2;
        } else if (localDate instanceof OffsetTime) {
            object = parsedValue2;
        } else {
            throw new IllegalArgumentException("Unsupported string schema type: " + value.getClass().getName());
        }
        return object;
    }

    private final byte[] fromBytes(Object value) {
        byte[] byArray;
        Object object = value;
        if (object instanceof byte[]) {
            byArray = (byte[])value;
        } else if (object instanceof ByteBuffer) {
            byArray = ((ByteBuffer)value).array();
        } else {
            throw new IllegalArgumentException("unsupported bytes type " + value.getClass().getName());
        }
        return byArray;
    }

    private final String fromProtobufDecimal(Object value) {
        if (!(value instanceof Struct)) {
            throw new IllegalArgumentException("unsupported protobuf decimal type " + value.getClass().getName());
        }
        BigInteger bigInteger = new BigInteger(((Struct)value).getBytes("value"));
        Integer n = ((Struct)value).getInt32("scale");
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getInt32(...)");
        String string2 = new BigDecimal(bigInteger, ((Number)n).intValue()).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return string2;
    }

    private final String fromConnectDecimal(Object value) {
        if (!(value instanceof BigDecimal)) {
            throw new IllegalArgumentException("unsupported Kafka Connect decimal type " + value.getClass().getName());
        }
        String string2 = ((BigDecimal)value).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return string2;
    }

    private final LocalDateTime fromProtobufTimestamp(Object value) {
        if (!(value instanceof Struct)) {
            throw new IllegalArgumentException("unsupported protobuf timestamp type " + value.getClass().getName());
        }
        Long l = ((Struct)value).getInt64("seconds");
        Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getInt64(...)");
        long l2 = ((Number)l).longValue();
        Integer n = ((Struct)value).getInt32("nanos");
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getInt32(...)");
        return LocalDateTime.ofEpochSecond(l2, ((Number)n).intValue(), ZoneOffset.UTC);
    }

    private final LocalDateTime fromConnectTimestamp(Object value, Schema schema) {
        if (!(value instanceof java.util.Date)) {
            throw new IllegalArgumentException("unsupported Kafka Connect time type " + value.getClass().getName());
        }
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(Timestamp.fromLogical((Schema)schema, (java.util.Date)((java.util.Date)value))), ZoneOffset.UTC);
    }

    private final LocalTime fromProtobufTime(Object value) {
        if (!(value instanceof Struct)) {
            throw new IllegalArgumentException("unsupported protobuf time type " + value.getClass().getName());
        }
        Integer n = ((Struct)value).getInt32("hours");
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getInt32(...)");
        int n2 = ((Number)n).intValue();
        Integer n3 = ((Struct)value).getInt32("minutes");
        Intrinsics.checkNotNullExpressionValue((Object)n3, (String)"getInt32(...)");
        int n4 = ((Number)n3).intValue();
        Integer n5 = ((Struct)value).getInt32("seconds");
        Intrinsics.checkNotNullExpressionValue((Object)n5, (String)"getInt32(...)");
        int n6 = ((Number)n5).intValue();
        Integer n7 = ((Struct)value).getInt32("nanos");
        Intrinsics.checkNotNullExpressionValue((Object)n7, (String)"getInt32(...)");
        return LocalTime.of(n2, n4, n6, ((Number)n7).intValue());
    }

    private final LocalTime fromConnectTime(Object value) {
        if (!(value instanceof java.util.Date)) {
            throw new IllegalArgumentException("unsupported Kafka Connect time type " + value.getClass().getName());
        }
        return LocalTime.ofInstant(((java.util.Date)value).toInstant(), ZoneOffset.UTC);
    }

    private final LocalDate fromProtobufDate(Object value) {
        if (!(value instanceof Struct)) {
            throw new IllegalArgumentException("unsupported protobuf date type " + value.getClass().getName());
        }
        Integer n = ((Struct)value).getInt32("year");
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getInt32(...)");
        int n2 = ((Number)n).intValue();
        Integer n3 = ((Struct)value).getInt32("month");
        Intrinsics.checkNotNullExpressionValue((Object)n3, (String)"getInt32(...)");
        int n4 = ((Number)n3).intValue();
        Integer n5 = ((Struct)value).getInt32("day");
        Intrinsics.checkNotNullExpressionValue((Object)n5, (String)"getInt32(...)");
        return LocalDate.of(n2, n4, ((Number)n5).intValue());
    }

    private final LocalDate fromConnectDate(Object value, Schema schema) {
        if (!(value instanceof java.util.Date)) {
            throw new IllegalArgumentException("unsupported Kafka Connect date type " + value.getClass().getName());
        }
        return LocalDate.ofEpochDay(Date.fromLogical((Schema)schema, (java.util.Date)((java.util.Date)value)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean notNullOrEmpty$common(@Nullable Object $this$notNullOrEmpty) {
        Object it;
        Object value = $this$notNullOrEmpty;
        if (value == null) {
            return false;
        }
        if (value instanceof Collection) {
            Object it2;
            if (((Collection)value).isEmpty()) return false;
            boolean bl = true;
            if (!bl) return false;
            Iterable $this$any$iv = (Iterable)value;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                return false;
            }
            Iterator iterator = $this$any$iv.iterator();
            do {
                Object element$iv;
                if (!iterator.hasNext()) return false;
                it2 = element$iv = iterator.next();
                boolean bl2 = false;
            } while (!INSTANCE.notNullOrEmpty$common(it2));
            return true;
        }
        if (value instanceof Object[]) {
            if (((Object[])value).length == 0) {
                return false;
            }
            boolean bl = false;
            if (bl) return false;
            boolean bl3 = true;
            if (!bl3) return false;
            Object[] $this$any$iv = (Object[])value;
            boolean $i$f$any = false;
            int n = 0;
            int element$iv = $this$any$iv.length;
            while (n < element$iv) {
                Object element$iv2;
                Object it3 = element$iv2 = $this$any$iv[n];
                boolean bl4 = false;
                if (INSTANCE.notNullOrEmpty$common(it3)) {
                    return true;
                }
                ++n;
            }
            return false;
        }
        if (!(value instanceof Map)) return true;
        if (((Map)value).isEmpty()) return false;
        boolean bl = true;
        if (!bl) return false;
        Iterable $this$any$iv = ((Map)value).values();
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            Object element$iv;
            if (!iterator.hasNext()) return false;
            it = element$iv = iterator.next();
            boolean bl5 = false;
        } while (!INSTANCE.notNullOrEmpty$common(it));
        return true;
    }

    private static final LocalDate fromString$lambda$0$0(TemporalAccessor parsed) {
        return LocalDate.from(parsed);
    }

    private static final LocalTime fromString$lambda$1$0(TemporalAccessor parsed) {
        return LocalTime.from(parsed);
    }

    private static final LocalDateTime fromString$lambda$2$0(TemporalAccessor parsed) {
        return LocalDateTime.from(parsed);
    }

    private static final OffsetTime fromString$lambda$4$0(TemporalAccessor parsed) {
        return OffsetTime.from(parsed);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Schema.Type.values().length];
            try {
                nArray[Schema.Type.BOOLEAN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Schema.Type.INT8.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Schema.Type.INT16.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Schema.Type.INT32.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Schema.Type.INT64.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Schema.Type.FLOAT32.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Schema.Type.FLOAT64.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Schema.Type.BYTES.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Schema.Type.STRING.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Schema.Type.STRUCT.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Schema.Type.ARRAY.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Schema.Type.MAP.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

