/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.connectors.kafka.utils;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.kafka.common.utils.AppInfoParser;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neo4j.connectors.kafka.configuration.Neo4jConfiguration;
import org.neo4j.connectors.kafka.configuration.helpers.VersionUtil;
import org.neo4j.connectors.kafka.utils.EnvironmentProvider;
import org.neo4j.driver.Config;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\r\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0019B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00052\b\b\u0002\u0010\t\u001a\u00020\u00052\b\b\u0002\u0010\n\u001a\u00020\u000bJ\u0012\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\n\u001a\u00020\u000bH\u0002J3\u0010\u000e\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00052\b\b\u0002\u0010\u000f\u001a\u00020\u00052\b\b\u0002\u0010\t\u001a\u00020\u00052\b\b\u0002\u0010\n\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b\u0010J\r\u0010\u0011\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\b\u0012J\r\u0010\u0013\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\b\u0014J\r\u0010\u0015\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\b\u0016J\r\u0010\u0017\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\b\u0018R\u000e\u0010\u0004\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/neo4j/connectors/kafka/utils/Telemetry;", "", "<init>", "()V", "CONFLUENT_ENV", "", "CONFLUENT_ENV_VALUE", "userAgent", "type", "comment", "provider", "Lorg/neo4j/connectors/kafka/utils/EnvironmentProvider;", "runningInConfluentCloud", "", "connectorInformation", "version", "connectorInformation$common", "kafkaConnectInformation", "kafkaConnectInformation$common", "platform", "platform$common", "neo4jDriverVersion", "neo4jDriverVersion$common", "jreInformation", "jreInformation$common", "SystemEnvironmentProvider", "common"})
public final class Telemetry {
    @NotNull
    public static final Telemetry INSTANCE = new Telemetry();
    @NotNull
    public static final String CONFLUENT_ENV = "CONFLUENT_ENV";
    @NotNull
    public static final String CONFLUENT_ENV_VALUE = "CCLOUD_CUSTOM_CONNECTOR";

    private Telemetry() {
    }

    @NotNull
    public final String userAgent(@NotNull String type, @NotNull String comment, @NotNull EnvironmentProvider provider) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)comment, (String)"comment");
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        String string2 = "%s %s (%s) %s %s";
        Object[] objectArray = new Object[]{this.connectorInformation$common(type, VersionUtil.INSTANCE.version(Neo4jConfiguration.class), comment, provider), this.kafkaConnectInformation$common(), this.platform$common(), this.neo4jDriverVersion$common(), this.jreInformation$common()};
        String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
        return string3;
    }

    public static /* synthetic */ String userAgent$default(Telemetry telemetry, String string2, String string3, EnvironmentProvider environmentProvider, int n, Object object) {
        if ((n & 2) != 0) {
            string3 = "";
        }
        if ((n & 4) != 0) {
            environmentProvider = SystemEnvironmentProvider.INSTANCE;
        }
        return telemetry.userAgent(string2, string3, environmentProvider);
    }

    private final boolean runningInConfluentCloud(EnvironmentProvider provider) {
        String value = provider.get(CONFLUENT_ENV);
        CharSequence charSequence = value;
        if (charSequence == null || charSequence.length() == 0) {
            return false;
        }
        return StringsKt.contentEquals((CharSequence)value, (CharSequence)CONFLUENT_ENV_VALUE, (boolean)true);
    }

    static /* synthetic */ boolean runningInConfluentCloud$default(Telemetry telemetry, EnvironmentProvider environmentProvider, int n, Object object) {
        if ((n & 1) != 0) {
            environmentProvider = SystemEnvironmentProvider.INSTANCE;
        }
        return telemetry.runningInConfluentCloud(environmentProvider);
    }

    @NotNull
    public final String connectorInformation$common(@NotNull String type, @NotNull String version, @NotNull String comment, @NotNull EnvironmentProvider provider) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter((Object)comment, (String)"comment");
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        String string2 = "%s-%s%s%s";
        Object[] objectArray = new Object[]{this.runningInConfluentCloud(provider) ? "confluent-cloud" : "kafka", type, ((CharSequence)version).length() == 0 ? "" : "/" + version, ((CharSequence)comment).length() == 0 ? "" : " (" + comment + ")"};
        String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
        return string3;
    }

    public static /* synthetic */ String connectorInformation$common$default(Telemetry telemetry, String string2, String string3, String string4, EnvironmentProvider environmentProvider, int n, Object object) {
        if ((n & 2) != 0) {
            string3 = "";
        }
        if ((n & 4) != 0) {
            string4 = "";
        }
        if ((n & 8) != 0) {
            environmentProvider = SystemEnvironmentProvider.INSTANCE;
        }
        return telemetry.connectorInformation$common(string2, string3, string4, environmentProvider);
    }

    @NotNull
    public final String kafkaConnectInformation$common() {
        String string2 = "kafka-connect/%s";
        Object[] objectArray = new Object[]{AppInfoParser.getVersion()};
        String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
        return string3;
    }

    @NotNull
    public final String platform$common() {
        String string2 = "%s; %s; %s";
        Object[] objectArray = new Object[]{System.getProperty("os.name"), System.getProperty("os.version"), System.getProperty("os.arch")};
        String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
        return string3;
    }

    @NotNull
    public final String neo4jDriverVersion$common() {
        String string2 = Config.defaultConfig().userAgent();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"userAgent(...)");
        return string2;
    }

    @NotNull
    public final String jreInformation$common() {
        String string2 = "Java/%s (%s; %s; %s)";
        Object[] objectArray = new Object[]{System.getProperty("java.version"), System.getProperty("java.vm.vendor"), System.getProperty("java.vm.name"), System.getProperty("java.vm.version")};
        String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
        return string3;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/neo4j/connectors/kafka/utils/Telemetry$SystemEnvironmentProvider;", "Lorg/neo4j/connectors/kafka/utils/EnvironmentProvider;", "<init>", "()V", "get", "", "env", "common"})
    private static final class SystemEnvironmentProvider
    implements EnvironmentProvider {
        @NotNull
        public static final SystemEnvironmentProvider INSTANCE = new SystemEnvironmentProvider();

        private SystemEnvironmentProvider() {
        }

        @Override
        @Nullable
        public String get(@NotNull String env) {
            Intrinsics.checkNotNullParameter((Object)env, (String)"env");
            return System.getenv(env);
        }
    }
}

