/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.networknt.schema.SpecificationVersion;
import com.networknt.schema.dialect.Dialect;
import com.networknt.schema.dialect.Dialects;

public class Specification {
    public static Dialect getDialect(SpecificationVersion version) {
        if (null == version) {
            return null;
        }
        switch (version) {
            case DRAFT_2020_12: {
                return Dialects.getDraft202012();
            }
            case DRAFT_2019_09: {
                return Dialects.getDraft201909();
            }
            case DRAFT_7: {
                return Dialects.getDraft7();
            }
            case DRAFT_6: {
                return Dialects.getDraft6();
            }
            case DRAFT_4: {
                return Dialects.getDraft4();
            }
        }
        return null;
    }

    public static Dialect getDialect(String dialectId) {
        if (null == dialectId) {
            return null;
        }
        switch (dialectId) {
            case "https://json-schema.org/draft/2020-12/schema": {
                return Dialects.getDraft202012();
            }
            case "https://json-schema.org/draft/2019-09/schema": {
                return Dialects.getDraft201909();
            }
            case "http://json-schema.org/draft-07/schema#": {
                return Dialects.getDraft7();
            }
            case "http://json-schema.org/draft-06/schema#": {
                return Dialects.getDraft6();
            }
            case "http://json-schema.org/draft-04/schema#": {
                return Dialects.getDraft4();
            }
        }
        return null;
    }
}

