/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema.keyword;

import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.schema.ExecutionContext;
import com.networknt.schema.MessageSourceError;
import com.networknt.schema.Schema;
import com.networknt.schema.SchemaContext;
import com.networknt.schema.SchemaException;
import com.networknt.schema.SchemaLocation;
import com.networknt.schema.keyword.BaseKeywordValidator;
import com.networknt.schema.keyword.KeywordType;
import com.networknt.schema.keyword.ThresholdMixin;
import com.networknt.schema.path.NodePath;
import com.networknt.schema.utils.JsonNodeTypes;
import com.networknt.schema.utils.JsonType;
import java.math.BigDecimal;
import java.math.BigInteger;

public class MinimumValidator
extends BaseKeywordValidator {
    private static final String PROPERTY_EXCLUSIVE_MINIMUM = "exclusiveMinimum";
    private final boolean excludeEqual;
    private final ThresholdMixin typedMinimum;

    public MinimumValidator(SchemaLocation schemaLocation, final JsonNode schemaNode, Schema parentSchema, SchemaContext schemaContext) {
        super(KeywordType.MINIMUM, schemaNode, schemaLocation, parentSchema, schemaContext);
        if (!schemaNode.isNumber()) {
            throw new SchemaException("minimum value is not a number");
        }
        JsonNode exclusiveMinimumNode = this.getParentSchema().getSchemaNode().get(PROPERTY_EXCLUSIVE_MINIMUM);
        this.excludeEqual = exclusiveMinimumNode != null && exclusiveMinimumNode.isBoolean() ? exclusiveMinimumNode.booleanValue() : false;
        final String minimumText = schemaNode.asText();
        if ((schemaNode.isLong() || schemaNode.isInt()) && JsonType.INTEGER.toString().equals(this.getNodeFieldType())) {
            final long lmin = schemaNode.asLong();
            this.typedMinimum = new ThresholdMixin(){

                @Override
                public boolean crossesThreshold(JsonNode node) {
                    if (node.isBigInteger()) {
                        int compare = node.bigIntegerValue().compareTo(new BigInteger(minimumText));
                        return compare < 0 || MinimumValidator.this.excludeEqual && compare == 0;
                    }
                    if (node.isTextual()) {
                        BigDecimal min = new BigDecimal(minimumText);
                        BigDecimal value = new BigDecimal(node.asText());
                        int compare = value.compareTo(min);
                        return compare < 0 || MinimumValidator.this.excludeEqual && compare == 0;
                    }
                    long val = node.asLong();
                    return lmin > val || MinimumValidator.this.excludeEqual && lmin == val;
                }

                @Override
                public String thresholdValue() {
                    return String.valueOf(lmin);
                }
            };
        } else {
            this.typedMinimum = new ThresholdMixin(){

                @Override
                public boolean crossesThreshold(JsonNode node) {
                    if (schemaNode.isDouble() && schemaNode.doubleValue() == Double.NEGATIVE_INFINITY) {
                        return false;
                    }
                    if (schemaNode.isDouble() && schemaNode.doubleValue() == Double.POSITIVE_INFINITY) {
                        return true;
                    }
                    if (node.isDouble() && node.doubleValue() == Double.NEGATIVE_INFINITY) {
                        return true;
                    }
                    if (node.isDouble() && node.doubleValue() == Double.POSITIVE_INFINITY) {
                        return false;
                    }
                    BigDecimal min = new BigDecimal(minimumText);
                    BigDecimal value = new BigDecimal(node.asText());
                    int compare = value.compareTo(min);
                    return compare < 0 || MinimumValidator.this.excludeEqual && compare == 0;
                }

                @Override
                public String thresholdValue() {
                    return minimumText;
                }
            };
        }
    }

    @Override
    public void validate(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, NodePath instanceLocation) {
        if (!JsonNodeTypes.isNumber(node, this.schemaContext.getSchemaRegistryConfig())) {
            return;
        }
        if (this.typedMinimum.crossesThreshold(node)) {
            executionContext.addError(((MessageSourceError.Builder)((MessageSourceError.Builder)((MessageSourceError.Builder)((MessageSourceError.Builder)((MessageSourceError.Builder)this.error().instanceNode(node)).instanceLocation(instanceLocation)).evaluationPath(executionContext.getEvaluationPath())).locale(executionContext.getExecutionConfig().getLocale())).arguments(this.typedMinimum.thresholdValue())).build());
        }
    }
}

