/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core.internal;

import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apiguardian.api.API;
import org.neo4j.cypherdsl.core.AliasedExpression;
import org.neo4j.cypherdsl.core.Expression;
import org.neo4j.cypherdsl.core.Foreach;
import org.neo4j.cypherdsl.core.FunctionInvocation;
import org.neo4j.cypherdsl.core.IdentifiableElement;
import org.neo4j.cypherdsl.core.Named;
import org.neo4j.cypherdsl.core.Order;
import org.neo4j.cypherdsl.core.PatternComprehension;
import org.neo4j.cypherdsl.core.ProcedureCall;
import org.neo4j.cypherdsl.core.Property;
import org.neo4j.cypherdsl.core.Return;
import org.neo4j.cypherdsl.core.Statement;
import org.neo4j.cypherdsl.core.Subquery;
import org.neo4j.cypherdsl.core.SymbolicName;
import org.neo4j.cypherdsl.core.With;
import org.neo4j.cypherdsl.core.ast.TypedSubtree;
import org.neo4j.cypherdsl.core.ast.Visitable;
import org.neo4j.cypherdsl.core.ast.Visitor;
import org.neo4j.cypherdsl.core.internal.YieldItems;

@API(status=API.Status.INTERNAL, since="2021.3.2")
public final class ScopingStrategy {
    private final Deque<Set<IdentifiableElement>> dequeOfVisitedNamed = new ArrayDeque<Set<IdentifiableElement>>(new HashSet());
    private Set<IdentifiableElement> afterStatement = Collections.emptySet();
    private Visitable previous;
    private boolean inOrder = false;
    private boolean inProperty = false;
    private boolean inListFunctionPredicate = false;

    public ScopingStrategy() {
        this.dequeOfVisitedNamed.push(new HashSet());
    }

    public void doEnter(Visitable visitable) {
        if (visitable instanceof Order) {
            this.inOrder = true;
        }
        if (visitable instanceof Property) {
            this.inProperty = true;
        }
        if (this.isListFunctionPredicate(visitable)) {
            this.inListFunctionPredicate = true;
        }
        if (ScopingStrategy.hasLocalScope(visitable)) {
            this.dequeOfVisitedNamed.push(new HashSet(this.dequeOfVisitedNamed.isEmpty() ? Collections.emptySet() : (Collection)this.dequeOfVisitedNamed.peek()));
        }
    }

    private boolean isListFunctionPredicate(Visitable visitable) {
        return visitable instanceof FunctionInvocation && new HashSet<String>(Arrays.asList("all", "any", "none", "single")).contains(((FunctionInvocation)visitable).getFunctionName().toLowerCase(Locale.ROOT));
    }

    public void doLeave(Visitable visitable) {
        if (!this.hasScope()) {
            return;
        }
        if (visitable instanceof IdentifiableElement && !this.inOrder && (!this.inProperty || visitable instanceof Property)) {
            if (visitable instanceof SymbolicName && this.inListFunctionPredicate) {
                this.inListFunctionPredicate = false;
            }
            this.dequeOfVisitedNamed.peek().add((IdentifiableElement)((Object)visitable));
        }
        if (visitable instanceof Statement) {
            Set<IdentifiableElement> lastScope = this.dequeOfVisitedNamed.peek();
            this.afterStatement = !(this.previous instanceof Return) && !(this.previous instanceof YieldItems) ? lastScope.stream().filter(i -> !(i instanceof Property)).collect(Collectors.toSet()) : new HashSet<IdentifiableElement>(lastScope);
            if (!(visitable instanceof ProcedureCall)) {
                lastScope.clear();
            }
        } else if (ScopingStrategy.hasLocalScope(visitable)) {
            this.dequeOfVisitedNamed.pop();
        } else {
            this.clearPreviouslyVisitedNamed(visitable);
        }
        if (visitable instanceof Order) {
            this.inOrder = false;
        }
        if (visitable instanceof Property) {
            this.inProperty = false;
        }
        this.previous = visitable;
    }

    public boolean hasVisitedBefore(Named namedItem) {
        if (!this.hasScope()) {
            return false;
        }
        Set<IdentifiableElement> scope = this.dequeOfVisitedNamed.peek();
        return this.hasVisitedInScope(scope, namedItem);
    }

    private boolean hasScope() {
        return !this.dequeOfVisitedNamed.isEmpty();
    }

    private boolean hasVisitedInScope(Collection<IdentifiableElement> visited, Named needle) {
        Predicate<IdentifiableElement> hasAName = Named.class::isInstance;
        hasAName = hasAName.or(AliasedExpression.class::isInstance);
        return visited.contains(needle) || needle.getSymbolicName().isPresent() && visited.stream().filter(hasAName).anyMatch(i -> {
            if (i instanceof Named) {
                return ((Named)i).getSymbolicName().equals(needle.getSymbolicName());
            }
            if (i instanceof AliasedExpression) {
                return ((AliasedExpression)i).getAlias().equals(needle.getRequiredSymbolicName().getValue());
            }
            return false;
        });
    }

    private static boolean hasLocalScope(Visitable visitable) {
        return visitable instanceof PatternComprehension || visitable instanceof Subquery || visitable instanceof Foreach;
    }

    private void clearPreviouslyVisitedNamed(Visitable visitable) {
        if (visitable instanceof With) {
            this.clearPreviouslyVisitedAfterWith((With)visitable);
        } else if (visitable instanceof Return || visitable instanceof YieldItems) {
            this.clearPreviouslyVisitedAfterReturnish(visitable);
        }
    }

    private void clearPreviouslyVisitedAfterWith(With with) {
        HashSet retain = new HashSet();
        Set<IdentifiableElement> visitedNamed = this.dequeOfVisitedNamed.peek();
        with.accept(segment -> {
            if (segment instanceof SymbolicName) {
                visitedNamed.stream().filter(element -> {
                    if (element instanceof Named) {
                        return ((Named)element).getRequiredSymbolicName().equals(segment);
                    }
                    if (element instanceof AliasedExpression) {
                        return ((AliasedExpression)element).getAlias().equals(((SymbolicName)segment).getValue());
                    }
                    return false;
                }).forEach(retain::add);
            }
        });
        if (visitedNamed != null) {
            visitedNamed.retainAll(retain);
        }
    }

    private void clearPreviouslyVisitedAfterReturnish(Visitable returnish) {
        final HashSet retain = new HashSet();
        Set<IdentifiableElement> visitedNamed = this.dequeOfVisitedNamed.peek();
        returnish.accept(new Visitor(){
            int level = 0;
            Visitable entranceLevel1;

            @Override
            public void enter(Visitable segment) {
                if (this.entranceLevel1 == null && segment instanceof TypedSubtree) {
                    this.entranceLevel1 = segment;
                    return;
                }
                if (this.entranceLevel1 != null) {
                    ++this.level;
                }
                if (this.level == 1 && segment instanceof IdentifiableElement) {
                    retain.add((IdentifiableElement)((Object)segment));
                }
            }

            @Override
            public void leave(Visitable segment) {
                if (this.entranceLevel1 != null) {
                    this.level = Math.max(0, this.level - 1);
                    if (segment == this.entranceLevel1) {
                        this.entranceLevel1 = null;
                    }
                }
            }
        });
        if (visitedNamed != null) {
            visitedNamed.retainAll(retain);
        }
    }

    public Collection<Expression> getIdentifiables() {
        if (!this.hasScope()) {
            return Collections.emptySet();
        }
        Predicate<IdentifiableElement> allNamedElementsHaveResolvedNames = e -> !(e instanceof Named) || ((Named)e).getSymbolicName().isPresent();
        Set<IdentifiableElement> items = Optional.ofNullable(this.dequeOfVisitedNamed.peek()).filter(scope -> !scope.isEmpty()).orElse(this.afterStatement);
        return items.stream().filter(allNamedElementsHaveResolvedNames).map(IdentifiableElement::asExpression).collect(Collectors.collectingAndThen(Collectors.toSet(), Collections::unmodifiableSet));
    }
}

