/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.connectors.kafka.configuration.helpers;

import java.util.Locale;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a\u0017\u0010\u0006\u001a\u00020\u0007*\u00020\b2\u0006\u0010\t\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\n\u001a\u0011\u0010\u000b\u001a\u00020\u0001*\u00020\u0007\u00a2\u0006\u0004\b\f\u0010\r\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u000e"}, d2={"VALID_UNITS_DESCRIPTION", "", "SIMPLE_DURATION_PATTERN", "Ljava/util/regex/Pattern;", "getSIMPLE_DURATION_PATTERN", "()Ljava/util/regex/Pattern;", "parseSimpleString", "Lkotlin/time/Duration;", "Lkotlin/time/Duration$Companion;", "value", "(Lkotlin/time/Duration$Companion;Ljava/lang/String;)J", "toSimpleString", "toSimpleString-LRDsOJo", "(J)Ljava/lang/String;", "common"})
@SourceDebugExtension(value={"SMAP\nDuration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Duration.kt\norg/neo4j/connectors/kafka/configuration/helpers/DurationKt\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,112:1\n158#2,6:113\n648#2,5:120\n648#2,5:125\n1#3:119\n*S KotlinDebug\n*F\n+ 1 Duration.kt\norg/neo4j/connectors/kafka/configuration/helpers/DurationKt\n*L\n46#1:113,6\n57#1:120,5\n58#1:125,5\n*E\n"})
public final class DurationKt {
    @NotNull
    private static final String VALID_UNITS_DESCRIPTION = "Valid units are: `ms`, `s`, `m`, `h` and `d`";
    @NotNull
    private static final Pattern SIMPLE_DURATION_PATTERN;

    @NotNull
    public static final Pattern getSIMPLE_DURATION_PATTERN() {
        return SIMPLE_DURATION_PATTERN;
    }

    /*
     * WARNING - void declaration
     */
    public static final long parseSimpleString(@NotNull Duration.Companion $this$parseSimpleString, @NotNull String value) {
        int unitIndex;
        block6: {
            int n;
            Intrinsics.checkNotNullParameter((Object)$this$parseSimpleString, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            CharSequence $this$indexOfFirst$iv = value;
            boolean $i$f$indexOfFirst = false;
            int n2 = $this$indexOfFirst$iv.length();
            for (int index$iv = 0; index$iv < n2; ++index$iv) {
                char it = $this$indexOfFirst$iv.charAt(index$iv);
                boolean bl = false;
                if (!(!Character.isDigit(it))) continue;
                n = index$iv;
                break block6;
            }
            n = unitIndex = -1;
        }
        if (unitIndex == -1) {
            throw new IllegalArgumentException("Invalid duration string '" + value + "'. No unit provided. Valid units are: `ms`, `s`, `m`, `h` and `d`");
        }
        if (!(unitIndex != 0)) {
            boolean $i$a$-require-DurationKt$parseSimpleString$22 = false;
            String $i$a$-require-DurationKt$parseSimpleString$22 = "Missing numeric value: " + value;
            throw new IllegalArgumentException($i$a$-require-DurationKt$parseSimpleString$22.toString());
        }
        String input = value;
        long timeInNanos = 0L;
        while (((CharSequence)input).length() > 0) {
            String unit;
            String string2;
            String amount;
            block8: {
                void $this$takeWhile$iv;
                String string3;
                block7: {
                    String $this$takeWhile$iv2 = input;
                    boolean $i$f$takeWhile = false;
                    int n = $this$takeWhile$iv2.length();
                    for (int index$iv = 0; index$iv < n; ++index$iv) {
                        char it = $this$takeWhile$iv2.charAt(index$iv);
                        int n3 = 0;
                        if (Character.isDigit(it)) continue;
                        String string4 = $this$takeWhile$iv2;
                        n3 = 0;
                        String string5 = string4.substring(n3, index$iv);
                        string3 = string5;
                        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
                        break block7;
                    }
                    string3 = $this$takeWhile$iv2;
                }
                amount = string3;
                Intrinsics.checkNotNullExpressionValue((Object)input.substring(amount.length()), (String)"substring(...)");
                boolean $i$f$takeWhile = false;
                int n = $this$takeWhile$iv.length();
                for (int index$iv = 0; index$iv < n; ++index$iv) {
                    char it = $this$takeWhile$iv.charAt(index$iv);
                    boolean bl = false;
                    if (!Character.isDigit(it)) continue;
                    void var12_20 = $this$takeWhile$iv;
                    int n4 = 0;
                    String string6 = var12_20.substring(n4, index$iv);
                    string2 = string6;
                    Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"substring(...)");
                    break block8;
                }
                string2 = $this$takeWhile$iv;
            }
            void var8_12 = string2;
            Locale locale = Locale.ROOT;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ROOT");
            Intrinsics.checkNotNullExpressionValue((Object)var8_12.toLowerCase(locale), (String)"toLowerCase(...)");
            timeInNanos += DurationKt.parseSimpleString$toNanos(unit, Integer.parseInt(amount));
            Intrinsics.checkNotNullExpressionValue((Object)input.substring(amount.length() + unit.length()), (String)"substring(...)");
        }
        return kotlin.time.DurationKt.toDuration((long)timeInNanos, (DurationUnit)DurationUnit.NANOSECONDS);
    }

    @NotNull
    public static final String toSimpleString-LRDsOJo(long l) {
        long milliseconds;
        long seconds;
        long minutes;
        long hours;
        long duration = l;
        if (Duration.isNegative-impl((long)duration)) {
            throw new IllegalArgumentException("negative durations are not supported: " + Duration.toString-impl((long)duration));
        }
        StringBuilder timeString = new StringBuilder();
        long days = Duration.getInWholeDays-impl((long)duration);
        if (days > 0L) {
            timeString.append(days).append("d");
            duration = Duration.minus-LRDsOJo((long)duration, (long)kotlin.time.DurationKt.toDuration((long)days, (DurationUnit)DurationUnit.DAYS));
        }
        if ((hours = Duration.getInWholeHours-impl((long)duration)) > 0L) {
            timeString.append(hours).append('h');
            duration = Duration.minus-LRDsOJo((long)duration, (long)kotlin.time.DurationKt.toDuration((long)hours, (DurationUnit)DurationUnit.HOURS));
        }
        if ((minutes = Duration.getInWholeMinutes-impl((long)duration)) > 0L) {
            timeString.append(minutes).append('m');
            duration = Duration.minus-LRDsOJo((long)duration, (long)kotlin.time.DurationKt.toDuration((long)minutes, (DurationUnit)DurationUnit.MINUTES));
        }
        if ((seconds = Duration.getInWholeSeconds-impl((long)duration)) > 0L) {
            timeString.append(seconds).append('s');
            duration = Duration.minus-LRDsOJo((long)duration, (long)kotlin.time.DurationKt.toDuration((long)seconds, (DurationUnit)DurationUnit.SECONDS));
        }
        if ((milliseconds = Duration.getInWholeMilliseconds-impl((long)duration)) > 0L) {
            timeString.append(milliseconds).append("ms");
            duration = Duration.minus-LRDsOJo((long)duration, (long)kotlin.time.DurationKt.toDuration((long)milliseconds, (DurationUnit)DurationUnit.MILLISECONDS));
        }
        if (((CharSequence)timeString).length() == 0) {
            timeString.append("0s");
        }
        String string2 = timeString.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return string2;
    }

    private static final long parseSimpleString$toNanos(String unit, int amount) {
        long l;
        switch (unit) {
            case "ms": {
                l = TimeUnit.MILLISECONDS.toNanos(amount);
                break;
            }
            case "s": {
                l = TimeUnit.SECONDS.toNanos(amount);
                break;
            }
            case "m": {
                l = TimeUnit.MINUTES.toNanos(amount);
                break;
            }
            case "h": {
                l = TimeUnit.HOURS.toNanos(amount);
                break;
            }
            case "d": {
                l = TimeUnit.DAYS.toNanos(amount);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognized unit `" + unit + "`. Valid units are: `ms`, `s`, `m`, `h` and `d`");
            }
        }
        return l;
    }

    static {
        Pattern pattern2 = Pattern.compile("(\\d+(ms|s|m|h|d))+");
        Intrinsics.checkNotNullExpressionValue((Object)pattern2, (String)"compile(...)");
        SIMPLE_DURATION_PATTERN = pattern2;
    }
}

