/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.connectors.kafka.data;

import java.nio.ByteBuffer;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neo4j.connectors.kafka.data.PropertyType;
import org.neo4j.connectors.kafka.data.TypesCommonsKt;
import org.neo4j.driver.Value;
import org.neo4j.driver.Values;
import org.neo4j.driver.types.IsoDuration;
import org.neo4j.driver.types.Point;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0018\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010(\u001a\u0004\u0018\u00010)2\b\u0010*\u001a\u0004\u0018\u00010\u0001J\"\u0010+\u001a\u0004\u0018\u00010)2\n\u0010*\u001a\u0006\u0012\u0002\b\u00030,2\n\u0010-\u001a\u0006\u0012\u0002\b\u00030.H\u0002J\u0012\u0010/\u001a\u0004\u0018\u00010\u00012\b\u0010*\u001a\u0004\u0018\u00010)J\u0018\u00100\u001a\u00020)2\u0006\u00101\u001a\u00020\u00052\b\u0010*\u001a\u0004\u0018\u00010\u0001J\u0010\u00102\u001a\u0002032\u0006\u00104\u001a\u00020\u0005H\u0002J\u0010\u00105\u001a\u0002062\u0006\u00104\u001a\u00020\u0005H\u0002J\u0010\u00107\u001a\u0002082\u0006\u00104\u001a\u00020\u0005H\u0002J\u0018\u00109\u001a\n :*\u0004\u0018\u00010\u00010\u00012\u0006\u00104\u001a\u00020\u0005H\u0002J\u0010\u0010;\u001a\u00020<2\u0006\u00104\u001a\u00020\u0005H\u0002J\u0010\u0010=\u001a\u00020>2\u0006\u00104\u001a\u00020)H\u0002J\u0010\u0010?\u001a\u00020@2\u0006\u00104\u001a\u00020)H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00050\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00050\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\u00020!X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0014\u0010$\u001a\u00020!X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010#R\u0011\u0010&\u001a\u00020!\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010#\u00a8\u0006A"}, d2={"Lorg/neo4j/connectors/kafka/data/PropertyType;", "", "<init>", "()V", "TYPE", "", "BOOLEAN", "BOOLEAN_LIST", "LONG", "LONG_LIST", "FLOAT", "FLOAT_LIST", "STRING", "STRING_LIST", "BYTES", "LOCAL_DATE", "LOCAL_DATE_LIST", "LOCAL_DATE_TIME", "LOCAL_DATE_TIME_LIST", "LOCAL_TIME", "LOCAL_TIME_LIST", "ZONED_DATE_TIME", "ZONED_DATE_TIME_LIST", "OFFSET_TIME", "OFFSET_TIME_LIST", "DURATION", "DURATION_LIST", "POINT", "POINT_LIST", "SIMPLE_TYPE_FIELDS", "", "LIST_TYPE_FIELDS", "durationSchema", "Lorg/apache/kafka/connect/data/Schema;", "getDurationSchema$common", "()Lorg/apache/kafka/connect/data/Schema;", "pointSchema", "getPointSchema$common", "schema", "getSchema", "toConnectValue", "Lorg/apache/kafka/connect/data/Struct;", "value", "asList", "", "componentType", "Lkotlin/reflect/KClass;", "fromConnectValue", "getPropertyStruct", "type", "parseLocalDate", "Ljava/time/LocalDate;", "s", "parseLocalTime", "Ljava/time/LocalTime;", "parseLocalDateTime", "Ljava/time/LocalDateTime;", "parseZonedDateTime", "kotlin.jvm.PlatformType", "parseOffsetTime", "Ljava/time/OffsetTime;", "toDuration", "Lorg/neo4j/driver/types/IsoDuration;", "toPoint", "Lorg/neo4j/driver/types/Point;", "common"})
@SourceDebugExtension(value={"SMAP\nPropertyType.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PropertyType.kt\norg/neo4j/connectors/kafka/data/PropertyType\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,398:1\n1#2:399\n11581#3:400\n11916#3,3:401\n11591#3:404\n11926#3,3:405\n11611#3:408\n11946#3,3:409\n1563#4:412\n1634#4,3:413\n1563#4:416\n1634#4,3:417\n1563#4:420\n1634#4,3:421\n1563#4:424\n1634#4,3:425\n1563#4:428\n1634#4,3:429\n1563#4:432\n1634#4,3:433\n1563#4:436\n1634#4,3:437\n1563#4:440\n1634#4,3:441\n1563#4:444\n1634#4,3:445\n1563#4:448\n1634#4,3:449\n1563#4:452\n1634#4,3:453\n1563#4:456\n1634#4,3:457\n1563#4:460\n1634#4,3:461\n1563#4:464\n1634#4,3:465\n1563#4:468\n1634#4,3:469\n1563#4:472\n1634#4,3:473\n1563#4:476\n1634#4,3:477\n1563#4:480\n1634#4,3:481\n1563#4:484\n1634#4,3:485\n1563#4:488\n1634#4,3:489\n1563#4:492\n1634#4,3:493\n*S KotlinDebug\n*F\n+ 1 PropertyType.kt\norg/neo4j/connectors/kafka/data/PropertyType\n*L\n186#1:400\n186#1:401,3\n187#1:404\n187#1:405,3\n189#1:408\n189#1:409,3\n194#1:412\n194#1:413,3\n214#1:416\n214#1:417,3\n215#1:420\n215#1:421,3\n217#1:424\n217#1:425,3\n223#1:428\n223#1:429,3\n228#1:432\n228#1:433,3\n233#1:436\n233#1:437,3\n238#1:440\n238#1:441,3\n243#1:444\n243#1:445,3\n248#1:448\n248#1:449,3\n255#1:452\n255#1:453,3\n256#1:456\n256#1:457,3\n268#1:460\n268#1:461,3\n269#1:464\n269#1:465,3\n332#1:468\n332#1:469,3\n333#1:472\n333#1:473,3\n334#1:476\n334#1:477,3\n335#1:480\n335#1:481,3\n336#1:484\n336#1:485,3\n337#1:488\n337#1:489,3\n338#1:492\n338#1:493,3\n*E\n"})
public final class PropertyType {
    @NotNull
    public static final PropertyType INSTANCE = new PropertyType();
    @NotNull
    public static final String TYPE = "type";
    @NotNull
    public static final String BOOLEAN = "B";
    @NotNull
    public static final String BOOLEAN_LIST = "LB";
    @NotNull
    public static final String LONG = "I64";
    @NotNull
    public static final String LONG_LIST = "LI64";
    @NotNull
    public static final String FLOAT = "F64";
    @NotNull
    public static final String FLOAT_LIST = "LF64";
    @NotNull
    public static final String STRING = "S";
    @NotNull
    public static final String STRING_LIST = "LS";
    @NotNull
    public static final String BYTES = "BA";
    @NotNull
    public static final String LOCAL_DATE = "TLD";
    @NotNull
    public static final String LOCAL_DATE_LIST = "LTLD";
    @NotNull
    public static final String LOCAL_DATE_TIME = "TLDT";
    @NotNull
    public static final String LOCAL_DATE_TIME_LIST = "LTLDT";
    @NotNull
    public static final String LOCAL_TIME = "TLT";
    @NotNull
    public static final String LOCAL_TIME_LIST = "LTLT";
    @NotNull
    public static final String ZONED_DATE_TIME = "TZDT";
    @NotNull
    public static final String ZONED_DATE_TIME_LIST = "LZDT";
    @NotNull
    public static final String OFFSET_TIME = "TOT";
    @NotNull
    public static final String OFFSET_TIME_LIST = "LTOT";
    @NotNull
    public static final String DURATION = "TD";
    @NotNull
    public static final String DURATION_LIST = "LTD";
    @NotNull
    public static final String POINT = "SP";
    @NotNull
    public static final String POINT_LIST = "LSP";
    @NotNull
    private static final List<String> SIMPLE_TYPE_FIELDS;
    @NotNull
    private static final List<String> LIST_TYPE_FIELDS;
    @NotNull
    private static final Schema durationSchema;
    @NotNull
    private static final Schema pointSchema;
    @NotNull
    private static final Schema schema;

    private PropertyType() {
    }

    @NotNull
    public final Schema getDurationSchema$common() {
        return durationSchema;
    }

    @NotNull
    public final Schema getPointSchema$common() {
        return pointSchema;
    }

    @NotNull
    public final Schema getSchema() {
        return schema;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Struct toConnectValue(@Nullable Object value) {
        Struct struct;
        Object object = value;
        if (object == null) {
            struct = null;
        } else if (object instanceof Boolean) {
            struct = this.getPropertyStruct(BOOLEAN, value);
        } else if (object instanceof Float) {
            struct = this.getPropertyStruct(FLOAT, ((Number)value).floatValue());
        } else if (object instanceof Double) {
            struct = this.getPropertyStruct(FLOAT, value);
        } else if (object instanceof Number) {
            struct = this.getPropertyStruct(LONG, ((Number)value).longValue());
        } else if (object instanceof String) {
            struct = this.getPropertyStruct(STRING, value);
        } else if (object instanceof Character) {
            struct = this.getPropertyStruct(STRING, String.valueOf(((Character)value).charValue()));
        } else if (object instanceof char[]) {
            struct = this.getPropertyStruct(STRING, new String((char[])value));
        } else if (object instanceof CharSequence) {
            void it;
            int[] nArray = ((CharSequence)value).codePoints().toArray();
            String string2 = STRING;
            PropertyType propertyType = this;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            String string3 = new String((int[])it, 0, ((void)it).length);
            struct = propertyType.getPropertyStruct(string2, string3);
        } else if (object instanceof byte[]) {
            struct = this.getPropertyStruct(BYTES, value);
        } else if (object instanceof ByteBuffer) {
            struct = this.getPropertyStruct(BYTES, ((ByteBuffer)value).array());
        } else if (object instanceof LocalDate) {
            struct = this.getPropertyStruct(LOCAL_DATE, DateTimeFormatter.ISO_DATE.format((TemporalAccessor)value));
        } else if (object instanceof LocalDateTime) {
            struct = this.getPropertyStruct(LOCAL_DATE_TIME, DateTimeFormatter.ISO_DATE_TIME.format((TemporalAccessor)value));
        } else if (object instanceof LocalTime) {
            struct = this.getPropertyStruct(LOCAL_TIME, DateTimeFormatter.ISO_TIME.format((TemporalAccessor)value));
        } else if (object instanceof OffsetDateTime) {
            struct = this.getPropertyStruct(ZONED_DATE_TIME, DateTimeFormatter.ISO_DATE_TIME.format((TemporalAccessor)value));
        } else if (object instanceof ZonedDateTime) {
            struct = this.getPropertyStruct(ZONED_DATE_TIME, DateTimeFormatter.ISO_DATE_TIME.format((TemporalAccessor)value));
        } else if (object instanceof OffsetTime) {
            struct = this.getPropertyStruct(OFFSET_TIME, DateTimeFormatter.ISO_TIME.format((TemporalAccessor)value));
        } else if (object instanceof IsoDuration) {
            Struct durationStruct = new Struct(durationSchema).put("months", (Object)((IsoDuration)value).months()).put("days", (Object)((IsoDuration)value).days()).put("seconds", (Object)((IsoDuration)value).seconds()).put("nanoseconds", (Object)((IsoDuration)value).nanoseconds());
            struct = this.getPropertyStruct(DURATION, durationStruct);
        } else if (object instanceof Point) {
            Struct it;
            Struct it2 = it = new Struct(pointSchema).put("srid", (Object)((Point)value).srid()).put("x", (Object)((Point)value).x()).put("y", (Object)((Point)value).y());
            boolean bl = false;
            it2.put("dimension", (Object)(Double.isNaN(((Point)value).z()) ? (byte)2 : 3));
            if (!Double.isNaN(((Point)value).z())) {
                it2.put("z", (Object)((Point)value).z());
            }
            Struct pointStruct = it;
            struct = this.getPropertyStruct(POINT, pointStruct);
        } else if (object instanceof short[]) {
            Collection<Long> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            short[] pointStruct = (short[])value;
            String string4 = LONG_LIST;
            PropertyType propertyType = this;
            boolean $i$f$map = false;
            void it2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
            boolean $i$f$mapTo = false;
            int n = ((void)$this$mapTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void it;
                void item$iv$iv;
                void var11_55 = item$iv$iv = $this$mapTo$iv$iv[i];
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add((long)it);
            }
            collection = (List)destination$iv$iv;
            struct = propertyType.getPropertyStruct(string4, collection);
        } else if (object instanceof int[]) {
            Collection<Long> collection;
            int[] $this$map$iv = (int[])value;
            String string5 = LONG_LIST;
            PropertyType propertyType = this;
            boolean $i$f$map = false;
            int[] $this$mapTo$iv$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            int n = $this$mapTo$iv$iv.length;
            for (int i = 0; i < n; ++i) {
                int item$iv$iv;
                int it = item$iv$iv = $this$mapTo$iv$iv[i];
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(Long.valueOf(it));
            }
            collection = (List)destination$iv$iv;
            struct = propertyType.getPropertyStruct(string5, collection);
        } else if (object instanceof long[]) {
            struct = this.getPropertyStruct(LONG_LIST, ArraysKt.toList((long[])((long[])value)));
        } else if (object instanceof float[]) {
            Collection<Double> collection;
            float[] $this$map$iv = (float[])value;
            String string6 = FLOAT_LIST;
            PropertyType propertyType = this;
            boolean $i$f$map = false;
            float[] $this$mapTo$iv$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            int n = $this$mapTo$iv$iv.length;
            for (int i = 0; i < n; ++i) {
                float item$iv$iv;
                float it = item$iv$iv = $this$mapTo$iv$iv[i];
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(Double.valueOf(it));
            }
            collection = (List)destination$iv$iv;
            struct = propertyType.getPropertyStruct(string6, collection);
        } else if (object instanceof double[]) {
            struct = this.getPropertyStruct(FLOAT_LIST, ArraysKt.toList((double[])((double[])value)));
        } else if (object instanceof boolean[]) {
            struct = this.getPropertyStruct(BOOLEAN_LIST, ArraysKt.toList((boolean[])((boolean[])value)));
        } else if (object instanceof Object[]) {
            Iterable iterable = ArraysKt.toList((Object[])((Object[])value));
            Class<?> clazz = value.getClass().getComponentType();
            Intrinsics.checkNotNullExpressionValue(clazz, (String)"getComponentType(...)");
            struct = this.asList(iterable, JvmClassMappingKt.getKotlinClass(clazz));
        } else {
            if (object instanceof Iterable) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = (Iterable)value;
                boolean $i$f$map = false;
                Iterable destination$iv$iv = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                Iterator iterator = $this$mapTo$iv$iv.iterator();
                while (iterator.hasNext()) {
                    Object item$iv$iv;
                    Object it = item$iv$iv = iterator.next();
                    Collection collection = destination$iv$iv2;
                    boolean bl = false;
                    Object t = it;
                    collection.add(t != null && (t = t.getClass()) != null ? JvmClassMappingKt.getKotlinClass(t) : null);
                }
                Set elementTypes = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
                if (elementTypes.isEmpty()) {
                    return this.asList((Iterable)value, Reflection.getOrCreateKotlinClass(Integer.TYPE));
                }
                KClass elementType = (KClass)CollectionsKt.singleOrNull((Iterable)elementTypes);
                if (elementType != null) {
                    return this.asList((Iterable)value, elementType);
                }
                throw new IllegalArgumentException("collections with multiple element types are not supported: " + CollectionsKt.joinToString$default((Iterable)elementTypes, null, null, null, (int)0, null, PropertyType::toConnectValue$lambda$6, (int)31, null));
            }
            throw new IllegalArgumentException("unsupported property type: " + value.getClass().getName());
        }
        return struct;
    }

    /*
     * WARNING - void declaration
     */
    private final Struct asList(Iterable<?> value, KClass<?> componentType) {
        Struct struct;
        KClass<?> kClass = componentType;
        if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Boolean.TYPE))) {
            struct = this.getPropertyStruct(BOOLEAN_LIST, value);
        } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Byte.TYPE))) {
            Intrinsics.checkNotNull(value, (String)"null cannot be cast to non-null type kotlin.collections.List<kotlin.Byte>");
            struct = this.getPropertyStruct(BYTES, CollectionsKt.toByteArray((Collection)((List)value)));
        } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Short.TYPE))) {
            Collection<Long> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Intrinsics.checkNotNull(value, (String)"null cannot be cast to non-null type kotlin.collections.List<kotlin.Short>");
            Iterable iterable = (List)value;
            String string2 = LONG_LIST;
            PropertyType propertyType = this;
            boolean $i$f$map = false;
            void var6_48 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                short s = ((Number)item$iv$iv).shortValue();
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add((long)it);
            }
            collection = (List)destination$iv$iv;
            struct = propertyType.getPropertyStruct(string2, collection);
        } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE))) {
            Collection<Long> collection;
            Intrinsics.checkNotNull(value, (String)"null cannot be cast to non-null type kotlin.collections.List<kotlin.Int>");
            Iterable $this$map$iv = (List)value;
            String string3 = LONG_LIST;
            PropertyType propertyType = this;
            boolean $i$f$map = false;
            Iterable $this$mapTo$iv$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                int it = ((Number)item$iv$iv).intValue();
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(Long.valueOf(it));
            }
            collection = (List)destination$iv$iv;
            struct = propertyType.getPropertyStruct(string3, collection);
        } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Long.TYPE))) {
            struct = this.getPropertyStruct(LONG_LIST, value);
        } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Float.TYPE))) {
            Collection<Double> collection;
            Intrinsics.checkNotNull(value, (String)"null cannot be cast to non-null type kotlin.collections.List<kotlin.Float>");
            Iterable $this$map$iv = (List)value;
            String string4 = FLOAT_LIST;
            PropertyType propertyType = this;
            boolean $i$f$map = false;
            Iterable $this$mapTo$iv$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                float it = ((Number)item$iv$iv).floatValue();
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(Double.valueOf(it));
            }
            collection = (List)destination$iv$iv;
            struct = propertyType.getPropertyStruct(string4, collection);
        } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Double.TYPE))) {
            struct = this.getPropertyStruct(FLOAT_LIST, value);
        } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(String.class))) {
            struct = this.getPropertyStruct(STRING_LIST, value);
        } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(LocalDate.class))) {
            Collection<String> collection;
            Intrinsics.checkNotNull(value, (String)"null cannot be cast to non-null type kotlin.collections.List<java.time.LocalDate>");
            Iterable $this$map$iv = (List)value;
            String string5 = LOCAL_DATE_LIST;
            PropertyType propertyType = this;
            boolean $i$f$map = false;
            Iterable $this$mapTo$iv$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                LocalDate it = (LocalDate)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(DateTimeFormatter.ISO_DATE.format(it));
            }
            collection = (List)destination$iv$iv;
            struct = propertyType.getPropertyStruct(string5, collection);
        } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(LocalDateTime.class))) {
            Collection<String> collection;
            Intrinsics.checkNotNull(value, (String)"null cannot be cast to non-null type kotlin.collections.List<java.time.LocalDateTime>");
            Iterable $this$map$iv = (List)value;
            String string6 = LOCAL_DATE_TIME_LIST;
            PropertyType propertyType = this;
            boolean $i$f$map = false;
            Iterable $this$mapTo$iv$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                LocalDateTime it = (LocalDateTime)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(DateTimeFormatter.ISO_DATE_TIME.format(it));
            }
            collection = (List)destination$iv$iv;
            struct = propertyType.getPropertyStruct(string6, collection);
        } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(LocalTime.class))) {
            Collection<String> collection;
            Intrinsics.checkNotNull(value, (String)"null cannot be cast to non-null type kotlin.collections.List<java.time.LocalTime>");
            Iterable $this$map$iv = (List)value;
            String string7 = LOCAL_TIME_LIST;
            PropertyType propertyType = this;
            boolean $i$f$map = false;
            Iterable $this$mapTo$iv$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                LocalTime it = (LocalTime)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(DateTimeFormatter.ISO_TIME.format(it));
            }
            collection = (List)destination$iv$iv;
            struct = propertyType.getPropertyStruct(string7, collection);
        } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(OffsetDateTime.class))) {
            Collection<String> collection;
            Intrinsics.checkNotNull(value, (String)"null cannot be cast to non-null type kotlin.collections.List<java.time.OffsetDateTime>");
            Iterable $this$map$iv = (List)value;
            String string8 = ZONED_DATE_TIME_LIST;
            PropertyType propertyType = this;
            boolean $i$f$map = false;
            Iterable $this$mapTo$iv$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                OffsetDateTime it = (OffsetDateTime)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(DateTimeFormatter.ISO_DATE_TIME.format(it));
            }
            collection = (List)destination$iv$iv;
            struct = propertyType.getPropertyStruct(string8, collection);
        } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(ZonedDateTime.class))) {
            Collection<String> collection;
            Intrinsics.checkNotNull(value, (String)"null cannot be cast to non-null type kotlin.collections.List<java.time.ZonedDateTime>");
            Iterable $this$map$iv = (List)value;
            String string9 = ZONED_DATE_TIME_LIST;
            PropertyType propertyType = this;
            boolean $i$f$map = false;
            Iterable $this$mapTo$iv$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                ZonedDateTime it = (ZonedDateTime)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(DateTimeFormatter.ISO_DATE_TIME.format(it));
            }
            collection = (List)destination$iv$iv;
            struct = propertyType.getPropertyStruct(string9, collection);
        } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(OffsetTime.class))) {
            Collection<String> collection;
            Intrinsics.checkNotNull(value, (String)"null cannot be cast to non-null type kotlin.collections.List<java.time.OffsetTime>");
            Iterable $this$map$iv = (List)value;
            String string10 = OFFSET_TIME_LIST;
            PropertyType propertyType = this;
            boolean $i$f$map = false;
            Iterable $this$mapTo$iv$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                OffsetTime it = (OffsetTime)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(DateTimeFormatter.ISO_TIME.format(it));
            }
            collection = (List)destination$iv$iv;
            struct = propertyType.getPropertyStruct(string10, collection);
        } else if (IsoDuration.class.isAssignableFrom(JvmClassMappingKt.getJavaClass(componentType))) {
            Collection<Struct> collection;
            Object it;
            Iterable $this$map$iv = value;
            String string11 = DURATION_LIST;
            PropertyType propertyType = this;
            boolean $i$f$map = false;
            Iterable $this$mapTo$iv$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator<Object> iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                Object item$iv$iv;
                it = item$iv$iv = iterator.next();
                collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull(it, (String)"null cannot be cast to non-null type org.neo4j.driver.types.IsoDuration");
                collection.add((Struct)((IsoDuration)it));
            }
            collection = (List)destination$iv$iv;
            $this$map$iv = collection;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (IsoDuration)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new Struct(durationSchema).put("months", (Object)it.months()).put("days", (Object)it.days()).put("seconds", (Object)it.seconds()).put("nanoseconds", (Object)it.nanoseconds()));
            }
            collection = (List)destination$iv$iv;
            struct = propertyType.getPropertyStruct(string11, collection);
        } else if (Point.class.isAssignableFrom(JvmClassMappingKt.getJavaClass(componentType))) {
            Collection<Struct> collection;
            Object it;
            Iterable $this$map$iv = value;
            String string12 = POINT_LIST;
            PropertyType propertyType = this;
            boolean $i$f$map = false;
            Iterable $this$mapTo$iv$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator<Object> iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                Object item$iv$iv;
                it = item$iv$iv = iterator.next();
                collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull(it, (String)"null cannot be cast to non-null type org.neo4j.driver.types.Point");
                collection.add((Struct)((Point)it));
            }
            collection = (List)destination$iv$iv;
            $this$map$iv = collection;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void point;
                Struct struct2;
                it = (Point)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                Struct it2 = struct2 = new Struct(pointSchema).put("srid", (Object)point.srid()).put("x", (Object)point.x()).put("y", (Object)point.y());
                boolean bl2 = false;
                it2.put("dimension", (Object)(Double.isNaN(point.z()) ? (byte)2 : 3));
                if (!Double.isNaN(point.z())) {
                    it2.put("z", (Object)point.z());
                }
                collection.add(struct2);
            }
            collection = (List)destination$iv$iv;
            struct = propertyType.getPropertyStruct(string12, collection);
        } else {
            throw new IllegalArgumentException("unsupported array type: array of " + JvmClassMappingKt.getJavaClass(componentType).getName());
        }
        return struct;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public final Object fromConnectValue(@Nullable Struct value) {
        Object fieldValue;
        int n;
        String fieldType;
        Struct it;
        block82: {
            if (value == null) return null;
            it = value;
            boolean bl = false;
            fieldType = it.getString(TYPE);
            if (!SIMPLE_TYPE_FIELDS.contains(fieldType)) break block82;
            String string2 = fieldType;
            Class<?> clazz = it.getWithoutDefault(fieldType);
            if (string2 == null) throw new IllegalArgumentException("unsupported simple type: " + fieldType + ": " + (clazz != null && (clazz = clazz.getClass()) != null ? clazz.getName() : null));
            n = -1;
            switch (string2.hashCode()) {
                case 2672: {
                    if (string2.equals(DURATION)) {
                        n = 1;
                    }
                    break;
                }
                case 2591126: {
                    if (string2.equals(ZONED_DATE_TIME)) {
                        n = 2;
                    }
                    break;
                }
                case 66: {
                    if (string2.equals(BOOLEAN)) {
                        n = 3;
                    }
                    break;
                }
                case 83: {
                    if (string2.equals(STRING)) {
                        n = 4;
                    }
                    break;
                }
                case 68996: {
                    if (string2.equals(FLOAT)) {
                        n = 5;
                    }
                    break;
                }
                case 71879: {
                    if (string2.equals(LONG)) {
                        n = 6;
                    }
                    break;
                }
                case 83257: {
                    if (string2.equals(OFFSET_TIME)) {
                        n = 7;
                    }
                    break;
                }
                case 83148: {
                    if (string2.equals(LOCAL_DATE)) {
                        n = 8;
                    }
                    break;
                }
                case 83164: {
                    if (string2.equals(LOCAL_TIME)) {
                        n = 9;
                    }
                    break;
                }
                case 2653: {
                    if (string2.equals(POINT)) {
                        n = 10;
                    }
                    break;
                }
                case 2111: {
                    if (string2.equals(BYTES)) {
                        n = 11;
                    }
                    break;
                }
                case 2577672: {
                    if (string2.equals(LOCAL_DATE_TIME)) {
                        n = 12;
                    }
                    break;
                }
            }
            switch (n) {
                case 3: {
                    Object object = it.getWithoutDefault(BOOLEAN);
                    Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Boolean");
                    Object object2 = (Boolean)object;
                    return object2;
                }
                case 6: {
                    Object object = it.getWithoutDefault(LONG);
                    Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Long");
                    Object object2 = (Long)object;
                    return object2;
                }
                case 5: {
                    Object object = it.getWithoutDefault(FLOAT);
                    Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Double");
                    Object object2 = (Double)object;
                    return object2;
                }
                case 4: {
                    Object object = it.getWithoutDefault(STRING);
                    Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
                    Object object2 = (String)object;
                    return object2;
                }
                case 11: {
                    Object object2;
                    Class<?> bytes = it.getWithoutDefault(BYTES);
                    if (bytes instanceof byte[]) {
                        object2 = (byte[])bytes;
                        return object2;
                    }
                    Class<?> clazz2 = bytes;
                    if (!(bytes instanceof ByteBuffer)) throw new IllegalArgumentException("unsupported BYTES value: " + (clazz2 != null && (clazz2 = clazz2.getClass()) != null ? clazz2.getName() : null));
                    object2 = ((ByteBuffer)((Object)bytes)).array();
                    return object2;
                }
                case 8: {
                    Object object = it.getWithoutDefault(LOCAL_DATE);
                    Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
                    Object object2 = INSTANCE.parseLocalDate((String)object);
                    return object2;
                }
                case 9: {
                    Object object = it.getWithoutDefault(LOCAL_TIME);
                    Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
                    Object object2 = INSTANCE.parseLocalTime((String)object);
                    return object2;
                }
                case 12: {
                    Object object = it.getWithoutDefault(LOCAL_DATE_TIME);
                    Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
                    Object object2 = INSTANCE.parseLocalDateTime((String)object);
                    return object2;
                }
                case 2: {
                    Object object = it.getWithoutDefault(ZONED_DATE_TIME);
                    Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
                    Object object2 = INSTANCE.parseZonedDateTime((String)object);
                    return object2;
                }
                case 7: {
                    Object object = it.getWithoutDefault(OFFSET_TIME);
                    Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
                    Object object2 = INSTANCE.parseOffsetTime((String)object);
                    return object2;
                }
                case 1: {
                    Object object = it.getWithoutDefault(DURATION);
                    Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.apache.kafka.connect.data.Struct");
                    Object object2 = INSTANCE.toDuration((Struct)object);
                    return object2;
                }
                case 10: {
                    Object object = it.getWithoutDefault(POINT);
                    Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.apache.kafka.connect.data.Struct");
                    Object object2 = INSTANCE.toPoint((Struct)object);
                    return object2;
                }
                default: {
                    throw new IllegalArgumentException("unsupported simple type: " + fieldType + ": " + (clazz != null && (clazz = clazz.getClass()) != null ? clazz.getName() : null));
                }
            }
        }
        if (!LIST_TYPE_FIELDS.contains(fieldType) || (fieldValue = it.getWithoutDefault(fieldType)) == null || !(fieldValue instanceof Collection) || !(!((Collection)fieldValue).isEmpty())) return CollectionsKt.emptyList();
        String string3 = fieldType;
        if (string3 == null) throw new IllegalArgumentException("unsupported list type: " + fieldType + ": " + fieldValue.getClass().getName());
        tmp = -1;
        switch (string3.hashCode()) {
            case 72765268: {
                if (string3.equals(LOCAL_DATE_TIME_LIST)) {
                    tmp = 1;
                }
                break;
            }
            case 2347264: {
                if (string3.equals(LOCAL_DATE_LIST)) {
                    tmp = 2;
                }
                break;
            }
            case 2347280: {
                if (string3.equals(LOCAL_TIME_LIST)) {
                    tmp = 3;
                }
                break;
            }
            case 2422: {
                if (string3.equals(BOOLEAN_LIST)) {
                    tmp = 4;
                }
                break;
            }
            case 2439: {
                if (string3.equals(STRING_LIST)) {
                    tmp = 4;
                }
                break;
            }
            case 2335995: {
                if (string3.equals(LONG_LIST)) {
                    tmp = 4;
                }
                break;
            }
            case 75689: {
                if (string3.equals(POINT_LIST)) {
                    tmp = 5;
                }
                break;
            }
            case 2333112: {
                if (string3.equals(FLOAT_LIST)) {
                    tmp = 4;
                }
                break;
            }
            case 2352798: {
                if (string3.equals(ZONED_DATE_TIME_LIST)) {
                    tmp = 6;
                }
                break;
            }
            case 75708: {
                if (string3.equals(DURATION_LIST)) {
                    tmp = 7;
                }
                break;
            }
            case 2347373: {
                if (string3.equals(OFFSET_TIME_LIST)) {
                    tmp = 8;
                }
                break;
            }
        }
        switch (tmp) {
            case 4: {
                List list = (List)fieldValue;
                return list;
            }
            case 2: {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = (List)fieldValue;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void s;
                    String string4 = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(INSTANCE.parseLocalDate((String)s));
                }
                List list = (List)destination$iv$iv;
                return list;
            }
            case 3: {
                Iterable $this$map$iv = (List)fieldValue;
                boolean $i$f$map = false;
                Iterable $this$mapTo$iv$iv = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    String s = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(INSTANCE.parseLocalTime(s));
                }
                List list = (List)destination$iv$iv;
                return list;
            }
            case 1: {
                Iterable $this$map$iv = (List)fieldValue;
                boolean $i$f$map = false;
                Iterable $this$mapTo$iv$iv = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    String s = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(INSTANCE.parseLocalDateTime(s));
                }
                List list = (List)destination$iv$iv;
                return list;
            }
            case 6: {
                Iterable $this$map$iv = (List)fieldValue;
                boolean $i$f$map = false;
                Iterable $this$mapTo$iv$iv = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    String s = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(INSTANCE.parseZonedDateTime(s));
                }
                List list = (List)destination$iv$iv;
                return list;
            }
            case 8: {
                Iterable $this$map$iv = (List)fieldValue;
                boolean $i$f$map = false;
                Iterable $this$mapTo$iv$iv = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    String s = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(INSTANCE.parseOffsetTime(s));
                }
                List list = (List)destination$iv$iv;
                return list;
            }
            case 7: {
                Iterable $this$map$iv = (List)fieldValue;
                boolean $i$f$map = false;
                Iterable $this$mapTo$iv$iv = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    Struct s = (Struct)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(INSTANCE.toDuration(s));
                }
                List list = (List)destination$iv$iv;
                return list;
            }
            case 5: {
                Iterable $this$map$iv = (List)fieldValue;
                boolean $i$f$map = false;
                Iterable $this$mapTo$iv$iv = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    Struct s = (Struct)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(INSTANCE.toPoint(s));
                }
                List list = (List)destination$iv$iv;
                return list;
            }
            default: {
                throw new IllegalArgumentException("unsupported list type: " + fieldType + ": " + fieldValue.getClass().getName());
            }
        }
    }

    @NotNull
    public final Struct getPropertyStruct(@NotNull String type, @Nullable Object value) {
        Intrinsics.checkNotNullParameter((Object)type, (String)TYPE);
        Struct struct = new Struct(schema).put(TYPE, (Object)type).put(type, value);
        Intrinsics.checkNotNullExpressionValue((Object)struct, (String)"put(...)");
        return struct;
    }

    private final LocalDate parseLocalDate(String s) {
        LocalDate localDate = DateTimeFormatter.ISO_DATE.parse((CharSequence)s, PropertyType::parseLocalDate$lambda$0);
        Intrinsics.checkNotNullExpressionValue((Object)localDate, (String)"parse(...)");
        return localDate;
    }

    private final LocalTime parseLocalTime(String s) {
        LocalTime localTime = DateTimeFormatter.ISO_TIME.parse((CharSequence)s, PropertyType::parseLocalTime$lambda$0);
        Intrinsics.checkNotNullExpressionValue((Object)localTime, (String)"parse(...)");
        return localTime;
    }

    private final LocalDateTime parseLocalDateTime(String s) {
        LocalDateTime localDateTime = DateTimeFormatter.ISO_DATE_TIME.parse((CharSequence)s, PropertyType::parseLocalDateTime$lambda$0);
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"parse(...)");
        return localDateTime;
    }

    private final Object parseZonedDateTime(String s) {
        return DateTimeFormatter.ISO_DATE_TIME.parse((CharSequence)s, parseZonedDateTime.1.INSTANCE);
    }

    private final OffsetTime parseOffsetTime(String s) {
        OffsetTime offsetTime = DateTimeFormatter.ISO_TIME.parse((CharSequence)s, PropertyType::parseOffsetTime$lambda$0);
        Intrinsics.checkNotNullExpressionValue((Object)offsetTime, (String)"parse(...)");
        return offsetTime;
    }

    private final IsoDuration toDuration(Struct s) {
        Long l = s.getInt64("months");
        Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getInt64(...)");
        long l2 = ((Number)l).longValue();
        Long l3 = s.getInt64("days");
        Intrinsics.checkNotNullExpressionValue((Object)l3, (String)"getInt64(...)");
        long l4 = ((Number)l3).longValue();
        Long l5 = s.getInt64("seconds");
        Intrinsics.checkNotNullExpressionValue((Object)l5, (String)"getInt64(...)");
        long l6 = ((Number)l5).longValue();
        Integer n = s.getInt32("nanoseconds");
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getInt32(...)");
        IsoDuration isoDuration = Values.isoDuration((long)l2, (long)l4, (long)l6, (int)((Number)n).intValue()).asIsoDuration();
        Intrinsics.checkNotNullExpressionValue((Object)isoDuration, (String)"asIsoDuration(...)");
        return isoDuration;
    }

    private final Point toPoint(Struct s) {
        Value value;
        Byte dimension = s.getInt8("dimension");
        if (dimension == 2) {
            Integer n = s.getInt32("srid");
            Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getInt32(...)");
            int n2 = ((Number)n).intValue();
            Double d = s.getFloat64("x");
            Intrinsics.checkNotNullExpressionValue((Object)d, (String)"getFloat64(...)");
            double d2 = ((Number)d).doubleValue();
            Double d3 = s.getFloat64("y");
            Intrinsics.checkNotNullExpressionValue((Object)d3, (String)"getFloat64(...)");
            value = Values.point((int)n2, (double)d2, (double)((Number)d3).doubleValue());
        } else if (dimension == 3) {
            Integer n = s.getInt32("srid");
            Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getInt32(...)");
            int n3 = ((Number)n).intValue();
            Double d = s.getFloat64("x");
            Intrinsics.checkNotNullExpressionValue((Object)d, (String)"getFloat64(...)");
            double d4 = ((Number)d).doubleValue();
            Double d5 = s.getFloat64("y");
            Intrinsics.checkNotNullExpressionValue((Object)d5, (String)"getFloat64(...)");
            double d6 = ((Number)d5).doubleValue();
            Double d7 = s.getFloat64("z");
            Intrinsics.checkNotNullExpressionValue((Object)d7, (String)"getFloat64(...)");
            value = Values.point((int)n3, (double)d4, (double)d6, (double)((Number)d7).doubleValue());
        } else {
            throw new IllegalArgumentException("unsupported dimension value " + dimension);
        }
        Point point = value.asPoint();
        Intrinsics.checkNotNullExpressionValue((Object)point, (String)"asPoint(...)");
        return point;
    }

    private static final CharSequence toConnectValue$lambda$6(KClass it) {
        Object object = it;
        return object != null && (object = JvmClassMappingKt.getJavaClass((KClass)object)) != null && (object = ((Class)object).getName()) != null ? (CharSequence)object : (CharSequence)"null";
    }

    private static final LocalDate parseLocalDate$lambda$0(TemporalAccessor parsed) {
        return LocalDate.from(parsed);
    }

    private static final LocalTime parseLocalTime$lambda$0(TemporalAccessor parsed) {
        return LocalTime.from(parsed);
    }

    private static final LocalDateTime parseLocalDateTime$lambda$0(TemporalAccessor parsed) {
        return LocalDateTime.from(parsed);
    }

    private static final OffsetTime parseOffsetTime$lambda$0(TemporalAccessor parsed) {
        return OffsetTime.from(parsed);
    }

    static {
        String[] stringArray = new String[]{BOOLEAN, LONG, FLOAT, STRING, BYTES, LOCAL_DATE, LOCAL_DATE_TIME, LOCAL_TIME, ZONED_DATE_TIME, OFFSET_TIME, DURATION, POINT};
        SIMPLE_TYPE_FIELDS = CollectionsKt.listOf((Object[])stringArray);
        stringArray = new String[]{BOOLEAN_LIST, LONG_LIST, FLOAT_LIST, STRING_LIST, LOCAL_DATE_LIST, LOCAL_DATE_TIME_LIST, LOCAL_TIME_LIST, ZONED_DATE_TIME_LIST, OFFSET_TIME_LIST, DURATION_LIST, POINT_LIST};
        LIST_TYPE_FIELDS = CollectionsKt.listOf((Object[])stringArray);
        Schema schema = new SchemaBuilder(Schema.Type.STRUCT).field("months", Schema.INT64_SCHEMA).field("days", Schema.INT64_SCHEMA).field("seconds", Schema.INT64_SCHEMA).field("nanoseconds", Schema.INT32_SCHEMA).optional().build();
        Intrinsics.checkNotNullExpressionValue((Object)schema, (String)"build(...)");
        durationSchema = schema;
        Schema schema2 = new SchemaBuilder(Schema.Type.STRUCT).field("dimension", Schema.INT8_SCHEMA).field("srid", Schema.INT32_SCHEMA).field("x", Schema.FLOAT64_SCHEMA).field("y", Schema.FLOAT64_SCHEMA).field("z", Schema.OPTIONAL_FLOAT64_SCHEMA).optional().build();
        Intrinsics.checkNotNullExpressionValue((Object)schema2, (String)"build(...)");
        pointSchema = schema2;
        SchemaBuilder schemaBuilder = SchemaBuilder.struct();
        Intrinsics.checkNotNullExpressionValue((Object)schemaBuilder, (String)"struct(...)");
        String[] stringArray2 = new String[]{"Neo4jPropertyType"};
        stringArray = TypesCommonsKt.namespaced(schemaBuilder, stringArray2).field(TYPE, Schema.STRING_SCHEMA).field(BOOLEAN, Schema.OPTIONAL_BOOLEAN_SCHEMA).field(LONG, Schema.OPTIONAL_INT64_SCHEMA).field(FLOAT, Schema.OPTIONAL_FLOAT64_SCHEMA).field(STRING, Schema.OPTIONAL_STRING_SCHEMA).field(BYTES, Schema.OPTIONAL_BYTES_SCHEMA).field(LOCAL_DATE, Schema.OPTIONAL_STRING_SCHEMA).field(LOCAL_DATE_TIME, Schema.OPTIONAL_STRING_SCHEMA).field(LOCAL_TIME, Schema.OPTIONAL_STRING_SCHEMA).field(ZONED_DATE_TIME, Schema.OPTIONAL_STRING_SCHEMA).field(OFFSET_TIME, Schema.OPTIONAL_STRING_SCHEMA).field(DURATION, durationSchema).field(POINT, pointSchema).field(BOOLEAN_LIST, SchemaBuilder.array((Schema)Schema.BOOLEAN_SCHEMA).optional().build()).field(LONG_LIST, SchemaBuilder.array((Schema)Schema.INT64_SCHEMA).optional().build()).field(FLOAT_LIST, SchemaBuilder.array((Schema)Schema.FLOAT64_SCHEMA).optional().build()).field(STRING_LIST, SchemaBuilder.array((Schema)Schema.STRING_SCHEMA).optional().build()).field(LOCAL_DATE_LIST, SchemaBuilder.array((Schema)Schema.STRING_SCHEMA).optional().build()).field(LOCAL_DATE_TIME_LIST, SchemaBuilder.array((Schema)Schema.STRING_SCHEMA).optional().build()).field(LOCAL_TIME_LIST, SchemaBuilder.array((Schema)Schema.STRING_SCHEMA).optional().build()).field(ZONED_DATE_TIME_LIST, SchemaBuilder.array((Schema)Schema.STRING_SCHEMA).optional().build()).field(OFFSET_TIME_LIST, SchemaBuilder.array((Schema)Schema.STRING_SCHEMA).optional().build()).field(DURATION_LIST, SchemaBuilder.array((Schema)durationSchema).optional().build()).field(POINT_LIST, SchemaBuilder.array((Schema)pointSchema).optional().build()).optional().build();
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"build(...)");
        PropertyType.schema = stringArray;
    }
}

