/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.connectors.kafka.sink;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.Predicate;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.apache.kafka.common.config.Config;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.ConfigValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.neo4j.caniuse.Neo4j;
import org.neo4j.caniuse.Neo4jDetector;
import org.neo4j.connectors.kafka.configuration.ConnectorType;
import org.neo4j.connectors.kafka.configuration.Groups;
import org.neo4j.connectors.kafka.configuration.Neo4jConfiguration;
import org.neo4j.connectors.kafka.configuration.helpers.ConfigKeyBuilder;
import org.neo4j.connectors.kafka.configuration.helpers.Recommenders;
import org.neo4j.connectors.kafka.configuration.helpers.Validators;
import org.neo4j.connectors.kafka.sink.Cypher5Renderer;
import org.neo4j.connectors.kafka.sink.SinkStrategyHandler;
import org.neo4j.cypherdsl.core.renderer.Renderer;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 :2\u00020\u0001:\u0001:B\u001b\b\u0016\u0012\u0010\u0010\u0002\u001a\f\u0012\u0004\u0012\u00020\u0004\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006B%\b\u0017\u0012\u0010\u0010\u0007\u001a\f\u0012\u0004\u0012\u00020\u0004\u0012\u0002\b\u00030\u0003\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\u0005\u0010\nJ\b\u00107\u001a\u00020\u0004H\u0016J\b\u00108\u001a\u000209H\u0002R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0012R\u0011\u0010\u0015\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0012R\u0011\u0010\u0017\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0012R\u0011\u0010\u0019\u001a\u00020\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u001d\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u0012R\u0011\u0010\u001f\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b \u0010\u0012R\u0011\u0010!\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u0012R\u0011\u0010#\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u0012R\u001b\u0010%\u001a\u00020&8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b)\u0010*\u001a\u0004\b'\u0010(R\u001b\u0010\b\u001a\u00020\t8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b-\u0010*\u001a\u0004\b+\u0010,R\u0017\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00040/8F\u00a2\u0006\u0006\u001a\u0004\b0\u00101R'\u00102\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u0002030\u00038FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b6\u0010*\u001a\u0004\b4\u00105\u00a8\u0006;"}, d2={"Lorg/neo4j/connectors/kafka/sink/SinkConfiguration;", "Lorg/neo4j/connectors/kafka/configuration/Neo4jConfiguration;", "original", "", "", "<init>", "(Ljava/util/Map;)V", "originals", "renderer", "Lorg/neo4j/cypherdsl/core/renderer/Renderer;", "(Ljava/util/Map;Lorg/neo4j/cypherdsl/core/renderer/Renderer;)V", "fixedRenderer", "batchSize", "", "getBatchSize", "()I", "cypherBindTimestampAs", "getCypherBindTimestampAs", "()Ljava/lang/String;", "cypherBindHeaderAs", "getCypherBindHeaderAs", "cypherBindKeyAs", "getCypherBindKeyAs", "cypherBindValueAs", "getCypherBindValueAs", "cypherBindValueAsEvent", "", "getCypherBindValueAsEvent", "()Z", "patternBindTimestampAs", "getPatternBindTimestampAs", "patternBindHeaderAs", "getPatternBindHeaderAs", "patternBindKeyAs", "getPatternBindKeyAs", "patternBindValueAs", "getPatternBindValueAs", "neo4j", "Lorg/neo4j/caniuse/Neo4j;", "getNeo4j", "()Lorg/neo4j/caniuse/Neo4j;", "neo4j$delegate", "Lkotlin/Lazy;", "getRenderer", "()Lorg/neo4j/cypherdsl/core/renderer/Renderer;", "renderer$delegate", "topicNames", "", "getTopicNames", "()Ljava/util/List;", "topicHandlers", "Lorg/neo4j/connectors/kafka/sink/SinkStrategyHandler;", "getTopicHandlers", "()Ljava/util/Map;", "topicHandlers$delegate", "userAgentComment", "validateAllTopics", "", "Companion", "sink"})
@SourceDebugExtension(value={"SMAP\nSinkConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SinkConfiguration.kt\norg/neo4j/connectors/kafka/sink/SinkConfiguration\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,329:1\n1563#2:330\n1634#2,3:331\n*S KotlinDebug\n*F\n+ 1 SinkConfiguration.kt\norg/neo4j/connectors/kafka/sink/SinkConfiguration\n*L\n89#1:330\n89#1:331,3\n*E\n"})
public final class SinkConfiguration
extends Neo4jConfiguration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Renderer fixedRenderer;
    @NotNull
    private final Lazy neo4j$delegate;
    @NotNull
    private final Lazy renderer$delegate;
    @NotNull
    private final Lazy topicHandlers$delegate;
    @NotNull
    public static final String BATCH_SIZE = "neo4j.batch-size";
    @NotNull
    public static final String BATCH_TIMEOUT = "neo4j.batch-timeout";
    @NotNull
    public static final String CYPHER_TOPIC_PREFIX = "neo4j.cypher.topic.";
    @NotNull
    public static final String CYPHER_BIND_TIMESTAMP_AS = "neo4j.cypher.bind-timestamp-as";
    @NotNull
    public static final String CYPHER_BIND_HEADER_AS = "neo4j.cypher.bind-header-as";
    @NotNull
    public static final String CYPHER_BIND_KEY_AS = "neo4j.cypher.bind-key-as";
    @NotNull
    public static final String CYPHER_BIND_VALUE_AS = "neo4j.cypher.bind-value-as";
    @NotNull
    public static final String CYPHER_BIND_VALUE_AS_EVENT = "neo4j.cypher.bind-value-as-event";
    @NotNull
    public static final String CDC_SOURCE_ID_TOPICS = "neo4j.cdc.source-id.topics";
    @NotNull
    public static final String CDC_SOURCE_ID_LABEL_NAME = "neo4j.cdc.source-id.label-name";
    @NotNull
    public static final String CDC_SOURCE_ID_PROPERTY_NAME = "neo4j.cdc.source-id.property-name";
    @NotNull
    public static final String CDC_SCHEMA_TOPICS = "neo4j.cdc.schema.topics";
    @NotNull
    public static final String PATTERN_BIND_TIMESTAMP_AS = "neo4j.pattern.bind-timestamp-as";
    @NotNull
    public static final String PATTERN_BIND_HEADER_AS = "neo4j.pattern.bind-header-as";
    @NotNull
    public static final String PATTERN_BIND_KEY_AS = "neo4j.pattern.bind-key-as";
    @NotNull
    public static final String PATTERN_BIND_VALUE_AS = "neo4j.pattern.bind-value-as";
    @NotNull
    public static final String PATTERN_TOPIC_PREFIX = "neo4j.pattern.topic.";
    @NotNull
    public static final String PATTERN_MERGE_NODE_PROPERTIES = "neo4j.pattern.merge-node-properties";
    @NotNull
    public static final String PATTERN_MERGE_RELATIONSHIP_PROPERTIES = "neo4j.pattern.merge-relationship-properties";
    @NotNull
    public static final String CUD_TOPICS = "neo4j.cud.topics";
    private static final int DEFAULT_BATCH_SIZE = 1000;
    private static final long DEFAULT_BATCH_TIMEOUT = DurationKt.toDuration((int)0, (DurationUnit)DurationUnit.SECONDS);
    private static final boolean DEFAULT_TOPIC_PATTERN_MERGE_NODE_PROPERTIES = false;
    private static final boolean DEFAULT_TOPIC_PATTERN_MERGE_RELATIONSHIP_PROPERTIES = false;
    @NotNull
    public static final String DEFAULT_BIND_TIMESTAMP_ALIAS = "__timestamp";
    @NotNull
    public static final String DEFAULT_BIND_HEADER_ALIAS = "__header";
    @NotNull
    public static final String DEFAULT_BIND_KEY_ALIAS = "__key";
    @NotNull
    public static final String DEFAULT_BIND_VALUE_ALIAS = "__value";
    public static final boolean DEFAULT_CYPHER_BIND_VALUE_AS_EVENT = true;
    @NotNull
    public static final String DEFAULT_SOURCE_ID_LABEL_NAME = "SourceEvent";
    @NotNull
    public static final String DEFAULT_SOURCE_ID_PROPERTY_NAME = "sourceId";

    public SinkConfiguration(@NotNull Map<String, ?> original) {
        Intrinsics.checkNotNullParameter(original, (String)"original");
        this(original, null);
    }

    @TestOnly
    public SinkConfiguration(@NotNull Map<String, ?> originals, @Nullable Renderer renderer) {
        Intrinsics.checkNotNullParameter(originals, (String)"originals");
        super(Companion.config(), originals, ConnectorType.SINK);
        this.neo4j$delegate = LazyKt.lazy(() -> SinkConfiguration.neo4j_delegate$lambda$0(this));
        this.renderer$delegate = LazyKt.lazy(() -> SinkConfiguration.renderer_delegate$lambda$0(this));
        this.topicHandlers$delegate = LazyKt.lazy(() -> SinkConfiguration.topicHandlers_delegate$lambda$0(this));
        this.fixedRenderer = renderer;
        this.validateAllTopics();
    }

    public final int getBatchSize() {
        Integer n = this.getInt(BATCH_SIZE);
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getInt(...)");
        return ((Number)n).intValue();
    }

    @NotNull
    public final String getCypherBindTimestampAs() {
        String string = this.getString(CYPHER_BIND_TIMESTAMP_AS);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        return string;
    }

    @NotNull
    public final String getCypherBindHeaderAs() {
        String string = this.getString(CYPHER_BIND_HEADER_AS);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        return string;
    }

    @NotNull
    public final String getCypherBindKeyAs() {
        String string = this.getString(CYPHER_BIND_KEY_AS);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        return string;
    }

    @NotNull
    public final String getCypherBindValueAs() {
        String string = this.getString(CYPHER_BIND_VALUE_AS);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        return string;
    }

    public final boolean getCypherBindValueAsEvent() {
        return Boolean.parseBoolean(this.getString(CYPHER_BIND_VALUE_AS_EVENT));
    }

    @NotNull
    public final String getPatternBindTimestampAs() {
        String string = this.getString(PATTERN_BIND_TIMESTAMP_AS);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        return string;
    }

    @NotNull
    public final String getPatternBindHeaderAs() {
        String string = this.getString(PATTERN_BIND_HEADER_AS);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        return string;
    }

    @NotNull
    public final String getPatternBindKeyAs() {
        String string = this.getString(PATTERN_BIND_KEY_AS);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        return string;
    }

    @NotNull
    public final String getPatternBindValueAs() {
        String string = this.getString(PATTERN_BIND_VALUE_AS);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        return string;
    }

    @NotNull
    public final Neo4j getNeo4j() {
        Lazy lazy = this.neo4j$delegate;
        return (Neo4j)lazy.getValue();
    }

    @NotNull
    public final Renderer getRenderer() {
        Lazy lazy = this.renderer$delegate;
        return (Renderer)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> getTopicNames() {
        Object object;
        block4: {
            block3: {
                void $this$mapTo$iv$iv;
                char[] cArray;
                object = (String)this.originalsStrings().get("topics");
                if (object == null || (object = StringsKt.split$default((CharSequence)((CharSequence)object), (char[])(cArray = new char[]{','}), (boolean)false, (int)0, (int)6, null)) == null) break block3;
                Iterable $this$map$iv = (Iterable)object;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    String string = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(((Object)StringsKt.trim((CharSequence)((CharSequence)it))).toString());
                }
                object = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
                if (object != null) break block4;
            }
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    @NotNull
    public final Map<String, SinkStrategyHandler> getTopicHandlers() {
        Lazy lazy = this.topicHandlers$delegate;
        return (Map)lazy.getValue();
    }

    @NotNull
    public String userAgentComment() {
        return CollectionsKt.joinToString$default((Iterable)CollectionsKt.sorted((Iterable)SinkStrategyHandler.Companion.configuredStrategies(this)), (CharSequence)"; ", null, null, (int)0, null, null, (int)62, null);
    }

    private final void validateAllTopics() {
        Set<String> configuredTopics;
        Set sourceTopics = CollectionsKt.toSet((Iterable)this.getTopicNames());
        if (!Intrinsics.areEqual((Object)sourceTopics, configuredTopics = this.getTopicHandlers().keySet())) {
            throw new ConfigException("There is a mismatch between topics defined into the property `topics` (" + sourceTopics + ") and configured strategies (" + configuredTopics + ")");
        }
    }

    private static final Neo4j neo4j_delegate$lambda$0(SinkConfiguration this$0) {
        return Neo4jDetector.INSTANCE.detect(this$0.getDriver());
    }

    private static final Renderer renderer_delegate$lambda$0(SinkConfiguration this$0) {
        Renderer renderer = this$0.fixedRenderer;
        if (renderer == null) {
            renderer = new Cypher5Renderer(this$0.getNeo4j());
        }
        return renderer;
    }

    private static final Map topicHandlers_delegate$lambda$0(SinkConfiguration this$0) {
        return SinkStrategyHandler.Companion.createFrom(this$0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0014\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+J!\u0010,\u001a\u0004\u0018\u0001H-\"\u0004\b\u0000\u0010-*\u00020+2\u0006\u0010.\u001a\u00020\u0005H\u0002\u00a2\u0006\u0002\u0010/J\u0006\u0010*\u001a\u000200R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001dR\u000e\u0010\u001e\u001a\u00020\u001fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u001fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u001fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lorg/neo4j/connectors/kafka/sink/SinkConfiguration$Companion;", "", "<init>", "()V", "BATCH_SIZE", "", "BATCH_TIMEOUT", "CYPHER_TOPIC_PREFIX", "CYPHER_BIND_TIMESTAMP_AS", "CYPHER_BIND_HEADER_AS", "CYPHER_BIND_KEY_AS", "CYPHER_BIND_VALUE_AS", "CYPHER_BIND_VALUE_AS_EVENT", "CDC_SOURCE_ID_TOPICS", "CDC_SOURCE_ID_LABEL_NAME", "CDC_SOURCE_ID_PROPERTY_NAME", "CDC_SCHEMA_TOPICS", "PATTERN_BIND_TIMESTAMP_AS", "PATTERN_BIND_HEADER_AS", "PATTERN_BIND_KEY_AS", "PATTERN_BIND_VALUE_AS", "PATTERN_TOPIC_PREFIX", "PATTERN_MERGE_NODE_PROPERTIES", "PATTERN_MERGE_RELATIONSHIP_PROPERTIES", "CUD_TOPICS", "DEFAULT_BATCH_SIZE", "", "DEFAULT_BATCH_TIMEOUT", "Lkotlin/time/Duration;", "J", "DEFAULT_TOPIC_PATTERN_MERGE_NODE_PROPERTIES", "", "DEFAULT_TOPIC_PATTERN_MERGE_RELATIONSHIP_PROPERTIES", "DEFAULT_BIND_TIMESTAMP_ALIAS", "DEFAULT_BIND_HEADER_ALIAS", "DEFAULT_BIND_KEY_ALIAS", "DEFAULT_BIND_VALUE_ALIAS", "DEFAULT_CYPHER_BIND_VALUE_AS_EVENT", "DEFAULT_SOURCE_ID_LABEL_NAME", "DEFAULT_SOURCE_ID_PROPERTY_NAME", "validate", "", "config", "Lorg/apache/kafka/common/config/Config;", "value", "T", "key", "(Lorg/apache/kafka/common/config/Config;Ljava/lang/String;)Ljava/lang/Object;", "Lorg/apache/kafka/common/config/ConfigDef;", "sink"})
    @SourceDebugExtension(value={"SMAP\nSinkConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SinkConfiguration.kt\norg/neo4j/connectors/kafka/sink/SinkConfiguration$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,329:1\n774#2:330\n865#2,2:331\n1869#2,2:333\n230#2,2:335\n1#3:337\n*S KotlinDebug\n*F\n+ 1 SinkConfiguration.kt\norg/neo4j/connectors/kafka/sink/SinkConfiguration$Companion\n*L\n164#1:330\n164#1:331,2\n174#1:333,2\n184#1:335,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        public final void validate(@NotNull Config config) {
            boolean cypherUseEventForValue;
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            Neo4jConfiguration.Companion.validate(config);
            CharSequence charSequence = (CharSequence)this.value(config, SinkConfiguration.CYPHER_BIND_TIMESTAMP_AS);
            boolean cypherAliasForTimestamp = charSequence == null || charSequence.length() == 0;
            CharSequence charSequence2 = (CharSequence)this.value(config, SinkConfiguration.CYPHER_BIND_HEADER_AS);
            boolean cypherAliasForHeader = charSequence2 == null || charSequence2.length() == 0;
            CharSequence charSequence3 = (CharSequence)this.value(config, SinkConfiguration.CYPHER_BIND_KEY_AS);
            boolean cypherAliasForKey = charSequence3 == null || charSequence3.length() == 0;
            CharSequence charSequence4 = (CharSequence)this.value(config, SinkConfiguration.CYPHER_BIND_VALUE_AS);
            boolean cypherAliasForValue = charSequence4 == null || charSequence4.length() == 0;
            String string = (String)this.value(config, SinkConfiguration.CYPHER_BIND_VALUE_AS_EVENT);
            boolean bl = cypherUseEventForValue = string != null ? Boolean.parseBoolean(string) : true;
            if (!cypherUseEventForValue && cypherAliasForHeader && cypherAliasForKey && cypherAliasForValue && cypherAliasForTimestamp) {
                void $this$forEach$iv;
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv;
                List list = config.configValues();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"configValues(...)");
                Iterable iterable = list;
                boolean $i$f$filter = false;
                Iterator iterator = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    ConfigValue it = (ConfigValue)element$iv$iv;
                    boolean bl2 = false;
                    Object[] objectArray = new String[]{SinkConfiguration.CYPHER_BIND_TIMESTAMP_AS, SinkConfiguration.CYPHER_BIND_HEADER_AS, SinkConfiguration.CYPHER_BIND_KEY_AS, SinkConfiguration.CYPHER_BIND_VALUE_AS, SinkConfiguration.CYPHER_BIND_VALUE_AS_EVENT};
                    if (!CollectionsKt.listOf((Object[])objectArray).contains(it.name())) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    ConfigValue it = (ConfigValue)element$iv;
                    boolean bl3 = false;
                    it.addErrorMessage("At least one variable binding must be specified for Cypher strategies.");
                }
            }
        }

        private final <T> T value(Config $this$value, String key) {
            Object element$iv2;
            block1: {
                List list = $this$value.configValues();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"configValues(...)");
                Iterable $this$first$iv = list;
                boolean $i$f$first = false;
                for (Object element$iv2 : $this$first$iv) {
                    ConfigValue it = (ConfigValue)element$iv2;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.name(), (Object)key)) continue;
                    break block1;
                }
                throw new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            ConfigValue it = (ConfigValue)element$iv2;
            boolean bl = false;
            return (T)it.value();
        }

        @NotNull
        public final ConfigDef config() {
            ConfigDef configDef = Neo4jConfiguration.Companion.config().define(ConfigKeyBuilder.Companion.of(SinkConfiguration.CDC_SOURCE_ID_TOPICS, ConfigDef.Type.LIST, Companion::config$lambda$0)).define(ConfigKeyBuilder.Companion.of(SinkConfiguration.CDC_SCHEMA_TOPICS, ConfigDef.Type.LIST, Companion::config$lambda$1)).define(ConfigKeyBuilder.Companion.of(SinkConfiguration.CUD_TOPICS, ConfigDef.Type.LIST, Companion::config$lambda$2)).define(ConfigKeyBuilder.Companion.of(SinkConfiguration.BATCH_SIZE, ConfigDef.Type.INT, Companion::config$lambda$3)).define(ConfigKeyBuilder.Companion.of(SinkConfiguration.BATCH_TIMEOUT, ConfigDef.Type.STRING, Companion::config$lambda$4)).define(ConfigKeyBuilder.Companion.of(SinkConfiguration.CDC_SOURCE_ID_LABEL_NAME, ConfigDef.Type.STRING, Companion::config$lambda$5)).define(ConfigKeyBuilder.Companion.of(SinkConfiguration.CDC_SOURCE_ID_PROPERTY_NAME, ConfigDef.Type.STRING, Companion::config$lambda$6)).define(ConfigKeyBuilder.Companion.of(SinkConfiguration.CYPHER_BIND_TIMESTAMP_AS, ConfigDef.Type.STRING, Companion::config$lambda$7)).define(ConfigKeyBuilder.Companion.of(SinkConfiguration.CYPHER_BIND_HEADER_AS, ConfigDef.Type.STRING, Companion::config$lambda$8)).define(ConfigKeyBuilder.Companion.of(SinkConfiguration.CYPHER_BIND_KEY_AS, ConfigDef.Type.STRING, Companion::config$lambda$9)).define(ConfigKeyBuilder.Companion.of(SinkConfiguration.CYPHER_BIND_VALUE_AS, ConfigDef.Type.STRING, Companion::config$lambda$10)).define(ConfigKeyBuilder.Companion.of(SinkConfiguration.CYPHER_BIND_VALUE_AS_EVENT, ConfigDef.Type.STRING, Companion::config$lambda$11)).define(ConfigKeyBuilder.Companion.of(SinkConfiguration.PATTERN_BIND_TIMESTAMP_AS, ConfigDef.Type.STRING, Companion::config$lambda$12)).define(ConfigKeyBuilder.Companion.of(SinkConfiguration.PATTERN_BIND_HEADER_AS, ConfigDef.Type.STRING, Companion::config$lambda$13)).define(ConfigKeyBuilder.Companion.of(SinkConfiguration.PATTERN_BIND_KEY_AS, ConfigDef.Type.STRING, Companion::config$lambda$14)).define(ConfigKeyBuilder.Companion.of(SinkConfiguration.PATTERN_BIND_VALUE_AS, ConfigDef.Type.STRING, Companion::config$lambda$15)).define(ConfigKeyBuilder.Companion.of(SinkConfiguration.PATTERN_MERGE_NODE_PROPERTIES, ConfigDef.Type.STRING, Companion::config$lambda$16)).define(ConfigKeyBuilder.Companion.of(SinkConfiguration.PATTERN_MERGE_RELATIONSHIP_PROPERTIES, ConfigDef.Type.STRING, Companion::config$lambda$17));
            Intrinsics.checkNotNullExpressionValue((Object)configDef, (String)"define(...)");
            return configDef;
        }

        private static final Unit config$lambda$0(ConfigKeyBuilder $this$of) {
            Intrinsics.checkNotNullParameter((Object)$this$of, (String)"$this$of");
            $this$of.setImportance(ConfigDef.Importance.MEDIUM);
            $this$of.setDefaultValue((Object)"");
            $this$of.setGroup(Groups.CONNECTOR.getTitle());
            return Unit.INSTANCE;
        }

        private static final Unit config$lambda$1(ConfigKeyBuilder $this$of) {
            Intrinsics.checkNotNullParameter((Object)$this$of, (String)"$this$of");
            $this$of.setImportance(ConfigDef.Importance.MEDIUM);
            $this$of.setDefaultValue((Object)"");
            $this$of.setGroup(Groups.CONNECTOR.getTitle());
            return Unit.INSTANCE;
        }

        private static final Unit config$lambda$2(ConfigKeyBuilder $this$of) {
            Intrinsics.checkNotNullParameter((Object)$this$of, (String)"$this$of");
            $this$of.setImportance(ConfigDef.Importance.MEDIUM);
            $this$of.setDefaultValue((Object)"");
            $this$of.setGroup(Groups.CONNECTOR.getTitle());
            return Unit.INSTANCE;
        }

        private static final Unit config$lambda$3(ConfigKeyBuilder $this$of) {
            Intrinsics.checkNotNullParameter((Object)$this$of, (String)"$this$of");
            $this$of.setImportance(ConfigDef.Importance.MEDIUM);
            $this$of.setDefaultValue((Object)1000);
            $this$of.setGroup(Groups.CONNECTOR_ADVANCED.getTitle());
            $this$of.setValidator((ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1));
            return Unit.INSTANCE;
        }

        private static final Unit config$lambda$4(ConfigKeyBuilder $this$of) {
            Intrinsics.checkNotNullParameter((Object)$this$of, (String)"$this$of");
            $this$of.setImportance(ConfigDef.Importance.MEDIUM);
            $this$of.setDefaultValue((Object)org.neo4j.connectors.kafka.configuration.helpers.DurationKt.toSimpleString-LRDsOJo((long)DEFAULT_BATCH_TIMEOUT));
            $this$of.setGroup(Groups.CONNECTOR_ADVANCED.getTitle());
            $this$of.setValidator(Validators.INSTANCE.pattern(org.neo4j.connectors.kafka.configuration.helpers.DurationKt.getSIMPLE_DURATION_PATTERN()));
            return Unit.INSTANCE;
        }

        private static final Unit config$lambda$5(ConfigKeyBuilder $this$of) {
            Intrinsics.checkNotNullParameter((Object)$this$of, (String)"$this$of");
            $this$of.setImportance(ConfigDef.Importance.LOW);
            $this$of.setDefaultValue((Object)SinkConfiguration.DEFAULT_SOURCE_ID_LABEL_NAME);
            $this$of.setGroup(Groups.CONNECTOR_ADVANCED.getTitle());
            Predicate predicate = Predicate.isEqual(SinkConfiguration.CDC_SOURCE_ID_TOPICS);
            Intrinsics.checkNotNullExpressionValue(predicate, (String)"isEqual(...)");
            $this$of.setRecommender(Recommenders.INSTANCE.visibleIfNotEmpty(predicate));
            return Unit.INSTANCE;
        }

        private static final Unit config$lambda$6(ConfigKeyBuilder $this$of) {
            Intrinsics.checkNotNullParameter((Object)$this$of, (String)"$this$of");
            $this$of.setImportance(ConfigDef.Importance.LOW);
            $this$of.setDefaultValue((Object)SinkConfiguration.DEFAULT_SOURCE_ID_PROPERTY_NAME);
            $this$of.setGroup(Groups.CONNECTOR_ADVANCED.getTitle());
            Predicate predicate = Predicate.isEqual(SinkConfiguration.CDC_SOURCE_ID_TOPICS);
            Intrinsics.checkNotNullExpressionValue(predicate, (String)"isEqual(...)");
            $this$of.setRecommender(Recommenders.INSTANCE.visibleIfNotEmpty(predicate));
            return Unit.INSTANCE;
        }

        private static final Unit config$lambda$7(ConfigKeyBuilder $this$of) {
            Intrinsics.checkNotNullParameter((Object)$this$of, (String)"$this$of");
            $this$of.setImportance(ConfigDef.Importance.MEDIUM);
            $this$of.setDefaultValue((Object)SinkConfiguration.DEFAULT_BIND_TIMESTAMP_ALIAS);
            $this$of.setGroup(Groups.CONNECTOR_ADVANCED.getTitle());
            return Unit.INSTANCE;
        }

        private static final Unit config$lambda$8(ConfigKeyBuilder $this$of) {
            Intrinsics.checkNotNullParameter((Object)$this$of, (String)"$this$of");
            $this$of.setImportance(ConfigDef.Importance.LOW);
            $this$of.setDefaultValue((Object)SinkConfiguration.DEFAULT_BIND_HEADER_ALIAS);
            $this$of.setGroup(Groups.CONNECTOR_ADVANCED.getTitle());
            return Unit.INSTANCE;
        }

        private static final Unit config$lambda$9(ConfigKeyBuilder $this$of) {
            Intrinsics.checkNotNullParameter((Object)$this$of, (String)"$this$of");
            $this$of.setImportance(ConfigDef.Importance.LOW);
            $this$of.setDefaultValue((Object)SinkConfiguration.DEFAULT_BIND_KEY_ALIAS);
            $this$of.setGroup(Groups.CONNECTOR_ADVANCED.getTitle());
            return Unit.INSTANCE;
        }

        private static final Unit config$lambda$10(ConfigKeyBuilder $this$of) {
            Intrinsics.checkNotNullParameter((Object)$this$of, (String)"$this$of");
            $this$of.setImportance(ConfigDef.Importance.LOW);
            $this$of.setDefaultValue((Object)SinkConfiguration.DEFAULT_BIND_VALUE_ALIAS);
            $this$of.setGroup(Groups.CONNECTOR_ADVANCED.getTitle());
            return Unit.INSTANCE;
        }

        private static final Unit config$lambda$11(ConfigKeyBuilder $this$of) {
            Intrinsics.checkNotNullParameter((Object)$this$of, (String)"$this$of");
            $this$of.setImportance(ConfigDef.Importance.LOW);
            $this$of.setDefaultValue((Object)"true");
            $this$of.setGroup(Groups.CONNECTOR_ADVANCED.getTitle());
            $this$of.setValidator(Validators.INSTANCE.bool());
            $this$of.setRecommender(Recommenders.INSTANCE.bool());
            return Unit.INSTANCE;
        }

        private static final Unit config$lambda$12(ConfigKeyBuilder $this$of) {
            Intrinsics.checkNotNullParameter((Object)$this$of, (String)"$this$of");
            $this$of.setImportance(ConfigDef.Importance.LOW);
            $this$of.setDefaultValue((Object)SinkConfiguration.DEFAULT_BIND_TIMESTAMP_ALIAS);
            $this$of.setGroup(Groups.CONNECTOR_ADVANCED.getTitle());
            return Unit.INSTANCE;
        }

        private static final Unit config$lambda$13(ConfigKeyBuilder $this$of) {
            Intrinsics.checkNotNullParameter((Object)$this$of, (String)"$this$of");
            $this$of.setImportance(ConfigDef.Importance.LOW);
            $this$of.setDefaultValue((Object)SinkConfiguration.DEFAULT_BIND_HEADER_ALIAS);
            $this$of.setGroup(Groups.CONNECTOR_ADVANCED.getTitle());
            return Unit.INSTANCE;
        }

        private static final Unit config$lambda$14(ConfigKeyBuilder $this$of) {
            Intrinsics.checkNotNullParameter((Object)$this$of, (String)"$this$of");
            $this$of.setImportance(ConfigDef.Importance.LOW);
            $this$of.setDefaultValue((Object)SinkConfiguration.DEFAULT_BIND_KEY_ALIAS);
            $this$of.setGroup(Groups.CONNECTOR_ADVANCED.getTitle());
            return Unit.INSTANCE;
        }

        private static final Unit config$lambda$15(ConfigKeyBuilder $this$of) {
            Intrinsics.checkNotNullParameter((Object)$this$of, (String)"$this$of");
            $this$of.setImportance(ConfigDef.Importance.LOW);
            $this$of.setDefaultValue((Object)SinkConfiguration.DEFAULT_BIND_VALUE_ALIAS);
            $this$of.setGroup(Groups.CONNECTOR_ADVANCED.getTitle());
            return Unit.INSTANCE;
        }

        private static final Unit config$lambda$16(ConfigKeyBuilder $this$of) {
            Intrinsics.checkNotNullParameter((Object)$this$of, (String)"$this$of");
            $this$of.setImportance(ConfigDef.Importance.LOW);
            $this$of.setDefaultValue((Object)"false");
            $this$of.setGroup(Groups.CONNECTOR_ADVANCED.getTitle());
            $this$of.setValidator(Validators.INSTANCE.bool());
            $this$of.setRecommender(Recommenders.INSTANCE.bool());
            return Unit.INSTANCE;
        }

        private static final Unit config$lambda$17(ConfigKeyBuilder $this$of) {
            Intrinsics.checkNotNullParameter((Object)$this$of, (String)"$this$of");
            $this$of.setImportance(ConfigDef.Importance.LOW);
            $this$of.setDefaultValue((Object)"false");
            $this$of.setGroup(Groups.CONNECTOR_ADVANCED.getTitle());
            $this$of.setValidator(Validators.INSTANCE.bool());
            $this$of.setRecommender(Recommenders.INSTANCE.bool());
            return Unit.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

