/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.connectors.kafka.sink;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.apache.kafka.common.config.ConfigException;
import org.jetbrains.annotations.NotNull;
import org.neo4j.connectors.kafka.data.PropertyConstraintsKt;
import org.neo4j.connectors.kafka.sink.ChangeQuery;
import org.neo4j.connectors.kafka.sink.SinkConfiguration;
import org.neo4j.connectors.kafka.sink.SinkMessage;
import org.neo4j.connectors.kafka.sink.SinkStrategy;
import org.neo4j.connectors.kafka.sink.strategy.CdcSchemaHandler;
import org.neo4j.connectors.kafka.sink.strategy.CdcSourceIdHandler;
import org.neo4j.connectors.kafka.sink.strategy.CudHandler;
import org.neo4j.connectors.kafka.sink.strategy.CypherHandler;
import org.neo4j.connectors.kafka.sink.strategy.NodePatternHandler;
import org.neo4j.connectors.kafka.sink.strategy.PatternHandler;
import org.neo4j.connectors.kafka.sink.strategy.RelationshipPatternHandler;
import org.neo4j.connectors.kafka.sink.strategy.pattern.NodePattern;
import org.neo4j.connectors.kafka.sink.strategy.pattern.Pattern;
import org.neo4j.connectors.kafka.sink.strategy.pattern.RelationshipPattern;
import org.neo4j.cypherdsl.core.renderer.Renderer;
import org.neo4j.driver.Bookmark;
import org.neo4j.driver.Driver;
import org.neo4j.driver.SessionConfig;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000 \t2\u00020\u0001:\u0001\tJ\b\u0010\u0002\u001a\u00020\u0003H&J\"\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u00052\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005H&\u00a8\u0006\n\u00c0\u0006\u0003"}, d2={"Lorg/neo4j/connectors/kafka/sink/SinkStrategyHandler;", "", "strategy", "Lorg/neo4j/connectors/kafka/sink/SinkStrategy;", "handle", "", "Lorg/neo4j/connectors/kafka/sink/ChangeQuery;", "messages", "Lorg/neo4j/connectors/kafka/sink/SinkMessage;", "Companion", "sink"})
public interface SinkStrategyHandler {
    @NotNull
    public static final Companion Companion = org.neo4j.connectors.kafka.sink.SinkStrategyHandler$Companion.$$INSTANCE;

    @NotNull
    public SinkStrategy strategy();

    @NotNull
    public Iterable<Iterable<ChangeQuery>> handle(@NotNull Iterable<SinkMessage> var1);

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00052\u0006\u0010\b\u001a\u00020\tJ\u0018\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0002J\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\r2\u0006\u0010\b\u001a\u00020\tJ\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u0010"}, d2={"Lorg/neo4j/connectors/kafka/sink/SinkStrategyHandler$Companion;", "", "<init>", "()V", "createFrom", "", "", "Lorg/neo4j/connectors/kafka/sink/SinkStrategyHandler;", "config", "Lorg/neo4j/connectors/kafka/sink/SinkConfiguration;", "createForTopic", "topic", "configuredStrategies", "", "topicStrategy", "Lorg/neo4j/connectors/kafka/sink/SinkStrategy;", "sink"})
    @SourceDebugExtension(value={"SMAP\nSinkStrategy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SinkStrategy.kt\norg/neo4j/connectors/kafka/sink/SinkStrategyHandler$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,284:1\n1285#2,2:285\n1299#2,4:287\n1563#2:291\n1634#2,3:292\n1563#2:295\n1634#2,3:296\n*S KotlinDebug\n*F\n+ 1 SinkStrategy.kt\norg/neo4j/connectors/kafka/sink/SinkStrategyHandler$Companion\n*L\n136#1:285,2\n136#1:287,4\n240#1:291\n240#1:292,3\n241#1:295\n241#1:296,3\n*E\n"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;

        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Map<String, SinkStrategyHandler> createFrom(@NotNull SinkConfiguration config) {
            void $this$associateWithTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)((Object)config), (String)"config");
            Iterable $this$associateWith$iv = config.getTopicNames();
            boolean $i$f$associateWith = false;
            LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
            Iterable iterable = $this$associateWith$iv;
            Map destination$iv$iv = result$iv;
            boolean $i$f$associateWithTo = false;
            for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
                void topic;
                String string = (String)element$iv$iv;
                Object t = element$iv$iv;
                Map map = destination$iv$iv;
                boolean bl = false;
                SinkStrategyHandler sinkStrategyHandler = $$INSTANCE.createForTopic((String)topic, config);
                map.put(t, sinkStrategyHandler);
            }
            return destination$iv$iv;
        }

        private final SinkStrategyHandler createForTopic(String topic, SinkConfiguration config) {
            List cudTopics;
            List cdcSchemaTopics;
            List cdcSourceIdTopics;
            String pattern;
            SinkStrategyHandler handler = null;
            Map originals = config.originalsStrings();
            String query = (String)originals.get("neo4j.cypher.topic." + topic);
            if (query != null) {
                handler = new CypherHandler(topic, query, config.getRenderer(), config.getBatchSize(), config.getCypherBindTimestampAs(), config.getCypherBindHeaderAs(), config.getCypherBindKeyAs(), config.getCypherBindValueAs(), config.getCypherBindValueAsEvent());
            }
            if ((pattern = (String)originals.get("neo4j.pattern.topic." + topic)) != null) {
                PatternHandler patternHandler;
                if (handler != null) {
                    throw new ConfigException("Topic '" + topic + "' has multiple strategies defined");
                }
                Pattern parsedPattern = Pattern.Companion.parse(pattern);
                if (parsedPattern instanceof NodePattern) {
                    patternHandler = new NodePatternHandler(topic, (NodePattern)parsedPattern, Boolean.parseBoolean(config.getString("neo4j.pattern.merge-node-properties")), config.getRenderer(), config.getBatchSize(), config.getPatternBindTimestampAs(), config.getPatternBindHeaderAs(), config.getPatternBindKeyAs(), config.getPatternBindValueAs());
                } else if (parsedPattern instanceof RelationshipPattern) {
                    patternHandler = new RelationshipPatternHandler(topic, (RelationshipPattern)parsedPattern, Boolean.parseBoolean(config.getString("neo4j.pattern.merge-node-properties")), Boolean.parseBoolean(config.getString("neo4j.pattern.merge-relationship-properties")), config.getRenderer(), config.getBatchSize(), config.getPatternBindTimestampAs(), config.getPatternBindHeaderAs(), config.getPatternBindKeyAs(), config.getPatternBindValueAs());
                } else {
                    throw new IllegalArgumentException("Invalid pattern provided for PatternHandler: " + parsedPattern.getClass().getName());
                }
                PatternHandler patternHandler2 = patternHandler;
                patternHandler2.validate(PropertyConstraintsKt.fetchConstraintData((Driver)config.getDriver(), (SessionConfig)config.sessionConfig(new Bookmark[0])));
                handler = patternHandler2;
            }
            if ((cdcSourceIdTopics = config.getList("neo4j.cdc.source-id.topics")).contains(topic)) {
                if (handler != null) {
                    throw new ConfigException("Topic '" + topic + "' has multiple strategies defined");
                }
                String labelName = config.getString("neo4j.cdc.source-id.label-name");
                String propertyName = config.getString("neo4j.cdc.source-id.property-name");
                Renderer renderer = config.getRenderer();
                Intrinsics.checkNotNull((Object)labelName);
                Intrinsics.checkNotNull((Object)propertyName);
                handler = new CdcSourceIdHandler(topic, renderer, labelName, propertyName);
            }
            if ((cdcSchemaTopics = config.getList("neo4j.cdc.schema.topics")).contains(topic)) {
                if (handler != null) {
                    throw new ConfigException("Topic '" + topic + "' has multiple strategies defined");
                }
                handler = new CdcSchemaHandler(topic, config.getRenderer());
            }
            if ((cudTopics = config.getList("neo4j.cud.topics")).contains(topic)) {
                if (handler != null) {
                    throw new ConfigException("Topic '" + topic + "' has multiple strategies defined");
                }
                handler = new CudHandler(topic, config.getRenderer(), config.getBatchSize());
            }
            SinkStrategyHandler sinkStrategyHandler = handler;
            if (sinkStrategyHandler == null) {
                throw new ConfigException("Topic '" + topic + "' is not assigned a sink strategy");
            }
            return sinkStrategyHandler;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Set<String> configuredStrategies(@NotNull SinkConfiguration config) {
            SinkStrategy topic;
            Collection collection;
            Iterable $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)((Object)config), (String)"config");
            Iterable $this$map$iv = config.getTopicNames();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                String string = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add($$INSTANCE.topicStrategy((String)((Object)topic), config));
            }
            $this$map$iv = (List)destination$iv$iv;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                topic = (SinkStrategy)((Object)item$iv$iv);
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getDescription());
            }
            return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        }

        private final SinkStrategy topicStrategy(String topic, SinkConfiguration config) {
            Map originals = config.originalsStrings();
            String query = (String)originals.get("neo4j.cypher.topic." + topic);
            if (query != null) {
                return SinkStrategy.CYPHER;
            }
            String pattern = (String)originals.get("neo4j.pattern.topic." + topic);
            if (pattern != null) {
                SinkStrategy sinkStrategy;
                Pattern parsedPattern = Pattern.Companion.parse(pattern);
                if (parsedPattern instanceof NodePattern) {
                    sinkStrategy = SinkStrategy.NODE_PATTERN;
                } else if (parsedPattern instanceof RelationshipPattern) {
                    sinkStrategy = SinkStrategy.RELATIONSHIP_PATTERN;
                } else {
                    throw new IllegalArgumentException("Invalid pattern provided for PatternHandler: " + parsedPattern.getClass().getName());
                }
                return sinkStrategy;
            }
            List cdcSourceIdTopics = config.getList("neo4j.cdc.source-id.topics");
            if (cdcSourceIdTopics.contains(topic)) {
                return SinkStrategy.CDC_SOURCE_ID;
            }
            List cdcSchemaTopics = config.getList("neo4j.cdc.schema.topics");
            if (cdcSchemaTopics.contains(topic)) {
                return SinkStrategy.CDC_SCHEMA;
            }
            List cudTopics = config.getList("neo4j.cud.topics");
            if (cudTopics.contains(topic)) {
                return SinkStrategy.CUD;
            }
            throw new ConfigException("Topic " + topic + " is not assigned a sink strategy");
        }

        static {
            $$INSTANCE = new Companion();
        }
    }
}

