/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.connectors.kafka.sink.strategy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neo4j.cdc.client.model.EntityEvent;
import org.neo4j.cdc.client.model.NodeEvent;
import org.neo4j.cdc.client.model.NodeState;
import org.neo4j.cdc.client.model.RelationshipEvent;
import org.neo4j.cdc.client.model.RelationshipState;
import org.neo4j.connectors.kafka.exceptions.InvalidDataException;
import org.neo4j.connectors.kafka.sink.SinkStrategy;
import org.neo4j.connectors.kafka.sink.strategy.CdcHandler;
import org.neo4j.connectors.kafka.sink.strategy.EventExtensionsKt;
import org.neo4j.cypherdsl.core.Cypher;
import org.neo4j.cypherdsl.core.Expression;
import org.neo4j.cypherdsl.core.Named;
import org.neo4j.cypherdsl.core.Node;
import org.neo4j.cypherdsl.core.Parameter;
import org.neo4j.cypherdsl.core.PatternElement;
import org.neo4j.cypherdsl.core.Relationship;
import org.neo4j.cypherdsl.core.Statement;
import org.neo4j.cypherdsl.core.StatementBuilder;
import org.neo4j.cypherdsl.core.renderer.Renderer;
import org.neo4j.driver.Query;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010 \n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001eB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u0010\u0010\u0011\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0012H\u0014J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0012H\u0014J\u0010\u0010\u0011\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0012H\u0014J6\u0010\u0013\u001a\u00020\u00142$\u0010\u0015\u001a \u0012\u0004\u0012\u00020\u0003\u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00180\u00160\u00170\u00162\u0006\u0010\u0019\u001a\u00020\u0003H\u0002J \u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u000e\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u001dH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/neo4j/connectors/kafka/sink/strategy/CdcSchemaHandler;", "Lorg/neo4j/connectors/kafka/sink/strategy/CdcHandler;", "topic", "", "renderer", "Lorg/neo4j/cypherdsl/core/renderer/Renderer;", "<init>", "(Ljava/lang/String;Lorg/neo4j/cypherdsl/core/renderer/Renderer;)V", "getTopic", "()Ljava/lang/String;", "strategy", "Lorg/neo4j/connectors/kafka/sink/SinkStrategy;", "transformCreate", "Lorg/neo4j/driver/Query;", "event", "Lorg/neo4j/cdc/client/model/NodeEvent;", "transformUpdate", "transformDelete", "Lorg/neo4j/cdc/client/model/RelationshipEvent;", "buildNode", "Lorg/neo4j/cypherdsl/core/Node;", "keys", "", "", "", "named", "buildRelationship", "Lorg/neo4j/connectors/kafka/sink/strategy/CdcSchemaHandler$RelationshipOutput;", "forCreate", "", "RelationshipOutput", "sink"})
@SourceDebugExtension(value={"SMAP\nCdcSchemaHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CdcSchemaHandler.kt\norg/neo4j/connectors/kafka/sink/strategy/CdcSchemaHandler\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,217:1\n463#2:218\n413#2:219\n504#2,7:226\n1252#3,2:220\n774#3:222\n865#3,2:223\n1255#3:225\n774#3:244\n865#3,2:245\n77#4:233\n97#4,5:234\n666#5:239\n747#5,2:240\n750#5:243\n666#5:247\n747#5,4:248\n1#6:242\n*S KotlinDebug\n*F\n+ 1 CdcSchemaHandler.kt\norg/neo4j/connectors/kafka/sink/strategy/CdcSchemaHandler\n*L\n141#1:218\n141#1:219\n142#1:226,7\n141#1:220,2\n141#1:222\n141#1:223,2\n141#1:225\n185#1:244\n185#1:245,2\n154#1:233\n154#1:234,5\n157#1:239\n157#1:240,2\n157#1:243\n202#1:247\n202#1:248,4\n*E\n"})
public final class CdcSchemaHandler
extends CdcHandler {
    @NotNull
    private final String topic;
    @NotNull
    private final Renderer renderer;

    public CdcSchemaHandler(@NotNull String topic, @NotNull Renderer renderer) {
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        Intrinsics.checkNotNullParameter((Object)renderer, (String)"renderer");
        this.topic = topic;
        this.renderer = renderer;
    }

    @NotNull
    public final String getTopic() {
        return this.topic;
    }

    @Override
    @NotNull
    public SinkStrategy strategy() {
        return SinkStrategy.CDC_SCHEMA;
    }

    @Override
    @NotNull
    protected Query transformCreate(@NotNull NodeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getAfter() == null) {
            throw new InvalidDataException("create operation requires 'after' field in the event object");
        }
        Map map = event.getKeys();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getKeys(...)");
        Node node = this.buildNode(map, "n");
        PatternElement[] patternElementArray = new PatternElement[]{node};
        StatementBuilder.BuildableMatchAndUpdate it = Cypher.merge((PatternElement[])patternElementArray).set((Named)node, (Expression)Cypher.parameter((String)"nProps", (Object)((NodeState)event.getAfter()).getProperties()));
        boolean bl = false;
        List list = ((NodeState)event.getAfter()).getLabels();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getLabels(...)");
        List labels = CollectionsKt.minus((Iterable)list, (Iterable)event.getKeys().keySet());
        Statement statement = (!((Collection)labels).isEmpty() ? it.set(node, (Collection)labels) : it).build();
        Intrinsics.checkNotNullExpressionValue((Object)statement, (String)"build(...)");
        Statement stmt = statement;
        return new Query(this.renderer.render(stmt), stmt.getParameters());
    }

    @Override
    @NotNull
    protected Query transformUpdate(@NotNull NodeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getBefore() == null) {
            throw new InvalidDataException("update operation requires 'before' field in the event object");
        }
        if (event.getAfter() == null) {
            throw new InvalidDataException("update operation requires 'after' field in the event object");
        }
        Map map = event.getKeys();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getKeys(...)");
        Node node = this.buildNode(map, "n");
        PatternElement[] patternElementArray = new PatternElement[]{node};
        StatementBuilder.BuildableMatchAndUpdate it = Cypher.merge((PatternElement[])patternElementArray).mutate((Named)node, (Expression)Cypher.parameter((String)"nProps", EventExtensionsKt.mutatedProperties((EntityEvent)event)));
        boolean bl = false;
        Collection<String> addedLabels = EventExtensionsKt.addedLabels(event);
        it = !addedLabels.isEmpty() ? it.set(node, addedLabels) : it;
        boolean bl2 = false;
        Collection<String> removedLabels = EventExtensionsKt.removedLabels(event);
        Statement statement = (!removedLabels.isEmpty() ? it.remove(node, removedLabels) : it).build();
        Intrinsics.checkNotNullExpressionValue((Object)statement, (String)"build(...)");
        Statement stmt = statement;
        return new Query(this.renderer.render(stmt), stmt.getParameters());
    }

    @Override
    @NotNull
    protected Query transformDelete(@NotNull NodeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Map map = event.getKeys();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getKeys(...)");
        Node node = this.buildNode(map, "n");
        PatternElement[] patternElementArray = new PatternElement[]{node};
        StatementBuilder.OngoingReadingWithoutWhere ongoingReadingWithoutWhere = Cypher.match((PatternElement[])patternElementArray);
        patternElementArray = new Named[]{node};
        Statement statement = ongoingReadingWithoutWhere.detachDelete((Named[])patternElementArray).build();
        Intrinsics.checkNotNullExpressionValue((Object)statement, (String)"build(...)");
        Statement stmt = statement;
        return new Query(this.renderer.render(stmt), stmt.getParameters());
    }

    @Override
    @NotNull
    protected Query transformCreate(@NotNull RelationshipEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getAfter() == null) {
            throw new InvalidDataException("create operation requires 'after' field in the event object");
        }
        RelationshipOutput relationshipOutput = this.buildRelationship(event, "r", true);
        Node start = relationshipOutput.component1();
        Node end = relationshipOutput.component2();
        Relationship rel = relationshipOutput.component3();
        PatternElement[] patternElementArray = new PatternElement[]{start};
        StatementBuilder.OngoingMerge ongoingMerge = Cypher.merge((PatternElement[])patternElementArray);
        patternElementArray = new PatternElement[]{end};
        StatementBuilder.OngoingMerge ongoingMerge2 = ongoingMerge.merge(patternElementArray);
        patternElementArray = new PatternElement[]{rel};
        Statement statement = ongoingMerge2.merge(patternElementArray).set((Named)rel, (Expression)Cypher.parameter((String)"rProps", (Object)((RelationshipState)event.getAfter()).getProperties())).build();
        Intrinsics.checkNotNullExpressionValue((Object)statement, (String)"build(...)");
        Statement stmt = statement;
        return new Query(this.renderer.render(stmt), stmt.getParameters());
    }

    @Override
    @NotNull
    protected Query transformUpdate(@NotNull RelationshipEvent event) {
        StatementBuilder.OngoingReadingWithoutWhere ongoingReadingWithoutWhere;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getBefore() == null) {
            throw new InvalidDataException("update operation requires 'before' field in the event object");
        }
        if (event.getAfter() == null) {
            throw new InvalidDataException("update operation requires 'after' field in the event object");
        }
        RelationshipOutput relationshipOutput = this.buildRelationship(event, "r", false);
        Node start = relationshipOutput.component1();
        Node end = relationshipOutput.component2();
        Relationship rel = relationshipOutput.component3();
        boolean matchNodes = relationshipOutput.component4();
        if (matchNodes) {
            PatternElement[] patternElementArray = new PatternElement[]{start};
            StatementBuilder.OngoingMerge ongoingMerge = Cypher.merge((PatternElement[])patternElementArray);
            patternElementArray = new PatternElement[]{end};
            StatementBuilder.OngoingMerge ongoingMerge2 = ongoingMerge.merge(patternElementArray);
            patternElementArray = new PatternElement[]{rel};
            ongoingReadingWithoutWhere = ongoingMerge2.merge(patternElementArray);
        } else {
            PatternElement[] patternElementArray = new PatternElement[]{rel};
            ongoingReadingWithoutWhere = Cypher.match((PatternElement[])patternElementArray);
        }
        Statement statement = ((StatementBuilder.ExposesSet)ongoingReadingWithoutWhere).mutate((Named)rel, (Expression)Cypher.parameter((String)"rProps", EventExtensionsKt.mutatedProperties((EntityEvent)event))).build();
        Intrinsics.checkNotNullExpressionValue((Object)statement, (String)"build(...)");
        Statement stmt = statement;
        return new Query(this.renderer.render(stmt), stmt.getParameters());
    }

    @Override
    @NotNull
    protected Query transformDelete(@NotNull RelationshipEvent event) {
        StatementBuilder.OngoingReadingWithoutWhere ongoingReadingWithoutWhere;
        PatternElement[] patternElementArray;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        RelationshipOutput relationshipOutput = this.buildRelationship(event, "r", false);
        Node start = relationshipOutput.component1();
        Node end = relationshipOutput.component2();
        Relationship rel = relationshipOutput.component3();
        boolean matchNodes = relationshipOutput.component4();
        if (matchNodes) {
            patternElementArray = new PatternElement[]{start};
            StatementBuilder.OngoingReadingWithoutWhere ongoingReadingWithoutWhere2 = Cypher.match((PatternElement[])patternElementArray);
            patternElementArray = new PatternElement[]{end};
            StatementBuilder.OngoingReadingWithoutWhere ongoingReadingWithoutWhere3 = ongoingReadingWithoutWhere2.match(patternElementArray);
            patternElementArray = new PatternElement[]{rel};
            ongoingReadingWithoutWhere = ongoingReadingWithoutWhere3.match(patternElementArray);
        } else {
            patternElementArray = new PatternElement[]{rel};
            ongoingReadingWithoutWhere = Cypher.match((PatternElement[])patternElementArray);
        }
        patternElementArray = new Named[]{rel};
        Statement statement = ongoingReadingWithoutWhere.delete((Named[])patternElementArray).build();
        Intrinsics.checkNotNullExpressionValue((Object)statement, (String)"build(...)");
        Statement stmt = statement;
        return new Query(this.renderer.render(stmt), stmt.getParameters());
    }

    /*
     * WARNING - void declaration
     */
    private final Node buildNode(Map<String, ? extends List<? extends Map<String, ? extends Object>>> keys, String named) {
        void $this$associate$iv;
        Sequence $this$flatMap$iv;
        void $this$filterValues$iv;
        Map map;
        void $this$associateByTo$iv$iv$iv;
        void $this$mapValuesTo$iv$iv;
        Map $this$mapValues$iv;
        Map<String, ? extends List<? extends Map<String, ? extends Object>>> map2 = keys;
        boolean $i$f$mapValues = false;
        void var6_5 = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean bl = false;
        Iterable iterable = $this$mapValuesTo$iv$iv.entrySet();
        Map destination$iv$iv$iv = destination$iv$iv;
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void $this$filterTo$iv$iv;
            void kvp;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map3 = destination$iv$iv$iv;
            boolean bl2 = false;
            Map.Entry c3 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            map = map3;
            boolean bl22 = false;
            Iterable $this$filter$iv = (Iterable)kvp.getValue();
            boolean $i$f$filter = false;
            Iterable iterable2 = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Map it = (Map)element$iv$iv;
                boolean bl3 = false;
                boolean bl4 = !it.isEmpty();
                if (!bl4) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List list = (List)destination$iv$iv2;
            map.put(k, list);
        }
        $this$mapValues$iv = destination$iv$iv$iv;
        boolean $i$f$filterValues = false;
        Map result$iv = new LinkedHashMap();
        for (Map.Entry entry : $this$filterValues$iv.entrySet()) {
            List it = (List)entry.getValue();
            boolean bl5 = false;
            boolean bl6 = !((Collection)it).isEmpty();
            if (!bl6) continue;
            result$iv.put(entry.getKey(), entry.getValue());
        }
        Map validKeys = result$iv;
        if (validKeys.isEmpty()) {
            throw new InvalidDataException("schema strategy requires at least one node key with valid properties on node aliased '" + named + "'.");
        }
        result$iv = validKeys;
        map = Cypher.node((String)((String)CollectionsKt.first((Iterable)validKeys.keySet())), (List)CollectionsKt.drop((Iterable)validKeys.keySet(), (int)1));
        boolean $i$f$flatMap = false;
        void var8_10 = $this$flatMap$iv;
        Collection destination$iv$iv3 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Map.Entry element$iv$iv : var8_10.entrySet()) {
            Map.Entry it = element$iv$iv;
            boolean bl7 = false;
            Iterable list$iv$iv = (Iterable)it.getValue();
            CollectionsKt.addAll((Collection)destination$iv$iv3, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = SequencesKt.flatMap((Sequence)CollectionsKt.asSequence((Iterable)((List)destination$iv$iv3)), CdcSchemaHandler::buildNode$lambda$3);
        boolean $i$f$associate = false;
        void var8_11 = $this$associate$iv;
        Map destination$iv$iv2 = new LinkedHashMap();
        boolean $i$f$associateTo = false;
        for (Map.Entry element$iv$iv : var8_11) {
            String string;
            Map map4 = destination$iv$iv2;
            Map.Entry e = element$iv$iv;
            boolean bl8 = false;
            Object k = e.getKey();
            String string2 = named;
            String string3 = (String)e.getKey();
            if (((CharSequence)string3).length() > 0) {
                void c;
                char kvp = string3.charAt(0);
                String string4 = string2;
                Object k2 = k;
                boolean bl6 = false;
                char c2 = Character.toUpperCase((char)c);
                k = k2;
                string2 = string4;
                char c3 = c2;
                String string5 = string3;
                int n = 1;
                String string6 = string5.substring(n);
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"substring(...)");
                string5 = string6;
                string = c3 + string5;
            } else {
                string = string3;
            }
            Parameter parameter = Cypher.parameter((String)(string2 + string), e.getValue());
            Object k3 = k;
            Pair pair = new Pair(k3, (Object)parameter);
            map4.put(pair.getFirst(), pair.getSecond());
        }
        Node node = ((Node)map.withProperties(destination$iv$iv2)).named(named);
        Intrinsics.checkNotNullExpressionValue((Object)node, (String)"named(...)");
        Node node2 = node;
        return node2;
    }

    /*
     * WARNING - void declaration
     */
    private final RelationshipOutput buildRelationship(RelationshipEvent event, String named, boolean forCreate) {
        void $this$associateTo$iv$iv;
        void $this$associate$iv;
        Node node;
        Node node2;
        Object element$iv$iv2;
        Node $this$filterTo$iv$iv;
        List list = event.getKeys();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getKeys(...)");
        Iterable $this$filter$iv = list;
        boolean $i$f$filter22 = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo22 = false;
        for (Object element$iv$iv2 : $this$filterTo$iv$iv) {
            Map it = (Map)element$iv$iv2;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            boolean bl2 = !it.isEmpty();
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv2);
        }
        boolean relationshipHasKeys = CollectionsKt.any((Iterable)((List)destination$iv$iv));
        if (!forCreate && relationshipHasKeys) {
            node2 = Cypher.anyNode((String)"start");
        } else {
            Map map = event.getStart().getKeys();
            Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getKeys(...)");
            node2 = this.buildNode(map, "start");
        }
        Node $i$f$filter22 = node2;
        Intrinsics.checkNotNull((Object)$i$f$filter22);
        Node start = $i$f$filter22;
        if (!forCreate && relationshipHasKeys) {
            node = Cypher.anyNode((String)"end");
        } else {
            Map map = event.getEnd().getKeys();
            Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getKeys(...)");
            node = this.buildNode(map, "end");
        }
        $this$filterTo$iv$iv = node;
        Intrinsics.checkNotNull((Object)$this$filterTo$iv$iv);
        Node end = $this$filterTo$iv$iv;
        String[] $i$f$filterTo22 = new String[]{event.getType()};
        Relationship relationship = (Relationship)start.relationshipTo(end, $i$f$filterTo22);
        List list2 = event.getKeys();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getKeys(...)");
        $i$f$filterTo22 = SequencesKt.flatMap((Sequence)CollectionsKt.asSequence((Iterable)list2), CdcSchemaHandler::buildRelationship$lambda$1);
        Relationship relationship2 = relationship;
        boolean $i$f$associate = false;
        element$iv$iv2 = $this$associate$iv;
        Map destination$iv$iv2 = new LinkedHashMap();
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv3 : $this$associateTo$iv$iv) {
            String string;
            Map map = destination$iv$iv2;
            Map.Entry e = (Map.Entry)element$iv$iv3;
            boolean bl = false;
            Object k = e.getKey();
            String string2 = named;
            Object k2 = e.getKey();
            Intrinsics.checkNotNullExpressionValue(k2, (String)"<get-key>(...)");
            String string3 = (String)k2;
            if (((CharSequence)string3).length() > 0) {
                void c;
                char c2 = string3.charAt(0);
                String string4 = string2;
                Object k3 = k;
                boolean bl3 = false;
                char c3 = Character.toUpperCase((char)c);
                k = k3;
                string2 = string4;
                c2 = c3;
                String string5 = string3;
                int n = 1;
                String string6 = string5.substring(n);
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"substring(...)");
                string5 = string6;
                string = c2 + string5;
            } else {
                string = string3;
            }
            Parameter parameter = Cypher.parameter((String)(string2 + string), e.getValue());
            Object k4 = k;
            Pair pair = new Pair(k4, (Object)parameter);
            map.put(pair.getFirst(), pair.getSecond());
        }
        Relationship relationship3 = ((Relationship)relationship2.withProperties(destination$iv$iv2)).named(named);
        Intrinsics.checkNotNullExpressionValue((Object)relationship3, (String)"named(...)");
        Relationship rel = relationship3;
        return new RelationshipOutput(start, end, rel, forCreate || !relationshipHasKeys);
    }

    private static final Sequence buildNode$lambda$3(Map it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return MapsKt.asSequence((Map)it);
    }

    private static final Sequence buildRelationship$lambda$1(Map it) {
        Intrinsics.checkNotNull((Object)it);
        return MapsKt.asSequence((Map)it);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0011\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\bH\u00c6\u0003J1\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\b2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001d"}, d2={"Lorg/neo4j/connectors/kafka/sink/strategy/CdcSchemaHandler$RelationshipOutput;", "", "start", "Lorg/neo4j/cypherdsl/core/Node;", "end", "relationship", "Lorg/neo4j/cypherdsl/core/Relationship;", "matchNodes", "", "<init>", "(Lorg/neo4j/cypherdsl/core/Node;Lorg/neo4j/cypherdsl/core/Node;Lorg/neo4j/cypherdsl/core/Relationship;Z)V", "getStart", "()Lorg/neo4j/cypherdsl/core/Node;", "getEnd", "getRelationship", "()Lorg/neo4j/cypherdsl/core/Relationship;", "getMatchNodes", "()Z", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "", "toString", "", "sink"})
    public static final class RelationshipOutput {
        @NotNull
        private final Node start;
        @NotNull
        private final Node end;
        @NotNull
        private final Relationship relationship;
        private final boolean matchNodes;

        public RelationshipOutput(@NotNull Node start, @NotNull Node end, @NotNull Relationship relationship, boolean matchNodes) {
            Intrinsics.checkNotNullParameter((Object)start, (String)"start");
            Intrinsics.checkNotNullParameter((Object)end, (String)"end");
            Intrinsics.checkNotNullParameter((Object)relationship, (String)"relationship");
            this.start = start;
            this.end = end;
            this.relationship = relationship;
            this.matchNodes = matchNodes;
        }

        @NotNull
        public final Node getStart() {
            return this.start;
        }

        @NotNull
        public final Node getEnd() {
            return this.end;
        }

        @NotNull
        public final Relationship getRelationship() {
            return this.relationship;
        }

        public final boolean getMatchNodes() {
            return this.matchNodes;
        }

        @NotNull
        public final Node component1() {
            return this.start;
        }

        @NotNull
        public final Node component2() {
            return this.end;
        }

        @NotNull
        public final Relationship component3() {
            return this.relationship;
        }

        public final boolean component4() {
            return this.matchNodes;
        }

        @NotNull
        public final RelationshipOutput copy(@NotNull Node start, @NotNull Node end, @NotNull Relationship relationship, boolean matchNodes) {
            Intrinsics.checkNotNullParameter((Object)start, (String)"start");
            Intrinsics.checkNotNullParameter((Object)end, (String)"end");
            Intrinsics.checkNotNullParameter((Object)relationship, (String)"relationship");
            return new RelationshipOutput(start, end, relationship, matchNodes);
        }

        public static /* synthetic */ RelationshipOutput copy$default(RelationshipOutput relationshipOutput, Node node, Node node2, Relationship relationship, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                node = relationshipOutput.start;
            }
            if ((n & 2) != 0) {
                node2 = relationshipOutput.end;
            }
            if ((n & 4) != 0) {
                relationship = relationshipOutput.relationship;
            }
            if ((n & 8) != 0) {
                bl = relationshipOutput.matchNodes;
            }
            return relationshipOutput.copy(node, node2, relationship, bl);
        }

        @NotNull
        public String toString() {
            return "RelationshipOutput(start=" + this.start + ", end=" + this.end + ", relationship=" + this.relationship + ", matchNodes=" + this.matchNodes + ")";
        }

        public int hashCode() {
            int result = this.start.hashCode();
            result = result * 31 + this.end.hashCode();
            result = result * 31 + this.relationship.hashCode();
            result = result * 31 + Boolean.hashCode(this.matchNodes);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RelationshipOutput)) {
                return false;
            }
            RelationshipOutput relationshipOutput = (RelationshipOutput)other;
            if (!Intrinsics.areEqual((Object)this.start, (Object)relationshipOutput.start)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.end, (Object)relationshipOutput.end)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.relationship, (Object)relationshipOutput.relationship)) {
                return false;
            }
            return this.matchNodes == relationshipOutput.matchNodes;
        }
    }
}

