/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.connectors.kafka.sink.strategy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neo4j.connectors.kafka.data.ConstraintData;
import org.neo4j.connectors.kafka.sink.ChangeQuery;
import org.neo4j.connectors.kafka.sink.SinkMessage;
import org.neo4j.connectors.kafka.sink.SinkStrategy;
import org.neo4j.connectors.kafka.sink.strategy.PatternHandler;
import org.neo4j.connectors.kafka.sink.strategy.pattern.Pattern;
import org.neo4j.connectors.kafka.sink.strategy.pattern.PatternConstraintValidator;
import org.neo4j.connectors.kafka.sink.strategy.pattern.PropertyMapping;
import org.neo4j.connectors.kafka.sink.strategy.pattern.RelationshipPattern;
import org.neo4j.cypherdsl.core.AliasedExpression;
import org.neo4j.cypherdsl.core.Cypher;
import org.neo4j.cypherdsl.core.ExposesSubqueryCall;
import org.neo4j.cypherdsl.core.Expression;
import org.neo4j.cypherdsl.core.IdentifiableElement;
import org.neo4j.cypherdsl.core.Literal;
import org.neo4j.cypherdsl.core.Named;
import org.neo4j.cypherdsl.core.Node;
import org.neo4j.cypherdsl.core.PatternElement;
import org.neo4j.cypherdsl.core.Property;
import org.neo4j.cypherdsl.core.Relationship;
import org.neo4j.cypherdsl.core.ResultStatement;
import org.neo4j.cypherdsl.core.Statement;
import org.neo4j.cypherdsl.core.StatementBuilder;
import org.neo4j.cypherdsl.core.SymbolicName;
import org.neo4j.cypherdsl.core.renderer.Renderer;
import org.neo4j.driver.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u00015B_\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\r\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0011\u0010\u0012Ba\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\r\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0011\u0010\u0013J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\"\u0010\u001c\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001e0\u001d0\u001d2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u001dH\u0016J\u0016\u0010!\u001a\u00020\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$H\u0016J!\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00040$2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$H\u0000\u00a2\u0006\u0002\b'J\b\u0010(\u001a\u00020\u0004H\u0002J#\u0010)\u001a\u00070*\u00a2\u0006\u0002\b+2\u0006\u0010,\u001a\u00020-2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00040/H\u0002J3\u00100\u001a\u00070*\u00a2\u0006\u0002\b+2\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u0002022\u0006\u0010,\u001a\u00020-2\f\u00104\u001a\b\u0012\u0004\u0012\u00020\u00040/H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0015\u00a8\u00066"}, d2={"Lorg/neo4j/connectors/kafka/sink/strategy/RelationshipPatternHandler;", "Lorg/neo4j/connectors/kafka/sink/strategy/PatternHandler;", "Lorg/neo4j/connectors/kafka/sink/strategy/pattern/RelationshipPattern;", "topic", "", "pattern", "mergeNodeProperties", "", "mergeRelationshipProperties", "renderer", "Lorg/neo4j/cypherdsl/core/renderer/Renderer;", "batchSize", "", "bindTimestampAs", "bindHeaderAs", "bindKeyAs", "bindValueAs", "<init>", "(Ljava/lang/String;Lorg/neo4j/connectors/kafka/sink/strategy/pattern/RelationshipPattern;ZZLorg/neo4j/cypherdsl/core/renderer/Renderer;ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "(Ljava/lang/String;Ljava/lang/String;ZZLorg/neo4j/cypherdsl/core/renderer/Renderer;ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getTopic", "()Ljava/lang/String;", "logger", "Lorg/slf4j/Logger;", "query", "getQuery$sink", "strategy", "Lorg/neo4j/connectors/kafka/sink/SinkStrategy;", "handle", "", "Lorg/neo4j/connectors/kafka/sink/ChangeQuery;", "messages", "Lorg/neo4j/connectors/kafka/sink/SinkMessage;", "validate", "", "constraints", "", "Lorg/neo4j/connectors/kafka/data/ConstraintData;", "checkConstraints", "checkConstraints$sink", "buildStatement", "buildDeleteStatement", "Lorg/neo4j/cypherdsl/core/ResultStatement;", "Lorg/jetbrains/annotations/NotNull;", "relationship", "Lorg/neo4j/cypherdsl/core/Relationship;", "deleteOperation", "Lorg/neo4j/cypherdsl/core/Literal;", "buildCreateStatement", "startNode", "Lorg/neo4j/cypherdsl/core/Node;", "endNode", "createOperation", "MessageToEventList", "sink"})
@SourceDebugExtension(value={"SMAP\nRelationshipPatternHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RelationshipPatternHandler.kt\norg/neo4j/connectors/kafka/sink/strategy/RelationshipPatternHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,293:1\n1869#2,2:294\n1193#2,2:296\n1267#2,4:298\n1193#2,2:302\n1267#2,4:304\n1193#2,2:308\n1267#2,4:310\n1563#2:314\n1634#2,3:315\n1563#2:318\n1634#2,3:319\n*S KotlinDebug\n*F\n+ 1 RelationshipPatternHandler.kt\norg/neo4j/connectors/kafka/sink/strategy/RelationshipPatternHandler\n*L\n166#1:294,2\n198#1:296,2\n198#1:298,4\n206#1:302,2\n206#1:304,4\n215#1:308,2\n215#1:310,4\n155#1:314\n155#1:315,3\n156#1:318\n156#1:319,3\n*E\n"})
public final class RelationshipPatternHandler
extends PatternHandler<RelationshipPattern> {
    @NotNull
    private final String topic;
    private final boolean mergeNodeProperties;
    private final boolean mergeRelationshipProperties;
    @NotNull
    private final Renderer renderer;
    private final int batchSize;
    @NotNull
    private final Logger logger;
    @NotNull
    private final String query;

    public RelationshipPatternHandler(@NotNull String topic, @NotNull RelationshipPattern pattern, boolean mergeNodeProperties, boolean mergeRelationshipProperties, @NotNull Renderer renderer, int batchSize, @NotNull String bindTimestampAs, @NotNull String bindHeaderAs, @NotNull String bindKeyAs, @NotNull String bindValueAs) {
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        Intrinsics.checkNotNullParameter((Object)renderer, (String)"renderer");
        Intrinsics.checkNotNullParameter((Object)bindTimestampAs, (String)"bindTimestampAs");
        Intrinsics.checkNotNullParameter((Object)bindHeaderAs, (String)"bindHeaderAs");
        Intrinsics.checkNotNullParameter((Object)bindKeyAs, (String)"bindKeyAs");
        Intrinsics.checkNotNullParameter((Object)bindValueAs, (String)"bindValueAs");
        super((Pattern)pattern, bindTimestampAs, bindHeaderAs, bindKeyAs, bindValueAs);
        this.topic = topic;
        this.mergeNodeProperties = mergeNodeProperties;
        this.mergeRelationshipProperties = mergeRelationshipProperties;
        this.renderer = renderer;
        this.batchSize = batchSize;
        Logger logger = LoggerFactory.getLogger(this.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.logger = logger;
        this.query = this.buildStatement();
        this.logger.debug("using Cypher query '{}' for topic '{}'", (Object)this.query, (Object)this.topic);
    }

    public /* synthetic */ RelationshipPatternHandler(String string, RelationshipPattern relationshipPattern, boolean bl, boolean bl2, Renderer renderer, int n, String string2, String string3, String string4, String string5, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 0x40) != 0) {
            string2 = "__timestamp";
        }
        if ((n2 & 0x80) != 0) {
            string3 = "__header";
        }
        if ((n2 & 0x100) != 0) {
            string4 = "__key";
        }
        if ((n2 & 0x200) != 0) {
            string5 = "__value";
        }
        this(string, relationshipPattern, bl, bl2, renderer, n, string2, string3, string4, string5);
    }

    @NotNull
    public final String getTopic() {
        return this.topic;
    }

    @NotNull
    public final String getQuery$sink() {
        return this.query;
    }

    public RelationshipPatternHandler(@NotNull String topic, @NotNull String pattern, boolean mergeNodeProperties, boolean mergeRelationshipProperties, @NotNull Renderer renderer, int batchSize, @NotNull String bindTimestampAs, @NotNull String bindHeaderAs, @NotNull String bindKeyAs, @NotNull String bindValueAs) {
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        Intrinsics.checkNotNullParameter((Object)renderer, (String)"renderer");
        Intrinsics.checkNotNullParameter((Object)bindTimestampAs, (String)"bindTimestampAs");
        Intrinsics.checkNotNullParameter((Object)bindHeaderAs, (String)"bindHeaderAs");
        Intrinsics.checkNotNullParameter((Object)bindKeyAs, (String)"bindKeyAs");
        Intrinsics.checkNotNullParameter((Object)bindValueAs, (String)"bindValueAs");
        Pattern parsed = Pattern.Companion.parse(pattern);
        if (!(parsed instanceof RelationshipPattern)) {
            throw new IllegalArgumentException("Invalid pattern provided for RelationshipPatternHandler: " + parsed.getClass().getName());
        }
        this(topic, (RelationshipPattern)parsed, mergeNodeProperties, mergeRelationshipProperties, renderer, batchSize, bindTimestampAs, bindHeaderAs, bindKeyAs, bindValueAs);
    }

    public /* synthetic */ RelationshipPatternHandler(String string, String string2, boolean bl, boolean bl2, Renderer renderer, int n, String string3, String string4, String string5, String string6, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 0x40) != 0) {
            string3 = "__timestamp";
        }
        if ((n2 & 0x80) != 0) {
            string4 = "__header";
        }
        if ((n2 & 0x100) != 0) {
            string5 = "__key";
        }
        if ((n2 & 0x200) != 0) {
            string6 = "__value";
        }
        this(string, string2, bl, bl2, renderer, n, string3, string4, string5, string6);
    }

    @Override
    @NotNull
    public SinkStrategy strategy() {
        return SinkStrategy.RELATIONSHIP_PATTERN;
    }

    @Override
    @NotNull
    public Iterable<Iterable<ChangeQuery>> handle(@NotNull Iterable<SinkMessage> messages) {
        Intrinsics.checkNotNullParameter(messages, (String)"messages");
        return SequencesKt.toList((Sequence)SequencesKt.onEach((Sequence)SequencesKt.map((Sequence)SequencesKt.chunked((Sequence)SequencesKt.map((Sequence)SequencesKt.onEach((Sequence)CollectionsKt.asSequence(messages), arg_0 -> RelationshipPatternHandler.handle$lambda$0(this, arg_0)), arg_0 -> RelationshipPatternHandler.handle$lambda$1(this, arg_0)), (int)this.batchSize), arg_0 -> RelationshipPatternHandler.handle$lambda$2(this, arg_0)), arg_0 -> RelationshipPatternHandler.handle$lambda$3(this, arg_0)));
    }

    @Override
    public void validate(@NotNull List<ConstraintData> constraints) {
        Intrinsics.checkNotNullParameter(constraints, (String)"constraints");
        List<String> warningMessages = this.checkConstraints$sink(constraints);
        Iterable $this$forEach$iv = warningMessages;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            this.logger.warn(it);
        }
    }

    @NotNull
    public final List<String> checkConstraints$sink(@NotNull List<ConstraintData> constraints) {
        Intrinsics.checkNotNullParameter(constraints, (String)"constraints");
        List warningMessages = new ArrayList();
        String startNodeWarning = PatternConstraintValidator.INSTANCE.checkNodeWarning(constraints, ((RelationshipPattern)this.getPattern()).getStart(), ((RelationshipPattern)this.getPattern()).getText());
        String relationshipWarning = PatternConstraintValidator.INSTANCE.checkRelationshipWarning(constraints, (RelationshipPattern)this.getPattern(), ((RelationshipPattern)this.getPattern()).getText());
        String endNodeWarning = PatternConstraintValidator.INSTANCE.checkNodeWarning(constraints, ((RelationshipPattern)this.getPattern()).getEnd(), ((RelationshipPattern)this.getPattern()).getText());
        if (startNodeWarning != null) {
            warningMessages.add(startNodeWarning);
        }
        if (relationshipWarning != null) {
            warningMessages.add(relationshipWarning);
        }
        if (endNodeWarning != null) {
            warningMessages.add(endNodeWarning);
        }
        return warningMessages;
    }

    /*
     * WARNING - void declaration
     */
    private final String buildStatement() {
        void $this$associateTo$iv$iv;
        void $this$associate$iv;
        void $this$associateTo$iv$iv2;
        void $this$associate$iv2;
        Object it;
        void $this$associateTo$iv$iv3;
        void $this$associate$iv3;
        Literal literal = Cypher.literalOf((Object)"C");
        Intrinsics.checkNotNullExpressionValue((Object)literal, (String)"literalOf(...)");
        Literal createOperation = literal;
        Literal literal2 = Cypher.literalOf((Object)"D");
        Intrinsics.checkNotNullExpressionValue((Object)literal2, (String)"literalOf(...)");
        Literal deleteOperation = literal2;
        Iterable iterable = ((RelationshipPattern)this.getPattern()).getStart().getKeyProperties();
        Node node = Cypher.node((String)((String)CollectionsKt.first((Iterable)((RelationshipPattern)this.getPattern()).getStart().getLabels())), (List)CollectionsKt.drop((Iterable)((RelationshipPattern)this.getPattern()).getStart().getLabels(), (int)1));
        boolean $i$f$associate22 = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv3, (int)10)), (int)16);
        void var8_9 = $this$associate$iv3;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv3) {
            Map map = destination$iv$iv;
            it = (PropertyMapping)element$iv$iv;
            boolean bl = false;
            String[] stringArray = new String[]{"start", "keys"};
            Property property = PatternHandler.Companion.getNAME_EVENT$sink().property(stringArray);
            stringArray = new String[]{((PropertyMapping)it).getTo()};
            it = TuplesKt.to((Object)((PropertyMapping)it).getTo(), (Object)property.property(stringArray));
            map.put(it.getFirst(), it.getSecond());
        }
        Node node2 = ((Node)node.withProperties(destination$iv$iv)).named("start");
        Intrinsics.checkNotNullExpressionValue((Object)node2, (String)"named(...)");
        Node startNode = node2;
        Iterable $i$f$associate22 = ((RelationshipPattern)this.getPattern()).getEnd().getKeyProperties();
        node = Cypher.node((String)((String)CollectionsKt.first((Iterable)((RelationshipPattern)this.getPattern()).getEnd().getLabels())), (List)CollectionsKt.drop((Iterable)((RelationshipPattern)this.getPattern()).getEnd().getLabels(), (int)1));
        boolean $i$f$associate32 = false;
        int capacity$iv2 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv2, (int)10)), (int)16);
        destination$iv$iv = $this$associate$iv2;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv2);
        boolean $i$f$associateTo2 = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv2) {
            it = destination$iv$iv2;
            PropertyMapping it2 = (PropertyMapping)element$iv$iv;
            boolean bl = false;
            String[] stringArray = new String[]{"end", "keys"};
            Property property = PatternHandler.Companion.getNAME_EVENT$sink().property(stringArray);
            stringArray = new String[]{it2.getTo()};
            Pair pair = TuplesKt.to((Object)it2.getTo(), (Object)property.property(stringArray));
            it.put(pair.getFirst(), pair.getSecond());
        }
        Node node3 = ((Node)node.withProperties(destination$iv$iv2)).named("end");
        Intrinsics.checkNotNullExpressionValue((Object)node3, (String)"named(...)");
        Node endNode = node3;
        Object $i$f$associate32 = new String[]{((RelationshipPattern)this.getPattern()).getType()};
        Relationship relationship = (Relationship)startNode.relationshipTo(endNode, $i$f$associate32);
        $i$f$associate32 = ((RelationshipPattern)this.getPattern()).getKeyProperties();
        node = relationship;
        boolean $i$f$associate = false;
        int capacity$iv3 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        destination$iv$iv2 = $this$associate$iv;
        Map destination$iv$iv3 = new LinkedHashMap(capacity$iv3);
        boolean $i$f$associateTo3 = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv3;
            PropertyMapping it3 = (PropertyMapping)element$iv$iv;
            boolean bl = false;
            String[] stringArray = new String[]{"keys"};
            Property property = PatternHandler.Companion.getNAME_EVENT$sink().property(stringArray);
            stringArray = new String[]{it3.getTo()};
            Pair pair = TuplesKt.to((Object)it3.getTo(), (Object)property.property(stringArray));
            map.put(pair.getFirst(), pair.getSecond());
        }
        Relationship relationship2 = ((Relationship)node.withProperties(destination$iv$iv3)).named("relationship");
        Intrinsics.checkNotNullExpressionValue((Object)relationship2, (String)"named(...)");
        Relationship relationship3 = relationship2;
        Expression[] expressionArray = new Expression[]{PatternHandler.Companion.getNAME_CREATED$sink(), PatternHandler.Companion.getNAME_DELETED$sink()};
        Statement statement = Cypher.call((Statement)((Statement)this.buildCreateStatement(startNode, endNode, relationship3, (Literal<String>)createOperation))).call((Statement)this.buildDeleteStatement(relationship3, (Literal<String>)deleteOperation)).returning(expressionArray).build();
        expressionArray = new IdentifiableElement[]{PatternHandler.Companion.getNAME_EVENT$sink()};
        ExposesSubqueryCall.BuildableSubquery buildableSubquery = Cypher.unwind((Expression)((Expression)Cypher.parameter((String)"events"))).as(PatternHandler.Companion.getNAME_EVENT$sink()).call(statement, (IdentifiableElement[])expressionArray);
        expressionArray = new Expression[2];
        Object[] objectArray = new Object[]{PatternHandler.Companion.getNAME_CREATED$sink()};
        expressionArray[0] = Cypher.raw((String)"sum($E)", (Object[])objectArray).as(PatternHandler.Companion.getNAME_CREATED$sink());
        objectArray = new Object[]{PatternHandler.Companion.getNAME_DELETED$sink()};
        expressionArray[1] = Cypher.raw((String)"sum($E)", (Object[])objectArray).as(PatternHandler.Companion.getNAME_DELETED$sink());
        String string = this.renderer.render(buildableSubquery.returning(expressionArray).build());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"render(...)");
        return string;
    }

    private final ResultStatement buildDeleteStatement(Relationship relationship, Literal<String> deleteOperation) {
        SymbolicName[] symbolicNameArray = new SymbolicName[]{PatternHandler.Companion.getNAME_EVENT$sink()};
        StatementBuilder.OrderableOngoingReadingAndWithWithoutWhere orderableOngoingReadingAndWithWithoutWhere = Cypher.with((SymbolicName[])symbolicNameArray);
        symbolicNameArray = new SymbolicName[]{PatternHandler.Companion.getNAME_EVENT$sink()};
        StatementBuilder.OrderableOngoingReadingAndWithWithWhere orderableOngoingReadingAndWithWithWhere = orderableOngoingReadingAndWithWithoutWhere.with(symbolicNameArray).where(Cypher.valueAt((Expression)((Expression)PatternHandler.Companion.getNAME_EVENT$sink()), (Integer)0).eq((Expression)deleteOperation));
        symbolicNameArray = new AliasedExpression[]{Cypher.valueAt((Expression)((Expression)PatternHandler.Companion.getNAME_EVENT$sink()), (Integer)1).as(PatternHandler.Companion.getNAME_EVENT$sink())};
        StatementBuilder.OrderableOngoingReadingAndWithWithoutWhere orderableOngoingReadingAndWithWithoutWhere2 = orderableOngoingReadingAndWithWithWhere.with((AliasedExpression[])symbolicNameArray);
        symbolicNameArray = new PatternElement[]{relationship};
        StatementBuilder.OngoingReadingWithoutWhere ongoingReadingWithoutWhere = orderableOngoingReadingAndWithWithoutWhere2.match((PatternElement[])symbolicNameArray);
        symbolicNameArray = new Named[]{relationship};
        StatementBuilder.OngoingUpdate ongoingUpdate = ongoingReadingWithoutWhere.delete((Named[])symbolicNameArray);
        symbolicNameArray = new Expression[1];
        Object[] objectArray = new Object[]{relationship.getRequiredSymbolicName()};
        symbolicNameArray[0] = Cypher.raw((String)"count($E)", (Object[])objectArray).as(PatternHandler.Companion.getNAME_DELETED$sink());
        Statement statement = ongoingUpdate.returning((Expression[])symbolicNameArray).build();
        Intrinsics.checkNotNullExpressionValue((Object)statement, (String)"build(...)");
        return (ResultStatement)statement;
    }

    private final ResultStatement buildCreateStatement(Node startNode, Node endNode, Relationship relationship, Literal<String> createOperation) {
        StatementBuilder.BuildableMatchAndUpdate buildableMatchAndUpdate;
        StatementBuilder.BuildableMatchAndUpdate buildableMatchAndUpdate2;
        String[] stringArray;
        StatementBuilder.BuildableMatchAndUpdate buildableMatchAndUpdate3;
        Object[] objectArray;
        SymbolicName[] symbolicNameArray = new SymbolicName[]{PatternHandler.Companion.getNAME_EVENT$sink()};
        StatementBuilder.OrderableOngoingReadingAndWithWithoutWhere orderableOngoingReadingAndWithWithoutWhere = Cypher.with((SymbolicName[])symbolicNameArray);
        symbolicNameArray = new SymbolicName[]{PatternHandler.Companion.getNAME_EVENT$sink()};
        StatementBuilder.OrderableOngoingReadingAndWithWithWhere orderableOngoingReadingAndWithWithWhere = orderableOngoingReadingAndWithWithoutWhere.with(symbolicNameArray).where(Cypher.valueAt((Expression)((Expression)PatternHandler.Companion.getNAME_EVENT$sink()), (Integer)0).eq((Expression)createOperation));
        symbolicNameArray = new AliasedExpression[]{Cypher.valueAt((Expression)((Expression)PatternHandler.Companion.getNAME_EVENT$sink()), (Integer)1).as(PatternHandler.Companion.getNAME_EVENT$sink())};
        StatementBuilder.OrderableOngoingReadingAndWithWithoutWhere orderableOngoingReadingAndWithWithoutWhere2 = orderableOngoingReadingAndWithWithWhere.with((AliasedExpression[])symbolicNameArray);
        symbolicNameArray = new PatternElement[]{startNode};
        StatementBuilder.OngoingMerge it = orderableOngoingReadingAndWithWithoutWhere2.merge((PatternElement[])symbolicNameArray);
        boolean bl = false;
        if (this.mergeNodeProperties) {
            objectArray = new String[]{"start", "properties"};
            buildableMatchAndUpdate3 = it.mutate(startNode.asExpression(), (Expression)Cypher.property((Expression)((Expression)PatternHandler.Companion.getNAME_EVENT$sink()), (String[])objectArray));
        } else {
            objectArray = new Expression[2];
            objectArray[0] = startNode.asExpression();
            stringArray = new String[]{"start", "properties"};
            objectArray[1] = Cypher.property((Expression)((Expression)PatternHandler.Companion.getNAME_EVENT$sink()), (String[])stringArray);
            StatementBuilder.BuildableMatchAndUpdate buildableMatchAndUpdate4 = it.set(objectArray);
            objectArray = new String[]{"start", "keys"};
            buildableMatchAndUpdate3 = buildableMatchAndUpdate4.mutate(startNode.asExpression(), (Expression)Cypher.property((Expression)((Expression)PatternHandler.Companion.getNAME_EVENT$sink()), (String[])objectArray));
        }
        symbolicNameArray = new PatternElement[]{endNode};
        it = buildableMatchAndUpdate3.merge((PatternElement[])symbolicNameArray);
        boolean bl2 = false;
        if (this.mergeNodeProperties) {
            objectArray = new String[]{"end", "properties"};
            buildableMatchAndUpdate2 = it.mutate(endNode.asExpression(), (Expression)Cypher.property((Expression)((Expression)PatternHandler.Companion.getNAME_EVENT$sink()), (String[])objectArray));
        } else {
            objectArray = new Expression[2];
            objectArray[0] = endNode.asExpression();
            stringArray = new String[]{"end", "properties"};
            objectArray[1] = Cypher.property((Expression)((Expression)PatternHandler.Companion.getNAME_EVENT$sink()), (String[])stringArray);
            StatementBuilder.BuildableMatchAndUpdate buildableMatchAndUpdate5 = it.set(objectArray);
            objectArray = new String[]{"end", "keys"};
            buildableMatchAndUpdate2 = buildableMatchAndUpdate5.mutate(endNode.asExpression(), (Expression)Cypher.property((Expression)((Expression)PatternHandler.Companion.getNAME_EVENT$sink()), (String[])objectArray));
        }
        symbolicNameArray = new PatternElement[]{relationship};
        it = buildableMatchAndUpdate2.merge((PatternElement[])symbolicNameArray);
        boolean bl3 = false;
        if (this.mergeRelationshipProperties) {
            objectArray = new String[]{"properties"};
            buildableMatchAndUpdate = it.mutate(relationship.asExpression(), (Expression)Cypher.property((Expression)((Expression)PatternHandler.Companion.getNAME_EVENT$sink()), (String[])objectArray));
        } else {
            objectArray = new Expression[2];
            objectArray[0] = relationship.asExpression();
            stringArray = new String[]{"properties"};
            objectArray[1] = Cypher.property((Expression)((Expression)PatternHandler.Companion.getNAME_EVENT$sink()), (String[])stringArray);
            StatementBuilder.BuildableMatchAndUpdate buildableMatchAndUpdate6 = it.set(objectArray);
            objectArray = new String[]{"keys"};
            buildableMatchAndUpdate = buildableMatchAndUpdate6.mutate(relationship.asExpression(), (Expression)Cypher.property((Expression)((Expression)PatternHandler.Companion.getNAME_EVENT$sink()), (String[])objectArray));
        }
        symbolicNameArray = new Expression[1];
        Object[] objectArray2 = new Object[]{relationship.getRequiredSymbolicName()};
        symbolicNameArray[0] = Cypher.raw((String)"count($E)", (Object[])objectArray2).as(PatternHandler.Companion.getNAME_CREATED$sink());
        Statement statement = buildableMatchAndUpdate.returning((Expression[])symbolicNameArray).build();
        Intrinsics.checkNotNullExpressionValue((Object)statement, (String)"build(...)");
        return (ResultStatement)statement;
    }

    private static final Unit handle$lambda$0(RelationshipPatternHandler this$0, SinkMessage it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.logger.trace("received message: '{}'", (Object)it);
        return Unit.INSTANCE;
    }

    private static final MessageToEventList handle$lambda$1(RelationshipPatternHandler this$0, SinkMessage it) {
        List list;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        boolean isTombstoneMessage = it.getValue() == null;
        Map<String, Object> flattened = this$0.flattenMessage(it);
        Set used = new LinkedHashSet();
        String[] stringArray = new String[]{this$0.getBindValueAs(), this$0.getBindKeyAs()};
        Map<String, Object> startKeys = this$0.extractKeys(((RelationshipPattern)this$0.getPattern()).getStart(), flattened, isTombstoneMessage, used, stringArray);
        String[] stringArray2 = new String[]{this$0.getBindValueAs(), this$0.getBindKeyAs()};
        Map<String, Object> endKeys = this$0.extractKeys(((RelationshipPattern)this$0.getPattern()).getEnd(), flattened, isTombstoneMessage, used, stringArray2);
        String[] stringArray3 = new String[]{this$0.getBindValueAs(), this$0.getBindKeyAs()};
        Map<String, Object> keys = this$0.extractKeys((Pattern)this$0.getPattern(), (Map<String, ? extends Object>)flattened, isTombstoneMessage, used, stringArray3);
        if (isTombstoneMessage) {
            Object[] objectArray = new Object[2];
            objectArray[0] = "D";
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"start", (Object)MapsKt.mapOf((Pair)TuplesKt.to((Object)"keys", startKeys))), TuplesKt.to((Object)"end", (Object)MapsKt.mapOf((Pair)TuplesKt.to((Object)"keys", endKeys))), TuplesKt.to((Object)"keys", keys)};
            objectArray[1] = MapsKt.mapOf((Pair[])pairArray);
            list = CollectionsKt.listOf((Object[])objectArray);
        } else {
            Map<String, Object> startProperties = this$0.computeProperties(((RelationshipPattern)this$0.getPattern()).getStart(), flattened, used);
            Map<String, Object> endProperties = this$0.computeProperties(((RelationshipPattern)this$0.getPattern()).getEnd(), flattened, used);
            Object[] objectArray = new Object[2];
            objectArray[0] = "C";
            Pair[] pairArray = new Pair[4];
            Pair[] pairArray2 = new Pair[]{TuplesKt.to((Object)"keys", startKeys), TuplesKt.to((Object)"properties", startProperties)};
            pairArray[0] = TuplesKt.to((Object)"start", (Object)MapsKt.mapOf((Pair[])pairArray2));
            pairArray2 = new Pair[]{TuplesKt.to((Object)"keys", endKeys), TuplesKt.to((Object)"properties", endProperties)};
            pairArray[1] = TuplesKt.to((Object)"end", (Object)MapsKt.mapOf((Pair[])pairArray2));
            pairArray[2] = TuplesKt.to((Object)"keys", keys);
            pairArray[3] = TuplesKt.to((Object)"properties", this$0.computeProperties((Pattern)this$0.getPattern(), (Map<String, ? extends Object>)flattened, used));
            objectArray[1] = MapsKt.mapOf((Pair[])pairArray);
            list = CollectionsKt.listOf((Object[])objectArray);
        }
        List mapped = list;
        this$0.logger.trace("message '{}' mapped to: '{}'", (Object)it, (Object)mapped);
        return new MessageToEventList(it, mapped);
    }

    private static final List handle$lambda$2(RelationshipPatternHandler this$0, List it) {
        Collection<List<Object>> collection;
        MessageToEventList data;
        Iterable iterable;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Iterable iterable2 = it;
        Integer n = null;
        Long l = null;
        boolean $i$f$map = false;
        void var4_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            MessageToEventList messageToEventList = (MessageToEventList)item$iv$iv;
            iterable = destination$iv$iv;
            boolean bl = false;
            iterable.add(data.getMessage());
        }
        iterable = (List)destination$iv$iv;
        $this$map$iv = it;
        String string = "events";
        String string2 = this$0.query;
        iterable = iterable;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            data = (MessageToEventList)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(data.getEventList());
        }
        collection = (List)destination$iv$iv;
        Map map = MapsKt.mapOf((Pair)TuplesKt.to((Object)string, (Object)collection));
        String string3 = string2;
        Query query = new Query(string3, map);
        Iterable iterable3 = iterable;
        Integer n2 = n;
        Long l2 = l;
        return CollectionsKt.listOf((Object)new ChangeQuery(l2, n2, iterable3, query));
    }

    private static final Unit handle$lambda$3(RelationshipPatternHandler this$0, List it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.logger.trace("mapped messages: '{}'", (Object)it);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005H\u00c6\u0003J#\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lorg/neo4j/connectors/kafka/sink/strategy/RelationshipPatternHandler$MessageToEventList;", "", "message", "Lorg/neo4j/connectors/kafka/sink/SinkMessage;", "eventList", "", "<init>", "(Lorg/neo4j/connectors/kafka/sink/SinkMessage;Ljava/util/List;)V", "getMessage", "()Lorg/neo4j/connectors/kafka/sink/SinkMessage;", "getEventList", "()Ljava/util/List;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "sink"})
    public static final class MessageToEventList {
        @NotNull
        private final SinkMessage message;
        @NotNull
        private final List<Object> eventList;

        public MessageToEventList(@NotNull SinkMessage message, @NotNull List<? extends Object> eventList) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            Intrinsics.checkNotNullParameter(eventList, (String)"eventList");
            this.message = message;
            this.eventList = eventList;
        }

        @NotNull
        public final SinkMessage getMessage() {
            return this.message;
        }

        @NotNull
        public final List<Object> getEventList() {
            return this.eventList;
        }

        @NotNull
        public final SinkMessage component1() {
            return this.message;
        }

        @NotNull
        public final List<Object> component2() {
            return this.eventList;
        }

        @NotNull
        public final MessageToEventList copy(@NotNull SinkMessage message, @NotNull List<? extends Object> eventList) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            Intrinsics.checkNotNullParameter(eventList, (String)"eventList");
            return new MessageToEventList(message, eventList);
        }

        public static /* synthetic */ MessageToEventList copy$default(MessageToEventList messageToEventList, SinkMessage sinkMessage, List list, int n, Object object) {
            if ((n & 1) != 0) {
                sinkMessage = messageToEventList.message;
            }
            if ((n & 2) != 0) {
                list = messageToEventList.eventList;
            }
            return messageToEventList.copy(sinkMessage, list);
        }

        @NotNull
        public String toString() {
            return "MessageToEventList(message=" + this.message + ", eventList=" + this.eventList + ")";
        }

        public int hashCode() {
            int result = this.message.hashCode();
            result = result * 31 + ((Object)this.eventList).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MessageToEventList)) {
                return false;
            }
            MessageToEventList messageToEventList = (MessageToEventList)other;
            if (!Intrinsics.areEqual((Object)this.message, (Object)messageToEventList.message)) {
                return false;
            }
            return Intrinsics.areEqual(this.eventList, messageToEventList.eventList);
        }
    }
}

